/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class ProcessXMLDAO
extends BLDAOService {
    private static final String[] CREATE_LIST;
    private static final String[] LOAD_LIST;
    private static String insertProcessXML;
    private static String loadProcessXML;
    private static String removeProcessXML;
    private static String updateProcessXML;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void create(long ptID, String description, String xmlContent) {
        block7: {
            Connection conn = null;
            PreparedStatement pstmtInsertProcessXML = null;
            new StringBuffer();
            ByteArrayInputStream pXmlInsert = null;
            try {
                conn = ProcessXMLDAO.getConnection();
                pstmtInsertProcessXML = conn.prepareStatement(insertProcessXML);
                pstmtInsertProcessXML.setLong(1, ptID);
                pstmtInsertProcessXML.setString(2, description);
                pXmlInsert = new ByteArrayInputStream(ProcessXMLDAO.convertToBytes((Object)xmlContent));
                pstmtInsertProcessXML.setBinaryStream(3, (InputStream)pXmlInsert, pXmlInsert.available());
                pstmtInsertProcessXML.executeUpdate();
                ProcessXMLDAO.clean(null, (Statement)pstmtInsertProcessXML, (Connection)conn);
            }
            catch (SQLException sqlerr) {
                ProcessXMLDAO.handle((SQLException)sqlerr);
                break block7;
            }
            catch (Throwable th) {
                ProcessXMLDAO.handle((Throwable)th);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ProcessXMLDAO.clean(null, (Statement)pstmtInsertProcessXML, (Connection)conn);
                FileUtil.close(pXmlInsert);
                break block7;
            }
            finally {
                ProcessXMLDAO.clean(null, (Statement)pstmtInsertProcessXML, (Connection)conn);
                FileUtil.close(pXmlInsert);
            }
            FileUtil.close((InputStream)pXmlInsert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(long ptID, String xmldefinition) {
        Connection conn = null;
        PreparedStatement pstmtUpdateProcessXML = null;
        ByteArrayInputStream pXmlUpdate = null;
        try {
            conn = ProcessXMLDAO.getConnection();
            pstmtUpdateProcessXML = conn.prepareStatement(updateProcessXML);
            pXmlUpdate = new ByteArrayInputStream(ProcessXMLDAO.convertToBytes((Object)xmldefinition));
            pstmtUpdateProcessXML.setBinaryStream(1, (InputStream)pXmlUpdate, pXmlUpdate.available());
            pstmtUpdateProcessXML.setLong(2, ptID);
            pstmtUpdateProcessXML.executeUpdate();
        }
        catch (Throwable th) {
            try {
                ProcessXMLDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ProcessXMLDAO.clean(null, (Statement)pstmtUpdateProcessXML, (Connection)conn);
                FileUtil.close(pXmlUpdate);
            }
        }
        ProcessXMLDAO.clean(null, (Statement)pstmtUpdateProcessXML, (Connection)conn);
        FileUtil.close((InputStream)pXmlUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void update(long ptID) {
        Connection conn = null;
        PreparedStatement pstmtUpdateProcessXML = null;
        StringBuffer buffer = new StringBuffer();
        ByteArrayInputStream pXmlUpdate = null;
        try {
            int ch;
            conn = ProcessXMLDAO.getConnection();
            HashMap xmlFileInfo = ProcessControl.getXMLFileInfo(ptID);
            ((Integer)xmlFileInfo.get("XML_FILE_LENGTH")).intValue();
            Reader xmlReader = (Reader)xmlFileInfo.get("XML_READER");
            while ((ch = xmlReader.read()) != -1) {
                buffer.append((char)ch);
            }
            String pXml = buffer.toString();
            pstmtUpdateProcessXML = conn.prepareStatement(updateProcessXML);
            pXmlUpdate = new ByteArrayInputStream(ProcessXMLDAO.convertToBytes((Object)pXml));
            pstmtUpdateProcessXML.setBinaryStream(1, (InputStream)pXmlUpdate, pXmlUpdate.available());
            pstmtUpdateProcessXML.setLong(2, ptID);
            pstmtUpdateProcessXML.executeUpdate();
            ProcessXMLDAO.clean(null, (Statement)pstmtUpdateProcessXML, (Connection)conn);
        }
        catch (IOException e) {
            throw new BizLogicException("BizLogic_ERR_2538", "ProcessXMLDAO.update", new Object[]{ProcessControl.getProcessTemplate(ptID).getName()}, (Throwable)e);
            catch (Throwable th) {
                ProcessXMLDAO.handle((Throwable)th);
                return;
            }
        }
        FileUtil.close((InputStream)pXmlUpdate);
        return;
        finally {
            ProcessXMLDAO.clean(null, pstmtUpdateProcessXML, (Connection)conn);
            FileUtil.close(pXmlUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String load(long ptID) {
        String pXml;
        block7: {
            Connection conn = null;
            PreparedStatement pstmtLoadProcessXML = null;
            ResultSet rset = null;
            pXml = null;
            InputStream is = null;
            try {
                conn = ProcessXMLDAO.getConnection();
                pstmtLoadProcessXML = conn.prepareStatement(loadProcessXML);
                pstmtLoadProcessXML.setLong(1, ptID);
                rset = pstmtLoadProcessXML.executeQuery();
                if (rset.next()) {
                    is = rset.getBinaryStream(1);
                    pXml = (String)ProcessXMLDAO.convertToObject((InputStream)is);
                }
                ProcessXMLDAO.clean((ResultSet)rset, (Statement)pstmtLoadProcessXML, (Connection)conn);
            }
            catch (SQLException sqlerr) {
                ProcessXMLDAO.handle((SQLException)sqlerr);
                break block7;
            }
            finally {
                ProcessXMLDAO.clean(rset, (Statement)pstmtLoadProcessXML, (Connection)conn);
                FileUtil.close(is);
            }
            FileUtil.close((InputStream)is);
        }
        if (pXml == null || pXml.length() == 0) {
            throw new BizLogicException("BizLogic_ERR_2540", "ProcessXMLDAO.load", new Object[]{ProcessControl.getProcessTemplate(ptID).getName()});
        }
        return pXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(long ptID) {
        Connection conn = null;
        PreparedStatement pstmtRemoveProcessXML = null;
        try {
            conn = ProcessXMLDAO.getConnection();
            pstmtRemoveProcessXML = conn.prepareStatement(removeProcessXML);
            pstmtRemoveProcessXML.setLong(1, ptID);
            pstmtRemoveProcessXML.executeUpdate();
        }
        catch (SQLException sqlerr) {
            ProcessXMLDAO.handle((SQLException)sqlerr);
        }
        finally {
            ProcessXMLDAO.clean(null, (Statement)pstmtRemoveProcessXML, (Connection)conn);
        }
    }

    public static synchronized void initSQLStatements() {
        int ix = 0;
        StringBuffer buffer = new StringBuffer();
        buffer.append("insert into ");
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        buffer.append("PROCESSXML");
        buffer.append(" (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            buffer.append(CREATE_LIST[ix]);
            if (ix == CREATE_LIST.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(") values (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            buffer.append("?");
            if (ix == CREATE_LIST.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        insertProcessXML = buffer.toString();
        buffer = new StringBuffer();
        buffer.append("select ");
        for (ix = 0; ix < LOAD_LIST.length; ++ix) {
            buffer.append(LOAD_LIST[ix]);
            if (ix == LOAD_LIST.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(" from ");
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        buffer.append("PROCESSXML");
        buffer.append(" where ");
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        buffer.append("PROCESS_TEMPLATE_ID");
        buffer.append(" = ?");
        loadProcessXML = buffer.toString();
        buffer = new StringBuffer(100);
        buffer.append("delete from ");
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        buffer.append("PROCESSXML");
        buffer.append(" where ");
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        buffer.append("PROCESS_TEMPLATE_ID");
        buffer.append(" = ?");
        removeProcessXML = buffer.toString();
        buffer = new StringBuffer(100);
        buffer.append("update ");
        DBConstants.TableConstants cfr_ignored_5 = BLControl.dbconsts.tab;
        buffer.append("PROCESSXML");
        buffer.append(" set ");
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        buffer.append("XML");
        buffer.append(" = ? where ");
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        buffer.append("PROCESS_TEMPLATE_ID");
        buffer.append(" = ?");
        updateProcessXML = buffer.toString();
        ProcessXMLDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"ProcessXMLDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", insertProcessXML, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadProcessXML, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeProcessXML, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", updateProcessXML, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[3];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[0] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[1] = "DESCRIPTION";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[2] = "XML";
        CREATE_LIST = stringArray;
        String[] stringArray2 = new String[1];
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray2[0] = "XML";
        LOAD_LIST = stringArray2;
    }
}

