/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.XMLDocRepository;
import com.savvion.sbm.bizlogic.server.dao.BLDocDSDAO;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLDocService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DAOContext;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.bizlogic.util.DataslotUtil;
import com.savvion.sbm.dms.DSContext;
import com.savvion.sbm.util.CacheManager;
import com.savvion.sbm.util.DBService;
import com.savvion.sbm.util.SBMDatabase;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.dcl.FCLService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DataSlotDAO
extends BLDAOService {
    private static final String UPDATE = "update ";
    private static final String SET = " set ";
    private static final String EQUALS_QUESTION_COMMA = " = ?,";
    private static final String EQUALS_QUESTION = "= ?";
    private static final String WHERE = " where ";
    private static final String SPACE_EQUALS_QUESTION = " = ?";
    private static final String TYPE_KEY = "TYPE";
    private static final String CACHE_NAME = "DataSlotDAO";
    private static final String NULL_VALUE = "<NULL>";

    private static void updateCache(long ptid, long piid, boolean instanceDS, HashMap<String, Object> dataslots) {
        CacheKey key = new CacheKey(ptid, piid, instanceDS);
        Map cached = (Map)CacheManager.cached((String)CACHE_NAME, (Object)key);
        if (cached == null) {
            CacheManager.cache((String)CACHE_NAME, (Object)key, dataslots);
        } else {
            cached.putAll(dataslots);
        }
    }

    private static HashMap<String, Object> findInCache(long ptid, long piid, boolean instanceDS, List<String> dsNames) {
        CacheKey key = new CacheKey(ptid, piid, instanceDS);
        HashMap cached = (HashMap)CacheManager.cached((String)CACHE_NAME, (Object)key);
        if (cached != null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String dsName : dsNames) {
                if (cached.containsKey(dsName)) {
                    result.put(dsName, cached.get(dsName));
                    continue;
                }
                return null;
            }
            return result;
        }
        return null;
    }

    private static void evictFromCache(long ptid, long piid, boolean instanceDS) {
        CacheManager.evict((String)CACHE_NAME, (Object)new CacheKey(ptid, piid, instanceDS));
    }

    public static void create(long ptid, HashMap dsNameValues) {
        DataSlotDAO.insert(ptid, 0L, dsNameValues, false);
    }

    public static void create(long ptid, long piid, HashMap dsNameValues) {
        DataSlotDAO.insert(ptid, piid, dsNameValues, true);
    }

    public static void store(long ptid, HashMap modifiedDS) {
        DataSlotDAO.update(ptid, 0L, modifiedDS, false);
    }

    public static void store(long ptid, long piid, HashMap modifiedDS) {
        DataSlotDAO.update(ptid, piid, modifiedDS, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(long ptid, long piid) {
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        String tableName = pt.getDSTableName();
        if (tableName != null) {
            StringBuffer mainClause = new StringBuffer(100);
            mainClause.append("delete from ");
            mainClause.append(tableName);
            mainClause.append(WHERE);
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            mainClause.append("PROCESS_INSTANCE_ID");
            mainClause.append(" = ? ");
            Connection conn = null;
            PreparedStatement pstmtRemove = null;
            try {
                conn = DataSlotDAO.getConnection();
                pstmtRemove = conn.prepareStatement(mainClause.toString());
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
                }
                pstmtRemove.setLong(1, piid);
                pstmtRemove.executeUpdate();
            }
            catch (SQLException sqlex) {
                try {
                    DataSlotDAO.handle((SQLException)sqlex);
                }
                catch (Throwable throwable) {
                    DataSlotDAO.clean(null, pstmtRemove, (Connection)conn);
                    throw throwable;
                }
                DataSlotDAO.clean(null, (Statement)pstmtRemove, (Connection)conn);
            }
            DataSlotDAO.clean(null, (Statement)pstmtRemove, (Connection)conn);
        }
        DataSlotDAO.evictFromCache(ptid, piid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllData(long piid, long ptid, String tableName, boolean hws, boolean isMonitoring, boolean hasVote, boolean hasMessages, boolean collaborationEnabled, boolean deleteEvents, String processName, String monitorDSValue) {
        Connection conn = null;
        PreparedStatement pstmtRemove = null;
        try {
            conn = DataSlotDAO.getConnection();
            String procedureCall = "{call BIZLOGIC_DELETEDATAS (?,?,?,?,?,?,?,?,?,?,?)}";
            if (ServiceLocator.self().isPostgresql()) {
                procedureCall = "select BIZLOGIC_DELETEDATAS(?,?,?,?,?,?,?,?,?,?,?)";
            }
            pstmtRemove = conn.prepareStatement(procedureCall);
            pstmtRemove.setLong(1, piid);
            pstmtRemove.setLong(2, ptid);
            pstmtRemove.setString(3, tableName);
            pstmtRemove.setString(4, processName);
            pstmtRemove.setString(5, monitorDSValue);
            pstmtRemove.setInt(6, hws ? 0 : 1);
            pstmtRemove.setInt(7, isMonitoring ? 0 : 1);
            pstmtRemove.setInt(8, hasVote ? 0 : 1);
            pstmtRemove.setInt(9, hasMessages ? 0 : 1);
            pstmtRemove.setInt(10, collaborationEnabled ? 0 : 1);
            pstmtRemove.setInt(11, deleteEvents ? 0 : 1);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", procedureCall, new Object[0]);
            }
            pstmtRemove.execute();
            DataSlotDAO.clean(null, (Statement)pstmtRemove, (Connection)conn);
        }
        catch (SQLException sqlex) {
            DataSlotDAO.handle((SQLException)sqlex);
        }
        finally {
            DataSlotDAO.clean(null, pstmtRemove, (Connection)conn);
        }
        DataSlotDAO.evictFromCache(ptid, piid, true);
        DataSlotDAO.evictFromCache(ptid, piid, false);
    }

    public static Object findByName(DAOContext daoCtx, long ptid, String dsName) {
        Vector<String> dsNames = new Vector<String>();
        dsNames.addElement(dsName);
        HashMap result = DataSlotDAO.findValues(daoCtx, ptid, 0L, dsNames, false);
        return result.get(dsName);
    }

    public static Object findByName(DAOContext daoCtx, long ptid, long piid, String dsName) {
        Vector<String> dsNames = new Vector<String>();
        dsNames.addElement(dsName);
        HashMap result = DataSlotDAO.findValues(daoCtx, ptid, piid, dsNames, true);
        return result.get(dsName);
    }

    public static HashMap findByProcessTemplete(DAOContext daoCtx, long ptid) {
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        Vector globalDSNames = pt.getGlobalDSNamesList();
        return DataSlotDAO.findValues(daoCtx, ptid, 0L, globalDSNames, false);
    }

    public static HashMap findByProcessInstance(DAOContext daoCtx, long ptid, long piid) {
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        Vector instanceDSNames = pt.getInstanceDSNameList();
        return DataSlotDAO.findValues(daoCtx, ptid, piid, instanceDSNames, true);
    }

    public static HashMap findByNameList(DAOContext daoCtx, long ptid, Vector dsNames) {
        return DataSlotDAO.findValues(daoCtx, ptid, 0L, dsNames, false);
    }

    public static HashMap findByNameList(DAOContext daoCtx, long ptid, long piid, Vector dsNames) {
        return DataSlotDAO.findValues(daoCtx, ptid, piid, dsNames, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementLongDS(long ptid, long piid, String dsName, boolean isInstanceDS, long value) {
        dsName = DBService.polish((String)dsName);
        StringBuffer query = new StringBuffer(100);
        query.append("UPDATE ");
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        if (isInstanceDS) {
            query.append(pt.getDSTableName());
        } else {
            query.append(pt.getGlobalDSTableName());
        }
        query.append(" SET ");
        query.append(dsName);
        query.append(" = ");
        query.append(dsName);
        query.append(" + ");
        query.append(value);
        long idToBeSet = piid;
        DBConstants.KeywordConstants cfr_ignored_0 = DBConstants.single().kwd;
        query.append(" WHERE ");
        if (isInstanceDS) {
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            query.append("PROCESS_INSTANCE_ID");
            idToBeSet = piid;
        } else {
            DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
            query.append("PROCESS_TEMPLATE_ID");
            idToBeSet = ptid;
        }
        DBConstants.KeywordConstants cfr_ignored_3 = DBConstants.single().kwd;
        query.append(" = ? ");
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debugKey("BizLogic_ERR_1185", query.toString(), new Object[0]);
        }
        Connection conn = null;
        PreparedStatement incrLongDsPstmt = null;
        try {
            conn = DataSlotDAO.getConnection();
            incrLongDsPstmt = conn.prepareStatement(query.toString());
            incrLongDsPstmt.setLong(1, idToBeSet);
            incrLongDsPstmt.executeUpdate();
        }
        catch (SQLException sqlex) {
            try {
                DataSlotDAO.handle((SQLException)sqlex);
            }
            catch (Throwable throwable) {
                DataSlotDAO.clean(null, incrLongDsPstmt, (Connection)conn);
                throw throwable;
            }
            DataSlotDAO.clean(null, (Statement)incrLongDsPstmt, (Connection)conn);
        }
        DataSlotDAO.clean(null, (Statement)incrLongDsPstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendStringDS(long ptid, long piid, String dsName, boolean isInstanceDS, String value) {
        if (value == null || value.length() == 0) {
            throw new BizLogicException("BizLogic_ERR_4630", "DataSlotDAO.appendStringDS", new Object[]{dsName, ptid, piid});
        }
        dsName = DBService.polish((String)dsName);
        StringBuffer query = new StringBuffer(100);
        query.append("UPDATE ");
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        if (isInstanceDS) {
            query.append(pt.getDSTableName());
        } else {
            query.append(pt.getGlobalDSTableName());
        }
        query.append(" SET ");
        query.append(dsName);
        query.append(" = ");
        query.append(DataSlotDAO.composeConcatString((String)dsName));
        long idToBeSet = piid;
        DBConstants.KeywordConstants cfr_ignored_0 = DBConstants.single().kwd;
        query.append(" WHERE ");
        if (isInstanceDS) {
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            query.append("PROCESS_INSTANCE_ID");
            idToBeSet = piid;
        } else {
            DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
            query.append("PROCESS_TEMPLATE_ID");
            idToBeSet = ptid;
        }
        DBConstants.KeywordConstants cfr_ignored_3 = DBConstants.single().kwd;
        query.append(" = ? ");
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debugKey("BizLogic_ERR_1185", query.toString(), new Object[0]);
        }
        Connection conn = null;
        PreparedStatement updateStmt = null;
        try {
            conn = DataSlotDAO.getConnection();
            updateStmt = conn.prepareStatement(query.toString());
            updateStmt.setString(1, value);
            updateStmt.setLong(2, idToBeSet);
            updateStmt.executeUpdate();
        }
        catch (SQLException sqlex) {
            try {
                DataSlotDAO.handle((SQLException)sqlex);
            }
            catch (Throwable throwable) {
                DataSlotDAO.clean(null, updateStmt, (Connection)conn);
                throw throwable;
            }
            DataSlotDAO.clean(null, (Statement)updateStmt, (Connection)conn);
        }
        DataSlotDAO.clean(null, (Statement)updateStmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap findValues(DAOContext daoCtx, long ptid, long piid, Vector dsNameList, boolean isInstanceDS) {
        if (dsNameList == null || dsNameList.isEmpty()) {
            return null;
        }
        if (daoCtx == null) {
            throw new BizLogicException("BizLogic_ERR_4641", "DataSlotDAO.findValues");
        }
        HashMap<String, Object> cached = DataSlotDAO.findInCache(ptid, piid, isInstanceDS, dsNameList);
        if (cached != null) {
            return cached;
        }
        LinkedHashMap<String, Object> dsNameValues = new LinkedHashMap<String, Object>();
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        StringBuffer mainClause = new StringBuffer(500);
        new StringBuffer(100);
        mainClause.append("select ");
        ArrayList<String> blobDSNames = new ArrayList<String>();
        HashMap dsTypeMeta = pt.getDataSlotsMetaInfo(TYPE_KEY);
        String type = null;
        String dsName = null;
        int ix = 0;
        for (ix = dsNameList.size() - 1; ix >= 0; --ix) {
            dsName = (String)dsNameList.elementAt(ix);
            type = (String)dsTypeMeta.get(dsName);
            if (!BLUtil.isLargeDataSlot((String)type)) continue;
            blobDSNames.add(dsName);
            dsNameList.removeElementAt(ix);
        }
        if (!blobDSNames.isEmpty()) {
            mainClause.append("large_dataslots");
            mainClause.append(",");
        }
        for (ix = dsNameList.size() - 1; ix >= 0; --ix) {
            dsName = (String)dsNameList.elementAt(ix);
            mainClause.append(DBService.polish((String)dsName));
            mainClause.append(",");
        }
        mainClause.deleteCharAt(mainClause.length() - 1);
        mainClause.append(" from ");
        if (isInstanceDS) {
            mainClause.append(pt.getDSTableName());
        } else {
            mainClause.append(pt.getGlobalDSTableName());
        }
        if (isInstanceDS) {
            mainClause.append(WHERE);
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            mainClause.append("PROCESS_INSTANCE_ID");
            mainClause.append(SPACE_EQUALS_QUESTION);
        }
        if (ServiceLocator.self().isDB2()) {
            DataSlotDAO.addReadUncommittedHint((StringBuffer)mainClause);
        }
        SBMDatabase.addReadPastHintOpenEdge((StringBuffer)mainClause);
        Connection conn = null;
        PreparedStatement pstmtFindByProcessInstance = null;
        ResultSet rset = null;
        boolean hasXML = false;
        try {
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debug((Object)("execute:" + mainClause.toString()));
            }
            conn = DataSlotDAO.getConnection();
            pstmtFindByProcessInstance = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            if (isInstanceDS) {
                pstmtFindByProcessInstance.setLong(1, piid);
            }
            if (!(rset = pstmtFindByProcessInstance.executeQuery()).next()) {
                HashMap hashMap = null;
                DataSlotDAO.clean((ResultSet)rset, (Statement)pstmtFindByProcessInstance, (Connection)conn);
                return hashMap;
            }
            int colNum = dsNameList.size();
            int index = 0;
            if (!blobDSNames.isEmpty()) {
                HashMap tmpHash = null;
                InputStream is = rset.getBinaryStream(++index);
                FCLService.setCurrentThreadCLName((String)pt.getName());
                tmpHash = (HashMap)DataSlotDAO.converToObjectUsingFCL((InputStream)is);
                FCLService.removeCurrentThreadCLName();
                if (tmpHash == null) {
                    tmpHash = new HashMap();
                }
                for (ix = 0; ix < blobDSNames.size(); ++ix) {
                    dsName = (String)blobDSNames.get(ix);
                    dsNameValues.put(dsName, tmpHash.get(dsName));
                }
            }
            for (ix = index + 1; ix < colNum + index + 1; ++ix) {
                dsName = (String)dsNameList.elementAt(colNum - ix + index);
                type = (String)dsTypeMeta.get(dsName);
                if (type.equalsIgnoreCase("BOOLEAN")) {
                    int bValue = rset.getInt(ix);
                    dsNameValues.put(dsName, bValue == 1);
                    continue;
                }
                if (type.equalsIgnoreCase("DOUBLE")) {
                    dsNameValues.put(dsName, new Double(rset.getDouble(ix)));
                    continue;
                }
                if (type.equalsIgnoreCase("LONG")) {
                    dsNameValues.put(dsName, new Long(rset.getLong(ix)));
                    continue;
                }
                if (type.equalsIgnoreCase("XML")) {
                    long xid = rset.getLong(ix);
                    dsNameValues.put(dsName, new XML(xid));
                    if (xid <= 0L) continue;
                    hasXML = true;
                    continue;
                }
                if (type.equalsIgnoreCase("DATETIME")) {
                    Timestamp ts = rset.getTimestamp(ix);
                    DateTime dt = null;
                    dt = ts == null ? new DateTime((Timestamp)null) : new DateTime(ts.getTime());
                    dsNameValues.put(dsName, dt);
                    continue;
                }
                if (type.equalsIgnoreCase("DECIMAL")) {
                    BigDecimal bd = rset.getBigDecimal(ix);
                    WFDataslot ds = pt.getDataslot(dsName);
                    int precision = ds.getPrecision();
                    int scale = ds.getScale();
                    try {
                        Decimal d = new Decimal(bd, precision, scale);
                        dsNameValues.put(dsName, d);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (type.equalsIgnoreCase("CURRENCY")) continue;
                if (type.equalsIgnoreCase("DOCUMENT")) {
                    DSContext dsContext = (DSContext)daoCtx.get("DMS_CONTEXT");
                    String dsFolderId = rset.getString(ix);
                    DocumentDS docDS = null;
                    WFDataslot ds = pt.getDataslot(dsName);
                    docDS = isInstanceDS ? BLDocService.getInstanceDocumentDS((DSContext)dsContext, (long)ptid, (long)piid, (String)dsName, (String)dsFolderId, (boolean)ds.isEditableByAuthor(), (boolean)ds.isMultiLine()) : BLDocService.getGlobalDocumentDS((DSContext)dsContext, (long)ptid, (String)dsName, (String)dsFolderId, (boolean)ds.isEditableByAuthor(), (boolean)ds.isMultiLine());
                    dsNameValues.put(dsName, docDS);
                    continue;
                }
                String s = rset.getString(ix);
                if (s == null && BLUtil.self().isAngularNullForStrDs()) {
                    s = NULL_VALUE;
                }
                dsNameValues.put(dsName, s);
            }
            DataSlotDAO.clean((ResultSet)rset, (Statement)pstmtFindByProcessInstance, (Connection)conn);
        }
        catch (SQLException sqlex) {
            DataSlotDAO.handle((SQLException)sqlex);
        }
        finally {
            DataSlotDAO.clean(rset, pstmtFindByProcessInstance, (Connection)conn);
        }
        if (hasXML) {
            Iterator iter = ((HashMap)dsNameValues).keySet().iterator();
            XML xmlObj = null;
            while (iter.hasNext()) {
                dsName = (String)iter.next();
                Object obj = ((HashMap)dsNameValues).get(dsName);
                if (!(obj instanceof XML)) continue;
                xmlObj = (XML)obj;
                if (xmlObj.getID() > 0L) {
                    String fname = XMLDocRepository.getName(xmlObj.getID());
                    xmlObj.setName(fname);
                }
                dsNameValues.put(dsName, xmlObj);
            }
        }
        DataSlotDAO.updateCache(ptid, piid, isInstanceDS, dsNameValues);
        return dsNameValues;
    }

    private static HashMap merge(HashMap bigger, HashMap smaller) {
        Iterator keySet = smaller.keySet().iterator();
        String key = null;
        while (keySet.hasNext()) {
            key = (String)keySet.next();
            bigger.put(key, smaller.get(key));
        }
        return bigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insert(long ptid, long piid, HashMap dsNameValues, boolean isInstanceDS) {
        HashMap splitedList = DataslotUtil.splitPrimitiveAndLargeDS((long)ptid, (Map)dsNameValues);
        HashMap primitiveDS = (HashMap)splitedList.get("PRIMITIVEDS");
        HashMap blobDS = (HashMap)splitedList.get("large_dataslots");
        WFProcess process = ProcessControl.getProcessTemplate(ptid);
        DataSlotDAO.insertDocumentDS(process, primitiveDS, piid, isInstanceDS);
        StringBuffer mainClause = new StringBuffer(500);
        StringBuffer valueClause = new StringBuffer(100);
        valueClause.append(") values (");
        mainClause.append("insert into ");
        DataSlotDAO.appendTableName(mainClause, isInstanceDS, process);
        DataSlotDAO.addRowlockHint((StringBuffer)mainClause);
        mainClause.append(" ( ");
        DataSlotDAO.addProcessInstanceId(mainClause, valueClause, isInstanceDS);
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        mainClause.append("PROCESS_TEMPLATE_ID").append(",");
        valueClause.append("?,");
        Iterator keySet = null;
        Object dsName = null;
        Object value = null;
        keySet = primitiveDS.keySet().iterator();
        DataSlotDAO.appendDSNames(keySet, mainClause, valueClause);
        DataSlotDAO.appendBlobsDs(blobDS, mainClause, valueClause);
        mainClause.append(valueClause.toString());
        Connection conn = null;
        PreparedStatement pstmtInsertDS = null;
        try {
            conn = DataSlotDAO.getConnection();
            pstmtInsertDS = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            int counter = 1;
            if (isInstanceDS) {
                pstmtInsertDS.setLong(counter++, piid);
            }
            pstmtInsertDS.setLong(counter++, ptid);
            keySet = primitiveDS.keySet().iterator();
            HashMap dsTypeMeta = process.getDataSlotsMetaInfo(TYPE_KEY);
            Object type = null;
            counter = DataSlotDAO.insertKeySetValues(keySet, counter, primitiveDS, dsTypeMeta, pstmtInsertDS);
            DataSlotDAO.insertBinaryStream(counter, blobDS, pstmtInsertDS);
            pstmtInsertDS.executeUpdate();
            DataSlotDAO.updateCache(ptid, piid, isInstanceDS, dsNameValues);
        }
        catch (SQLException sqlex) {
            try {
                DataSlotDAO.handle((SQLException)sqlex);
            }
            catch (Throwable throwable) {
                DataSlotDAO.clean(null, pstmtInsertDS, (Connection)conn);
                throw throwable;
            }
            DataSlotDAO.clean(null, (Statement)pstmtInsertDS, (Connection)conn);
        }
        DataSlotDAO.clean(null, (Statement)pstmtInsertDS, (Connection)conn);
        DataSlotDAO.updateCache(ptid, piid, isInstanceDS, dsNameValues);
    }

    private static void appendDSNames(Iterator keySet, StringBuffer mainClause, StringBuffer valueClause) {
        while (keySet.hasNext()) {
            String dsName = (String)keySet.next();
            mainClause.append(DBService.polish((String)dsName));
            mainClause.append(",");
            valueClause.append("?,");
        }
    }

    private static void appendBlobsDs(Map blobDS, StringBuffer mainClause, StringBuffer valueClause) {
        if (!blobDS.isEmpty()) {
            mainClause.append("large_dataslots");
            valueClause.append("?)");
        } else {
            mainClause.deleteCharAt(mainClause.length() - 1);
            valueClause.deleteCharAt(valueClause.length() - 1);
            valueClause.append(") ");
        }
    }

    private static void addProcessInstanceId(StringBuffer mainClause, StringBuffer valueClause, boolean isDSInstance) {
        if (isDSInstance) {
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            mainClause.append("PROCESS_INSTANCE_ID");
            mainClause.append(",");
            valueClause.append("?,");
        }
    }

    private static void appendTableName(StringBuffer mainClause, boolean isInstanceDS, WFProcess process) {
        if (isInstanceDS) {
            mainClause.append(process.getDSTableName());
        } else {
            mainClause.append(process.getGlobalDSTableName());
        }
    }

    private static int insertKeySetValues(Iterator keySet, int counter, Map primitiveDS, Map dsTypeMeta, PreparedStatement pstmtInsertDS) throws SQLException {
        while (keySet.hasNext()) {
            String dsName = (String)keySet.next();
            Object value = primitiveDS.get(dsName);
            String type = (String)dsTypeMeta.get(dsName);
            if (type.equalsIgnoreCase("BOOLEAN")) {
                counter = DataSlotDAO.processForBooleanType(value, counter, pstmtInsertDS);
                continue;
            }
            if (type.equalsIgnoreCase("DOUBLE")) {
                counter = DataSlotDAO.processForDoubleSlotType(value, counter, pstmtInsertDS);
                continue;
            }
            if (type.equalsIgnoreCase("LONG")) {
                counter = DataSlotDAO.processForLongSlot(value, counter, pstmtInsertDS);
                continue;
            }
            if (type.equalsIgnoreCase("XML")) {
                counter = DataSlotDAO.processForXMLSlot(value, counter, pstmtInsertDS);
                continue;
            }
            if (type.equalsIgnoreCase("DATETIME")) {
                counter = DataSlotDAO.processForDateTimeSlotType(value, counter, dsName, type, pstmtInsertDS);
                continue;
            }
            if (type.equalsIgnoreCase("DECIMAL")) {
                counter = DataSlotDAO.processForDecimalSlotType(value, counter, dsName, type, pstmtInsertDS);
                continue;
            }
            if (type.equalsIgnoreCase("CURRENCY")) {
                counter = DataSlotDAO.processForCurrencySlot(value, counter, pstmtInsertDS);
                continue;
            }
            if (type.equalsIgnoreCase("DOCUMENT")) {
                counter = DataSlotDAO.processForDocumentSlotType(value, counter, dsName, type, pstmtInsertDS);
                continue;
            }
            counter = DataSlotDAO.processForOtherObjects(value, counter, pstmtInsertDS);
        }
        return counter;
    }

    private static void insertBinaryStream(int counter, Map blobDS, PreparedStatement pstmt) throws SQLException {
        if (!blobDS.isEmpty()) {
            ByteArrayInputStream contextInsert = new ByteArrayInputStream(DataSlotDAO.convertToBytes((Object)blobDS));
            pstmt.setBinaryStream(counter, (InputStream)contextInsert, contextInsert.available());
        }
    }

    private static int processForBooleanType(Object value, int counter, PreparedStatement pstmt) throws SQLException {
        if (value == null) {
            pstmt.setNull(counter++, 4);
        } else if (((Boolean)value).booleanValue()) {
            pstmt.setInt(counter++, 1);
        } else {
            pstmt.setInt(counter++, 0);
        }
        return counter;
    }

    private static int processForDoubleSlotType(Object value, int counter, PreparedStatement pstmt) throws SQLException {
        if (value == null) {
            pstmt.setNull(counter++, 8);
        } else {
            pstmt.setDouble(counter++, (Double)value);
        }
        return counter;
    }

    private static int processForLongSlot(Object value, int counter, PreparedStatement pstmt) throws SQLException {
        if (value == null) {
            pstmt.setNull(counter++, -5);
        } else {
            pstmt.setLong(counter++, (Long)value);
        }
        return counter;
    }

    private static int processForXMLSlot(Object value, int counter, PreparedStatement pstmt) throws SQLException {
        if (value == null || NULL_VALUE.equals(value.toString())) {
            pstmt.setNull(counter++, -5);
        } else {
            long xmlid = ((XML)value).getID();
            pstmt.setLong(counter++, xmlid);
        }
        return counter;
    }

    private static int processForDateTimeSlotType(Object value, int counter, String dsName, String type, PreparedStatement pstmtInsertDS) throws SQLException {
        DateTime dateTime = null;
        Timestamp timestamp = null;
        if (value != null) {
            if (value instanceof DateTime) {
                dateTime = (DateTime)value;
                timestamp = dateTime.getValue();
            } else if (value instanceof Timestamp) {
                timestamp = (Timestamp)value;
            } else {
                throw new BizLogicException("BizLogic_ERR_3765", "DataSlotDAO.insert()", new Object[]{dsName, value.getClass().getName(), type, "com.savvion.sbm.bizlogic.server.svo.DateTime, java.sql.Timestamp"});
            }
        }
        if (value == null || timestamp == null || NULL_VALUE.equals(value.toString())) {
            pstmtInsertDS.setNull(counter++, 93);
        } else {
            pstmtInsertDS.setTimestamp(counter++, timestamp);
        }
        return counter;
    }

    private static int processForDecimalSlotType(Object value, int counter, String dsName, String type, PreparedStatement pstmtInsertDS) throws SQLException {
        Decimal d = null;
        BigDecimal bd = null;
        if (value != null) {
            if (value instanceof Decimal) {
                d = (Decimal)value;
                bd = d.getValue();
            } else if (value instanceof BigDecimal) {
                bd = (BigDecimal)value;
            } else {
                throw new BizLogicException("BizLogic_ERR_3765", "DataSlotDAO.insert()", new Object[]{dsName, value.getClass().getName(), type, "com.savvion.sbm.bizlogic.server.svo.Decimal, java.math.BigDecimal"});
            }
        }
        if (value == null || bd == null || NULL_VALUE.equals(value.toString())) {
            pstmtInsertDS.setNull(counter++, 3);
        } else {
            pstmtInsertDS.setBigDecimal(counter++, bd);
        }
        return counter;
    }

    private static int processForCurrencySlot(Object value, int counter, PreparedStatement pstmt) throws SQLException {
        if (value == null || NULL_VALUE.equals(value.toString())) {
            pstmt.setNull(counter++, 3);
        }
        return counter;
    }

    private static int processForDocumentSlotType(Object value, int counter, String dsName, String type, PreparedStatement pstmtInsertDS) throws SQLException {
        if (value != null) {
            DocumentDS docDS = (DocumentDS)value;
            String dsFolderId = null;
            if (docDS != null) {
                dsFolderId = docDS.getDataSlotFolderId();
            }
            if (dsFolderId != null) {
                pstmtInsertDS.setString(counter++, dsFolderId);
                if (BLUtil.self().isSaveDocumentIds()) {
                    BLDocService.updateDocumentDS((DocumentDS)docDS);
                }
            } else {
                pstmtInsertDS.setNull(counter++, 12);
            }
        } else {
            pstmtInsertDS.setNull(counter++, 12);
        }
        return counter;
    }

    private static int processForOtherObjects(Object value, int counter, PreparedStatement pstmt) throws SQLException {
        if (value == null || NULL_VALUE.equals(value.toString())) {
            pstmt.setNull(counter++, 12);
        } else {
            pstmt.setString(counter++, (String)value);
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void update(long ptid, long piid, HashMap modifiedDS, boolean isInstanceDS) {
        if (modifiedDS == null || modifiedDS.isEmpty()) {
            return;
        }
        HashMap modifiedSplittedDS = DataslotUtil.splitPrimitiveAndLargeDS((long)ptid, (Map)modifiedDS);
        Map primitiveDS = (Map)modifiedSplittedDS.get("PRIMITIVEDS");
        Map<?, ?> blobDS = (Map<?, ?>)modifiedSplittedDS.get("large_dataslots");
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        DataSlotDAO.validateAndInsertDocumentDS(pt, (HashMap)primitiveDS, piid, isInstanceDS);
        StringBuffer mainClause = new StringBuffer(500);
        mainClause.append(UPDATE);
        if (isInstanceDS) {
            mainClause.append(pt.getDSTableName());
        } else {
            mainClause.append(pt.getGlobalDSTableName());
        }
        DataSlotDAO.addRowlockHint((StringBuffer)mainClause);
        mainClause.append(SET);
        Iterator keySet = null;
        String key2 = null;
        for (String key2 : primitiveDS.keySet()) {
            mainClause.append(DBService.polish((String)key2));
            mainClause.append(EQUALS_QUESTION_COMMA);
        }
        if (!blobDS.isEmpty()) {
            mainClause.append("large_dataslots").append(EQUALS_QUESTION);
        } else {
            mainClause.deleteCharAt(mainClause.length() - 1);
        }
        if (isInstanceDS) {
            mainClause.append(WHERE);
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            mainClause.append("PROCESS_INSTANCE_ID");
            mainClause.append(SPACE_EQUALS_QUESTION);
        }
        Connection conn = null;
        PreparedStatement pstmtUpdateDS = null;
        try {
            conn = DataSlotDAO.getConnection();
            HashMap dsTypeMeta = pt.getDataSlotsMetaInfo(TYPE_KEY);
            pstmtUpdateDS = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            keySet = primitiveDS.keySet().iterator();
            int counter = DataSlotDAO.processPrimitiveDsKeySet(primitiveDS, keySet, pstmtUpdateDS, dsTypeMeta);
            if (!blobDS.isEmpty()) {
                blobDS = DataSlotDAO.mergeBlobDs(ptid, piid, isInstanceDS, blobDS);
                ByteArrayInputStream contextInsert = new ByteArrayInputStream(DataSlotDAO.convertToBytes(blobDS));
                pstmtUpdateDS.setBinaryStream(counter++, (InputStream)contextInsert, contextInsert.available());
            }
            if (isInstanceDS) {
                pstmtUpdateDS.setLong(counter, piid);
            }
            pstmtUpdateDS.executeUpdate();
            DataSlotDAO.clean(null, (Statement)pstmtUpdateDS, (Connection)conn);
        }
        catch (SQLException sqlex) {
            DataSlotDAO.handle((SQLException)sqlex);
        }
        finally {
            DataSlotDAO.clean(null, pstmtUpdateDS, (Connection)conn);
        }
        DataSlotDAO.updateCache(ptid, piid, isInstanceDS, modifiedDS);
    }

    private static int processPrimitiveDsKeySet(Map<?, ?> primitiveDS, Iterator keySet, PreparedStatement pstmtUpdateDS, Map<?, ?> dsTypeMeta) throws SQLException {
        String type = null;
        int counter = 1;
        while (keySet.hasNext()) {
            String key = (String)keySet.next();
            Object value = primitiveDS.get(key);
            type = (String)dsTypeMeta.get(key);
            if (type.equalsIgnoreCase("BOOLEAN")) {
                counter = DataSlotDAO.processBooleanSlotType(value, pstmtUpdateDS, counter);
                continue;
            }
            if (type.equalsIgnoreCase("DOUBLE")) {
                counter = DataSlotDAO.processDoubleSlotType(value, pstmtUpdateDS, counter);
                continue;
            }
            if (type.equalsIgnoreCase("LONG")) {
                counter = DataSlotDAO.processLongSlotType(value, pstmtUpdateDS, counter);
                continue;
            }
            if (type.equalsIgnoreCase("XML")) {
                counter = DataSlotDAO.processXmlSlotType(value, pstmtUpdateDS, counter);
                continue;
            }
            if (type.equalsIgnoreCase("DATETIME")) {
                counter = DataSlotDAO.processDateTimeSlot(value, pstmtUpdateDS, counter);
                continue;
            }
            if (type.equalsIgnoreCase("DECIMAL")) {
                counter = DataSlotDAO.processDecimalSlotType(value, pstmtUpdateDS, counter);
                continue;
            }
            if (type.equalsIgnoreCase("CURRENCY")) {
                if (value != null && !NULL_VALUE.equals(value.toString())) continue;
                pstmtUpdateDS.setNull(counter++, 3);
                continue;
            }
            if (type.equalsIgnoreCase("DOCUMENT")) {
                if (value != null) {
                    counter = DataSlotDAO.processDocumentSlotType(value, pstmtUpdateDS, counter);
                    continue;
                }
                pstmtUpdateDS.setNull(counter++, 12);
                continue;
            }
            counter = DataSlotDAO.processDefaultTypeValue(value, pstmtUpdateDS, counter);
        }
        return counter;
    }

    private static int processBooleanSlotType(Object value, PreparedStatement pstmtUpdateDS, int counterParam) throws SQLException {
        int counter = counterParam;
        if (value == null) {
            pstmtUpdateDS.setNull(counter++, 4);
        } else {
            pstmtUpdateDS.setInt(counter++, (Boolean)value != false ? 1 : 0);
        }
        return counter;
    }

    private static int processDoubleSlotType(Object value, PreparedStatement pstmtUpdateDS, int counterParam) throws SQLException {
        int counter = counterParam;
        if (value == null) {
            pstmtUpdateDS.setNull(counter++, 8);
        } else {
            pstmtUpdateDS.setDouble(counter++, (Double)value);
        }
        return counter;
    }

    private static int processLongSlotType(Object value, PreparedStatement pstmtUpdateDS, int counterParam) throws SQLException {
        int counter = counterParam;
        if (value == null) {
            pstmtUpdateDS.setNull(counter++, -5);
        } else {
            pstmtUpdateDS.setLong(counter++, (Long)value);
        }
        return counter;
    }

    private static int processXmlSlotType(Object value, PreparedStatement pstmtUpdateDS, int counterParam) throws SQLException {
        int counter = counterParam;
        if (value == null || NULL_VALUE.equals(value.toString())) {
            pstmtUpdateDS.setNull(counter++, -5);
        } else {
            XML xml = (XML)value;
            long id = xml.getID();
            pstmtUpdateDS.setLong(counter++, id);
        }
        return counter;
    }

    private static int processDateTimeSlot(Object value, PreparedStatement pstmtUpdateDS, int counterParam) throws SQLException {
        int counter = counterParam;
        DateTime dateTime = null;
        Timestamp timestamp = null;
        if (value != null) {
            dateTime = (DateTime)value;
            timestamp = dateTime.getValue();
        }
        if (value == null || timestamp == null || NULL_VALUE.equals(value.toString())) {
            pstmtUpdateDS.setNull(counter++, 93);
        } else {
            pstmtUpdateDS.setTimestamp(counter++, timestamp);
        }
        return counter;
    }

    private static int processDecimalSlotType(Object value, PreparedStatement pstmtUpdateDS, int counterParam) throws SQLException {
        int counter = counterParam;
        Decimal decimal = null;
        BigDecimal bigDecimal = null;
        if (value != null) {
            decimal = (Decimal)value;
            bigDecimal = decimal.getValue();
        }
        if (value == null || bigDecimal == null || NULL_VALUE.equals(value.toString())) {
            pstmtUpdateDS.setNull(counter++, 3);
        } else {
            pstmtUpdateDS.setBigDecimal(counter++, bigDecimal);
        }
        return counter;
    }

    private static int processDocumentSlotType(Object value, PreparedStatement pstmtUpdateDS, int counterParam) throws SQLException {
        int counter = counterParam;
        DocumentDS docDS = (DocumentDS)value;
        String dsFolderId = null;
        if (docDS != null) {
            dsFolderId = docDS.getDataSlotFolderId();
        }
        if (dsFolderId != null) {
            pstmtUpdateDS.setString(counter++, dsFolderId);
            if (BLUtil.self().isSaveDocumentIds()) {
                BLDocService.updateDocumentDS((DocumentDS)docDS);
            }
        } else {
            pstmtUpdateDS.setNull(counter++, 12);
        }
        return counter;
    }

    private static int processDefaultTypeValue(Object value, PreparedStatement pstmtUpdateDS, int counterParam) throws SQLException {
        int counter = counterParam;
        if (value == null || NULL_VALUE.equals(value.toString())) {
            pstmtUpdateDS.setNull(counter++, 12);
        } else {
            pstmtUpdateDS.setString(counter++, (String)value);
        }
        return counter;
    }

    private static Map<?, ?> mergeBlobDs(long ptid, long piid, boolean isInstanceDS, Map<?, ?> blobDSParam) {
        HashMap blobDS = blobDSParam;
        Object obj = DataSlotDAO.getBlob(ptid, piid, isInstanceDS);
        if (obj != null) {
            blobDS = DataSlotDAO.merge((HashMap)obj, blobDS);
        }
        return blobDS;
    }

    private static List<String> getDocumentNames(WFProcess process, Map primitiveDS) {
        BLConstants.single();
        HashMap dsTypeMeta = process.getDataSlotsMetaInfo(TYPE_KEY);
        Iterator itr = primitiveDS.keySet().iterator();
        ArrayList<String> docList = new ArrayList<String>();
        while (itr.hasNext()) {
            String dsName = (String)itr.next();
            String type = (String)dsTypeMeta.get(dsName);
            if (!type.equalsIgnoreCase("DOCUMENT")) continue;
            docList.add(dsName);
        }
        return docList;
    }

    private static void insertDocumentDS(WFProcess pt, Map<String, DocumentDS> primitiveDS, long piid, boolean isInstanceDS) {
        List<String> docNameList = DataSlotDAO.getDocumentNames(pt, primitiveDS);
        if (docNameList.isEmpty()) {
            return;
        }
        for (int i = 1; i < docNameList.size() + 1; ++i) {
            String dsName = docNameList.get(i - 1);
            DocumentDS docDS = primitiveDS.get(dsName);
            String dsFolderId = null;
            if (docDS != null) {
                dsFolderId = docDS.getDataSlotFolderId();
            }
            if (dsFolderId == null) continue;
            DataSlotDAO.insertDocumentDS(pt.getID(), piid, docDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateAndInsertDocumentDS(WFProcess pt, HashMap primitiveDS, long piid, boolean isInstanceDS) {
        List<String> docList = DataSlotDAO.getDocumentNames(pt, primitiveDS);
        if (docList.isEmpty()) {
            return;
        }
        StringBuffer sBuffer = new StringBuffer();
        DBConstants.KeywordConstants cfr_ignored_0 = DBConstants.single().kwd;
        sBuffer.append(" SELECT ");
        List updatedList = DataSlotDAO.polishDataslotNames(docList);
        DataSlotDAO.appendColumnList((StringBuffer)sBuffer, (List)updatedList);
        DBConstants.KeywordConstants cfr_ignored_1 = DBConstants.single().kwd;
        sBuffer.append(" FROM ");
        if (isInstanceDS) {
            sBuffer.append(pt.getDSTableName());
        } else {
            sBuffer.append(pt.getGlobalDSTableName());
        }
        if (isInstanceDS) {
            DBConstants.KeywordConstants cfr_ignored_2 = DBConstants.single().kwd;
            sBuffer.append(" WHERE ");
            DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
            sBuffer.append("PROCESS_INSTANCE_ID");
            sBuffer.append(SPACE_EQUALS_QUESTION);
        } else {
            DBConstants.KeywordConstants cfr_ignored_4 = DBConstants.single().kwd;
            sBuffer.append(" WHERE ");
            DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
            sBuffer.append("PROCESS_TEMPLATE_ID");
            sBuffer.append(SPACE_EQUALS_QUESTION);
        }
        if (ServiceLocator.self().isDB2()) {
            DataSlotDAO.addReadUncommittedHint((StringBuffer)sBuffer);
        }
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = DataSlotDAO.getConnection();
            ps = conn.prepareStatement(sBuffer.toString());
            if (isInstanceDS) {
                ps.setLong(1, piid);
            } else {
                ps.setLong(1, pt.getID());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                for (int i = 1; i < docList.size() + 1; ++i) {
                    String previousValue = rs.getString(i);
                    String dsName = docList.get(i - 1);
                    DocumentDS docDS = (DocumentDS)primitiveDS.get(dsName);
                    String newDSFolderId = null;
                    if (docDS != null) {
                        newDSFolderId = docDS.getDataSlotFolderId();
                    }
                    if (newDSFolderId != null) {
                        if (previousValue == null) {
                            DataSlotDAO.insertDocumentDS(pt.getID(), piid, docDS);
                            continue;
                        }
                        if (previousValue == null || newDSFolderId.equalsIgnoreCase(previousValue)) continue;
                        throw new BizLogicException("BizLogic_ERR_3572", "DataSlotDAO.checkDocumentDS()", new Object[]{dsName, pt.getID(), piid, previousValue, newDSFolderId});
                    }
                    if (previousValue == null) continue;
                    throw new BizLogicException("BizLogic_ERR_3571", "DataSlotDAO.checkDocumentDS()", new Object[]{dsName, pt.getID(), piid});
                }
            }
        }
        catch (SQLException sqlex) {
            try {
                DataSlotDAO.handle((SQLException)sqlex);
            }
            catch (Throwable throwable) {
                DataSlotDAO.clean(rs, ps, (Connection)conn);
                throw throwable;
            }
            DataSlotDAO.clean(rs, (Statement)ps, (Connection)conn);
        }
        DataSlotDAO.clean((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getBlob(long ptid, long piid, boolean isInstanceDS) {
        Object value = null;
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        StringBuffer mainClause = new StringBuffer(100);
        String dsTableName = isInstanceDS ? pt.getDSTableName() : pt.getGlobalDSTableName();
        mainClause.append("select ");
        mainClause.append("large_dataslots");
        mainClause.append(" from ");
        mainClause.append(dsTableName);
        if (isInstanceDS) {
            mainClause.append(WHERE);
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            mainClause.append("PROCESS_INSTANCE_ID");
            mainClause.append("= ? ");
        }
        Connection conn = null;
        PreparedStatement pstmtGetDSValue = null;
        ResultSet rset = null;
        try {
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            conn = DataSlotDAO.getConnection();
            pstmtGetDSValue = conn.prepareStatement(mainClause.toString());
            if (isInstanceDS) {
                pstmtGetDSValue.setLong(1, piid);
            }
            if (!(rset = pstmtGetDSValue.executeQuery()).next()) {
                value = null;
            }
            InputStream is = rset.getBinaryStream(1);
            FCLService.setCurrentThreadCLName((String)pt.getName());
            value = DataSlotDAO.converToObjectUsingFCL((InputStream)is);
            FCLService.removeCurrentThreadCLName();
            DataSlotDAO.clean((ResultSet)rset, (Statement)pstmtGetDSValue, (Connection)conn);
        }
        catch (SQLException sqlex) {
            DataSlotDAO.handle((SQLException)sqlex);
        }
        finally {
            DataSlotDAO.clean(rset, pstmtGetDSValue, (Connection)conn);
        }
        return value;
    }

    public static void deleteTable(long ptid) {
        DataSlotDAO.deleteTable(ProcessControl.getProcessTemplate(ptid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTable(WFProcess pt) {
        if (SBMDatabase.self().isOpenEdge()) {
            return;
        }
        Connection conn = null;
        Statement stmtDropTable = null;
        String dropDSQuery = "";
        String dropGlobalDSQuery = "";
        if (pt.getDSTableName() != null && pt.getDSTableName().length() > 0) {
            DBConstants.KeywordConstants cfr_ignored_0 = DBConstants.single().kwd;
            dropDSQuery = " DROP TABLE " + pt.getDSTableName();
        }
        if (pt.getGlobalDSTableName() != null && pt.getGlobalDSTableName().length() > 0) {
            DBConstants.KeywordConstants cfr_ignored_1 = DBConstants.single().kwd;
            dropGlobalDSQuery = " DROP TABLE " + pt.getGlobalDSTableName();
        }
        try {
            conn = DataSlotDAO.getConnection();
            stmtDropTable = conn.createStatement();
            if (dropDSQuery.length() > 0) {
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", dropDSQuery, new Object[0]);
                }
                stmtDropTable.executeUpdate(dropDSQuery);
            }
            if (dropGlobalDSQuery.length() > 0) {
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", dropGlobalDSQuery, new Object[0]);
                }
                stmtDropTable.executeUpdate(dropGlobalDSQuery);
            }
        }
        catch (SQLException sqlex) {
            DataSlotDAO.handle((SQLException)sqlex);
        }
        finally {
            DataSlotDAO.clean(null, (Statement)stmtDropTable, (Connection)conn);
        }
    }

    public static final Map polishDataslotNames(Map mapDS) {
        if (mapDS == null) {
            return null;
        }
        if (ServiceLocator.self().isMySQL()) {
            return mapDS;
        }
        HashMap updatedMap = new HashMap();
        for (String key : mapDS.keySet()) {
            Object value = mapDS.get(key);
            updatedMap.put(DBService.polish((String)key), value);
        }
        return updatedMap;
    }

    public static final List polishDataslotNames(List<String> dsNames) {
        if (dsNames == null) {
            return null;
        }
        if (ServiceLocator.self().isMySQL()) {
            return dsNames;
        }
        ArrayList<String> updatedList = new ArrayList<String>();
        StringBuffer buff = new StringBuffer();
        for (String key : dsNames) {
            updatedList.add(DBService.polish((String)key));
            buff.setLength(0);
        }
        return updatedList;
    }

    private static void insertDocumentDS(long ptid, long piid, DocumentDS docDS) {
        if (!BLUtil.self().isSaveDocumentIds()) {
            return;
        }
        String dsName = docDS.getDataslotName();
        String dsFolderid = docDS.getDataSlotFolderId();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        DBConstants.ColConstants cfr_ignored_0 = DBConstants.single().col;
        attributes.put("PROCESS_TEMPLATE_ID", ptid);
        DBConstants.ColConstants cfr_ignored_1 = DBConstants.single().col;
        attributes.put("PROCESS_INSTANCE_ID", piid);
        DBConstants.ColConstants cfr_ignored_2 = DBConstants.single().col;
        attributes.put("DATASLOT_NAME", dsName);
        DBConstants.ColConstants cfr_ignored_3 = DBConstants.single().col;
        attributes.put("DATASLOT_FOLDER_ID", dsFolderid);
        DBConstants.ColConstants cfr_ignored_4 = DBConstants.single().col;
        attributes.put("PARENT_PIID", docDS.getParentPiid());
        BLDocDSDAO.insertFolder(attributes);
        if (BLUtil.self().isDebugDocument()) {
            BLControl.logger.debugKey("BizLogic_ERR_3588", "DataSlotDAO.insertDocumentDS()", BLDocService.getDebugMsg((long)ptid, (long)piid, (String)dsName, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getProcessInstanceId(String monitorDSName, String monitorDSValue, String instanceDSTable) {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement pstmtGetPiid = null;
        long piid = -1L;
        if ("@PROCESS_INSTANCE_ID".equals(monitorDSName)) {
            monitorDSName = "PROCESS_INSTANCE_ID";
        }
        try {
            conn = DataSlotDAO.getConnection();
            StringBuilder getPIId = new StringBuilder(100);
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            getPIId.append("SELECT ").append("PROCESS_INSTANCE_ID");
            getPIId.append(" FROM ").append(instanceDSTable);
            getPIId.append(" WHERE ");
            getPIId.append(DBService.polish((String)monitorDSName));
            getPIId.append(" IS NOT NULL ");
            getPIId.append(" AND ");
            getPIId.append(DBService.polish((String)monitorDSName));
            getPIId.append(SPACE_EQUALS_QUESTION);
            pstmtGetPiid = conn.prepareStatement(getPIId.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getPIId.toString(), new Object[0]);
            }
            if ("PROCESS_INSTANCE_ID".equals(monitorDSName)) {
                long monitorDSLongVal = 0L;
                try {
                    monitorDSLongVal = Long.parseLong(monitorDSValue);
                }
                catch (NumberFormatException nfe) {
                    throw new BizLogicException("BizLogic_ERR_3903", "DataSlotDAO.getProcessInstanceId", new Object[]{monitorDSValue, "@PROCESS_INSTANCE_ID"}, (Throwable)nfe);
                }
                pstmtGetPiid.setLong(1, monitorDSLongVal);
            } else {
                pstmtGetPiid.setString(1, monitorDSValue);
            }
            rs = pstmtGetPiid.executeQuery();
            if (rs.next()) {
                piid = rs.getLong(1);
            }
            DataSlotDAO.clean((ResultSet)rs, (Statement)pstmtGetPiid, (Connection)conn);
            return piid;
        }
        catch (BizLogicException ble) {
            throw ble;
            catch (Throwable th) {
                DataSlotDAO.handle((Throwable)th);
                return piid;
            }
        }
        finally {
            DataSlotDAO.clean(rs, pstmtGetPiid, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasDuplicateMonitorId(String monitorDSName, String instanceDSTable) {
        boolean hasDuplicate;
        ResultSet rs;
        Statement stmtGetMonitorIdCount;
        Connection conn;
        block9: {
            conn = null;
            stmtGetMonitorIdCount = null;
            rs = null;
            hasDuplicate = false;
            try {
                conn = DataSlotDAO.getConnection();
                stmtGetMonitorIdCount = conn.createStatement();
                StringBuffer getMonitorIdCount = new StringBuffer(100);
                getMonitorIdCount.append("SELECT COUNT(*) FROM ");
                getMonitorIdCount.append(instanceDSTable);
                DataSlotDAO.addReadpastHint((StringBuffer)getMonitorIdCount);
                getMonitorIdCount.append(" WHERE ");
                getMonitorIdCount.append(DBService.polish((String)monitorDSName));
                getMonitorIdCount.append(" IS NOT NULL ");
                getMonitorIdCount.append(" UNION ALL ");
                getMonitorIdCount.append(" SELECT COUNT(*) FROM ");
                getMonitorIdCount.append(" ( SELECT DISTINCT ");
                getMonitorIdCount.append(DBService.polish((String)monitorDSName));
                getMonitorIdCount.append(" FROM ").append(instanceDSTable);
                DataSlotDAO.addReadpastHint((StringBuffer)getMonitorIdCount);
                getMonitorIdCount.append(" WHERE ");
                getMonitorIdCount.append(DBService.polish((String)monitorDSName));
                getMonitorIdCount.append(" IS NOT NULL ) ");
                if (!SBMDatabase.self().isOracle()) {
                    getMonitorIdCount.append(" AS DSTABLE_ALIAS ");
                }
                SBMDatabase.addReadPastHintOpenEdge((StringBuffer)getMonitorIdCount);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", getMonitorIdCount.toString(), new Object[0]);
                }
                rs = stmtGetMonitorIdCount.executeQuery(getMonitorIdCount.toString());
                int count1 = 0;
                int count2 = 0;
                if (rs.next()) {
                    count1 = rs.getInt(1);
                }
                if (rs.next()) {
                    count2 = rs.getInt(1);
                }
                if (count1 == count2) break block9;
                hasDuplicate = true;
            }
            catch (Throwable th) {
                try {
                    DataSlotDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DataSlotDAO.clean(rs, (Statement)stmtGetMonitorIdCount, (Connection)conn);
                }
            }
        }
        DataSlotDAO.clean((ResultSet)rs, (Statement)stmtGetMonitorIdCount, (Connection)conn);
        return hasDuplicate;
    }

    protected static class CacheKey {
        public final long ptid;
        public final long piid;
        public final boolean instanceDS;

        CacheKey(long ptid, long piid, boolean instanceDS) {
            this.ptid = ptid;
            this.piid = piid;
            this.instanceDS = instanceDS;
        }

        public int hashCode() {
            return (int)((long)(this.instanceDS ? 31 : 1) * (this.ptid * 71L + this.piid * 17L));
        }

        public boolean equals(Object that) {
            return this == that || that instanceof CacheKey && ((CacheKey)that).instanceDS == this.instanceDS && ((CacheKey)that).ptid == this.ptid && ((CacheKey)that).piid == this.piid;
        }
    }
}

