/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.DBConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;

public class AvailableWorkItemDAO
extends BLDAOService {
    private static final String[] CREATE_LIST;
    private static final String[] LOAD_LIST;
    static String insertAvailWorkItem;
    static String removeAvailWorkItem;
    static String getAvailPerformers;
    static String getAvailPerformersString;
    static String subSelectQuery;
    static String getPerformerList;
    static String removeByProcessInstance;
    static String removeByWorkStepInstance;
    static String removeByWorkitemID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(long wiid, long ptid, long piid, String[] perfs) {
        Connection conn = null;
        PreparedStatement pstmtInsertAvailWorkItem = null;
        try {
            conn = AvailableWorkItemDAO.getConnection();
            pstmtInsertAvailWorkItem = conn.prepareStatement(insertAvailWorkItem);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", "AvailableWorkItemDAO.store", new Object[]{insertAvailWorkItem});
            }
            for (int i = 0; i < perfs.length; ++i) {
                pstmtInsertAvailWorkItem.setLong(1, wiid);
                pstmtInsertAvailWorkItem.setLong(2, ptid);
                pstmtInsertAvailWorkItem.setLong(3, piid);
                pstmtInsertAvailWorkItem.setString(4, perfs[i]);
                pstmtInsertAvailWorkItem.executeUpdate();
            }
        }
        catch (SQLException sqlerr) {
            AvailableWorkItemDAO.handle((SQLException)sqlerr);
        }
        finally {
            AvailableWorkItemDAO.clean(null, (Statement)pstmtInsertAvailWorkItem, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getAvailablePerformers(long wiid) {
        Connection conn = null;
        PreparedStatement pstmtGetAvailPerformers = null;
        ResultSet rset = null;
        Vector<String> perfV = new Vector<String>();
        try {
            conn = AvailableWorkItemDAO.getConnection();
            pstmtGetAvailPerformers = conn.prepareStatement(getAvailPerformers);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", "AvailableWorkItemDAO.getAvailablePerformers", new Object[]{getAvailPerformers});
            }
            pstmtGetAvailPerformers.setLong(1, wiid);
            rset = pstmtGetAvailPerformers.executeQuery();
            while (rset.next()) {
                perfV.addElement(rset.getString(1));
            }
            AvailableWorkItemDAO.clean((ResultSet)rset, (Statement)pstmtGetAvailPerformers, (Connection)conn);
        }
        catch (SQLException sqlerr) {
            AvailableWorkItemDAO.handle((SQLException)sqlerr);
        }
        finally {
            AvailableWorkItemDAO.clean(rset, (Statement)pstmtGetAvailPerformers, (Connection)conn);
        }
        return perfV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAvailablePerformersString(long wiid) {
        Connection conn = null;
        PreparedStatement pstmtGetAvailPerformers = null;
        ResultSet rset = null;
        ArrayList<String> performerList = new ArrayList<String>();
        try {
            conn = AvailableWorkItemDAO.getConnection();
            pstmtGetAvailPerformers = conn.prepareStatement(getAvailPerformersString);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", "AvailableWorkItemDAO.getAvailablePerformersString", new Object[]{getAvailPerformersString});
            }
            pstmtGetAvailPerformers.setLong(1, wiid);
            rset = pstmtGetAvailPerformers.executeQuery();
            while (rset.next()) {
                performerList.add(rset.getString(1));
            }
            AvailableWorkItemDAO.clean((ResultSet)rset, (Statement)pstmtGetAvailPerformers, (Connection)conn);
        }
        catch (SQLException sqlerr) {
            AvailableWorkItemDAO.handle((SQLException)sqlerr);
        }
        finally {
            AvailableWorkItemDAO.clean(rset, (Statement)pstmtGetAvailPerformers, (Connection)conn);
        }
        return BLUtil.toStringListPerformer(performerList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(long wiid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveAvailWorkItem = null;
        try {
            conn = AvailableWorkItemDAO.getConnection();
            pstmtRemoveAvailWorkItem = conn.prepareStatement(removeAvailWorkItem);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", "AvailableWorkItemDAO.remove", new Object[]{removeAvailWorkItem});
            }
            pstmtRemoveAvailWorkItem.setLong(1, wiid);
            pstmtRemoveAvailWorkItem.executeUpdate();
        }
        catch (SQLException sqlerr) {
            AvailableWorkItemDAO.handle((SQLException)sqlerr);
        }
        finally {
            AvailableWorkItemDAO.clean(null, (Statement)pstmtRemoveAvailWorkItem, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByWorkitemID(long wiid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByWorkitemID = null;
        try {
            conn = AvailableWorkItemDAO.getConnection();
            pstmtRemoveByWorkitemID = conn.prepareStatement(removeByWorkitemID);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", "AvailableWorkItemDAO.removeByWorkitemID", new Object[]{removeByWorkitemID, wiid});
            }
            pstmtRemoveByWorkitemID.setLong(1, wiid);
            pstmtRemoveByWorkitemID.executeUpdate();
        }
        catch (SQLException sqlerr) {
            AvailableWorkItemDAO.handle((SQLException)sqlerr);
        }
        finally {
            AvailableWorkItemDAO.clean(null, (Statement)pstmtRemoveByWorkitemID, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByProcessInstance(long piid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByProcessInstance = null;
        try {
            conn = AvailableWorkItemDAO.getConnection();
            pstmtRemoveByProcessInstance = conn.prepareStatement(removeByProcessInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", "AvailableWorkItemDAO.removeByProcessInstance", new Object[]{removeByProcessInstance});
            }
            pstmtRemoveByProcessInstance.setLong(1, piid);
            pstmtRemoveByProcessInstance.executeUpdate();
        }
        catch (SQLException sqlerr) {
            AvailableWorkItemDAO.handle((SQLException)sqlerr);
        }
        finally {
            AvailableWorkItemDAO.clean(null, (Statement)pstmtRemoveByProcessInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByWorkStepInstance(long piid, long wsid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByWorkStepInstance = null;
        try {
            conn = AvailableWorkItemDAO.getConnection();
            pstmtRemoveByWorkStepInstance = conn.prepareStatement(removeByWorkStepInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", "AvailableWorkItemDAO.removeByWorkStepInstance", new Object[]{removeByWorkStepInstance});
            }
            pstmtRemoveByWorkStepInstance.setLong(1, piid);
            pstmtRemoveByWorkStepInstance.setLong(2, wsid);
            pstmtRemoveByWorkStepInstance.executeUpdate();
        }
        catch (SQLException sqlerr) {
            AvailableWorkItemDAO.handle((SQLException)sqlerr);
        }
        finally {
            AvailableWorkItemDAO.clean(null, (Statement)pstmtRemoveByWorkStepInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getPerformerList(long wiid) {
        Connection conn = null;
        PreparedStatement pstmtGetPerformerList = null;
        ResultSet rset = null;
        Vector<String> perfV = new Vector<String>();
        try {
            conn = AvailableWorkItemDAO.getConnection();
            pstmtGetPerformerList = conn.prepareStatement(getPerformerList);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", "AvailableWorkItemDAO.getPerformerList", new Object[]{getPerformerList});
            }
            pstmtGetPerformerList.setLong(1, wiid);
            rset = pstmtGetPerformerList.executeQuery();
            while (rset.next()) {
                perfV.addElement(rset.getString(1));
            }
            AvailableWorkItemDAO.clean((ResultSet)rset, (Statement)pstmtGetPerformerList, (Connection)conn);
        }
        catch (SQLException sqlerr) {
            AvailableWorkItemDAO.handle((SQLException)sqlerr);
        }
        finally {
            AvailableWorkItemDAO.clean(rset, (Statement)pstmtGetPerformerList, (Connection)conn);
        }
        return perfV;
    }

    public static synchronized void initSQLStatements() {
        int ix = 0;
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ");
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_AVAILABLEWORKITEM");
        sb.append(" (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            sb.append(CREATE_LIST[ix]);
            if (ix == CREATE_LIST.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") values (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            sb.append("?");
            if (ix == CREATE_LIST.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        insertAvailWorkItem = sb.toString();
        sb = new StringBuffer();
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_AVAILABLEWORKITEM");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        sb.append("WORKITEM_ID");
        sb.append(" = ? ");
        removeAvailWorkItem = sb.toString();
        sb = new StringBuffer();
        sb.append("select ");
        for (ix = 0; ix < LOAD_LIST.length; ++ix) {
            sb.append(LOAD_LIST[ix]);
            if (ix == LOAD_LIST.length - 1) continue;
            sb.append(", ");
        }
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_AVAILABLEWORKITEM");
        sb.append(" awi,");
        DBConstants.TableConstants cfr_ignored_4 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKITEM");
        sb.append(" wi where");
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        sb.append(" wi.").append("WORKITEM_ID");
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        sb.append(" = awi.").append("WORKITEM_ID");
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        sb.append(" AND wi.").append("STATUS");
        sb.append(" = ").append(27);
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        sb.append(" AND awi.").append("WORKITEM_ID");
        sb.append(" = ?");
        getAvailPerformers = sb.toString();
        sb = new StringBuffer();
        sb.append("SELECT ");
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        sb.append("AVAILABLEFOR");
        sb.append(" FROM ");
        DBConstants.TableConstants cfr_ignored_10 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_AVAILABLEWORKITEM");
        sb.append(" WHERE ");
        DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
        sb.append("WORKITEM_ID");
        sb.append(" = ?");
        getAvailPerformersString = sb.toString();
        sb = new StringBuffer();
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_12 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_AVAILABLEWORKITEM");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_13 = BLControl.dbconsts.col;
        sb.append("WORKITEM_ID");
        sb.append(" = ? ");
        removeByWorkitemID = sb.toString();
        sb = new StringBuffer();
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_14 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_AVAILABLEWORKITEM");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_15 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? ");
        removeByProcessInstance = sb.toString();
        sb = new StringBuffer();
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_16 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_AVAILABLEWORKITEM");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_17 = BLControl.dbconsts.col;
        sb.append("WORKITEM_ID");
        sb.append(" in (select ");
        DBConstants.ColConstants cfr_ignored_18 = BLControl.dbconsts.col;
        sb.append("WORKITEM_ID");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_19 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKITEM");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_20 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? and ");
        DBConstants.ColConstants cfr_ignored_21 = BLControl.dbconsts.col;
        sb.append("WORKSTEP_ID");
        sb.append(" = ?)");
        removeByWorkStepInstance = sb.toString();
        sb = new StringBuffer();
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_22 = BLControl.dbconsts.col;
        sb.append("AVAILABLEFOR");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_23 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_AVAILABLEWORKITEM");
        DBConstants.ColConstants cfr_ignored_24 = BLControl.dbconsts.col;
        sb.append(" where ").append("WORKITEM_ID");
        sb.append(" = ?");
        getPerformerList = sb.toString();
        AvailableWorkItemDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"AvailableWorkItemDAO.printSQLStatements:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", new Object[]{insertAvailWorkItem});
            BLControl.logger.debugKey("BizLogic_ERR_1199", new Object[]{removeAvailWorkItem});
            BLControl.logger.debugKey("BizLogic_ERR_1199", new Object[]{getAvailPerformers});
            BLControl.logger.debugKey("BizLogic_ERR_1199", new Object[]{getPerformerList});
        }
    }

    static {
        String[] stringArray = new String[4];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[0] = "WORKITEM_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[1] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[2] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray[3] = "AVAILABLEFOR";
        CREATE_LIST = stringArray;
        String[] stringArray2 = new String[1];
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray2[0] = "AVAILABLEFOR";
        LOAD_LIST = stringArray2;
    }
}

