/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.SubProcessMetaData;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.svo.DataSlotMapping;
import com.savvion.sbm.bizlogic.server.svo.DataSlotMappingList;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class WFNestedWS
extends WFWorkstep {
    static final long serialVersionUID = 4817894301519292482L;
    String SubProcess;
    boolean ClosedConnection = true;
    ArrayList SubProcessMetaDatas = new ArrayList();

    public WFNestedWS(String name, String performer, String subp, boolean smode) {
        this.setName(name);
        if (performer != null) {
            this.hasPerformer = performer;
        }
        this.SubProcess = subp;
        this.ClosedConnection = smode;
        this.typeTag = 108;
    }

    public boolean isSynchronous() {
        return this.ClosedConnection;
    }

    public String getSubProcess() {
        return this.SubProcess;
    }

    @Override
    public HashMap getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("SUBPROCESSNAME", this.SubProcess);
        attributes.put("SYNCHRONOUS", this.ClosedConnection);
        attributes.putAll(super.getAttributes());
        return attributes;
    }

    @Override
    public void validateWSData() {
        if (this.SubProcess == null || this.SubProcess.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_883", "WFWorkstep.validateWSData", new Object[]{this.getParentProcess().getName(), this.getName()});
        }
        ArrayList subProcMetaDatas = this.getSubProcessMetaDatas();
        for (int ix = 0; ix < subProcMetaDatas.size(); ++ix) {
            SubProcessMetaData template = (SubProcessMetaData)subProcMetaDatas.get(ix);
            template.validate();
        }
    }

    public void addSubProcessMetaData(SubProcessMetaData template) {
        if (template != null) {
            this.SubProcessMetaDatas.add(template);
        }
    }

    public boolean isSingleSubProcess() {
        ArrayList metaDatas = this.getSubProcessMetaDatas();
        if (metaDatas == null) {
            return true;
        }
        if (metaDatas.size() > 1) {
            return false;
        }
        SubProcessMetaData metaData = (SubProcessMetaData)metaDatas.get(0);
        if (metaData.isCountMappedDS()) {
            return false;
        }
        if (metaData.isSubProcessNameMappedDS()) {
            return false;
        }
        if (metaData.hasCount()) {
            try {
                long subPCount = (Long)metaData.getCount();
                if (subPCount > 1L) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized ArrayList getSubProcessMetaDatas() {
        if (this.SubProcessMetaDatas.isEmpty()) {
            try {
                SubProcessMetaData template = new SubProcessMetaData(this.getParentProcess(), this, this.SubProcess);
                template.setInputSlots(this.createDSMappingList(this.getInputDataslotList()));
                template.setOutputSlots(this.createDSMappingList(this.getOutputDataslotList()));
                this.SubProcessMetaDatas.add(template);
                this.fillDataslotMappingInfo();
            }
            catch (Throwable th) {
                throw new BizLogicException("BizLogic_ERR_884", "WFNestedWS.getSubProcessMetaDatas()", new Object[]{this.getName(), this.getParentProcess().getName()});
            }
        }
        return this.SubProcessMetaDatas;
    }

    @Override
    public void fillDataslotMappingInfo() {
        ArrayList subProcessMetaDatas = this.getSubProcessMetaDatas();
        for (int ix = 0; ix < subProcessMetaDatas.size(); ++ix) {
            SubProcessMetaData template = (SubProcessMetaData)subProcessMetaDatas.get(ix);
            template.fillDataslotMappingInfo();
        }
    }

    private DataSlotMappingList createDSMappingList(Hashtable dataslots) {
        ArrayList<DataSlotMapping> list = new ArrayList<DataSlotMapping>();
        for (String dsName : dataslots.keySet()) {
            String mappedName = (String)dataslots.get(dsName);
            DataSlotMapping dsMapping = new DataSlotMapping(dsName, mappedName);
            list.add(dsMapping);
        }
        return new DataSlotMappingList(list);
    }
}

