/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.common.script.ScriptBuilder;
import com.savvion.sbm.bizlogic.server.WFAppObject;
import com.savvion.sbm.bizlogic.server.WFJavaScript;
import com.savvion.sbm.bizlogic.server.WFPreCondition;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import java.util.Map;
import org.mozilla.javascript.Script;

public class WFLink
extends WFAppObject {
    static final long serialVersionUID = 8116493810554454956L;
    private WFWorkstep hasSource;
    private WFWorkstep hasTarget;
    private WFProcess parentProcess;
    private String queryExpression;
    private int queryType = -1;
    private String queryCode;
    private int type;
    private int index = 0;
    private transient Script compiledJSQuery;

    public WFLink(String n, WFWorkstep s, WFWorkstep t) {
        this.setName(n);
        this.hasSource = s;
        this.hasTarget = t;
    }

    public final String getQuery() {
        block3: {
            block2: {
                if (this.queryType == 203) break block2;
                if (this.queryType != 201) break block3;
            }
            return this.queryCode;
        }
        return this.queryExpression;
    }

    public void setQuery(String q) {
        this.queryExpression = q;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isTimeoutFlow() {
        BLConstants.single();
        return this.type == 1;
    }

    public void validateQuery() {
        if (this.queryExpression == null) {
            return;
        }
        this.queryExpression = this.queryExpression.trim();
        if (this.queryType == 203) {
            this.queryCode = ScriptBuilder.generateJava((String)this.getName(), (String)this.queryExpression, (Map)this.parentProcess.getDataSlotsType());
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debug((Object)("Generated Java code:\n" + this.queryCode));
            }
            WFJavaScript.parseJavaCode(this.queryCode);
            return;
        }
        if (BLUtil.isJS((String)this.queryExpression)) {
            this.queryCode = BLUtil.getJS((String)this.queryExpression);
            this.queryType = 201;
            this.compiledJSQuery = WFJavaScript.compileJS(this.queryCode, "DECISION");
        } else if (BLUtil.isJavaCode((String)this.queryExpression)) {
            this.queryCode = BLUtil.getJavaCode((String)this.queryExpression);
            this.queryType = 203;
            WFJavaScript.parseJavaCode(this.queryCode);
        } else {
            this.queryType = 200;
            this.queryExpression = WFPreCondition.self().formattingCondition(this.queryExpression);
        }
    }

    public final int getQueryType() {
        return this.queryType;
    }

    public void setQueryType(int type) {
        this.queryType = type;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public Script getcompiledJSQuery() {
        if (this.compiledJSQuery == null && BLUtil.isJS((String)this.queryExpression)) {
            this.compiledJSQuery = WFJavaScript.compileJS(BLUtil.getJS((String)this.queryExpression), "DECISION");
        }
        return this.compiledJSQuery;
    }

    public void delete() {
        this.hasSource.removeOutConnection(this);
        this.hasTarget.removeInConnection(this);
        this.hasSource = null;
        this.hasTarget = null;
    }

    public void setParentProcess(WFProcess p) {
        this.parentProcess = p;
    }

    public void setSource(WFWorkstep s) {
        this.hasSource = s;
    }

    public void setTarget(WFWorkstep t) {
        this.hasTarget = t;
    }

    public WFWorkstep getSource() {
        return this.hasSource;
    }

    public WFWorkstep getTarget() {
        return this.hasTarget;
    }

    public boolean validateLink() {
        return true;
    }

    public String toString() {
        String s = this.getName() + " , Connects ";
        s = s + this.hasSource.getName();
        s = s + " to ";
        s = s + this.hasTarget.getName();
        s = s + ", QUERY TYPE : " + this.queryType;
        s = s + ", QUERY : " + this.queryExpression;
        return s;
    }

    public boolean hasCondition() {
        return this.queryExpression != null;
    }

    public boolean isDefault() {
        return this.queryExpression == null;
    }
}

