/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.common.extbo.enums.ProviderType;
import com.savvion.sbm.bizlogic.server.DataSlotTableIndex;
import com.savvion.sbm.bizlogic.server.ExtBOConfig;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.ProcessInfo;
import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFDataSlotInstance;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFExternalWS;
import com.savvion.sbm.bizlogic.server.WFLink;
import com.savvion.sbm.bizlogic.server.WFNestedWS;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessReplaceInfo;
import com.savvion.sbm.bizlogic.server.WFWebServiceWS;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFimportProcess;
import com.savvion.sbm.bizlogic.server.dao.BLResourcesDAO;
import com.savvion.sbm.bizlogic.server.dao.DataSlotDAO;
import com.savvion.sbm.bizlogic.server.dao.MilestoneDAO;
import com.savvion.sbm.bizlogic.server.dao.PTReplaceInfoDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessXMLDAO;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.server.svo.SVOFactory;
import com.savvion.sbm.bizlogic.util.BCLService;
import com.savvion.sbm.bizlogic.util.BLAlertService;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDocService;
import com.savvion.sbm.bizlogic.util.BLProcessCacheService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.dms.svo.DocumentFolder;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMUtil;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class WFInplaceProcessReplacement {
    private static final String NEW_LINE = "\n";
    private static final String TAG = "\t";
    private static final String TARGET = "target";
    private static final String SOURCE = "source";
    private static final String CHECK_WORK_STEPS_METHOD = "WFInplaceProcessReplacement.checkWorkSteps";
    private static final String ROLLBACK_POINTS = "Rollback points";
    private static final String REACTIVE_WORKSTEPS = "Reactivate worksteps";
    private static final String MESSAGE_BIZ_LOGIC_ERROR_2765 = "BizLogic_ERR_2765";
    private static final String MESSAGE_BIZ_LOGIC_ERROR_2766 = "BizLogic_ERR_2766";
    private static final String MESSAGE_BIZ_LOGIC_ERROR_2767 = "BizLogic_ERR_2767";
    private static final String MESSAGE_BIZ_LOGIC_ERROR_2768 = "BizLogic_ERR_2768";
    private static final String MESSAGE_BIZ_LOGIC_ERROR_2769 = "BizLogic_ERR_2769";
    private static final String MESSAGE_BIZ_LOGIC_ERROR_2758 = "BizLogic_ERR_2758";
    private static final int RB_BUFFER_CODE = 300;
    private String[] addDSNames = null;
    private String[] addWSNames = null;
    private final HashMap extrace = new HashMap();
    private boolean validate = false;
    private long ptid = -1L;
    private String origptname = null;
    private String origptxml = null;
    private WFProcess origpt = null;
    private WFProcess inplacept = null;
    private final HashMap newws_map = new HashMap();
    private boolean hasInplaceInstanceBlobDSForSchema = false;
    private boolean hasInplaceGlobalBlobDSForSchema = false;
    private boolean hasInplaceInstanceBlobDSForValue = false;
    private boolean hasInplaceGlobalBlobDSForValue = false;
    private final HashMap addedInstanceDSInfoForSchema = new HashMap();
    private final HashMap addedGlobalDSInfoForSchema = new HashMap();
    private final HashMap addedInstanceDSInfoForValue = new HashMap();
    private final HashMap addedGlobalDSInfoForValue = new HashMap();
    private Session sess = null;
    private boolean hasNewInstanceComplexTypeDS = false;
    private Map<String, List<DataSlotTableIndex>> dsIndexes = null;

    public WFInplaceProcessReplacement(WFProcess origpt, Session sess) {
        this.ptid = origpt.getID();
        this.origpt = origpt;
        this.origptname = origpt.getName();
        BLConstants.single();
        BLConstants.single();
        this.extrace.put("RESULT", "SUCCESS");
        this.sess = sess;
    }

    private static synchronized WFProcess createProcess(WFProcess origpt, String processDefinition, HashMap extrace) throws Exception {
        WFProcess pt = null;
        try {
            if (origpt.hasMilestones()) {
                MilestoneDAO.removeMilestone(origpt.getID());
            }
            BLConstants.single();
            WFimportProcess importPr = new WFimportProcess(processDefinition, 2, origpt.getID(), origpt.getWorkstepNameList(), origpt.getMaxWorkstepID());
            pt = importPr.getProcess();
            if (importPr.getDataSlotIndexData() != null) {
                List<DataSlotTableIndex> dsTableIndexData = importPr.generateIndexNames(origpt.getID());
                pt.setDataSlotIndexData(dsTableIndexData);
            }
        }
        catch (Exception ex) {
            BLConstants.single();
            extrace.put("FAILEDREASON", ex.getMessage());
            BLConstants.single();
            BLConstants.single();
            extrace.put("RESULT", "FAILED");
            throw ex;
        }
        return pt;
    }

    public HashMap validateForUpdate(String processDefinition) {
        this.validate = true;
        try {
            processDefinition = WFInplaceProcessReplacement.getFileContent(processDefinition);
            this.inplacept = WFInplaceProcessReplacement.createProcess(this.origpt, processDefinition, this.extrace);
            this.syncProcessAttributes();
            this.validateProcess();
        }
        catch (BizLogicException bizLogicException) {
        }
        catch (Throwable th) {
            BLConstants.single();
            this.extrace.put("FAILEDREASON", th.getMessage());
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
        }
        return this.extrace;
    }

    private boolean validateProcess() {
        try {
            this.inplacept.validateProcess();
        }
        catch (BizLogicException blex) {
            BLConstants.single();
            this.extrace.put("FAILEDREASON", blex.getMessage());
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
            throw blex;
        }
        StringBuilder buf = new StringBuilder(300);
        if (!this.origpt.getName().equals(this.inplacept.getName())) {
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2770", new Object[]{this.origpt.getName(), this.inplacept.getName()}, false));
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            BLConstants.single();
            this.extrace.put("FAILEDREASON", buf.toString());
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
            throw new BizLogicException("BizLogic_ERR_2759", "WFInplaceProcessReplacement.validateProcess", new Object[]{this.origpt.getName(), this.inplacept.getName()});
        }
        if (!this.origpt.isActivated() && !this.origpt.isSuspendedBySeqVersion()) {
            buf = new StringBuilder(300);
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2771", new Object[]{this.origpt.getName()}, false));
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            BLConstants.single();
            this.extrace.put("FAILEDREASON", buf.toString());
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
            throw new BizLogicException("BizLogic_ERR_2761", "WFInplaceProcessReplacement.validateProcess", new Object[]{this.origpt.getName()});
        }
        this.checkWorkSteps();
        this.checkDataSlots();
        this.inplacept.checkPreCondGlobalSlotReference();
        return true;
    }

    public ProcessTemplate replace(String xmlDefinition) {
        ProcessTemplate pt = null;
        boolean isDSColumnAltered = false;
        try {
            xmlDefinition = WFInplaceProcessReplacement.getFileContent(xmlDefinition);
            this.inplacept = WFInplaceProcessReplacement.createProcess(this.origpt, xmlDefinition, this.extrace);
            if (BLControl.util.DEBUG_CREATE) {
                ProcessInfo.printProcess(this.inplacept);
            }
            this.syncProcessAttributes();
            this.validateProcess();
            if (this.origpt.hasResources()) {
                BLResourcesDAO.delete(this.ptid);
            }
            if (this.inplacept.hasResources()) {
                BLResourcesDAO.create(this.ptid, this.inplacept.resourceList);
            }
            ProcessControl.addDataSlotColumns(this.inplacept, this.addedInstanceDSInfoForSchema, this.addedGlobalDSInfoForSchema, this.hasInplaceInstanceBlobDSForSchema, this.hasInplaceGlobalBlobDSForSchema);
            if (!this.addedInstanceDSInfoForSchema.isEmpty() || !this.addedGlobalDSInfoForSchema.isEmpty()) {
                isDSColumnAltered = true;
            }
            this.origptxml = ProcessXMLDAO.load(this.ptid);
            ProcessXMLDAO.update(this.inplacept.getID(), xmlDefinition);
            if (!this.origpt.hasDocumentDataslot() && this.inplacept.hasDocumentDataslot()) {
                DocumentFolder folder = BLDocService.createTemplateFolder((long)this.ptid, (String)this.inplacept.getName());
                this.inplacept.setFolderId(folder.getId());
            }
            this.checkAndSetFYI();
            WFInplaceProcessReplacement.syncXMLCollectionID(this.origpt, this.inplacept);
            BLAlertService.single().updateForProcessRefresh(this.origpt, this.inplacept);
            this.dsIndexes = this.prepareDataSlotIndexes();
            long ptRefreshID = this.updateProcessReplaceInfo();
            ProcessControl.addProcessTemplateToCache(this.inplacept.getID(), this.inplacept);
            if (this.addedGlobalDSInfoForValue != null && !this.addedGlobalDSInfoForValue.isEmpty()) {
                ProcessControl.updateNewGlobalDSForPTR(this.sess, this.inplacept, this.addedGlobalDSInfoForValue);
            }
            Map<String, Object> eventContext = this.inplacept.getEventContext();
            if (this.addDSNames != null && this.addDSNames.length > 0) {
                BLConstants.single();
                eventContext.put("ADDITIONALDS", this.addDSNames);
            }
            if (this.addWSNames != null && this.addWSNames.length > 0) {
                BLConstants.single();
                eventContext.put("ADDITIONALWS", this.addWSNames);
            }
            eventContext.put("PT_REFRESH_ID", ptRefreshID);
            eventContext.put("PROCESS_XML", xmlDefinition);
            eventContext.put("LAST_MODIFIED_TIME", this.inplacept.getLastModifiedTime());
            eventContext.put("CATEGORY", this.inplacept.getCategory());
            BLUtil.fireEvent(eventContext, (int)151);
            this.inplacept.setStatus(2);
            if (this.origpt.isSuspendedBySeqVersion()) {
                this.inplacept.setStatus(4);
                this.inplacept.setSuspendedBySeqVersion(true);
            } else {
                this.inplacept.setStatus(2);
            }
            ProcessControl.updateProcessTemplate(this.inplacept);
            pt = SVOFactory.getProcessTemplate(this.sess, this.ptid);
            BCLService.removeService((String)this.origpt.getName());
        }
        catch (BizLogicException ble) {
            if (isDSColumnAltered) {
                ProcessControl.dropDataSlotColumns(this.inplacept, this.addedInstanceDSInfoForSchema, this.addedGlobalDSInfoForSchema, this.hasInplaceInstanceBlobDSForSchema, this.hasInplaceGlobalBlobDSForSchema);
            }
            ProcessControl.addProcessTemplateToCache(this.origpt.getID(), this.origpt);
            BLProcessCacheService.self().onUpdate(this.origpt.getID());
            throw new BizLogicException("BizLogic_ERR_2752", "WFInplaceProcessReplacement.replace", new Object[]{this.origptname}, (Throwable)ble);
        }
        catch (Exception e) {
            if (isDSColumnAltered) {
                ProcessControl.dropDataSlotColumns(this.inplacept, this.addedInstanceDSInfoForSchema, this.addedGlobalDSInfoForSchema, this.hasInplaceInstanceBlobDSForSchema, this.hasInplaceGlobalBlobDSForSchema);
            }
            ProcessControl.addProcessTemplateToCache(this.origpt.getID(), this.origpt);
            BLProcessCacheService.self().onUpdate(this.origpt.getID());
            throw new BizLogicException("BizLogic_ERR_2752", "WFInplaceProcessReplacement.create", new Object[]{this.origptname}, (Throwable)e);
        }
        return pt;
    }

    private static void syncXMLCollectionID(WFProcess origPT, WFProcess newPT) {
        Vector dsl = origPT.hasDataslots;
        WFDataslot pds = null;
        WFDataslot dds = null;
        if (dsl != null) {
            for (int itr = 0; itr < dsl.size(); ++itr) {
                pds = (WFDataslot)dsl.elementAt(itr);
                if (!pds.getType().equals("XML")) continue;
                dds = newPT.getDataslot(pds.getName());
                dds.setXMLCollectionID(pds.getXMLCollectionID());
            }
        }
    }

    private static String getFileContent(String xmlFile) {
        if (SBMUtil.isValidXMLFileName((String)xmlFile)) {
            String fn = BLUtil.getPTXMLFilePath((String)xmlFile);
            File f = new File(fn);
            if (!f.exists()) {
                throw new BizLogicException("BizLogic_ERR_109", "WFInplaceProcessReplacement.getFileContent()", new Object[]{xmlFile});
            }
            try {
                SBMConstants.self().getClass();
                xmlFile = FileUtil.getString((File)f, (String)"UTF-8");
            }
            catch (Exception e) {
                throw new BizLogicException("BizLogic_ERR_109", "WFInplaceProcessReplacement.getFileContent()", new Object[]{xmlFile}, (Throwable)e);
            }
        }
        return xmlFile;
    }

    private long updateProcessReplaceInfo() {
        long ptrID = -1L;
        try {
            ptrID = BLControl.util.ptrSeq.getNextNumber();
        }
        catch (SQLException sqle) {
            throw new RuntimeException("Error initializing sequence", sqle);
        }
        long createDate = new Date().getTime();
        PTReplaceInfoDAO.create(ptrID, this.ptid, this.origptname, createDate, this.origptxml);
        WFProcessReplaceInfo replaceInfo = new WFProcessReplaceInfo(ptrID, this.ptid, this.addedGlobalDSInfoForValue, this.addedInstanceDSInfoForValue, this.hasNewInstanceComplexTypeDS, this.dsIndexes);
        if (this.addedInstanceDSInfoForValue == null || this.addedInstanceDSInfoForValue.isEmpty()) {
            PTReplaceInfoDAO.update(ptrID, true);
        }
        this.inplacept.setReplaceInfo(replaceInfo);
        return ptrID;
    }

    private void updateDataSlot() {
        ProcessControl.updateNewDataSlotsForPTR(this.sess, this.inplacept);
    }

    private void checkWorkSteps() {
        int itr;
        int itr2;
        Vector origwslist = this.origpt.getWorksteps();
        Vector inplacewslist = this.inplacept.getWorksteps();
        String[] origwsnames = new String[origwslist.size()];
        String[] inplacewsnames = new String[inplacewslist.size()];
        Vector<String> deletedws = new Vector<String>();
        WFWorkstep origws = null;
        WFWorkstep inplacews = null;
        for (itr2 = 0; itr2 < origwslist.size(); ++itr2) {
            origws = (WFWorkstep)origwslist.elementAt(itr2);
            origwsnames[itr2] = origws.getName();
        }
        for (itr2 = 0; itr2 < inplacewslist.size(); ++itr2) {
            inplacews = (WFWorkstep)inplacewslist.elementAt(itr2);
            inplacewsnames[itr2] = inplacews.getName();
        }
        origws = null;
        inplacews = null;
        Object origwsname = null;
        boolean wspresent = false;
        for (int itr3 = 0; itr3 < origwsnames.length; ++itr3) {
            for (int inplaceitr = 0; inplaceitr < inplacewsnames.length; ++inplaceitr) {
                if (!inplacewsnames[inplaceitr].equals(origwsnames[itr3])) continue;
                wspresent = true;
                break;
            }
            if (!wspresent) {
                deletedws.add(origwsnames[itr3]);
                continue;
            }
            wspresent = false;
        }
        StringBuilder buf = null;
        if (!deletedws.isEmpty()) {
            BLConstants.single();
            buf = new StringBuilder("\n--------------------------------------------------------\n");
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2772", null, false));
            for (itr = 0; itr < deletedws.size(); ++itr) {
                buf.append("\n\t").append((String)deletedws.elementAt(itr));
            }
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            BLConstants.single();
            this.extrace.put("FAILEDREASON", buf.toString());
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
            throw new BizLogicException(MESSAGE_BIZ_LOGIC_ERROR_2758, "WFInplaceProcessReplacement.checkWorkSteps()", new Object[]{this.origpt.getName(), buf.toString()});
        }
        for (itr = 0; itr < inplacewslist.size(); ++itr) {
            inplacews = (WFWorkstep)inplacewslist.elementAt(itr);
            origws = this.origpt.getWorkstep(inplacews.getName(), true);
            if (origws != null) {
                this.compareWorkstep(origws, inplacews);
                continue;
            }
            this.newws_map.put(inplacews.getName(), inplacews);
        }
        if (BLUtil.self().isPTRSafeMode()) {
            this.checkSafeMode();
        }
        if (!this.origpt.getRollbackPoints().isEmpty()) {
            this.checkFlowMatchForRollback();
        }
        this.checkNewWorksteps();
    }

    private void checkSafeMode() {
        WFWorkstep inplacews = null;
        if (!this.newws_map.isEmpty()) {
            boolean violated = false;
            Map.Entry entry2 = null;
            String key = null;
            StringBuilder newwsbuf = new StringBuilder(300);
            BLConstants.single();
            newwsbuf.append("\n--------------------------------------------------------\n");
            newwsbuf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2783", new Object[]{this.inplacept.getName()}, false));
            for (Map.Entry entry2 : this.newws_map.entrySet()) {
                key = (String)entry2.getKey();
                inplacews = (WFWorkstep)entry2.getValue();
                if (!inplacews.isAndJoin()) continue;
                newwsbuf.append("\n\t" + key);
                violated = true;
            }
            if (!violated) {
                return;
            }
            BLConstants.single();
            newwsbuf.append("\n--------------------------------------------------------\n");
            BLConstants.single();
            this.extrace.put("FAILEDREASON", newwsbuf.toString());
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
            throw new BizLogicException(MESSAGE_BIZ_LOGIC_ERROR_2758, "WFInplaceProcessReplacement.checkSafeMode", new Object[]{this.origpt.getName(), newwsbuf.toString()});
        }
    }

    private boolean checkFlowMatchForRollback() {
        Vector origwslist = this.origpt.getWorkstepsAsc();
        Vector inplacewslist = this.inplacept.getWorkstepsAsc();
        WFWorkstep origws = null;
        WFWorkstep inplacews = null;
        Vector origLinks = null;
        Vector inplaceLinks = null;
        if (!this.newws_map.isEmpty()) {
            Map.Entry entry2 = null;
            String key = null;
            StringBuilder newwsbuf = new StringBuilder(300);
            BLConstants.single();
            newwsbuf.append("\n--------------------------------------------------------\n");
            newwsbuf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2762", null, false));
            for (Map.Entry entry2 : this.newws_map.entrySet()) {
                key = (String)entry2.getKey();
                newwsbuf.append("\n\t" + key);
            }
            BLConstants.single();
            newwsbuf.append("\n--------------------------------------------------------\n");
            BLConstants.single();
            this.extrace.put("FAILEDREASON", newwsbuf.toString());
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
            throw new BizLogicException(MESSAGE_BIZ_LOGIC_ERROR_2758, "WFInplaceProcessReplacement.checkFlowMatchForRollback", new Object[]{this.origpt.getName(), newwsbuf.toString()});
        }
        for (int itr = 0; itr < origwslist.size(); ++itr) {
            origws = (WFWorkstep)origwslist.elementAt(itr);
            origLinks = origws.getOutConnections();
            inplacews = (WFWorkstep)inplacewslist.elementAt(itr);
            if (!origws.getName().equals(inplacews.getName())) {
                StringBuilder rbbuf = new StringBuilder(300);
                BLConstants.single();
                rbbuf.append("\n--------------------------------------------------------\n");
                rbbuf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2763", null, false));
                BLConstants.single();
                rbbuf.append("\n--------------------------------------------------------\n");
                BLConstants.single();
                this.extrace.put("FAILEDREASON", rbbuf.toString());
                BLConstants.single();
                BLConstants.single();
                this.extrace.put("RESULT", "FAILED");
                throw new BizLogicException(MESSAGE_BIZ_LOGIC_ERROR_2758, "WFInplaceProcessReplacement.checkFlowMatchForRollback", new Object[]{this.origpt.getName(), rbbuf.toString()});
            }
            inplaceLinks = inplacews.getOutConnections();
            this.compareOutLinks(origws.getName(), this.origpt.getName(), origLinks, inplaceLinks);
        }
        return true;
    }

    private boolean compareOutLinks(String wsname, String ptname, Vector origLinks, Vector inplaceLinks) {
        WFWorkstep origws = null;
        WFWorkstep inplacews = null;
        boolean linkmatch = false;
        if (origLinks.isEmpty() && inplaceLinks.isEmpty()) {
            return true;
        }
        if (origLinks.size() == inplaceLinks.size()) {
            for (int itr = 0; itr < origLinks.size(); ++itr) {
                origws = ((WFLink)origLinks.elementAt(itr)).getTarget();
                inplacews = ((WFLink)inplaceLinks.elementAt(itr)).getTarget();
                if (!origws.getName().equals(inplacews.getName())) {
                    linkmatch = false;
                    break;
                }
                linkmatch = true;
            }
        }
        if (!linkmatch) {
            StringBuilder linkbuf = new StringBuilder(300);
            BLConstants.single();
            linkbuf.append("\n--------------------------------------------------------\n");
            linkbuf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2764", new Object[]{wsname}, false));
            BLConstants.single();
            this.extrace.put("FAILEDREASON", linkbuf.toString());
            BLConstants.single();
            linkbuf.append("\n--------------------------------------------------------\n");
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
            throw new BizLogicException(MESSAGE_BIZ_LOGIC_ERROR_2758, "WFInplaceProcessReplacement.compareOutLinks", new Object[]{this.origpt.getName(), linkbuf.toString()});
        }
        return true;
    }

    private void checkNewWorksteps() {
        Map.Entry entry2 = null;
        WFWorkstep pnt = null;
        this.addWSNames = new String[this.newws_map.size()];
        int index = 0;
        StringBuilder newAndJoinBuffer = new StringBuilder();
        newAndJoinBuffer.append("\n--------------------------------------------------------\n").append(BLControl.msgFactory.lookup(MESSAGE_BIZ_LOGIC_ERROR_2765, null, false));
        boolean isNewAndJoinBuffer = false;
        StringBuilder newWsSuccessBuffer = new StringBuilder(300);
        newWsSuccessBuffer.append("\n--------------------------------------------------------\n");
        newWsSuccessBuffer.append(BLControl.msgFactory.lookup(MESSAGE_BIZ_LOGIC_ERROR_2766, null, false));
        boolean isNewWsSuccessBuffer = false;
        for (Map.Entry entry2 : this.newws_map.entrySet()) {
            WFWorkstep wfWorkstep = (WFWorkstep)entry2.getValue();
            this.addWSNames[index] = wfWorkstep.getName();
            ++index;
            if (wfWorkstep.getType() == 104) {
                isNewAndJoinBuffer = this.updateNewAndJoinBufferOutgoing(newAndJoinBuffer, wfWorkstep, isNewAndJoinBuffer);
                Vector incoming = wfWorkstep.getInConnections();
                for (WFLink wfLink : incoming) {
                    pnt = wfLink.getSource();
                    isNewAndJoinBuffer = this.updateNewAndJoinBufferIncoming(newAndJoinBuffer, pnt, wfWorkstep, isNewAndJoinBuffer);
                }
            } else {
                isNewWsSuccessBuffer = this.updateNewWsSuccessBuffer(newWsSuccessBuffer, wfWorkstep, pnt, isNewWsSuccessBuffer);
            }
            this.processWsIsRollbackPoint(wfWorkstep);
            this.processWSNotReactiveWorkStepName(wfWorkstep);
        }
        this.updateExTraceWithSuccessAndJoinBuffer(isNewWsSuccessBuffer, newWsSuccessBuffer, isNewAndJoinBuffer, newAndJoinBuffer);
    }

    private boolean updateNewAndJoinBufferOutgoing(StringBuilder newAndJoinBuffer, WFWorkstep wfWorkstep, boolean isNewAndJoinBufferParam) {
        boolean isNewAndJoinBuffer = isNewAndJoinBufferParam;
        Vector outgoing = wfWorkstep.getOutConnections();
        for (WFLink wfLink : outgoing) {
            WFWorkstep child = wfLink.getTarget();
            if (this.newws_map.get(child.getName()) != null) continue;
            isNewAndJoinBuffer = true;
            newAndJoinBuffer.append("\n\t").append(BLControl.msgFactory.lookup(MESSAGE_BIZ_LOGIC_ERROR_2767, new Object[]{wfWorkstep.getName(), TARGET, child.getName()}, false)).append(" \n");
        }
        return isNewAndJoinBuffer;
    }

    private boolean updateNewAndJoinBufferIncoming(StringBuilder newAndJoinBuffer, WFWorkstep pntWorkstep, WFWorkstep wfWorkstep, boolean isNewAndJoinBufferParam) {
        boolean isNewAndJoinBuffer = isNewAndJoinBufferParam;
        if (this.newws_map.get(pntWorkstep.getName()) == null) {
            isNewAndJoinBuffer = true;
            newAndJoinBuffer.append("\n\t").append(BLControl.msgFactory.lookup(MESSAGE_BIZ_LOGIC_ERROR_2767, new Object[]{wfWorkstep.getName(), SOURCE, pntWorkstep.getName()}, false)).append(" \n");
        }
        return isNewAndJoinBuffer;
    }

    private boolean updateNewWsSuccessBuffer(StringBuilder newWsSuccessBuffer, WFWorkstep wfWorkstep, WFWorkstep pntWorkstep, boolean isNewWsSuccessBufferParam) {
        boolean isNewWsSuccessBuffer = isNewWsSuccessBufferParam;
        Vector outgoing = wfWorkstep.getOutConnections();
        for (WFLink wfLink : outgoing) {
            WFWorkstep child = wfLink.getTarget();
            if (child.getType() != 104 || this.newws_map.get(child.getName()) != null) continue;
            isNewWsSuccessBuffer = true;
            newWsSuccessBuffer.append("\n\t").append(wfWorkstep.getName()).append(BLControl.msgFactory.lookup(MESSAGE_BIZ_LOGIC_ERROR_2768, new Object[]{wfWorkstep.getName(), TARGET, pntWorkstep.getName(), child.getName()}, false));
        }
        return isNewWsSuccessBuffer;
    }

    private void processWsIsRollbackPoint(WFWorkstep wfWorkstep) {
        if (wfWorkstep.isRollbackPoint()) {
            this.updateExTraceWithRbBufferValue(wfWorkstep, ROLLBACK_POINTS);
        }
    }

    private void processWSNotReactiveWorkStepName(WFWorkstep wfWorkstep) {
        if (wfWorkstep.getReactivateWorkStepName() != null) {
            this.updateExTraceWithRbBufferValue(wfWorkstep, REACTIVE_WORKSTEPS);
        }
    }

    private void updateExTraceWithRbBufferValue(WFWorkstep wfWorkstep, String message) {
        StringBuilder rbbuf = new StringBuilder(300);
        rbbuf.append("\n--------------------------------------------------------\n").append(BLControl.msgFactory.lookup(MESSAGE_BIZ_LOGIC_ERROR_2769, new Object[]{message, wfWorkstep.getName()}, false)).append("\n--------------------------------------------------------\n");
        this.processExTrace(rbbuf.toString());
    }

    private void updateExTraceWithSuccessAndJoinBuffer(boolean isNewWsSuccessBuffer, StringBuilder newWsSuccessBuffer, boolean isNewAndJoinBuffer, StringBuilder newAndJoinBuffer) {
        String value = "";
        if (isNewWsSuccessBuffer) {
            newWsSuccessBuffer.append("\n--------------------------------------------------------\n");
            value = newWsSuccessBuffer.toString();
        }
        if (isNewAndJoinBuffer) {
            newAndJoinBuffer.append("\n--------------------------------------------------------\n");
            value = newAndJoinBuffer.append(value).toString();
        }
        if (!value.trim().isEmpty()) {
            this.processExTrace(value);
        }
    }

    private void processExTrace(String value) {
        this.extrace.put("FAILEDREASON", value);
        this.extrace.put("RESULT", "FAILED");
        throw new BizLogicException(MESSAGE_BIZ_LOGIC_ERROR_2758, CHECK_WORK_STEPS_METHOD, new Object[]{this.origpt.getName(), value});
    }

    private void checkDataSlots() {
        Vector origDSNames = this.origpt.getDataSlotNames();
        Vector inplaceDSList = this.inplacept.getDataslots();
        WFDataslot origds = null;
        WFDataslot inplaceds = null;
        Vector<WFDataslot> additionalInstanceDS = new Vector<WFDataslot>();
        Vector<WFDataslot> additionalGlobalDS = new Vector<WFDataslot>();
        boolean hasOrigInstanceBlobDS = this.origpt.hasInstanceBlobDS();
        boolean hasOrigGlobalBlobDS = this.origpt.hasGlobalBlobDS();
        Vector nonAllowedDs = new Vector();
        try {
            for (int itr = 0; itr < inplaceDSList.size(); ++itr) {
                inplaceds = (WFDataslot)inplaceDSList.elementAt(itr);
                origds = this.origpt.getDataslot(inplaceds.getName(), true);
                if (origds == null) {
                    if (!inplaceds.isGlobal()) {
                        if (inplaceds.isList() || inplaceds.isObject() || inplaceds.isMap()) {
                            if (!hasOrigInstanceBlobDS && !this.hasInplaceInstanceBlobDSForSchema) {
                                this.hasInplaceInstanceBlobDSForSchema = true;
                                this.hasInplaceInstanceBlobDSForValue = true;
                            } else if (!this.hasInplaceInstanceBlobDSForValue) {
                                this.hasInplaceInstanceBlobDSForValue = true;
                            }
                        }
                        this.checkComplexTypes(inplaceds);
                        additionalInstanceDS.addElement(inplaceds);
                        continue;
                    }
                    if (inplaceds.isList() || inplaceds.isObject() || inplaceds.isMap()) {
                        if (!hasOrigGlobalBlobDS && !this.hasInplaceGlobalBlobDSForSchema) {
                            this.hasInplaceGlobalBlobDSForSchema = true;
                            this.hasInplaceGlobalBlobDSForValue = true;
                        } else if (!this.hasInplaceGlobalBlobDSForValue) {
                            this.hasInplaceGlobalBlobDSForValue = true;
                        }
                    }
                    additionalGlobalDS.addElement(inplaceds);
                    continue;
                }
                this.compareDS(origds, inplaceds);
                if (this.inplacept.isMonitoringProcess()) {
                    this.checkDuplicateMonitorId();
                }
                origDSNames.remove(origds.getName());
            }
            StringBuilder buf = new StringBuilder(300);
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2773", null, false));
            if (!nonAllowedDs.isEmpty()) {
                for (int itr = 0; itr < nonAllowedDs.size(); ++itr) {
                    inplaceds = (WFDataslot)nonAllowedDs.elementAt(itr);
                    buf.append("\n\t" + inplaceds.getName()).append(" \n");
                }
                BLConstants.single();
                buf.append("\n--------------------------------------------------------\n");
                BLConstants.single();
                this.extrace.put("FAILEDREASON", buf.toString());
                BLConstants.single();
                BLConstants.single();
                this.extrace.put("RESULT", "FAILED");
                throw new BizLogicException("BizLogic_ERR_2760", "WFInplaceProcessReplacement.checkDataSlots", new Object[]{this.origpt.getName(), buf.toString()});
            }
            buf = new StringBuilder(300);
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2774", null, false));
            if (!origDSNames.isEmpty()) {
                for (int itr = 0; itr < origDSNames.size(); ++itr) {
                    buf.append(TAG + (String)origDSNames.elementAt(itr)).append(" \n");
                }
                BLConstants.single();
                buf.append("\n--------------------------------------------------------\n");
                BLConstants.single();
                this.extrace.put("FAILEDREASON", buf.toString());
                BLConstants.single();
                BLConstants.single();
                this.extrace.put("RESULT", "FAILED");
                throw new BizLogicException("BizLogic_ERR_2754", "WFInplaceProcessReplacement.checkDataSlots", new Object[]{this.origpt.getName()});
            }
            int addsize = additionalInstanceDS.size() + additionalGlobalDS.size();
            if (addsize > 0) {
                this.addDSNames = new String[addsize];
                int instItr = 0;
                for (instItr = 0; instItr < additionalInstanceDS.size(); ++instItr) {
                    WFDataslot ds = (WFDataslot)additionalInstanceDS.elementAt(instItr);
                    if (!(ds.isObject() || ds.isList() || ds.isMap())) {
                        this.addedInstanceDSInfoForSchema.put(ds.getName(), ds.getMetaData());
                        this.addedInstanceDSInfoForValue.put(ds.getName(), ds.getMetaData());
                    } else if (this.hasInplaceInstanceBlobDSForSchema) {
                        this.addedInstanceDSInfoForSchema.put(ds.getName(), ds.getMetaData());
                        this.addedInstanceDSInfoForValue.put(ds.getName(), ds.getMetaData());
                    } else if (this.hasInplaceInstanceBlobDSForValue) {
                        this.addedInstanceDSInfoForValue.put(ds.getName(), ds.getMetaData());
                    }
                    this.addDSNames[instItr] = ds.getName();
                }
                for (int itr = 0; itr < additionalGlobalDS.size(); ++itr) {
                    WFDataslot ds = (WFDataslot)additionalGlobalDS.elementAt(itr);
                    if (!(ds.isObject() || ds.isList() || ds.isMap())) {
                        this.addedGlobalDSInfoForSchema.put(ds.getName(), ds.getMetaData());
                        this.addedGlobalDSInfoForValue.put(ds.getName(), ds.getMetaData());
                    } else if (this.hasInplaceGlobalBlobDSForSchema) {
                        this.addedGlobalDSInfoForSchema.put(ds.getName(), ds.getMetaData());
                        this.addedGlobalDSInfoForValue.put(ds.getName(), ds.getMetaData());
                    } else if (this.hasInplaceGlobalBlobDSForValue) {
                        this.addedGlobalDSInfoForValue.put(ds.getName(), ds.getMetaData());
                    }
                    this.addDSNames[instItr + itr] = ds.getName();
                }
            }
        }
        catch (BizLogicException ble) {
            throw ble;
        }
        catch (RuntimeException rex) {
            throw new BizLogicException("BizLogic_ERR_2752", "WFInplaceProcessReplacement.checkDataSlots", new Object[]{this.origpt.getName()}, (Throwable)rex);
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_2752", "WFInplaceProcessReplacement.checkDataSlots", new Object[]{this.origpt.getName()}, (Throwable)ex);
        }
    }

    private void checkComplexTypes(WFDataslot ds) {
        if ((ds.isDocument() || ds.isXML() || ds.isDate()) && !this.hasNewInstanceComplexTypeDS) {
            this.hasNewInstanceComplexTypeDS = true;
        }
    }

    private void syncProcessAttributes() {
        this.inplacept.populateData();
        this.inplacept.setAppName(this.origpt.getAppName());
        this.inplacept.setGlobalDSTableName(this.origpt.getGlobalDSTableName());
        this.inplacept.setDSTableName(this.origpt.getDSTableName());
        this.inplacept.setStartTime(this.origpt.getStartTime());
        this.inplacept.setLastModifiedTime(System.currentTimeMillis());
    }

    private boolean compareWorkstep(WFWorkstep origws, WFWorkstep inplacews) {
        StringBuilder buf = new StringBuilder();
        BLConstants.single();
        buf.append("\n--------------------------------------------------------\n");
        buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2775", new Object[]{"workstep", origws.getName()}, false));
        boolean match = true;
        boolean typematch = true;
        if (origws.getType() != inplacews.getType()) {
            buf.append("TYPE : \n\tEXISTING :: " + origws.getType());
            buf.append("\n\tNEW :: " + inplacews.getType() + " \n\n");
            match = false;
            typematch = false;
        }
        if (typematch) {
            boolean inplacesync;
            boolean origsync;
            boolean inplaceAllPerf;
            boolean origAllPerf;
            int n = origws.getType();
            BLConstants.single();
            if (n == 102 && (origAllPerf = ((WFAtomicWS)origws).getPerformedByAll()) != (inplaceAllPerf = ((WFAtomicWS)inplacews).getPerformedByAll())) {
                String origPerf = "ALL";
                if (!origAllPerf) {
                    origPerf = "ANY";
                }
                String inplacePerf = "ALL";
                if (!inplaceAllPerf) {
                    inplacePerf = "ANY";
                }
                buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"PERFORMER CATEGORY", origPerf, inplacePerf}, false));
                match = false;
            }
            int n2 = origws.getType();
            BLConstants.single();
            if (n2 == 107 && (origsync = ((WFExternalWS)origws).isSynchron()) != (inplacesync = ((WFExternalWS)inplacews).isSynchron())) {
                buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"SYNCHRONOUS NATURE", String.valueOf(origsync), String.valueOf(inplacesync)}, false));
                match = false;
            }
            int n3 = origws.getType();
            BLConstants.single();
            if (n3 == 109 && (origsync = ((WFWebServiceWS)origws).isSynchronous()) != (inplacesync = ((WFWebServiceWS)inplacews).isSynchronous())) {
                buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"SYNCHRONOUS NATURE", String.valueOf(origsync), String.valueOf(inplacesync)}, false));
                match = false;
            }
            int n4 = origws.getType();
            BLConstants.single();
            if (n4 == 108 && (origsync = ((WFNestedWS)origws).isSynchronous()) != (inplacesync = ((WFNestedWS)inplacews).isSynchronous())) {
                buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"SYNCHRONOUS NATURE", String.valueOf(origsync), String.valueOf(inplacesync)}, false));
                match = false;
            }
            int n5 = origws.getType();
            BLConstants.single();
            if (n5 == 104) {
                boolean andmatch = this.compareAndLinks(origws, inplacews);
                if (match) {
                    match = andmatch;
                }
            }
        }
        if (origws.isRollbackPoint() != inplacews.isRollbackPoint()) {
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"ROLLBACKPOINT", String.valueOf(origws.isRollbackPoint()), String.valueOf(inplacews.isRollbackPoint())}, false));
            match = false;
        }
        String origReactWsname = origws.getReactivateWorkStepName();
        String inplaceReactWsname = inplacews.getReactivateWorkStepName();
        if ((origReactWsname != null || inplaceReactWsname != null) && (origReactWsname == null && inplaceReactWsname != null || origReactWsname != null && inplaceReactWsname == null || !origReactWsname.equals(inplaceReactWsname))) {
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"ReactivateWorkStepName", origReactWsname, inplaceReactWsname}, false));
            match = false;
        }
        if (!match) {
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            BLConstants.single();
            this.extrace.put("FAILEDREASON", buf.toString());
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
            throw new BizLogicException("BizLogic_ERR_2751", "WFInplaceProcessReplacement.compareDS", new Object[]{this.origptname, origws.getName(), buf.toString()});
        }
        return match;
    }

    private boolean compareAndLinks(WFWorkstep origws, WFWorkstep inplacews) {
        int itr;
        Vector origprewsnames = origws.getPreviousWorkstepsNames();
        Vector inplaceprewsnames = inplacews.getPreviousWorkstepsNames();
        StringBuilder buf = new StringBuilder(300);
        if (origprewsnames.size() != inplaceprewsnames.size()) {
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2777", new Object[]{String.valueOf(origprewsnames.size()), origws.getName(), String.valueOf(inplaceprewsnames.size())}, false));
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            BLConstants.single();
            this.extrace.put("FAILEDREASON", buf.toString());
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
            throw new BizLogicException("BizLogic_ERR_2756", "WFInplaceProcessReplacement.compareAndLinks", new Object[]{this.origptname, origws.getName(), String.valueOf(origprewsnames.size()), "predecessors", String.valueOf(inplaceprewsnames.size())});
        }
        String origwsname = null;
        String inplacewsname = null;
        block0: for (int origitr = origprewsnames.size(); origitr > 0; --origitr) {
            origwsname = (String)origprewsnames.elementAt(origitr - 1);
            for (int inplaceitr = inplaceprewsnames.size(); inplaceitr > 0; --inplaceitr) {
                inplacewsname = (String)inplaceprewsnames.elementAt(inplaceitr - 1);
                if (!inplacewsname.equals(origwsname)) continue;
                inplaceprewsnames.remove(inplacewsname);
                origprewsnames.remove(origwsname);
                continue block0;
            }
        }
        if (!origprewsnames.isEmpty()) {
            buf = new StringBuilder(300);
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2778", new Object[]{origws.getName()}, false));
            for (itr = 0; itr < origprewsnames.size(); ++itr) {
                buf.append("\n\t").append((String)origprewsnames.elementAt(itr));
            }
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2779", null, false));
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            BLConstants.single();
            this.extrace.put("FAILEDREASON", buf.toString());
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
            throw new BizLogicException("BizLogic_ERR_2757", "WFInplaceProcessReplacement.compareAndLinks", new Object[]{this.origptname, origws.getName(), "predecessors"});
        }
        if (!inplaceprewsnames.isEmpty()) {
            buf = new StringBuilder(300);
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2780", new Object[]{origws.getName()}, false));
            for (itr = 0; itr < inplaceprewsnames.size(); ++itr) {
                buf.append("\n\t ").append((String)inplaceprewsnames.elementAt(itr));
            }
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2779", null, false));
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            BLConstants.single();
            this.extrace.put("FAILEDREASON", buf.toString());
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
            throw new BizLogicException("BizLogic_ERR_2757", "WFInplaceProcessReplacement.compareAndLinks", new Object[]{this.origptname, origws.getName(), "predecessors"});
        }
        return true;
    }

    private boolean compareDS(WFDataslot origds, WFDataslot inplaceds) {
        String dsName = origds.getName();
        StringBuilder buf = new StringBuilder();
        BLConstants.single();
        buf.append("\n--------------------------------------------------------\n");
        buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2775", new Object[]{"dataslot", dsName}, false));
        boolean match = true;
        boolean typematch = true;
        if (!origds.getName().equals(inplaceds.getName())) {
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"NAME", dsName, inplaceds.getName()}, false));
            typematch = false;
            match = false;
        }
        if (!origds.getType().equals(inplaceds.getType())) {
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"TYPE", origds.getType(), inplaceds.getType()}, false));
            match = false;
            typematch = false;
        }
        if (origds.isPublic() != inplaceds.isPublic()) {
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"PUBLIC ACCESS", String.valueOf(origds.isPublic()), String.valueOf(inplaceds.isPublic())}, false));
            match = false;
        }
        if (origds.getSize() != inplaceds.getSize()) {
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"SIZE", String.valueOf(origds.getSize()), String.valueOf(inplaceds.getSize())}, false));
            match = false;
        }
        if (origds.isGlobal() != inplaceds.isGlobal()) {
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"GLOBAL SCOPE", String.valueOf(origds.isGlobal()), String.valueOf(inplaceds.isGlobal())}, false));
            match = false;
        }
        this.checkExternalPersistence(origds, inplaceds);
        if (!this.validate && typematch && origds.isGlobal()) {
            Object origDSValue = WFDataSlotInstance.self().getGlobalDSValue(this.sess, origds);
            String origDSName = origds.getName();
            Object inplaceDSValue = inplaceds.getValue();
            if (origDSValue == null && inplaceDSValue != null || origDSValue != null && inplaceDSValue == null) {
                inplaceds.syncValueForReplace(origDSValue);
                BLControl.logger.warnKey("BizLogic_ERR_1136", new Object[]{origDSName});
            } else if (typematch && origDSValue != null && inplaceDSValue != null && !origDSValue.equals(inplaceDSValue)) {
                inplaceds.syncValueForReplace(origDSValue);
                BLControl.logger.warnKey("BizLogic_ERR_1136", new Object[]{origDSName});
            }
        }
        if (typematch && origds.isString()) {
            Vector<String> choicesRemovedList = new Vector<String>();
            Vector origChoiceList = origds.getChoices();
            Vector inplaceChoiceList = inplaceds.getChoices();
            if (inplaceChoiceList == null) {
                inplaceChoiceList = new Vector();
            }
            if (origChoiceList != null) {
                for (int origitr = 0; origitr < origChoiceList.size(); ++origitr) {
                    String origChoice = (String)origChoiceList.elementAt(origitr);
                    boolean found = false;
                    for (int inplaceitr = 0; inplaceitr < inplaceChoiceList.size(); ++inplaceitr) {
                        String inplaceChoice = (String)inplaceChoiceList.elementAt(inplaceitr);
                        if (!origChoice.equals(inplaceChoice)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    choicesRemovedList.add(origChoice);
                }
                if (!choicesRemovedList.isEmpty()) {
                    match = false;
                    buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2781", null, false));
                    for (int itr = 0; itr < choicesRemovedList.size(); ++itr) {
                        buf.append(TAG).append(choicesRemovedList.elementAt(itr));
                    }
                }
            }
            String origappendwith = (String)origds.getAppendWith();
            String inplaceappendwith = (String)inplaceds.getAppendWith();
            if (origappendwith == null && inplaceappendwith != null || origappendwith != null && inplaceappendwith == null) {
                buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"APPEND WITH", origappendwith, inplaceappendwith}, false));
                match = false;
            }
        }
        if (typematch && origds.isDecimal()) {
            if (origds.getScale() != inplaceds.getScale()) {
                match = false;
                buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"DECIMAL SCALE", String.valueOf(origds.getScale()), String.valueOf(inplaceds.getScale())}, false));
            }
            if (origds.getPrecision() != inplaceds.getPrecision()) {
                match = false;
                buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"DECIMAL PRECISION", String.valueOf(origds.getPrecision()), String.valueOf(inplaceds.getPrecision())}, false));
            }
        }
        if (typematch && origds.isObject() && !origds.getJavaClassName().equals(inplaceds.getJavaClassName())) {
            match = false;
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"OBJECT DATASLOT JAVACLASSNAME", origds.getJavaClassName(), inplaceds.getJavaClassName()}, false));
        }
        if (this.origpt.isMonitoringProcess() == this.inplacept.isMonitoringProcess() && origds.isMonitorDS() != inplaceds.isMonitorDS()) {
            match = false;
            buf.append(BLControl.msgFactory.lookup("BizLogic_ERR_2776", new Object[]{"MONITORING ID", origds.isMonitorDS(), inplaceds.isMonitorDS()}, false));
        }
        if (!match) {
            BLConstants.single();
            buf.append("\n--------------------------------------------------------\n");
            BLConstants.single();
            this.extrace.put("FAILEDREASON", buf.toString());
            BLConstants.single();
            BLConstants.single();
            this.extrace.put("RESULT", "FAILED");
            throw new BizLogicException("BizLogic_ERR_2751", "WFInplaceProcessReplacement.compareDS", new Object[]{this.origptname, dsName, buf.toString()});
        }
        return true;
    }

    private void checkExternalPersistence(WFDataslot origds, WFDataslot inplaceds) {
        ProviderType inplaceProviderType;
        ProviderType origProviderType;
        ExtBOConfig origBOPersistenceConfig = origds.getBOPersistenceConfig();
        ExtBOConfig inplaceBOPersistenceConfig = inplaceds.getBOPersistenceConfig();
        if (origBOPersistenceConfig != null && inplaceBOPersistenceConfig == null || origBOPersistenceConfig == null && inplaceBOPersistenceConfig != null) {
            throw new BizLogicException("BizLogic_ERR_8082", "WFInplaceProcessReplacement.checkExternalPersistence()", new Object[]{origds.getParentProcess().getName(), origds.getName()});
        }
        if (null != origBOPersistenceConfig && null != inplaceBOPersistenceConfig && !(origProviderType = origBOPersistenceConfig.getProviderType()).equals((Object)(inplaceProviderType = inplaceBOPersistenceConfig.getProviderType()))) {
            throw new BizLogicException("BizLogic_ERR_8087", "WFInplaceProcessReplacement.checkExternalPersistence()", new Object[]{origds.getParentProcess().getName(), origds.getName()});
        }
    }

    private Map<String, List<DataSlotTableIndex>> prepareDataSlotIndexes() {
        HashMap<String, List<DataSlotTableIndex>> indexes = null;
        List<DataSlotTableIndex> inplaceDSIndexData = this.inplacept.getDataSlotIndexData();
        List<DataSlotTableIndex> origDSIndexData = this.origpt.getDataSlotIndexData();
        if (inplaceDSIndexData == null && origDSIndexData == null) {
            return null;
        }
        ArrayList<String> origIndexes = new ArrayList<String>();
        ArrayList<String> inplaceIndexes = new ArrayList<String>();
        HashMap<String, DataSlotTableIndex> deletedIndexes = new HashMap<String, DataSlotTableIndex>();
        HashMap<String, DataSlotTableIndex> addedIndexes = new HashMap<String, DataSlotTableIndex>();
        if (origDSIndexData != null) {
            for (DataSlotTableIndex origDSIndex : origDSIndexData) {
                origIndexes.add(origDSIndex.getIndexHashValue());
                deletedIndexes.put(origDSIndex.getIndexHashValue(), origDSIndex);
            }
        }
        if (inplaceDSIndexData != null) {
            for (DataSlotTableIndex inplaceDSIndex : inplaceDSIndexData) {
                inplaceIndexes.add(inplaceDSIndex.getIndexHashValue());
                addedIndexes.put(inplaceDSIndex.getIndexHashValue(), inplaceDSIndex);
            }
        }
        boolean isIndexDeleted = false;
        boolean isIndexAdded = false;
        if (!origIndexes.isEmpty()) {
            boolean bl = isIndexDeleted = !inplaceIndexes.containsAll(origIndexes);
        }
        if (!inplaceIndexes.isEmpty()) {
            boolean bl = isIndexAdded = !origIndexes.containsAll(inplaceIndexes);
        }
        if (isIndexDeleted) {
            for (String inplaceIndex : inplaceIndexes) {
                deletedIndexes.remove(inplaceIndex);
            }
        }
        if (isIndexAdded) {
            for (String origIndex : origIndexes) {
                addedIndexes.remove(origIndex);
            }
        }
        if (!isIndexDeleted && !isIndexAdded) {
            return null;
        }
        ArrayList createDSTableIndexes = new ArrayList();
        ArrayList deleteDSTableIndexes = new ArrayList();
        Iterator iterator = deletedIndexes.keySet().iterator();
        while (iterator.hasNext()) {
            deleteDSTableIndexes.add(deletedIndexes.get(iterator.next()));
        }
        iterator = addedIndexes.keySet().iterator();
        while (iterator.hasNext()) {
            createDSTableIndexes.add(addedIndexes.get(iterator.next()));
        }
        indexes = new HashMap<String, List<DataSlotTableIndex>>();
        indexes.put("CREATE_INDEX", createDSTableIndexes);
        indexes.put("DELETE_INDEX", deleteDSTableIndexes);
        return indexes;
    }

    private void checkAndSetFYI() {
        Vector ptFYI = this.origpt.getFYI();
        Hashtable wsFYI = this.origpt.getWSFYI();
        if (ptFYI == null && (wsFYI == null || wsFYI.isEmpty())) {
            return;
        }
        if (ptFYI != null) {
            this.inplacept.setFYI(ptFYI);
        }
        if (wsFYI != null && !wsFYI.isEmpty()) {
            this.inplacept.setWSFYI(wsFYI);
        }
    }

    private void checkDuplicateMonitorId() {
        if (this.hasDuplicateMonitorId(this.inplacept)) {
            throw new BizLogicException("BizLogic_ERR_4816", "WFInplaceProcessReplacement.checkDuplicateMonitorId()", new Object[]{this.inplacept.getName(), this.inplacept.getMonitorDSName()});
        }
    }

    private boolean hasDuplicateMonitorId(WFProcess origpt) {
        String instanceDSTable = origpt.getDSTableName();
        String monitorDSName = origpt.getMonitorDSName();
        if (monitorDSName == null || monitorDSName.trim().length() == 0) {
            return false;
        }
        if (origpt.isMonitorDSMappedToPIID()) {
            return false;
        }
        return DataSlotDAO.hasDuplicateMonitorId(monitorDSName, instanceDSTable);
    }
}

