/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.enums.BLLockContext;
import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFWorkItem;
import com.savvion.sbm.bizlogic.server.dao.CWorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.TimerActionDAO;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.util.BLCalendar;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.PerformerUtil;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.ResultData;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.tdiinc.userManager.Group;
import com.tdiinc.userManager.User;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WFCWorkItem {
    private static WFCWorkItem self;

    private WFCWorkItem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WFCWorkItem self() {
        if (self != null) return self;
        Class<WFCWorkItem> clazz = WFCWorkItem.class;
        synchronized (WFCWorkItem.class) {
            if (self != null) return self;
            self = new WFCWorkItem();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public long create(WFProcessContext pCtx, long parentWIID, List<String> collaborators, String stepNameAlias, Map<String, Object> cWorkItemData) {
        HashMap cwiData = null;
        cwiData = cWorkItemData == null ? new HashMap() : (HashMap)((HashMap)cWorkItemData).clone();
        long piid = pCtx.getProcessInstanceID();
        String piName = pCtx.getProcessInstanceName();
        cwiData.put("PROCESSINSTANCEID", piid);
        cwiData.put("PROCESSINSTANCENAME", piName);
        long ptid = pCtx.getProcessTemplateID();
        cwiData.put("PROCESSTEMPLATEID", ptid);
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(parentWIID);
        String wiName = wieb.getName();
        cwiData.put("PARENT_WORKITEM_ID", parentWIID);
        cwiData.put("WORKITEMNAME", wiName);
        long wsid = wieb.getWorkStepID();
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (!ws.isCollaborationEnabled()) {
            throw new BizLogicException("BizLogic_ERR_3650", "WFCWorkItem.create", new Object[]{wieb.getName(), piName, ws.getName(), pCtx.getProcessTemplateName()});
        }
        int parentWIState = wieb.getState();
        if (parentWIState != 28) {
            throw new BizLogicException("BizLogic_ERR_3639", "WFCWorkItem.create", new Object[]{wieb.getName(), piName});
        }
        if (stepNameAlias == null || stepNameAlias.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_3643", "WFCWorkItem.create", new Object[]{"step name alias", wiName, piName});
        }
        String emailAddress = null;
        if (cwiData.containsKey("ESCALATION_TYPE")) {
            int esclType = (Integer)cwiData.get("ESCALATION_TYPE");
            if (esclType == 1) {
                emailAddress = this.checkWIPerformerEmail(pCtx, wieb, stepNameAlias);
                cwiData.put("MAILTO", emailAddress);
            }
        } else {
            cwiData.put("ESCALATION_TYPE", 0);
        }
        if (collaborators == null || collaborators.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_3643", "WFCWorkItem.create", new Object[]{"collaborator", wiName, piName});
        }
        collaborators = this.expandCollaborators(piid, ws.getName(), collaborators);
        if (BLControl.util.isDebugCWI()) {
            BLControl.logger.debugKey("BizLogic_ERR_3126", "WFCWorkItem.create", new Object[]{stepNameAlias, wiName, piName, collaborators});
        }
        List<String> realWSCollaborators = this.getRealCollaborators(piid, ws);
        if (BLControl.util.isDebugCWI()) {
            BLControl.logger.debugKey("BizLogic_ERR_3127", "WFCWorkItem.create", new Object[]{stepNameAlias, wiName, piName, collaborators});
        }
        if (realWSCollaborators != null && !realWSCollaborators.isEmpty() && !realWSCollaborators.containsAll(collaborators)) {
            BLControl.logger.warnKey("BizLogic_ERR_3629", "WFCWorkItem.create", new Object[]{collaborators, stepNameAlias, wiName, piName, realWSCollaborators});
        }
        long cstepID = this.generateCStepId(piName, wiName, stepNameAlias);
        cwiData.put("CSTEP_ID", cstepID);
        String cStepName = this.composeCStepName(stepNameAlias, cstepID);
        if (cStepName.length() > BLControl.util.MAX_CSTEPNAME_SIZE) {
            throw new BizLogicException("BizLogic_ERR_3850", "WFCWorkItem.create", new Object[]{cStepName, piName, wiName, String.valueOf(BLControl.util.MAX_CSTEPNAME_SIZE)});
        }
        cwiData.put("CSTEP_NAME", cStepName);
        if (BLControl.util.isDebugCWI()) {
            BLControl.logger.debugKey("BizLogic_ERR_3125", "WFCWorkItem.create", new Object[]{stepNameAlias, wiName, piName, cstepID, cStepName});
        }
        String parentWIPerf = wieb.getPerformer();
        cwiData.put("CREATOR", parentWIPerf);
        int priority = this.getIntegerPriority(wieb, cwiData);
        cwiData.put("PRIORITY", priority);
        long duration = this.getDuration(pCtx, wsid, cwiData);
        cwiData.put("DURATION", duration);
        cwiData.put("STARTTIME", System.currentTimeMillis());
        String instruction = (String)cwiData.get("INSTRUCTION");
        if (instruction == null) {
            cwiData.put("INSTRUCTION", "");
        } else if (instruction.length() > BLControl.util.MAX_CWI_INSTRUCTION_SIZE) {
            BLControl.logger.warnKey("BizLogic_ERR_3845", "WFCWorkItem.create", new Object[]{instruction, cStepName, piName, parentWIID, String.valueOf(BLControl.util.MAX_CWI_INSTRUCTION_SIZE)});
            instruction = instruction.substring(0, BLControl.util.MAX_CWI_INSTRUCTION_SIZE);
            cwiData.put("INSTRUCTION", instruction);
        }
        boolean collaborateByAll = this.isCollaborateByAll(cwiData);
        cwiData.put("COLLABORATE_BY_ALL", collaborateByAll);
        int status = 65;
        if (!collaborateByAll) {
            status = 69;
        }
        cwiData.put("PREVIOUSSTATUS", status);
        cwiData.put("STATUS", status);
        this.createCStep(pCtx, ws, cwiData);
        cwiData.remove("COLLABORATE_BY_ALL");
        if (collaborateByAll) {
            for (int ix = 0; ix < collaborators.size(); ++ix) {
                String collaborator = collaborators.get(ix);
                cwiData.put("COLLABORATOR", collaborator);
                if (BLControl.util.isDebugCWI()) {
                    BLControl.logger.debugKey("BizLogic_ERR_3130", "WFCWorkItem.create", new Object[]{collaborator, cStepName, wiName, piName});
                }
                this.createOneCWorkItem(pCtx, wsid, cwiData, collaborator);
            }
        } else {
            String allCollaboratorsStr = BLUtil.toStringListPerformer(collaborators);
            if (allCollaboratorsStr.length() > BLControl.util.MAX_COLLABORATOR_SIZE) {
                BLControl.logger.warnKey("BizLogic_ERR_895", "WFCWorkItem.create", new Object[]{allCollaboratorsStr, cStepName, parentWIID, piName, String.valueOf(BLControl.util.MAX_COLLABORATOR_SIZE)});
                allCollaboratorsStr = allCollaboratorsStr.substring(0, BLControl.util.MAX_COLLABORATOR_SIZE);
            }
            cwiData.put("COLLABORATOR", allCollaboratorsStr);
            if (BLControl.util.isDebugCWI()) {
                BLControl.logger.debugKey("BizLogic_ERR_3130", "WFCWorkItem.create", new Object[]{allCollaboratorsStr, cStepName, wiName, piName});
            }
            long cWorkItemId = this.createOneCWorkItem(pCtx, wsid, cwiData, allCollaboratorsStr);
            CWorkItemDAO.createAvailableCWorkItems(piid, parentWIID, cWorkItemId, collaborators);
        }
        return cstepID;
    }

    private long createOneCWorkItem(WFProcessContext pCtx, long wsid, Map<String, Object> cwiData, String collaborator) {
        long dueDate;
        Long dueDateObj;
        long cWorkItemId;
        String cstepName = (String)cwiData.get("CSTEP_NAME");
        String wiName = (String)cwiData.get("WORKITEMNAME");
        String piName = (String)cwiData.get("PROCESSINSTANCENAME");
        try {
            cWorkItemId = BLControl.util.cwiSeq.getNextNumber();
            cwiData.put("CWORKITEM_ID", cWorkItemId);
        }
        catch (SQLException sqle) {
            throw new BizLogicException("BizLogic_ERR_3644", "WFCWorkItem.create", new Object[]{collaborator, cstepName, wiName, piName}, (Throwable)sqle);
        }
        String cwiName = this.composeCWorkItemName(cwiData);
        if (cwiName.length() > BLControl.util.MAX_CWINAME_SIZE) {
            throw new BizLogicException("BizLogic_ERR_3849", "WFCWorkItem.createOneCWorkItem", new Object[]{cwiName, piName, wiName, String.valueOf(BLControl.util.MAX_CWINAME_SIZE)});
        }
        cwiData.put("CWORKITEM_NAME", cwiName);
        if (BLControl.util.isDebugCWI()) {
            BLControl.logger.debugKey("BizLogic_ERR_3131", "WFCWorkItem.createOneCWorkItem", new Object[]{cWorkItemId, cwiName, collaborator, cstepName, wiName, piName});
        }
        if ((dueDateObj = (Long)cwiData.get("DUEDATE")) == null) {
            long startTime = (Long)cwiData.get("STARTTIME");
            long duration = (Long)cwiData.get("DURATION");
            dueDate = this.calculateDueDate(pCtx, startTime, duration, collaborator);
            cwiData.put("DUEDATE", dueDate);
        } else {
            dueDate = dueDateObj;
        }
        long timerActionID = -1L;
        int esclType = (Integer)cwiData.get("ESCALATION_TYPE");
        if (esclType != 0) {
            long ptid = (Long)cwiData.get("PROCESSTEMPLATEID");
            long piid = (Long)cwiData.get("PROCESSINSTANCEID");
            String emailAddress = (String)cwiData.remove("MAILTO");
            timerActionID = this.createTimerActionRecords(ptid, piid, wsid, cWorkItemId, dueDate, emailAddress, esclType);
            if (BLControl.util.isDebugCWI()) {
                String esclTypeString = BLControl.consts.escalationTypes[esclType];
                BLControl.logger.debugKey("BizLogic_ERR_3132", "WFCWorkItem.createOneCWorkItem", new Object[]{timerActionID, cwiName, cstepName, esclTypeString});
            }
        }
        cwiData.put("ESCALATION_ID", timerActionID);
        CWorkItemDAO.create(cwiData);
        if (BLControl.util.isDebugCWI()) {
            BLControl.logger.debugKey("BizLogic_ERR_3133", "WFCWorkItem.createOneCWorkItem", new Object[]{cwiName, cstepName, collaborator, piName});
        }
        Map<String, Object> eventContext = this.getEventContext(pCtx, cwiData, 73);
        BLUtil.fireEvent(eventContext, (int)73);
        return cWorkItemId;
    }

    public void reAssign(WFProcessContext pCtx, long cWorkItemId, String collaborator) {
        Map<String, Object> cwiData = CWorkItemDAO.getCWorkItem(cWorkItemId, false);
        String piName = pCtx.getProcessInstanceName();
        String stepName = (String)cwiData.get("CSTEP_NAME");
        String cwiName = (String)cwiData.get("CWORKITEM_NAME");
        Long parentWIID = (Long)cwiData.get("PARENT_WORKITEM_ID");
        int state = (Integer)cwiData.get("STATUS");
        if (state != 65) {
            throw new BizLogicException("BizLogic_ERR_3632", "WFCWorkItem.reAssign", new Object[]{cwiName, stepName, parentWIID, piName});
        }
        if (collaborator == null || collaborator.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_3631", "WFCWorkItem.reAssign", new Object[]{"NULL/EMPTY", cwiName, stepName, parentWIID, piName});
        }
        User user = pCtx.getUser(collaborator);
        if (user == null) {
            throw new BizLogicException("BizLogic_ERR_3631", "WFCWorkItem.reAssign", new Object[]{collaborator, cwiName, stepName, parentWIID, piName});
        }
        if (BLControl.util.isDebugCWI()) {
            BLControl.logger.debugKey("BizLogic_ERR_3134", "WFCWorkItem.reAssign", new Object[]{"ReAssign", cwiName, stepName, parentWIID, piName});
        }
        HashMap<String, Object> modifiedAttrs = new HashMap<String, Object>();
        modifiedAttrs.put("COLLABORATOR", collaborator);
        CWorkItemDAO.save(cWorkItemId, modifiedAttrs);
        cwiData.put("COLLABORATOR", collaborator);
        Map<String, Object> eventContext = this.getEventContext(pCtx, cwiData, 65);
        BLUtil.fireEvent(eventContext, (int)65);
    }

    public void assign(WFProcessContext pCtx, long cWorkItemId, String collaborator) {
        if (collaborator == null) {
            throw new BizLogicException("BizLogic_ERR_504", "WFCWorkItem.assign", new Object[]{"null"});
        }
        User userObj = pCtx.getUser(collaborator);
        if (userObj == null) {
            throw new BizLogicException("BizLogic_ERR_504", "WFWorkItem.assign", new Object[]{collaborator});
        }
        boolean isAvailableFor = CWorkItemDAO.isAvailableFor(cWorkItemId, collaborator);
        if (!isAvailableFor) {
            throw new BizLogicException("BizLogic_ERR_894", "WFCWorkItem.assign", new Object[]{cWorkItemId, pCtx.getProcessInstanceID(), collaborator});
        }
        Map<String, Object> cwiData = CWorkItemDAO.getCWorkItem(cWorkItemId, false);
        String piName = pCtx.getProcessInstanceName();
        String stepName = (String)cwiData.get("CSTEP_NAME");
        String cwiName = (String)cwiData.get("CWORKITEM_NAME");
        Long parentWIID = (Long)cwiData.get("PARENT_WORKITEM_ID");
        int state = (Integer)cwiData.get("STATUS");
        if (state != 69) {
            throw new BizLogicException("BizLogic_ERR_3622", "WFCWorkItem.assign", new Object[]{cwiName, stepName, parentWIID, piName});
        }
        HashMap<String, Object> attribsToBeUpdated = new HashMap<String, Object>();
        attribsToBeUpdated.put("STATUS", 65);
        attribsToBeUpdated.put("COLLABORATOR", collaborator);
        cwiData.put("PREVIOUSSTATUS", state);
        cwiData.put("STATUS", 65);
        cwiData.put("COLLABORATOR", collaborator);
        if (BLControl.util.isDebugCWI()) {
            BLControl.logger.debugKey("BizLogic_ERR_3134", "WFCWorkItem.assign", new Object[]{"Assign", cwiName, stepName, parentWIID, piName});
        }
        CWorkItemDAO.save(cWorkItemId, attribsToBeUpdated);
        Map<String, Object> eventContext = this.getEventContext(pCtx, cwiData, 65);
        BLUtil.fireEvent(eventContext, (int)65);
    }

    public void decline(WFProcessContext pCtx, long cWorkItemId, String reason) {
        Map<String, Object> cwiData = CWorkItemDAO.getCWorkItem(cWorkItemId, false);
        String piName = pCtx.getProcessInstanceName();
        String stepName = (String)cwiData.get("CSTEP_NAME");
        String cwiName = (String)cwiData.get("CWORKITEM_NAME");
        Long parentWIID = (Long)cwiData.get("PARENT_WORKITEM_ID");
        int state = (Integer)cwiData.get("STATUS");
        if (state == 74) {
            BLControl.logger.warnKey("BizLogic_ERR_3641", new Object[]{cwiName, stepName, parentWIID, piName, "declined"});
            return;
        }
        if (state == 65) {
            if (BLControl.util.isDebugCWI()) {
                BLControl.logger.debugKey("BizLogic_ERR_3134", "WFCWorkItem.decline", new Object[]{"Decline", cwiName, stepName, parentWIID, piName});
            }
            HashMap<String, Object> attribsToBeUpdated = new HashMap<String, Object>();
            if (reason != null && reason.trim().length() > 0) {
                if (reason.length() > BLControl.util.MAX_RESPONSE_SIZE) {
                    BLControl.logger.warnKey("BizLogic_ERR_3848", "WFCWorkItem.complete", new Object[]{reason, cwiName, piName, parentWIID, String.valueOf(BLControl.util.MAX_RESPONSE_SIZE)});
                    reason = reason.substring(0, BLControl.util.MAX_RESPONSE_SIZE);
                }
                cwiData.put("RESPONSE", reason);
                attribsToBeUpdated.put("RESPONSE", reason);
            }
            attribsToBeUpdated.put("STATUS", 74);
            cwiData.put("PREVIOUSSTATUS", state);
            cwiData.put("STATUS", 74);
            if (BLControl.util.isDebugCWI()) {
                BLControl.logger.debugKey("BizLogic_ERR_3134", "WFCWorkItem.complete", new Object[]{"Decline", cwiName, stepName, parentWIID, piName});
            }
            CWorkItemDAO.save(cWorkItemId, attribsToBeUpdated);
            Map<String, Object> eventContext = this.getEventContext(pCtx, cwiData, 74);
            BLUtil.fireEvent(eventContext, (int)74);
        }
    }

    public void suspend(Session session, long piid, long cWorkItemId) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        this.suspend(pCtx, cWorkItemId);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void suspend(WFProcessContext pCtx, long cWorkItemId) {
        Map<String, Object> cwiData = CWorkItemDAO.getCWorkItem(cWorkItemId, false);
        String piName = pCtx.getProcessInstanceName();
        String stepName = (String)cwiData.get("CSTEP_NAME");
        String cwiName = (String)cwiData.get("CWORKITEM_NAME");
        Long parentWIID = (Long)cwiData.get("PARENT_WORKITEM_ID");
        int state = (Integer)cwiData.get("STATUS");
        if (state == 66) {
            BLControl.logger.warnKey("BizLogic_ERR_3641", new Object[]{cwiName, stepName, parentWIID, piName, "suspended"});
            return;
        }
        if (state != 65) {
            if (state != 69) {
                if (state != 70) {
                    BLControl.logger.warnKey("BizLogic_ERR_3641", new Object[]{cwiName, stepName, parentWIID, piName, BLConstants.single().wfStates[state]});
                    return;
                }
            }
        }
        if (BLControl.util.isDebugCWI()) {
            BLControl.logger.debugKey("BizLogic_ERR_3134", "WFCWorkItem.suspend", new Object[]{"Suspend", cwiName, stepName, parentWIID, piName});
        }
        CWorkItemDAO.updateState(cWorkItemId, state, 66);
        cwiData.put("PREVIOUSSTATUS", state);
        cwiData.put("STATUS", 66);
        Map<String, Object> eventContext = this.getEventContext(pCtx, cwiData, 66);
        BLUtil.fireEvent(eventContext, (int)66);
    }

    public void resumeByClient(Session session, long piid, long cWorkItemId) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        Map<String, Object> cwiData = CWorkItemDAO.getCWorkItem(cWorkItemId, false);
        Long parentWIID = (Long)cwiData.get("PARENT_WORKITEM_ID");
        String cwiName = (String)cwiData.get("CWORKITEM_NAME");
        WorkItemEBLocal wiEB = pCtx.getWorkItemEB(parentWIID);
        int n = wiEB.getState();
        BLConstants.single();
        if (n == 32) {
            throw new BizLogicException("BizLogic_ERR_3764", "WFCWorkItem.resumeByClient", new Object[]{cwiName, wiEB.getName(), pCtx.getProcessInstanceName()});
        }
        this.resume(pCtx, cWorkItemId, cwiData);
    }

    public void resume(WFProcessContext pCtx, long cWorkItemId) {
        Map<String, Object> cwiData = CWorkItemDAO.getCWorkItem(cWorkItemId, false);
        this.resume(pCtx, cWorkItemId, cwiData);
    }

    private void resume(WFProcessContext pCtx, long cWorkItemId, Map<String, Object> cwiData) {
        String piName = pCtx.getProcessInstanceName();
        String stepName = (String)cwiData.get("CSTEP_NAME");
        String cwiName = (String)cwiData.get("CWORKITEM_NAME");
        Long parentWIID = (Long)cwiData.get("PARENT_WORKITEM_ID");
        int state = (Integer)cwiData.get("STATUS");
        if (state == 66) {
            if (BLControl.util.isDebugCWI()) {
                BLControl.logger.debugKey("BizLogic_ERR_3134", "WFCWorkItem.resume", new Object[]{"Resume", cwiName, stepName, parentWIID, piName});
            }
            int previousState = (Integer)cwiData.get("PREVIOUSSTATUS");
            CWorkItemDAO.updateState(cWorkItemId, state, previousState);
            cwiData.put("PREVIOUSSTATUS", 66);
            cwiData.put("STATUS", previousState);
            Map<String, Object> eventContext = this.getEventContext(pCtx, cwiData, 65);
            BLUtil.fireEvent(eventContext, (int)65);
        } else {
            BLControl.logger.warnKey("BizLogic_ERR_3640", new Object[]{cwiName, stepName, parentWIID, piName});
        }
    }

    public void terminate(Session session, long piid, long cWorkItemId) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        this.terminate(pCtx, cWorkItemId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void terminate(WFProcessContext pCtx, long cWorkItemId) {
        Map<String, Object> cwiData = CWorkItemDAO.getCWorkItem(cWorkItemId, false);
        String piName = pCtx.getProcessInstanceName();
        String stepName = (String)cwiData.get("CSTEP_NAME");
        String cwiName = (String)cwiData.get("CWORKITEM_NAME");
        Long parentWIID = (Long)cwiData.get("PARENT_WORKITEM_ID");
        int state = (Integer)cwiData.get("STATUS");
        if (state == 67) throw new BizLogicException("BizLogic_ERR_4634", "WFCWorkItem.terminate", new Object[]{cwiName, stepName, parentWIID, piName, BLControl.consts.wfStates[state]});
        if (state == 68) throw new BizLogicException("BizLogic_ERR_4634", "WFCWorkItem.terminate", new Object[]{cwiName, stepName, parentWIID, piName, BLControl.consts.wfStates[state]});
        if (state == 74) throw new BizLogicException("BizLogic_ERR_4634", "WFCWorkItem.terminate", new Object[]{cwiName, stepName, parentWIID, piName, BLControl.consts.wfStates[state]});
        if (BLControl.util.isDebugCWI()) {
            BLControl.logger.debugKey("BizLogic_ERR_3134", "WFCWorkItem.terminate", new Object[]{"Terminate", cwiName, stepName, parentWIID, piName});
        }
        CWorkItemDAO.updateState(cWorkItemId, state, 68);
        cwiData.put("PREVIOUSSTATUS", state);
        cwiData.put("STATUS", 68);
        Map<String, Object> eventContext = this.getEventContext(pCtx, cwiData, 68);
        BLUtil.fireEvent(eventContext, (int)68);
    }

    public void complete(Session session, long piid, long cWorkItemId) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        this.complete(pCtx, cWorkItemId, null, null);
    }

    public void complete(WFProcessContext pCtx, long cWorkItemId, HashMap dsValues, HashMap modifiedAttrs) {
        Map<String, Object> eventContext;
        boolean updatedTheSlots = this.updateSlotValues(pCtx, cWorkItemId, dsValues);
        if (!updatedTheSlots) {
            pCtx.lockRootOrInstanceDS(BLLockContext.WI, "WFCWorkItem.complete", cWorkItemId);
        }
        Map<String, Object> cwiData = CWorkItemDAO.getCWorkItem(cWorkItemId, false);
        String piName = pCtx.getProcessInstanceName();
        String stepName = (String)cwiData.get("CSTEP_NAME");
        String cwiName = (String)cwiData.get("CWORKITEM_NAME");
        Long parentWIID = (Long)cwiData.get("PARENT_WORKITEM_ID");
        int state = (Integer)cwiData.get("STATUS");
        if (state != 65) {
            if (state != 69) {
                throw new BizLogicException("BizLogic_ERR_3646", "WFCWorkItem.complete", new Object[]{cwiName, stepName, parentWIID, piName, BLControl.consts.wfStates[state]});
            }
        }
        HashMap<String, Object> attribsToBeUpdated = new HashMap<String, Object>();
        if (modifiedAttrs != null) {
            if (modifiedAttrs.containsKey("RESPONSE")) {
                String response = (String)modifiedAttrs.get("RESPONSE");
                if (response == null) {
                    response = "";
                }
                if (response.length() > BLControl.util.MAX_RESPONSE_SIZE) {
                    BLControl.logger.warnKey("BizLogic_ERR_3848", "WFCWorkItem.complete", new Object[]{response, cwiName, piName, parentWIID, String.valueOf(BLControl.util.MAX_RESPONSE_SIZE)});
                    response = response.substring(0, BLControl.util.MAX_RESPONSE_SIZE);
                }
                attribsToBeUpdated.put("RESPONSE", response);
                cwiData.put("RESPONSE", response);
            }
        }
        attribsToBeUpdated.put("STATUS", 67);
        String userWhoIsCompletingTheCWI = pCtx.getSession().getUser();
        String currentCollaborator = (String)cwiData.get("COLLABORATOR");
        if (state == 65) {
            if (!SBMControl.util.isGuest(userWhoIsCompletingTheCWI) && !userWhoIsCompletingTheCWI.equals(currentCollaborator)) {
                BLControl.logger.warnKey("BizLogic_ERR_896", new Object[]{cwiName, parentWIID, piName, userWhoIsCompletingTheCWI, currentCollaborator});
                attribsToBeUpdated.put("COLLABORATOR", userWhoIsCompletingTheCWI);
                cwiData.put("COLLABORATOR", userWhoIsCompletingTheCWI);
            }
        } else {
            boolean isAvailableFor = CWorkItemDAO.isAvailableFor(cWorkItemId, userWhoIsCompletingTheCWI);
            if (!SBMControl.util.isGuest(userWhoIsCompletingTheCWI)) {
                if (!isAvailableFor) {
                    BLControl.logger.warnKey("BizLogic_ERR_896", new Object[]{cwiName, parentWIID, piName, userWhoIsCompletingTheCWI, currentCollaborator});
                }
                attribsToBeUpdated.put("COLLABORATOR", userWhoIsCompletingTheCWI);
                cwiData.put("COLLABORATOR", userWhoIsCompletingTheCWI);
            }
        }
        cwiData.put("PREVIOUSSTATUS", state);
        cwiData.put("STATUS", 67);
        if (BLControl.util.isDebugCWI()) {
            BLControl.logger.debugKey("BizLogic_ERR_3134", "WFCWorkItem.complete", new Object[]{"Complete", cwiName, stepName, parentWIID, piName});
        }
        CWorkItemDAO.save(cWorkItemId, attribsToBeUpdated);
        long escalationID = (Long)cwiData.get("ESCALATION_ID");
        if (escalationID != -1L) {
            TimerActionDAO.removeByID(escalationID);
        }
        if (state == 69) {
            eventContext = this.getEventContext(pCtx, cwiData, 65);
            BLUtil.fireEvent(eventContext, (int)65);
        }
        eventContext = this.getEventContext(pCtx, cwiData, 67);
        BLUtil.fireEvent(eventContext, (int)67);
    }

    private boolean updateSlotValues(WFProcessContext pCtx, long cWorkItemId, HashMap dsValues) {
        if (dsValues == null || dsValues.isEmpty()) {
            return false;
        }
        String piName = pCtx.getProcessInstanceName();
        List<String> outputDSNames = CWorkItemDAO.getOutputDS(cWorkItemId);
        if (outputDSNames.isEmpty()) {
            BLControl.logger.warnKey("BizLogic_ERR_3623", "WFCWorkItem.updateSlotValues", new Object[]{cWorkItemId, piName});
            return false;
        }
        Set dsNamesForUpdate = dsValues.keySet();
        dsNamesForUpdate.retainAll(outputDSNames);
        int dsCount = dsValues.size();
        if (dsCount == 0) {
            return false;
        }
        if (BLControl.util.isDebugCWI() && BLControl.util.isDebugCWI()) {
            BLControl.logger.debugKey("BizLogic_ERR_3135", "WFCWorkItem.updateSlotValues", new Object[]{dsCount, cWorkItemId, piName});
        }
        pCtx.updateSlotValue(dsValues);
        return true;
    }

    public void setAttributes(Session session, long cWorkItemId, Map<String, Object> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        Map<String, Object> cwiInfo = CWorkItemDAO.getCWorkItem(cWorkItemId, false);
        WIInfoWrapper wiInfo = new WIInfoWrapper(cwiInfo);
        WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), wiInfo.piid);
        HashMap<String, Object> modifiedAttrs = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            this.setAttribute(cWorkItemId, cwiInfo, wiInfo, pCtx, modifiedAttrs, entry.getKey(), entry.getValue());
        }
        if (!modifiedAttrs.isEmpty()) {
            CWorkItemDAO.save(cWorkItemId, modifiedAttrs);
        }
        cwiInfo.putAll(modifiedAttrs);
        Map<String, Object> eventContext = this.getEventContext(pCtx, cwiInfo, 71);
        BLUtil.fireEvent(eventContext, (int)71);
    }

    private void setAttribute(long cWorkItemId, Map<String, Object> cwiInfo, WIInfoWrapper wiInfo, WFProcessContext pCtx, Map<String, Object> modifiedAttrs, String key, Object value) {
        if (key.equalsIgnoreCase("PRIORITY")) {
            int priority = this.getIntegerPriority((String)value);
            modifiedAttrs.put("PRIORITY", priority);
        } else if (key.equalsIgnoreCase("RESPONSE")) {
            String response = this.getResponse(wiInfo, (String)value);
            modifiedAttrs.put("RESPONSE", response);
        } else if (key.equalsIgnoreCase("DUEDATE")) {
            wiInfo.dueDate = (Long)value;
            wiInfo.duration = WFWorkItem.self().getDuration(pCtx, wiInfo.collaborator, wiInfo.startTime, wiInfo.dueDate);
            modifiedAttrs.put("DUEDATE", value);
            modifiedAttrs.put("DURATION", wiInfo.duration);
        } else if (key.equalsIgnoreCase("DURATION")) {
            wiInfo.duration = (Long)value;
            wiInfo.dueDate = WFCWorkItem.self().calculateDueDate(pCtx, wiInfo.startTime, wiInfo.duration, wiInfo.collaborator);
            modifiedAttrs.put("DUEDATE", wiInfo.dueDate);
            modifiedAttrs.put("DURATION", value);
        } else if (key.equalsIgnoreCase("ESCALATION_TYPE")) {
            long timerActionID = this.getTimerActionID(cWorkItemId, cwiInfo, wiInfo, pCtx, (Integer)value);
            modifiedAttrs.put("ESCALATION_TYPE", value);
            modifiedAttrs.put("ESCALATION_ID", timerActionID);
        } else {
            throw new BizLogicException("BizLogic_ERR_1507", "WFCWorkItem.setAttributes", new Object[]{"Collaborative WorkItem", cWorkItemId, key});
        }
    }

    private String getResponse(WIInfoWrapper wiInfo, String value) {
        String response = value;
        if (response == null) {
            response = "";
        }
        if (response.length() > BLControl.util.MAX_RESPONSE_SIZE) {
            BLControl.logger.warnKey("BizLogic_ERR_3848", "WFCWorkItem.setAttributes", new Object[]{response, wiInfo.cwiName, wiInfo.piid, wiInfo.wiid, BLControl.util.MAX_RESPONSE_SIZE});
            response = response.substring(0, BLControl.util.MAX_RESPONSE_SIZE);
        }
        return response;
    }

    private long getTimerActionID(long cWorkItemId, Map<String, Object> cwiInfo, WIInfoWrapper wiInfo, WFProcessContext pCtx, Integer value) {
        long escalationID;
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiInfo.wiid);
        long wsid = wieb.getWorkStepID();
        int esclType = value;
        String emailAddress = null;
        if (esclType == 1) {
            emailAddress = this.checkWIPerformerEmail(pCtx, wieb, wiInfo.stepName);
        }
        if ((escalationID = ((Long)cwiInfo.get("ESCALATION_ID")).longValue()) != -1L) {
            TimerActionDAO.removeByID(escalationID);
        }
        long timerActionID = -1L;
        if (esclType != 0) {
            timerActionID = this.createTimerActionRecords(wiInfo.ptid, wiInfo.piid, wsid, cWorkItemId, wiInfo.dueDate, emailAddress, esclType);
        }
        return timerActionID;
    }

    public List<String> getRealCollaborators(long piid, WFAtomicWS ws) {
        List<String> collaborators = ws.getCollaborators(1);
        return this.expandCollaborators(piid, ws.getName(), collaborators);
    }

    public void saveCWI(Session session, Map<Long, Map<String, Object>> modifiedAttrs) {
        if (modifiedAttrs == null || modifiedAttrs.isEmpty()) {
            return;
        }
        long cWorkItemId = 0L;
        Map<String, Object> cwiAttrs = null;
        Map.Entry<Long, Map<String, Object>> entry2 = null;
        for (Map.Entry<Long, Map<String, Object>> entry2 : modifiedAttrs.entrySet()) {
            cWorkItemId = entry2.getKey();
            cwiAttrs = entry2.getValue();
            if (cwiAttrs == null || cwiAttrs.isEmpty()) continue;
            this.saveCWI(session, cWorkItemId, cwiAttrs);
        }
    }

    public void saveCWI(Session session, long cWorkItemId, Map<String, Object> modifiedAttribs) {
        this.setAttributes(session, cWorkItemId, modifiedAttribs);
    }

    public ResultData<List<Long>> completeByClient(Session session, List<Map<String, Long>> idList) {
        if (idList == null || idList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFCWorkItem.completeByClient()", new Object[]{"complete", "collaborative workitem"});
        }
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Map<String, Long> cwiMap : idList) {
            try {
                block8: {
                    block7: {
                        if (cwiMap == null || cwiMap.isEmpty()) break block7;
                        if (!cwiMap.containsKey("CWORKITEM_ID")) break block7;
                        if (cwiMap.containsKey("PROCESSINSTANCEID")) break block8;
                    }
                    throw new BizLogicException("BizLogic_ERR_3762", "WFCWorkItem.completeByClient()", new Object[]{idList, "complete", "collaborative workitem"});
                }
                long cWorkItemId = cwiMap.get("CWORKITEM_ID");
                long piid = cwiMap.get("PROCESSINSTANCEID");
                BLUtil.getServiceLocal().completeCWorkItem(session, piid, cWorkItemId);
                validIdList.add(cWorkItemId);
            }
            catch (Throwable th) {
                return new ResultData(validIdList, th, cwiMap);
            }
        }
        return new ResultData();
    }

    public ResultData<List<Long>> suspendByClient(Session session, List<Map<String, Long>> idList) {
        if (idList == null || idList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFCWorkItem.suspendByClient()", new Object[]{"suspend", "collaborative workitem"});
        }
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Map<String, Long> cwiMap : idList) {
            try {
                block8: {
                    block7: {
                        if (cwiMap == null || cwiMap.isEmpty()) break block7;
                        if (!cwiMap.containsKey("CWORKITEM_ID")) break block7;
                        if (cwiMap.containsKey("PROCESSINSTANCEID")) break block8;
                    }
                    throw new BizLogicException("BizLogic_ERR_3762", "WFCWorkItem.suspendByClient()", new Object[]{idList, "suspend", "collaborative workitem"});
                }
                long cWorkItemId = cwiMap.get("CWORKITEM_ID");
                long piid = cwiMap.get("PROCESSINSTANCEID");
                BLUtil.getServiceLocal().suspendCWorkItem(session, piid, cWorkItemId);
                validIdList.add(cWorkItemId);
            }
            catch (Throwable th) {
                return new ResultData(validIdList, th, cwiMap);
            }
        }
        return new ResultData();
    }

    public ResultData<List<Long>> resumeByClient(Session session, List<Map<String, Long>> idList) {
        if (idList == null || idList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFCWorkItem.resumeByClient()", new Object[]{"resume", "collaborative workitem"});
        }
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Map<String, Long> cwiMap : idList) {
            try {
                block8: {
                    block7: {
                        if (cwiMap == null || cwiMap.isEmpty()) break block7;
                        if (!cwiMap.containsKey("CWORKITEM_ID")) break block7;
                        if (cwiMap.containsKey("PROCESSINSTANCEID")) break block8;
                    }
                    throw new BizLogicException("BizLogic_ERR_3762", "WFCWorkItem.resumeByClient()", new Object[]{idList, "resume", "collaborative workitem"});
                }
                long cWorkItemId = cwiMap.get("CWORKITEM_ID");
                long piid = cwiMap.get("PROCESSINSTANCEID");
                BLUtil.getServiceLocal().resumeCWorkItem(session, piid, cWorkItemId);
                validIdList.add(cWorkItemId);
            }
            catch (Throwable th) {
                return new ResultData(validIdList, th, cwiMap);
            }
        }
        return new ResultData();
    }

    public ResultData<List<Long>> terminateByClient(Session session, List<Map<String, Long>> idList) {
        if (idList == null || idList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFCWorkItem.terminateByClient()", new Object[]{"terminate", "collaborative workitem"});
        }
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Map<String, Long> cwiMap : idList) {
            try {
                block8: {
                    block7: {
                        if (cwiMap == null || cwiMap.isEmpty()) break block7;
                        if (!cwiMap.containsKey("CWORKITEM_ID")) break block7;
                        if (cwiMap.containsKey("PROCESSINSTANCEID")) break block8;
                    }
                    throw new BizLogicException("BizLogic_ERR_3762", "WFCWorkItem.terminateByClient()", new Object[]{idList, "terminate", "collaborative workitem"});
                }
                long cWorkItemId = cwiMap.get("CWORKITEM_ID");
                long piid = cwiMap.get("PROCESSINSTANCEID");
                BLUtil.getServiceLocal().terminateCWorkItem(session, piid, cWorkItemId);
                validIdList.add(cWorkItemId);
            }
            catch (Throwable th) {
                return new ResultData(validIdList, th, cwiMap);
            }
        }
        return new ResultData();
    }

    public boolean canCompleteOrTerminate(long cWorkItemId) {
        block3: {
            block2: {
                int state = CWorkItemDAO.getState(cWorkItemId);
                if (state == -1) break block2;
                if (state == 67) break block2;
                if (state == 68) break block2;
                if (state != 74) break block3;
            }
            return false;
        }
        return true;
    }

    private List<String> expandCollaborators(long piid, String wsName, List<String> collaborators) {
        if (collaborators == null || collaborators.isEmpty()) {
            return new ArrayList<String>();
        }
        HashSet<String> users = new HashSet<String>();
        WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
        ArrayList<String> dsNames = new ArrayList<String>();
        for (int ix = 0; ix < collaborators.size(); ++ix) {
            String collaborator = collaborators.get(ix);
            if (!collaborator.startsWith("@")) continue;
            if ("CREATOR".equalsIgnoreCase(collaborator = BLUtil.getParameter((String)collaborator))) {
                String piCreator = pCtx.getProcessInstanceEB().getCreator();
                if (piCreator == null) {
                    throw new BizLogicException("BizLogic_ERR_571", "WFCWorkItem.expandCollaborators", (Object[])new String[]{pCtx.getProcessInstanceName()});
                }
                users.add(piCreator);
                continue;
            }
            dsNames.add(collaborator);
        }
        if (!dsNames.isEmpty()) {
            String[] dsNamesArray = dsNames.toArray(new String[dsNames.size()]);
            HashMap dsValues = pCtx.getSlotValue(dsNamesArray);
            for (int i = 0; i < dsNamesArray.length; ++i) {
                String dsName = dsNamesArray[i];
                Object value = dsValues.get(dsName);
                if (value == null) continue;
                if (value instanceof String) {
                    collaborators.addAll(BLUtil.toVectorListPerformer((String)((String)value)));
                    continue;
                }
                if (value instanceof List) {
                    collaborators.addAll(BLUtil.validateAndFilterUserList((List)((List)value), (String)dsName, (String)pCtx.getProcessInstanceName()));
                    continue;
                }
                throw new BizLogicException("BizLogic_ERR_3909", "WFCWorkItem.expandCollaborators", (Object[])new String[]{dsName, wsName, pCtx.getProcessTemplateName()});
            }
        }
        ArrayList<String> invalidUsers = new ArrayList<String>();
        for (int ix = 0; ix < collaborators.size(); ++ix) {
            String collaborator = collaborators.get(ix);
            if (collaborator.startsWith("@")) continue;
            User user = pCtx.getUser(collaborator);
            if (user != null) {
                users.add(collaborator);
                continue;
            }
            Group group = BLUtil.getGroup((String)collaborator);
            if (group != null) {
                String[] memberNames = group.getMemberNames();
                for (int index = 0; index < memberNames.length; ++index) {
                    users.add(memberNames[index]);
                }
                continue;
            }
            invalidUsers.add(collaborator);
            if (BLControl.util.isRemoveInvalidPerformers()) continue;
            users.add(collaborator);
        }
        if (!invalidUsers.isEmpty()) {
            BLControl.logger.warnKey("BizLogic_ERR_3636", "WFCWorkItem.expandCollaborators()", new Object[]{invalidUsers, wsName, piid});
        }
        if (users.isEmpty()) {
            BLControl.logger.errorKey("BizLogic_ERR_4525", new Object[]{wsName, piid});
        }
        ArrayList<String> expandedCollaborators = new ArrayList<String>();
        expandedCollaborators.addAll(users);
        return expandedCollaborators;
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, Object> getEventContext(WFProcessContext pCtx, Map cwiContextInfo, int eventType) {
        block13: {
            eventContext = SBMUtil.getNewEventContext();
            if (!WFProcessInstance.checkAuditRequired(pCtx, eventType)) {
                eventContext.put("AUDIT_DISABLED", true);
                return eventContext;
            }
            pt = pCtx.getProcess();
            pieb = pCtx.getProcessInstanceEB();
            parentWIID = (Long)cwiContextInfo.get("PARENT_WORKITEM_ID");
            wieb = pCtx.getWorkItemEB(parentWIID);
            wsid = wieb.getWorkStepID();
            ws = pCtx.getWorkstep(wsid);
            wseb = pCtx.getWorkstepInstanceEB(wsid, true);
            eventContext.put("RPID", pieb.getRootInstanceID());
            eventContext.put("RPTID", pieb.getRootTemplateID());
            eventContext.put("APP_NAME", pt.getAppName());
            eventContext.put("PROCESSTEMPLATENAME", pt.getName());
            eventContext.put("PROCESSTEMPLATEID", pt.getID());
            eventContext.put("PROCESSINSTANCENAME", pieb.getName());
            eventContext.put("PROCESSINSTANCEID", pieb.getId());
            eventContext.put("WORKSTEPNAME", ws.getName());
            eventContext.put("WORKSTEPID", wsid);
            eventContext.put("WORKITEMNAME", wieb.getName());
            eventContext.put("WORKITEMID", wieb.getId());
            eventContext.put("LOOPCOUNTER", String.valueOf(wseb.getLoopCounter()));
            intPrio = (Integer)cwiContextInfo.get("PRIORITY");
            priority = SBMControl.util.getStringPriority(intPrio);
            if (priority != null) {
                eventContext.put("PRIORITY", priority);
            }
            longField = (Long)cwiContextInfo.get("STARTTIME");
            eventContext.put("STARTTIME", String.valueOf(longField));
            duration = (Long)cwiContextInfo.get("DURATION");
            if (duration != null) {
                longField = duration;
                eventContext.put("DURATION", String.valueOf(longField));
            }
            if ((duedate = (Long)cwiContextInfo.get("DUEDATE")) != null) {
                longField = duedate;
                eventContext.put("DUEDATE", String.valueOf(longField));
            }
            if ((response = (String)cwiContextInfo.get("RESPONSE")) == null) {
                eventContext.put("RESPONSE", "<NULL>");
            } else {
                eventContext.put("RESPONSE", response);
            }
            if (!cwiContextInfo.containsKey("CWORKITEM_ID")) break block13;
            eventContext.put("CWORKITEM_ID", cwiContextInfo.get("CWORKITEM_ID"));
            eventContext.put("CWORKITEM_NAME", cwiContextInfo.get("CWORKITEM_NAME"));
            eventContext.put("COLLABORATOR", cwiContextInfo.get("COLLABORATOR"));
            status = (Integer)cwiContextInfo.get("STATUS");
            eventContext.put("STATUS", BLControl.consts.wfStates[status]);
            timeCompleted = -1L;
            if (status == 67) ** GOTO lbl-1000
            if (status == 68) ** GOTO lbl-1000
            if (status == 74) lbl-1000:
            // 3 sources

            {
                timeCompleted = System.currentTimeMillis();
            } else if (duedate != null) {
                timeCompleted = duedate;
            }
            eventContext.put("ENDTIME", String.valueOf(timeCompleted));
        }
        eventContext.put("CSTEP_ID", cwiContextInfo.get("CSTEP_ID"));
        eventContext.put("CSTEP_NAME", cwiContextInfo.get("CSTEP_NAME"));
        eventContext.put("CREATOR", cwiContextInfo.get("CREATOR"));
        dsAccess = (Integer)cwiContextInfo.get("DATASLOT_ACCESS");
        if (dsAccess == -1) {
            eventContext.put("DATASLOT_ACCESS", "NO");
        } else if (dsAccess == 0) {
            eventContext.put("DATASLOT_ACCESS", "RO");
        } else {
            eventContext.put("DATASLOT_ACCESS", "RW");
        }
        WFWorkItem.self().addResourcesToContext(pCtx, eventContext);
        return eventContext;
    }

    private long calculateDueDate(WFProcessContext pCtx, long startTime, long duration, String collaborator) {
        long dueDate = startTime + (duration *= 1000L);
        if (BLUtil.self().useCalendar()) {
            dueDate = BLCalendar.self().getDueDate(startTime, duration);
            User user = pCtx.getUser(collaborator);
            if (user != null) {
                dueDate = BLCalendar.self().getDueDate(user, startTime, duration);
            }
        }
        return dueDate;
    }

    private long createTimerActionRecords(long ptid, long piid, long wsid, long cWorkItemId, long dueDate, String emailAddress, int esclType) {
        long timerActionID = -1L;
        if (esclType == 1) {
            BLConstants.TAConstants cfr_ignored_0 = BLControl.consts.ta;
            timerActionID = TimerActionDAO.create(piid, wsid, ptid, dueDate, "EMAIL_NOTIFY_CWORKITEM", String.valueOf(cWorkItemId), emailAddress, "BIZLOGIC");
        } else if (esclType == 2) {
            BLConstants.TAConstants cfr_ignored_1 = BLControl.consts.ta;
            timerActionID = TimerActionDAO.create(piid, wsid, ptid, dueDate, "COMPLETE_CWORKITEM", String.valueOf(cWorkItemId), null, "BIZLOGIC");
        } else if (esclType == 3) {
            BLConstants.TAConstants cfr_ignored_2 = BLControl.consts.ta;
            timerActionID = TimerActionDAO.create(piid, wsid, ptid, dueDate, "TERMINATE_CWORKITEM", String.valueOf(cWorkItemId), null, "BIZLOGIC");
        }
        return timerActionID;
    }

    private String checkWIPerformerEmail(WFProcessContext pCtx, WorkItemEBLocal wieb, String stepNameAlias) {
        String wiPerf = wieb.getPerformer();
        User user = pCtx.getUser(wiPerf);
        String emailAddress = PerformerUtil.getUserEmailAddress((User)user);
        if (emailAddress == null || emailAddress.trim().length() == 0) {
            BLControl.logger.warnKey("BizLogic_ERR_3634", "WFCWorkItem.checkWIPerformerEmail", new Object[]{stepNameAlias, wieb.getName(), pCtx.getProcessInstanceName(), wiPerf});
        }
        return emailAddress;
    }

    private long generateCStepId(String piName, String wiName, String stepNameAlias) {
        long cstepID;
        try {
            cstepID = BLControl.util.cstepSeq.getNextNumber();
        }
        catch (SQLException sqle) {
            throw new BizLogicException("BizLogic_ERR_3645", "WFCWorkItem.create", new Object[]{stepNameAlias, wiName, piName}, (Throwable)sqle);
        }
        return cstepID;
    }

    private String composeCStepName(String prefix, long id) {
        return prefix + "#" + id;
    }

    private String composeCWorkItemName(Map cwiData) {
        String cStepName = (String)cwiData.get("CSTEP_NAME");
        int lastCharOfCStepAlias = cStepName.lastIndexOf("#");
        String cStepNameAlias = cStepName.substring(0, lastCharOfCStepAlias);
        String cWorkItemAlias = "CWI";
        Long cwiid = (Long)cwiData.get("CWORKITEM_ID");
        return cStepNameAlias + ":" + cWorkItemAlias + "#" + cwiid;
    }

    private int getIntegerPriority(String priority) {
        int pri;
        if (priority != null && (pri = SBMControl.util.getIntegerPriority(priority)) != -1) {
            return pri;
        }
        throw new BizLogicException("BizLogic_ERR_1647", "WFCWorkItem.getPriority", new Object[]{SBMControl.util.strPriority});
    }

    private int getIntegerPriority(WorkItemEBLocal wieb, Map cwiData) {
        String priority = (String)cwiData.remove("PRIORITY");
        int intPriority = SBMControl.util.isValidPriority(priority) ? SBMControl.util.getIntegerPriority(priority) : wieb.getPriority();
        return intPriority;
    }

    private long getDuration(WFProcessContext pCtx, long wsid, Map cwiData) {
        Long durationObj = (Long)cwiData.get("DURATION");
        long duration = -1L;
        if (durationObj == null) {
            WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
            duration = wsieb.getDuration();
        } else {
            duration = durationObj;
        }
        return duration;
    }

    private void createCStep(WFProcessContext pCtx, WFAtomicWS ws, Map<String, Object> cwiData) {
        Integer dsAccessObject = (Integer)cwiData.get("DATASLOT_ACCESS");
        if (dsAccessObject != null) {
            if (dsAccessObject != -1) {
                if (!cwiData.containsKey("DATASLOTNAMELIST")) {
                    int ix;
                    String[] inputDS = ws.getInputSlotsKeys();
                    String[] outputDS = ws.getOutputSlotsKeys();
                    HashMap<String, Integer> dsMap = new HashMap<String, Integer>();
                    for (ix = 0; ix < inputDS.length; ++ix) {
                        dsMap.put(inputDS[ix], 0);
                    }
                    for (ix = 0; ix < outputDS.length; ++ix) {
                        dsMap.put(outputDS[ix], dsAccessObject);
                    }
                    cwiData.put("DATASLOTNAMELIST", dsMap);
                }
            }
        }
        String stepName = (String)cwiData.get("CSTEP_NAME");
        String wiName = (String)cwiData.get("WORKITEMNAME");
        String piName = (String)cwiData.get("PROCESSINSTANCENAME");
        Map dsMap = (Map)cwiData.get("DATASLOTNAMELIST");
        if (dsMap == null || dsMap.isEmpty()) {
            if (BLControl.util.isDebugCWI()) {
                BLControl.logger.debugKey("BizLogic_ERR_3128", "WFCWorkItem.createCStepDataSlots", new Object[]{stepName, wiName, piName});
            }
            dsAccessObject = -1;
        } else {
            if (BLControl.util.isDebugCWI()) {
                int dsCount = dsMap.size();
                BLControl.logger.debugKey("BizLogic_ERR_3129", "WFCWorkItem.createCStepDataSlots", new Object[]{dsCount, stepName, wiName, piName});
            }
            dsAccessObject = dsMap.containsValue(1) ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        cwiData.put("DATASLOT_ACCESS", dsAccessObject);
        CWorkItemDAO.createCStep(cwiData);
        Map<String, Object> eventContext = this.getEventContext(pCtx, cwiData, 72);
        Map<String, String> dataslotsForEvent = this.getDataSlotsForEvent(dsMap);
        eventContext.put("DATASLOTNAMELIST", dataslotsForEvent);
        BLUtil.fireEvent(eventContext, (int)72);
    }

    private Map<String, String> getDataSlotsForEvent(Map<String, Integer> dsMap) {
        if (dsMap == null || dsMap.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> dataslotsForEvent = new HashMap<String, String>(dsMap.size());
        for (String dsName : dsMap.keySet()) {
            int dsAccess = dsMap.get(dsName);
            if (dsAccess == 0) {
                dataslotsForEvent.put(dsName, "RO");
                continue;
            }
            dataslotsForEvent.put(dsName, "RW");
        }
        return dataslotsForEvent;
    }

    private boolean isCollaborateByAll(Map<String, Object> cwiData) {
        Boolean collaborateByAll = (Boolean)cwiData.get("COLLABORATE_BY_ALL");
        if (collaborateByAll != null) {
            return collaborateByAll;
        }
        return true;
    }

    private class WIInfoWrapper {
        private long piid;
        private long ptid;
        private long wiid;
        private String stepName;
        private String cwiName;
        private long startTime;
        private long dueDate;
        private long duration;
        private String collaborator;

        private WIInfoWrapper(Map<String, Object> cwiInfo) {
            this.piid = (Long)cwiInfo.get("PROCESSINSTANCEID");
            this.ptid = (Long)cwiInfo.get("PROCESSTEMPLATEID");
            this.wiid = (Long)cwiInfo.get("PARENT_WORKITEM_ID");
            this.stepName = (String)cwiInfo.get("CSTEP_NAME");
            this.cwiName = (String)cwiInfo.get("CWORKITEM_NAME");
            this.startTime = (Long)cwiInfo.get("STARTTIME");
            this.dueDate = (Long)cwiInfo.get("DUEDATE");
            this.duration = (Long)cwiInfo.get("DURATION");
            this.collaborator = (String)cwiInfo.get("COLLABORATOR");
        }
    }
}

