/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.email.EmailComposer;
import com.savvion.sbm.bizlogic.message.BLMessage;
import com.savvion.sbm.bizlogic.message.EmailMessage;
import com.savvion.sbm.bizlogic.server.Notify;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFAtomicInstance;
import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFCWorkItem;
import com.savvion.sbm.bizlogic.server.WFJavaScript;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFWorkItem;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.CWorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.TimerActionDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemDAO;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.svo.TimerAction;
import com.savvion.sbm.bizlogic.util.BLAlertService;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.PerformerUtil;
import com.savvion.sbm.bizlogic.util.ServiceManager;
import com.savvion.sbm.replication.ReplicationManager;
import com.savvion.sbm.replication.service.IServiceHandler;
import com.savvion.sbm.replication.service.ServiceRegister;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.MessageFactory;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.logger.SBMLogger;
import com.tdiinc.common.Emailer.OutGoingMailException;
import com.tdiinc.userManager.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TimerActionManager
extends ServiceManager {
    private static TimerActionManager self = null;
    public static boolean isRunning = false;
    private static long sleepTime = 0L;
    private static final String INVOKING_METHOD = "CheckDue";
    private long fetchedCount = 0L;
    private MessageFactory blEmailMF = EmailComposer.self().getBLEmailMessageFactory();

    private TimerActionManager() {
        ServiceRegister.self().registerService((IServiceHandler)new CheckDueHandler());
    }

    public static final synchronized TimerActionManager self() {
        if (self == null) {
            self = new TimerActionManager();
        }
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCheckDue() {
        if (TimerActionManager.isRunning()) {
            BLConstants.single();
            SBMUtil.logDuplicateMessage((SBMLogger)BLControl.logger, (String)"BizLogic_ERR_1009", (String)"Timer/Overdue Action Service(BLCHECKDUEMDB)");
            return;
        }
        if (!ReplicationManager.self().isPrimaryDatabase()) {
            Object[] objectArray = new Object[1];
            BLConstants.single();
            objectArray[0] = "BLCHECKDUEMDB";
            BLControl.logger.warnKey("BizLogic_ERR_1014", objectArray);
            return;
        }
        Class<TimerActionManager> clazz = TimerActionManager.class;
        synchronized (TimerActionManager.class) {
            if (TimerActionManager.isRunning()) {
                BLConstants.single();
                SBMUtil.logDuplicateMessage((SBMLogger)BLControl.logger, (String)"BizLogic_ERR_1009", (String)"Timer/Overdue Action Service(BLCHECKDUEMDB)");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                LoggerUtil logger = new LoggerUtil(BLControl.logger);
                this.initService("CHECKDUE", BLControl.util.DS_JNDI_NAME, ((Object)((Object)this)).getClass(), INVOKING_METHOD, BLControl.util.isClustering(), logger);
                sleepTime = BLControl.util.getTimerSchedule("BLCHECKDUEMDB");
                this.setSleepTime(sleepTime);
            }
            catch (BizLogicException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (BLControl.logger != null) {
                    BLControl.logger.error((Object)"Exception in TimerAction:runCheckDue(): ", (Throwable)ex);
                }
                throw new RuntimeException("Exception in TimerAction:runCheckDue() ", ex);
            }
            isRunning = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                this.setDebug(BLControl.util.DEBUG_TIMERACTION);
                this.runService();
            }
            catch (Throwable ex) {
                if (BLControl.logger != null) {
                    BLControl.logger.error((Object)"Exception in TimerAction:runService(): ", ex);
                }
                throw new RuntimeException("Exception in TimerAction: runService() ", ex);
            }
            finally {
                isRunning = false;
            }
            return;
        }
    }

    public void sleep() {
        try {
            if (this.errorCount > 1L) {
                if (BLControl.util.DEBUG_TIMERACTION) {
                    BLControl.logger.debugKey("Bizlogic_ERR_3218", "TimerActionManager.sleep", new Object[]{this.onExceptionSleeptime});
                }
                BLControl.util.sleep(this.onExceptionSleeptime);
            } else if (!ServiceLocator.self().isCluster()) {
                if (this.fetchedCount < (long)BLControl.util.getOverDueFetchSize()) {
                    if (BLControl.util.DEBUG_TIMERACTION) {
                        BLControl.logger.debugKey("Bizlogic_ERR_3217", "TimerActionManager.sleep", new Object[]{new Long(sleepTime), new Long(this.fetchedCount), new Long(BLControl.util.getOverDueFetchSize())});
                    }
                    BLControl.util.sleep(sleepTime);
                } else if (BLControl.util.DEBUG_TIMERACTION) {
                    BLControl.logger.debugKey("Bizlogic_ERR_3216", "TimerActionManager.sleep", new Object[]{new Long(this.fetchedCount), new Long(BLControl.util.getOverDueFetchSize())});
                }
            } else {
                if (BLControl.util.DEBUG_TIMERACTION) {
                    BLControl.logger.debugKey("Bizlogic_ERR_3217", "TimerActionManager.sleep", new Object[]{new Long(sleepTime), new Long(this.fetchedCount), new Long(BLControl.util.getOverDueFetchSize())});
                }
                BLControl.util.sleep(sleepTime);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void CheckDue() throws Exception {
        if (BLControl.util.DEBUG_TIMERACTION) {
            BLControl.logger.debugKey("BizLogic_ERR_3261", "TimerActionManager.CheckDue()", new Object[]{"CHECKDUE", System.currentTimeMillis()});
        }
        Vector dues = null;
        HashMap actionInfo = null;
        this.setDebug(BLControl.util.DEBUG_TIMERACTION);
        dues = (Vector)BLUtil.getServiceLocal().getOverDueList();
        if (dues == null || dues.isEmpty()) {
            this.fetchedCount = 0L;
            return;
        }
        this.fetchedCount = dues.size();
        for (int ix = dues.size() - 1; ix >= 0; --ix) {
            Long wid;
            Long pid;
            actionInfo = (HashMap)dues.elementAt(ix);
            try {
                BLUtil.getServiceLocal().executeAction(actionInfo);
                continue;
            }
            catch (BizLogicException be) {
                BLConstants.single();
                pid = (Long)actionInfo.get("PROCESSINSTANCEID");
                BLConstants.single();
                wid = (Long)actionInfo.get("WORKSTEPID");
                BLControl.logger.errorKey("BizLogic_ERR_812", new Object[]{pid, wid, be.getMessage()});
                if (BLControl.util.isRemoveActionOnError()) {
                    TimerActionDAO.removeByProcessInstance(pid);
                }
                if (BLControl.util.isSkipActionsOnError() && BLDAOService.isDBReady()) continue;
                throw be;
            }
            catch (Throwable th) {
                BLConstants.single();
                pid = (Long)actionInfo.get("PROCESSINSTANCEID");
                BLConstants.single();
                wid = (Long)actionInfo.get("WORKSTEPID");
                if (BLControl.util.isRemoveActionOnError()) {
                    TimerActionDAO.removeByProcessInstance(pid);
                }
                if (BLControl.util.isSkipActionsOnError() && BLDAOService.isDBReady()) {
                    BLControl.logger.errorKey("BizLogic_ERR_812", new Object[]{pid, wid, th.getMessage()}, th);
                    continue;
                }
                throw new BizLogicException("BizLogic_ERR_812", "TimerAction.CheckDue", new Object[]{pid, wid, th.getMessage()}, th);
            }
        }
    }

    public void executeAction(HashMap actionInfo) {
        BLConstants.single();
        String actionName = (String)actionInfo.get("ACTION_NAME");
        if (actionName == null || actionName.trim().length() == 0) {
            BLConstants.single();
            long piid = (Long)actionInfo.get("PROCESSINSTANCEID");
            BLConstants.single();
            long wsid = (Long)actionInfo.get("WORKSTEPID");
            BLConstants.single();
            int overdueTimes = (Integer)actionInfo.get("OVERDUE_TIMES");
            this.executeAction(piid, wsid, overdueTimes, actionInfo);
        } else {
            this.executeAction(actionName, actionInfo);
        }
    }

    private void executeAction(long piid, long wsid, int overdueTimes, HashMap actionInfoMap) {
        boolean isDueDateSet = false;
        WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
        if (pCtx.isPISuspended()) {
            BLControl.logger.warnKey("BizLogic_ERR_934", new Object[]{pCtx.getWorkStepInstanceName(wsid), pCtx.getProcessInstanceName()});
            return;
        }
        if (wsid > 0L && pCtx.isWorkstepSuspendedByCompensatory(wsid) && pCtx.isWorkstepSuspended(wsid)) {
            BLControl.logger.warnKey("BizLogic_ERR_922", new Object[]{pCtx.getWorkStepInstanceName(wsid), pCtx.getProcessInstanceName()});
            return;
        }
        TimerAction actions = null;
        int maxTimes = 0;
        long duration = 0L;
        if (wsid == -1L) {
            WFProcess pt = pCtx.getProcess();
            actions = pt.getOverDueAction(overdueTimes);
            maxTimes = pt.getMaxOverDueTimes();
            duration = WFProcessInstance.self().getDuration(pCtx);
        } else {
            WFWorkstep ws = pCtx.getWorkstep(wsid);
            actions = ws.getOverDueAction(overdueTimes);
            maxTimes = ws.getMaxOverDueTimes();
            duration = WFWorkstepInstance.single().getDuration(pCtx, wsid);
        }
        String debugInfo = null;
        if (BLControl.util.DEBUG_TIMERACTION) {
            debugInfo = this.prepareDebugInfo(pCtx, piid, wsid);
        }
        boolean maxOverDue = false;
        long taID = -1L;
        if (++overdueTimes >= maxTimes) {
            if (BLControl.util.DEBUG_TIMERACTION) {
                BLControl.logger.debugKey("BizLogic_ERR_1685", new Object[]{debugInfo});
            }
            BLConstants.TAConstants cfr_ignored_0 = BLConstants.single().ta;
            if (actionInfoMap.containsKey("TIMERACTION_ID")) {
                BLConstants.TAConstants cfr_ignored_1 = BLConstants.single().ta;
                taID = (Long)actionInfoMap.get("TIMERACTION_ID");
            }
            maxOverDue = true;
        }
        String lastAction = "";
        if (actions != null && actions.getNumberOfActions() > 0) {
            String actionName = null;
            HashMap actionInfo = null;
            for (int ix = 0; ix < actions.getNumberOfActions(); ++ix) {
                actionInfo = actions.getAction(ix);
                if (actionInfo == null) continue;
                BLConstants.single();
                actionName = (String)actionInfo.get("ACTION_NAME");
                if (actionName == null) continue;
                lastAction = actionName;
                if (BLControl.util.DEBUG_TIMERACTION) {
                    BLControl.logger.debugKey("BizLogic_ERR_1684", new Object[]{actionName, debugInfo});
                }
                BLConstants.TAConstants cfr_ignored_2 = BLConstants.single().ta;
                if (actionName.equals("REASSIGN")) {
                    BLConstants.single();
                    this.reAssgin(pCtx, wsid, (String)actionInfo.get("PERFORMER"));
                    continue;
                }
                BLConstants.TAConstants cfr_ignored_3 = BLConstants.single().ta;
                if (actionName.equals("SET_PRIORITY")) {
                    BLConstants.single();
                    this.setPriority(pCtx, wsid, (String)actionInfo.get("PRIORITY"));
                    continue;
                }
                BLConstants.TAConstants cfr_ignored_4 = BLConstants.single().ta;
                if (actionName.equals("SET_DURATION")) {
                    BLConstants.single();
                    this.setDuration(pCtx, wsid, (String)actionInfo.get("DURATION"));
                    isDueDateSet = true;
                    continue;
                }
                BLConstants.TAConstants cfr_ignored_5 = BLConstants.single().ta;
                if (actionName.equals("EXTEND_DURATION")) {
                    BLConstants.single();
                    this.extendDuration(pCtx, wsid, (String)actionInfo.get("DURATION"));
                    isDueDateSet = true;
                    continue;
                }
                BLConstants.TAConstants cfr_ignored_6 = BLConstants.single().ta;
                if (actionName.equals("COMPLETE_WORKSTEP")) {
                    this.completeWorkstep(pCtx, wsid);
                    continue;
                }
                BLConstants.TAConstants cfr_ignored_7 = BLConstants.single().ta;
                if (actionName.equals("REMOVE_PROCESS_INSTANCE")) {
                    this.remove(pCtx);
                    continue;
                }
                BLConstants.TAConstants cfr_ignored_8 = BLConstants.single().ta;
                if (actionName.equals("MAKE_AVAILABLE")) {
                    BLConstants.single();
                    String string = (String)actionInfo.get("PERFORMERS");
                    BLConstants.single();
                    this.makeAvailable(pCtx, wsid, string, (WFJavaScript)actionInfo.get("js:"));
                    continue;
                }
                BLConstants.TAConstants cfr_ignored_9 = BLConstants.single().ta;
                if (actionName.equals("EMAIL_NOTIFY")) {
                    BLConstants.single();
                    String string = (String)actionInfo.get("MAILTO");
                    BLConstants.single();
                    String string2 = (String)actionInfo.get("MAILCC");
                    BLConstants.single();
                    String string3 = (String)actionInfo.get("MAILBCC");
                    BLConstants.single();
                    String string4 = (String)actionInfo.get("SUBJECT");
                    BLConstants.single();
                    String string5 = (String)actionInfo.get("CONTENT");
                    BLConstants.single();
                    this.emailNotify(pCtx, wsid, string, string2, string3, string4, string5, (String)actionInfo.get("CHARSET"));
                    continue;
                }
                BLConstants.TAConstants cfr_ignored_10 = BLConstants.single().ta;
                if (actionName.equals("EXEC_JS")) {
                    int scriptType = this.getScriptType(actionInfo);
                    String scriptCode = this.getScriptCode(actionInfo);
                    this.executeScript(pCtx, wsid, scriptCode, scriptType);
                    continue;
                }
                BLConstants.TAConstants cfr_ignored_11 = BLConstants.single().ta;
                if (actionName.equals("CHANGE_PERFORMER")) {
                    WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
                    if (ws.getPerformedByAll()) {
                        BLConstants.single();
                        this.reAssgin(pCtx, wsid, (String)actionInfo.get("PERFORMER"));
                        continue;
                    }
                    long wiid = -1L;
                    Vector wiList = (Vector)WorkItemDAO.findByWorkStepInstance(pCtx.getProcessInstanceID(), wsid);
                    wiid = (Long)wiList.get(0);
                    WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
                    BLConstants.single();
                    User user = pCtx.getUser((String)actionInfo.get("PERFORMER"));
                    if (user != null) {
                        if (wieb.getState() == 28) {
                            BLConstants.single();
                            pCtx.reAssignWorkItem(wiid, (String)actionInfo.get("PERFORMER"));
                            continue;
                        }
                        if (wieb.getState() == 27) {
                            BLConstants.single();
                            pCtx.assignWorkItem(wiid, (String)actionInfo.get("PERFORMER"));
                            continue;
                        }
                        Object[] objectArray = new Object[3];
                        objectArray[0] = wiid;
                        objectArray[1] = wieb.getPerformer();
                        BLConstants.single();
                        objectArray[2] = (String)actionInfo.get("PERFORMER");
                        throw new BizLogicException("BizLogic_ERR_9301", "TimerActionManager.executeAction", objectArray);
                    }
                    BLConstants.single();
                    String string = (String)actionInfo.get("PERFORMER");
                    BLConstants.single();
                    this.makeAvailable(pCtx, wsid, string, (WFJavaScript)actionInfo.get("js:"));
                    continue;
                }
                BLConstants.TAConstants cfr_ignored_12 = BLConstants.single().ta;
                if (actionName.equals("ACTIVATE_TIMEOUT_FLOW")) {
                    this.activateTimeoutFlow(pCtx, wsid);
                    continue;
                }
                BLConstants.TAConstants cfr_ignored_13 = BLConstants.single().ta;
                if (actionName.equals("SEND_ALERTS")) {
                    this.sendAlert(pCtx, wsid, actionInfo);
                    continue;
                }
                BLConstants.TAConstants cfr_ignored_14 = BLConstants.single().ta;
                if (!actionName.equals("NO_OVERDUE_ACTION")) continue;
            }
        }
        if (!maxOverDue) {
            if (pCtx.isWsDueDateSet()) {
                isDueDateSet = true;
            }
            TimerActionDAO.increaseOverDueTimes(piid, wsid, new Date().getTime() + duration * 1000L, isDueDateSet);
        } else if (taID != -1L && !lastAction.equals("COMPLETE_WORKSTEP")) {
            TimerActionDAO.removeByID(taID);
            lastAction = "";
        }
    }

    private int getScriptType(HashMap actionInfo) {
        BLConstants.single();
        Integer scriptType = (Integer)actionInfo.get("SCRIPT_CODE_TYPE");
        int st = 201;
        if (scriptType != null) {
            st = scriptType;
        }
        return st;
    }

    private String getScriptCode(HashMap actionInfo) {
        BLConstants.single();
        String scriptCode = (String)actionInfo.get("SCRIPT_CODE");
        if (scriptCode == null) {
            scriptCode = (String)actionInfo.get("JS_SOURCE");
        }
        return scriptCode;
    }

    private String prepareDebugInfo(WFProcessContext pCtx, long piid, long wsid) {
        StringBuilder debugInfo = new StringBuilder(200);
        debugInfo.append("ProcessTemplate:").append(pCtx.getProcessTemplateName());
        debugInfo.append("(").append(pCtx.getProcessTemplateID()).append(")");
        debugInfo.append(", ProcessInstance:").append(pCtx.getProcessInstanceName());
        debugInfo.append("(").append(String.valueOf(piid)).append(")");
        debugInfo.append("state - ").append(WFProcessInstance.self().getStateDescription(pCtx));
        if (wsid > 0L) {
            debugInfo.append(", WorkstepInstance:").append(pCtx.getWorkStepInstanceName(wsid));
            debugInfo.append("(").append(String.valueOf(wsid)).append(")");
            debugInfo.append("state - ").append(WFWorkstepInstance.single().getStateDescription(pCtx, wsid));
        }
        return debugInfo.toString();
    }

    private void executeAction(String actionName, HashMap actionInfo) {
        BLConstants bl = BLConstants.single();
        BLConstants.TAConstants cfr_ignored_0 = bl.ta;
        String actionInput = (String)actionInfo.get("ACTION_INPUT");
        BLConstants.TAConstants cfr_ignored_1 = bl.ta;
        long actionId = (Long)actionInfo.get("TIMERACTION_ID");
        if (BLControl.util.DEBUG_TIMERACTION) {
            BLControl.logger.debugKey("BizLogic_ERR_3259", "TimerActionManager.executeAction()", new Object[]{this.getActionMsg(actionName, actionId), actionInfo});
        }
        BLConstants.TAConstants cfr_ignored_2 = bl.ta;
        if (actionName.equals("ACTIVATE_WORKSTEP_INSTANCE")) {
            long piid = (Long)actionInfo.get("PROCESSINSTANCEID");
            long wsid = (Long)actionInfo.get("WORKSTEPID");
            WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
            if (pCtx.getProcessInstanceEB().isSuspended()) {
                String wsName = pCtx.getWorkstep(wsid).getName();
                throw new BizLogicException("BizLogic_ERR_3525", "TM.executeAction", new Object[]{actionName, actionId, piid, wsName});
            }
            WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
            if (wsieb.getState() != 61) {
                return;
            }
            pCtx.activateWorkstep(wsid);
        } else {
            BLConstants.TAConstants cfr_ignored_3 = bl.ta;
            if (actionName.equals("ACTIVATE_TIMEOUT_FLOW")) {
                long piid = (Long)actionInfo.get("PROCESSINSTANCEID");
                long wsid = (Long)actionInfo.get("WORKSTEPID");
                WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
                this.activateTimeoutFlow(pCtx, wsid);
            } else {
                BLConstants.TAConstants cfr_ignored_4 = bl.ta;
                if (actionName.equals("COMPLETE_WORKSTEP_INSTANCE")) {
                    long piid = (Long)actionInfo.get("PROCESSINSTANCEID");
                    long wsid = (Long)actionInfo.get("WORKSTEPID");
                    WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
                    this.completeWorkstep(pCtx, wsid);
                } else {
                    BLConstants.TAConstants cfr_ignored_5 = BLConstants.single().ta;
                    if (actionName.equals("SUSPEND_SERVER")) {
                        BLControl.suspend();
                    } else {
                        BLConstants.TAConstants cfr_ignored_6 = BLConstants.single().ta;
                        if (actionName.equals("RESUME_SERVER")) {
                            BLControl.resume();
                        } else {
                            BLConstants.TAConstants cfr_ignored_7 = BLConstants.single().ta;
                            if (actionName.equals("SUSPEND_PROCESS_TEMPLATE")) {
                                BLConstants.single();
                                long ptid = (Long)actionInfo.get("PROCESSTEMPLATEID");
                                ProcessControl.suspendProcessTemplate(ptid);
                            } else {
                                BLConstants.TAConstants cfr_ignored_8 = BLConstants.single().ta;
                                if (actionName.equals("RESUME_PROCESS_TEMPLATE")) {
                                    BLConstants.single();
                                    long ptid = (Long)actionInfo.get("PROCESSTEMPLATEID");
                                    ProcessControl.resumeProcessTemplate(ptid);
                                } else {
                                    BLConstants.TAConstants cfr_ignored_9 = BLConstants.single().ta;
                                    if (actionName.equals("SUSPEND_PROCESS_INSTANCE")) {
                                        WFProcessInstance.self().suspend(this.getProcessContext(actionInfo));
                                    } else {
                                        BLConstants.TAConstants cfr_ignored_10 = BLConstants.single().ta;
                                        if (actionName.equals("RESUME_PROCESS_INSTANCE")) {
                                            WFProcessInstance.self().resume(this.getProcessContext(actionInfo));
                                        } else {
                                            BLConstants.TAConstants cfr_ignored_11 = BLConstants.single().ta;
                                            if (actionName.equals("REMOVE_PROCESS_INSTANCE")) {
                                                WFProcessInstance.self().remove(this.getProcessContext(actionInfo), false);
                                            } else {
                                                BLConstants.TAConstants cfr_ignored_12 = BLConstants.single().ta;
                                                if (actionName.equals("COMPLETE_CWORKITEM")) {
                                                    long piid = (Long)actionInfo.get("PROCESSINSTANCEID");
                                                    WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
                                                    long cwiid = Long.parseLong(actionInput);
                                                    if (WFCWorkItem.self().canCompleteOrTerminate(cwiid)) {
                                                        pCtx.completeCWorkItem(cwiid, null, null);
                                                    }
                                                } else {
                                                    BLConstants.TAConstants cfr_ignored_13 = BLConstants.single().ta;
                                                    if (actionName.equals("TERMINATE_CWORKITEM")) {
                                                        long piid = (Long)actionInfo.get("PROCESSINSTANCEID");
                                                        WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
                                                        long cwiid = Long.parseLong(actionInput);
                                                        if (WFCWorkItem.self().canCompleteOrTerminate(cwiid)) {
                                                            pCtx.terminateCWorkItem(cwiid);
                                                        }
                                                    } else {
                                                        BLConstants.TAConstants cfr_ignored_14 = BLConstants.single().ta;
                                                        if (actionName.equals("EMAIL_NOTIFY_CWORKITEM")) {
                                                            BLConstants.TAConstants cfr_ignored_15 = BLConstants.single().ta;
                                                            String notifyEmail = (String)actionInfo.remove("NOTIFY_EMAIL");
                                                            this.notifyCWorkItemOverDue(actionName, actionId, notifyEmail, actionInfo);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        try {
            BLConstants.TAConstants cfr_ignored_16 = BLConstants.single().ta;
            String notifyEmail = (String)actionInfo.get("NOTIFY_EMAIL");
            if (notifyEmail != null && notifyEmail.trim().length() > 1) {
                String subject = this.blEmailMF.lookup("BLEMAIL_MSG_034", new Object[]{this.getActionMsg(actionName, actionId)}, false);
                EmailMessage emsg = new EmailMessage(subject, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{notifyEmail}, new Date());
                Notify.self().send((BLMessage)emsg);
            }
        }
        catch (Throwable th) {
            BLControl.logger.warnKey("BizLogic_ERR_775", new Object[]{this.getActionMsg(actionName, actionId)});
        }
        TimerActionDAO.removeByID(actionId);
        if (BLControl.util.DEBUG_TIMERACTION) {
            BLControl.logger.debugKey("BizLogic_ERR_772", new Object[]{this.getActionMsg(actionName, actionId)});
        }
    }

    private void notifyCWorkItemOverDue(String actionName, long actionID, String notifyEmail, HashMap actionInfo) {
        BLConstants.TAConstants cfr_ignored_0 = BLConstants.single().ta;
        String actionInput = (String)actionInfo.get("ACTION_INPUT");
        long cwiid = Long.parseLong(actionInput);
        Map<String, Object> cwiInfo = CWorkItemDAO.getCWorkItem(cwiid, false);
        BLConstants.single();
        String cwiName = (String)cwiInfo.get("CWORKITEM_NAME");
        BLConstants.single();
        String cStepName = (String)cwiInfo.get("CSTEP_NAME");
        BLConstants.single();
        String piName = (String)cwiInfo.get("PROCESSINSTANCENAME");
        BLConstants.single();
        String creator = (String)cwiInfo.get("CREATOR");
        if (notifyEmail == null) {
            BLControl.logger.warnKey("BizLogic_ERR_3894", "TimerActionManager.notifyCWorkItemOverDue", new Object[]{cwiName, cStepName, piName, creator});
            return;
        }
        try {
            String subject = this.blEmailMF.lookup("BLEMAIL_MSG_035", new Object[]{cwiName}, false);
            String body = this.blEmailMF.lookup("BLEMAIL_MSG_036", new Object[]{cwiName, cStepName, piName}, false);
            EmailMessage emsg = new EmailMessage(subject, (Object)body, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{notifyEmail}, new Date());
            Notify.self().send((BLMessage)emsg);
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_775", "TimerActionManager.notifyCWorkItemOverDue", new Object[]{this.getActionMsg(actionName, actionID)});
        }
    }

    private void activateTimeoutFlow(WFProcessContext pCtx, long wsid) {
        String timeoutFlow = null;
        WFWorkstep overDueWS = null;
        WFWorkstep timeoutFlowWS = null;
        try {
            overDueWS = pCtx.getProcess().getWorkstep(wsid);
            timeoutFlow = overDueWS.getTimeoutFlow();
            timeoutFlowWS = pCtx.getProcess().getWorkstep(timeoutFlow);
            pCtx.terminateWorkstep(wsid);
            if (BLControl.util.DEBUG_TIMERACTION) {
                BLControl.logger.debugKey("BizLogic_ERR_3522", "TimerActionManager.activateTimeoutFlow", new Object[]{pCtx.getProcessInstanceName(), overDueWS.getName(), timeoutFlowWS.getName()});
            }
            pCtx.activateWorkstep(timeoutFlowWS.getID());
            if (BLControl.util.DEBUG_TIMERACTION) {
                BLControl.logger.debugKey("BizLogic_ERR_3521", "TimerActionManager.activateTimeoutFlow", new Object[]{pCtx.getProcessInstanceName(), overDueWS.getName(), timeoutFlowWS.getName()});
            }
        }
        catch (Exception ex) {
            if (overDueWS != null) {
                throw new BizLogicException("BizLogic_ERR_3518", "TimerActionManager.activateTimeoutFlow", new Object[]{pCtx.getProcessInstanceName(), overDueWS.getName()}, (Throwable)ex);
            }
            throw new BizLogicException("BizLogic_ERR_3518", "TimerActionManager.activateTimeoutFlow", new Object[]{pCtx.getProcessInstanceName(), null}, (Throwable)ex);
        }
    }

    private String getActionMsg(String actionName, long actionId) {
        StringBuilder msg = new StringBuilder();
        msg.append(actionName);
        msg.append(":");
        msg.append(actionId);
        return msg.toString();
    }

    private WFProcessContext getProcessContext(HashMap actionInfo) {
        BLConstants.single();
        long piid = (Long)actionInfo.get("PROCESSINSTANCEID");
        return new WFProcessContext(null, piid);
    }

    private void reAssgin(WFProcessContext pCtx, long wsid, String performer) {
        if (performer == null) {
            new RuntimeException("Auto forward - Not Supported Yet");
        }
        long l = pCtx.getProcessInstanceID();
        BLConstants.single();
        Vector idList = WorkItemDAO.getIDByWorkStepInstance(l, wsid, 26);
        long wiid = 0L;
        for (int ix = idList.size() - 1; ix >= 0; --ix) {
            wiid = (Long)idList.elementAt(ix);
            WFWorkItem.self().reAssignWorkItem(pCtx, wiid, performer);
        }
    }

    private void setPriority(WFProcessContext pCtx, long wsid, String value) {
        int currentPriority = 0;
        currentPriority = wsid == -1L ? pCtx.getProcessInstanceEB().getPriority() : pCtx.getWorkstepInstanceEB(wsid).getPriority();
        value = this.getRealParameter(pCtx, wsid, value);
        int newPriority = 0;
        BLConstants.single();
        if (value.equalsIgnoreCase("INCREASE")) {
            newPriority = SBMUtil.self().getHigherPriority(currentPriority);
        } else {
            BLConstants.single();
            if (value.equalsIgnoreCase("DECREASE")) {
                newPriority = SBMUtil.self().getLowerPriority(currentPriority);
            } else {
                newPriority = SBMUtil.self().getIntegerPriority(value);
                if (newPriority == -1) {
                    throw new BizLogicException("BizLogic_ERR_1647", "TimerAction.setPriority", new Object[]{SBMControl.util.strPriority});
                }
            }
        }
        if (currentPriority != newPriority) {
            if (wsid == -1L) {
                WFProcessInstance.self().setPriority(pCtx, newPriority, true);
            } else {
                WFWorkstepInstance.single().setPriority(pCtx, wsid, newPriority);
            }
        }
    }

    private void setDuration(WFProcessContext pCtx, long wsid, String duration) {
        duration = this.getRealParameter(pCtx, wsid, duration);
        if (wsid == -1L) {
            long timeStarted = pCtx.getProcessInstanceEB().getTimeStarted();
            WFProcessInstance.self().setDuedate(pCtx, timeStarted + BLUtil.convertDuration((String)duration) * 1000L, true);
        } else {
            WFWorkstepInstance.single().setDuration(pCtx, wsid, BLUtil.convertDuration((String)duration));
        }
    }

    private void extendDuration(WFProcessContext pCtx, long wsid, String extendDuration) {
        extendDuration = this.getRealParameter(pCtx, wsid, extendDuration);
        long duedate = -1L;
        if (wsid == -1L) {
            duedate = pCtx.getProcessInstanceEB().getDuedate();
            WFProcessInstance.self().setDuedate(pCtx, duedate + BLUtil.convertDuration((String)extendDuration) * 1000L, true);
        } else {
            duedate = pCtx.getWorkstepInstanceEB(wsid).getDuedate();
            WFWorkstepInstance.single().setDue(pCtx, wsid, duedate + BLUtil.convertDuration((String)extendDuration) * 1000L);
        }
    }

    private void remove(WFProcessContext pCtx) {
        pCtx.removeProcessInstance(false);
    }

    private void makeAvailable(WFProcessContext pCtx, long wsid, String performerList, WFJavaScript js) {
        if (wsid == -1L) {
            return;
        }
        if (js == null && BLUtil.isJS((String)performerList)) {
            js = new WFJavaScript();
            js.setPerformerFunction(BLUtil.getJS((String)performerList));
        }
        Vector performers = null;
        if (performerList != null) {
            if (js != null) {
                performers = (Vector)WFJavaScript.executeJS(pCtx, wsid, js, "ASSIGN");
            } else {
                String wsPerformers = WFWorkstepInstance.single().getRealPerformer(pCtx, wsid, performerList);
                performers = WFAtomicInstance.self().getPerformerList(pCtx, wsid, wsPerformers);
            }
        }
        pCtx.makeAvailable(wsid, performers);
    }

    private void emailNotify(WFProcessContext pCtx, long wsid, String emailAddress, String cc, String bcc, String subject, String content, String charset) {
        if ((emailAddress = this.getRealParameter(pCtx, wsid, emailAddress)) == null || emailAddress.trim().isEmpty()) {
            if (wsid > 0L) {
                int n = pCtx.getWorkstep(wsid).getType();
                BLConstants.single();
                if (n == 102) {
                    WFAtomicInstance.self();
                    emailAddress = WFAtomicInstance.getWorkItemPerformerEmailList(pCtx, wsid);
                }
            }
            if (emailAddress == null || emailAddress.trim().isEmpty()) {
                BLControl.logger.errorKey("BizLogic_ERR_1681", new Object[]{"email address"});
                return;
            }
        }
        if ((subject = this.getRealParameter(pCtx, wsid, subject)) == null || subject.trim().isEmpty()) {
            StringBuilder buf = new StringBuilder(120);
            if (wsid == -1L) {
                buf.append(this.blEmailMF.lookup("BLEMAIL_MSG_037", new Object[]{pCtx.getProcessInstanceName()}, false));
            } else {
                buf.append(this.blEmailMF.lookup("BLEMAIL_MSG_038", new Object[]{pCtx.getProcessInstanceName(), pCtx.getWorkstep(wsid).getName()}, false));
            }
            subject = buf.toString();
        }
        if ((content = this.getRealParameter(pCtx, wsid, content)) == null || content.trim().isEmpty()) {
            content = subject;
        }
        charset = this.getRealParameter(pCtx, wsid, charset);
        cc = this.getRealParameter(pCtx, wsid, cc);
        bcc = this.getRealParameter(pCtx, wsid, bcc);
        String[] toArr = this.parseEmailAddress(emailAddress);
        String[] ccArr = this.parseEmailAddress(cc);
        String[] bccArr = this.parseEmailAddress(bcc);
        if (toArr == null || toArr.length == 0) {
            throw new BizLogicException("BizLogic_ERR_4640", "TimerAction:emailNotify");
        }
        EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, toArr, ccArr, bccArr, charset);
        try {
            Notify.self().send((BLMessage)emsg);
        }
        catch (OutGoingMailException ex) {
            BLControl.logger.errorKey("BizLogic_ERR_3565", "TimerAction.emailNotify()", null, new Object[]{ex});
        }
    }

    private String[] parseEmailAddress(String emailIds) {
        String[] tokens;
        if (emailIds == null || emailIds.trim().length() == 0) {
            return null;
        }
        ArrayList<String> emailIdArr = new ArrayList<String>();
        String string = emailIds.trim();
        SBMConstants.self().getClass();
        for (String token : tokens = string.split("[\\s]*,[\\s]*")) {
            String emailAddr = TimerActionManager.getUserEmailAddress(token);
            if (emailAddr == null) {
                BLControl.logger.warnKey("BizLogic_ERR_3913", "TimerAction.parseEmailAddress()", new Object[]{token});
            }
            if (emailAddr == null || emailAddr.length() == 0) continue;
            emailIdArr.add(emailAddr);
        }
        return emailIdArr.toArray(new String[emailIdArr.size()]);
    }

    private static String getUserEmailAddress(String performerID) {
        User user = BLUtil.getUser((String)performerID);
        String email = null;
        if (user != null) {
            email = PerformerUtil.getUserEmailAddress((User)user);
        } else if (BLUtil.isEmailAddress((String)performerID)) {
            email = performerID;
        }
        return email;
    }

    private void executeScript(WFProcessContext pCtx, long wsid, String script, int scriptType) {
        WFJavaScript js = new WFJavaScript();
        js.setDueFunction(script, scriptType);
        BLConstants.single();
        WFJavaScript.executeScript(pCtx, wsid, js, "DUE");
    }

    private void sendAlert(WFProcessContext pCtx, long wsid, HashMap actionInfo) {
        try {
            BLAlertService bLAlertService = BLAlertService.single();
            BLConstants.single();
            List alertsPublished = bLAlertService.publishAlerts(pCtx, wsid, (ArrayList)actionInfo.get("ALERT_NAMES"));
            if (BLControl.util.DEBUG_ALERTS) {
                BLControl.logger.debugKey("BizLogic_ERR_3160", "TimerActionManager.sendAlert", new Object[]{pCtx.getProcessInstanceName(), pCtx.getWorkstep(wsid).getName(), "W_OVERDUE", alertsPublished});
            }
        }
        catch (Throwable th) {
            BLControl.logger.errorKey("BizLogic_ERR_3691", new Object[]{pCtx.getProcessInstanceName(), pCtx.getWorkstep(wsid).getName(), "ON OVERDUE"}, th);
        }
    }

    private Map prepareProcessContext(WFProcessContext pCtx, long wsid) {
        HashMap hm = null;
        hm = wsid == -1L ? WFProcessInstance.self().getProcessContextData(pCtx) : WFWorkstepInstance.single().getProcessContextData(pCtx, wsid);
        return hm;
    }

    private String getRealParameter(WFProcessContext pCtx, long wsid, String param) {
        String realParam = param;
        if (param != null) {
            BLConstants.single();
            if (param.startsWith("@")) {
                StringBuilder stringBuilder = new StringBuilder();
                BLConstants.single();
                if (!param.equalsIgnoreCase(stringBuilder.append("@").append("CREATOR").toString())) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    BLConstants.single();
                    if (!param.equalsIgnoreCase(stringBuilder2.append("@").append("PROCESSNAME").toString())) {
                        StringBuilder stringBuilder3 = new StringBuilder();
                        BLConstants.single();
                        if (!param.equalsIgnoreCase(stringBuilder3.append("@").append("WORKSTEPNAME").toString())) {
                            StringBuilder stringBuilder4 = new StringBuilder();
                            BLConstants.single();
                            if (!(param.equalsIgnoreCase(stringBuilder4.append("@").append("PRIORITY").toString()) || param.equalsIgnoreCase("@PROCESS_INSTANCE_ID") || param.equalsIgnoreCase("@PROCESS_TEMPLATE_NAME"))) {
                                BLUtil.self();
                                param = BLUtil.getParameter((String)param);
                            }
                        }
                    }
                }
                realParam = wsid == -1L ? (String)pCtx.getSlotValue(param) : (String)pCtx.getSlotValue(wsid, param);
            }
        }
        return realParam;
    }

    public static boolean isRunning() {
        return isRunning;
    }

    public boolean getStopFlag() {
        return TimerActionManager.isRunning() && BLControl.isServerReady() && BLUtil.self().isCheckDueEnabled();
    }

    public long createTimerAction(long executeTime, String actionName, String actionInput, String notifyEmail, String actionCreator) {
        this.validateExecuteTime(actionName, executeTime);
        try {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    actionName = actionName.toUpperCase();
                                    BLConstants.TAConstants cfr_ignored_0 = BLConstants.single().ta;
                                    if (actionName.equals("SUSPEND_SERVER")) break block9;
                                    BLConstants.TAConstants cfr_ignored_1 = BLConstants.single().ta;
                                    if (!actionName.equals("RESUME_SERVER")) break block10;
                                }
                                return TimerActionDAO.create(-1L, -1L, -1L, executeTime, actionName, actionInput, notifyEmail, actionCreator);
                            }
                            BLConstants.TAConstants cfr_ignored_2 = BLConstants.single().ta;
                            if (actionName.equals("SUSPEND_PROCESS_TEMPLATE")) break block11;
                            BLConstants.TAConstants cfr_ignored_3 = BLConstants.single().ta;
                            if (!actionName.equals("RESUME_PROCESS_TEMPLATE")) break block12;
                        }
                        long ptid = ProcessControl.getProcessTemplate(actionInput).getID();
                        return TimerActionDAO.create(-1L, -1L, ptid, executeTime, actionName, actionInput, notifyEmail, actionCreator);
                    }
                    BLConstants.TAConstants cfr_ignored_4 = BLConstants.single().ta;
                    if (actionName.equals("SUSPEND_PROCESS_INSTANCE")) break block13;
                    BLConstants.TAConstants cfr_ignored_5 = BLConstants.single().ta;
                    if (actionName.equals("RESUME_PROCESS_INSTANCE")) break block13;
                    BLConstants.TAConstants cfr_ignored_6 = BLConstants.single().ta;
                    if (!actionName.equals("REMOVE_PROCESS_INSTANCE")) break block14;
                }
                return TimerActionDAO.create(Long.parseLong(actionInput), -1L, -1L, executeTime, actionName, actionInput, notifyEmail, actionCreator);
            }
            throw new BizLogicException("BizLogic_ERR_771", "TimerAction:createTimerAction", new Object[]{actionName});
        }
        catch (BizLogicException blex) {
            throw blex;
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_774", "TimerAction:createTimerAction", new Object[]{actionName}, (Throwable)ex);
        }
    }

    private void validateExecuteTime(String actionName, long executeTime) {
        if (executeTime < System.currentTimeMillis()) {
            BLControl.logger.warnKey("BizLogic_ERR_770", new Object[]{actionName});
        }
    }

    private void completeWorkstep(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        long piid = pCtx.getProcessInstanceID();
        if (wsieb.getState() == 16) {
            if (BLControl.logger != null) {
                BLControl.logger.errorKey("BizLogic_ERR_809", new Object[]{piid, wsieb.getName()});
            }
        } else if (wsieb.getState() != 21) {
            pCtx.completeWorkstep(wsid);
        }
    }

    private class CheckDueHandler
    implements IServiceHandler {
        private CheckDueHandler() {
        }

        public String getServiceName() {
            return TimerActionManager.INVOKING_METHOD;
        }

        public void startService() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    TimerActionManager.this.runCheckDue();
                }
            }).start();
        }

        public void stopService() {
            isRunning = false;
        }

        public boolean isServiceRunning() {
            return TimerActionManager.isRunning();
        }
    }
}

