/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.SubProcessMetaData;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFNestedWS;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.svo.DataSlotMapping;
import com.savvion.sbm.bizlogic.server.svo.DataSlotMappingList;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.util.ServiceLocator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubProcessInstanceData {
    private final WFProcessContext pCtx;
    private final long wsid;
    private final String performer;
    private boolean isRemoteSubProcess = false;
    private String appServerID;
    private final String subProcessName;
    private String subProcessAlias;
    private HashMap inputSlotValues;
    private DataSlotMappingList outputSlots;

    private SubProcessInstanceData(WFProcessContext pCtx, long wsid, String subProcessName, String performer) {
        this.pCtx = pCtx;
        this.wsid = wsid;
        this.subProcessName = subProcessName;
        this.performer = performer;
        this.validatePerformer();
    }

    private void validatePerformer() {
        if (this.performer == null) {
            this.isRemoteSubProcess = false;
            return;
        }
        if (this.performer.equalsIgnoreCase(this.subProcessName) || this.performer.contains(this.subProcessName) || this.performer.trim().isEmpty() || "<NULL>".equals(this.performer)) {
            this.isRemoteSubProcess = false;
            return;
        }
        if (this.performer.toLowerCase().startsWith("jndi://")) {
            this.isRemoteSubProcess = true;
            return;
        }
        WorkStepInstanceEBLocal wsieb = this.pCtx.getWorkstepInstanceEB(this.wsid);
        wsieb.setPerformer(this.subProcessName);
        wsieb.setActualPerformer(this.subProcessName);
    }

    void setSubProcessAlias(String alias) {
        this.subProcessAlias = alias;
    }

    void setInputSlotValues(HashMap dsValues) {
        this.inputSlotValues = dsValues;
    }

    void setOutputSlots(DataSlotMappingList outputSlots) {
        this.outputSlots = outputSlots;
    }

    boolean isRemoteSubProcess() {
        return this.isRemoteSubProcess;
    }

    boolean isLocalSubProcess() {
        return !this.isRemoteSubProcess;
    }

    String getAppServerID() {
        if (this.appServerID == null) {
            if (this.isRemoteSubProcess()) {
                Hashtable ht = BLUtil.parseEJBPerformer((String)this.performer, (String)this.pCtx.getProcessInstanceName(), (String)this.pCtx.getProcess().getName());
                this.appServerID = (String)ht.get("APPSERVER");
            } else {
                this.appServerID = ServiceLocator.self().getAppServerID();
            }
        }
        return this.appServerID;
    }

    String getSubProcessAlias() {
        return this.subProcessAlias;
    }

    String getSubProcessName() {
        return this.subProcessName;
    }

    String getPerformer() {
        return this.performer;
    }

    HashMap getInputSlotValues() {
        return this.inputSlotValues;
    }

    HashMap getCallerInfo() {
        HashMap<String, Object> callerInfo = new HashMap<String, Object>();
        if (this.isRemoteSubProcess()) {
            callerInfo.put("CALLERPROTOCOL", "jndi://");
            callerInfo.put("CALLERSERVER", BLControl.getCallerInfo());
            callerInfo.put("CALLERLOCATION", ServiceLocator.self().getAppServerID());
        } else {
            callerInfo.put("CALLERPROTOCOL", "local");
        }
        callerInfo.put("CALLERROOTTEMPLATEID", this.pCtx.getRootTemplateID());
        callerInfo.put("CALLERROOTINSTANCEID", this.pCtx.getRootInstanceID());
        callerInfo.put("CALLERPROCESSINSTANCEID", this.pCtx.getProcessInstanceID());
        callerInfo.put("CALLERPROCESSINSTANCENAME", this.pCtx.getProcessInstanceName());
        callerInfo.put("CALLERWORKSTEPID", this.wsid);
        WFWorkstep parentWS = this.pCtx.getProcess().getWorkstep(this.wsid);
        callerInfo.put("CALLERWORKSTEPNAME", parentWS.getName());
        long wsDuration = WFWorkstepInstance.single().getDuration(this.pCtx, this.wsid);
        if (wsDuration > 0L) {
            callerInfo.put("CALLERWORKSTEPDURATION", wsDuration);
        }
        int loopCounter = this.pCtx.getWorkstepInstanceEB(this.wsid).getLoopCounter();
        callerInfo.put("LOOPCOUNTER", loopCounter);
        callerInfo.put("CALLERMAPPING", this.outputSlots.getMappingInfo());
        callerInfo.put("OUTPUTDATASLOTS", this.outputSlots);
        if (this.pCtx.isDebug()) {
            callerInfo.put("DEBUG_PROCESS_INSTANCE", Boolean.TRUE);
        }
        return callerInfo;
    }

    static ArrayList getSubProcessInstances(WFProcessContext pCtx, long wsid) {
        ArrayList subProcessInstances = new ArrayList();
        WFNestedWS ws = (WFNestedWS)pCtx.getWorkstep(wsid);
        ArrayList subProcessMetaDatas = ws.getSubProcessMetaDatas();
        String performer = WFWorkstepInstance.single().getRealPerformer(pCtx, wsid);
        for (int ix = 0; ix < subProcessMetaDatas.size(); ++ix) {
            SubProcessMetaData subProcessMetaData = (SubProcessMetaData)subProcessMetaDatas.get(ix);
            ArrayList instances = SubProcessInstanceData.createSubProcessInstances(pCtx, wsid, performer, subProcessMetaData);
            subProcessInstances.addAll(instances);
        }
        return subProcessInstances;
    }

    private static ArrayList createSubProcessInstances(WFProcessContext pCtx, long wsid, String performer, SubProcessMetaData subProcessMetaData) {
        long count = SubProcessInstanceData.getRealCount(pCtx, subProcessMetaData);
        if (BLControl.util.DEBUG_SUBPROCESS) {
            BLControl.logger.debugKey("BizLogic_ERR_3238", "SubProcessInstanceData.createSubProcessInstances()", new Object[]{pCtx.getProcessTemplateName(), pCtx.getProcessTemplateID(), pCtx.getWorkstep(wsid).getName(), "subProcess count", count});
        }
        ArrayList subProcessList = SubProcessInstanceData.getRealSubProcessNames(pCtx, wsid, subProcessMetaData, count);
        if (BLControl.util.DEBUG_SUBPROCESS) {
            BLControl.logger.debugKey("BizLogic_ERR_3238", "SubProcessInstanceData.createSubProcessInstances()", new Object[]{pCtx.getProcessTemplateName(), pCtx.getProcessTemplateID(), pCtx.getWorkstep(wsid).getName(), "subProcess Names", subProcessList});
        }
        ArrayList subProcessAliasList = SubProcessInstanceData.getRealSubProcessAliases(pCtx, wsid, subProcessMetaData);
        if (BLControl.util.DEBUG_SUBPROCESS) {
            BLControl.logger.debugKey("BizLogic_ERR_3238", "SubProcessInstanceData.createSubProcessInstances()", new Object[]{pCtx.getProcessTemplateName(), pCtx.getProcessTemplateID(), pCtx.getWorkstep(wsid).getName(), "subProcess Alias", subProcessAliasList});
        }
        DataSlotMappingList inputSlots = SubProcessInstanceData.getInputDataSlots(pCtx, wsid, subProcessMetaData);
        if (BLControl.util.DEBUG_SUBPROCESS) {
            SubProcessInstanceData.printDebug(pCtx, wsid, performer, subProcessMetaData, count, subProcessList, inputSlots);
        }
        ArrayList<SubProcessInstanceData> subProcessInstances = new ArrayList<SubProcessInstanceData>();
        HashMap inputDataSlotValues = null;
        for (int ix = 0; ix < subProcessList.size(); ++ix) {
            String actualSubProcessName = (String)subProcessList.get(ix);
            String actualSubProcessAlias = null;
            if (subProcessAliasList.size() > ix) {
                actualSubProcessAlias = (String)subProcessAliasList.get(ix);
            }
            if (actualSubProcessAlias == null || actualSubProcessAlias.trim().isEmpty() || "<NULL>".equals(actualSubProcessAlias)) {
                if (BLControl.util.DEBUG_SUBPROCESS) {
                    BLControl.logger.debug((Object)("SubProcess Alias provided <" + actualSubProcessAlias + "> is invalid. So subProcess name <" + actualSubProcessName + "> is used instead."));
                }
                actualSubProcessAlias = actualSubProcessName;
            }
            inputDataSlotValues = inputSlots.getValuesByMappedName(ix, actualSubProcessName);
            DataSlotMappingList outputSlots = (DataSlotMappingList)subProcessMetaData.getOutputSlots().clone();
            Map<String, String> outputDocumentDSNames = outputSlots.getDocumentDSNames();
            if (outputDocumentDSNames != null && !outputDocumentDSNames.isEmpty()) {
                inputDataSlotValues = SubProcessInstanceData.mergeDocumentDSValues(pCtx, inputDataSlotValues, outputDocumentDSNames);
            }
            SubProcessInstanceData instance = new SubProcessInstanceData(pCtx, wsid, actualSubProcessName, performer);
            instance.setSubProcessAlias(actualSubProcessAlias);
            instance.setInputSlotValues(inputDataSlotValues);
            instance.setOutputSlots(outputSlots);
            subProcessInstances.add(instance);
        }
        return subProcessInstances;
    }

    private static HashMap mergeDocumentDSValues(WFProcessContext pCtx, HashMap inputDataSlotValues, Map<String, String> outputDocumentDSNames) {
        if (outputDocumentDSNames != null && !outputDocumentDSNames.isEmpty()) {
            Set<String> docDSNames = outputDocumentDSNames.keySet();
            boolean documentDSOnlyInOutput = false;
            ArrayList<String> onlyOutputDSList = new ArrayList<String>();
            for (String dsName : docDSNames) {
                if (inputDataSlotValues.containsKey(dsName)) continue;
                documentDSOnlyInOutput = true;
                onlyOutputDSList.add(dsName);
                break;
            }
            if (!documentDSOnlyInOutput) {
                return inputDataSlotValues;
            }
            HashMap outputDocumentDSValues = pCtx.getSlotValue(onlyOutputDSList.toArray(new String[onlyOutputDSList.size()]));
            for (String dsName : outputDocumentDSValues.keySet()) {
                inputDataSlotValues.put(outputDocumentDSNames.get(dsName), outputDocumentDSValues.get(dsName));
            }
        }
        return inputDataSlotValues;
    }

    private static long getRealCount(WFProcessContext pCtx, SubProcessMetaData subProcessMetaData) {
        long count = 1L;
        if (!subProcessMetaData.hasCount()) {
            return count;
        }
        Object subProcessCount = subProcessMetaData.getCount();
        if (subProcessMetaData.isCountMappedDS()) {
            Object slotValue = pCtx.getSlotValue(subProcessCount.toString());
            count = (Long)slotValue;
        } else {
            count = (Long)subProcessCount;
        }
        return count;
    }

    private static ArrayList getRealSubProcessNames(WFProcessContext pCtx, long wsid, SubProcessMetaData subProcessMetaData, long count) {
        String subProcessName = subProcessMetaData.getSubProcessName();
        ArrayList<Object> subProcessList = new ArrayList<Object>();
        if (!BLUtil.isParameter((String)subProcessName)) {
            subProcessList.add(subProcessName);
            for (long ix = count - 1L; ix > 0L; --ix) {
                subProcessList.add(subProcessName);
            }
        } else {
            String dsName = BLUtil.getParameter((String)subProcessName);
            Object dsVal = pCtx.getSlotValue(dsName);
            WFNestedWS ws = (WFNestedWS)pCtx.getWorkstep(wsid);
            WFDataslot ds = ws.getDataslot(dsName);
            if (ds.isString()) {
                String dsValue = (String)dsVal;
                if (dsValue == null || dsValue.trim().length() == 0 || "<NULL>".equals(dsValue)) {
                    throw new BizLogicException("BizLogic_ERR_3743", "SubProcessInstanceData.getRealSubProcessNames()", new Object[]{ws.getParentProcess().getID(), dsValue, ws.getName()});
                }
                subProcessList.add(dsValue);
                for (long ix = count - 1L; ix > 0L; --ix) {
                    subProcessList.add(dsVal);
                }
            } else if (ds.isList()) {
                List dsValue = (List)dsVal;
                if (dsValue == null || dsValue.isEmpty()) {
                    throw new BizLogicException("BizLogic_ERR_3743", "SubProcessInstanceData.getRealSubProcessNames()", new Object[]{ws.getParentProcess().getName(), dsValue, ws.getName()});
                }
                subProcessList.addAll(dsValue);
            }
        }
        if (subProcessList.size() > 1) {
            SubProcessInstanceData.validateSubProcessNames(pCtx, wsid, subProcessList);
        }
        return subProcessList;
    }

    private static void validateSubProcessNames(WFProcessContext pCtx, long wsid, ArrayList subProcessNames) {
        ArrayList<String> distinctSPNames = new ArrayList<String>();
        for (Object obj : subProcessNames) {
            if (distinctSPNames.contains(obj)) continue;
            distinctSPNames.add((String)obj);
        }
        ArrayList<String> namesWithError = new ArrayList<String>();
        for (String processName : distinctSPNames) {
            if (ProcessControl.getActiveProcessTemplate(processName) != null) continue;
            if (ProcessControl.isProcessExists(processName)) {
                WFProcess pt = ProcessControl.getProcessTemplate(processName);
                if (pt.isActivated()) continue;
                namesWithError.add(pt.getName() + "(non active process template; current state = " + BLConstants.single().wfStates[pt.getStatus()] + ")");
                continue;
            }
            namesWithError.add(processName + "(invalid name)");
        }
        if (!namesWithError.isEmpty()) {
            WFNestedWS ws = (WFNestedWS)pCtx.getWorkstep(wsid);
            throw new BizLogicException("BizLogic_ERR_3864", "SubProcessInstanceData.validateSubProcessNames()", new Object[]{ws.getParentProcess().getID(), ws.getName(), namesWithError});
        }
    }

    private static ArrayList getRealSubProcessAliases(WFProcessContext pCtx, long wsid, SubProcessMetaData subProcessMetaData) {
        String subProcessAlias = subProcessMetaData.getSubProcessAlias();
        ArrayList<Object> subProcessList = new ArrayList<Object>();
        if (!BLUtil.isParameter((String)subProcessAlias)) {
            subProcessList.add(subProcessAlias);
        } else {
            String dsName = BLUtil.getParameter((String)subProcessAlias);
            Object dsVal = pCtx.getSlotValue(dsName);
            if (dsVal != null) {
                WFNestedWS ws = (WFNestedWS)pCtx.getWorkstep(wsid);
                WFDataslot ds = ws.getDataslot(dsName);
                if (ds.isString()) {
                    subProcessList.add(dsVal);
                } else if (ds.isList()) {
                    subProcessList.addAll((List)dsVal);
                }
            }
        }
        return subProcessList;
    }

    private static DataSlotMappingList getInputDataSlots(WFProcessContext pCtx, long wsid, SubProcessMetaData subProcessMetaData) {
        DataSlotMappingList inputSlots = (DataSlotMappingList)subProcessMetaData.getInputSlots().clone();
        String[] inputSlotNames = inputSlots.getDataSlotNames();
        HashMap inputSlotsValues = pCtx.getSlotValue(inputSlotNames);
        inputSlotsValues = WFProcessInstance.copyXML(pCtx, wsid, inputSlotsValues);
        inputSlots.populateValues(inputSlotsValues);
        return inputSlots;
    }

    private static void printDebug(WFProcessContext pCtx, long wsid, String performer, SubProcessMetaData subProcessMetaData, long count, ArrayList subProcessList, DataSlotMappingList inputSlots) {
        WFNestedWS ws = (WFNestedWS)pCtx.getWorkstep(wsid);
        StringBuilder debugMessage = new StringBuilder();
        debugMessage.append("\n============= SubProcess Instance Info =============");
        debugMessage.append("\npi name = " + pCtx.getProcessInstanceName());
        debugMessage.append("\nws name = " + ws.getName());
        debugMessage.append("\nperformer = " + performer);
        debugMessage.append("\nsub process count = " + count);
        debugMessage.append("\nfinal sub process list = " + subProcessList);
        debugMessage.append("\noutput slots mapping (ds name : mapped name)");
        HashMap outputSlotsMapping = subProcessMetaData.getOutputSlots().getMappingInfo();
        for (String dsName : outputSlotsMapping.keySet()) {
            debugMessage.append("\n\t" + dsName + " : " + outputSlotsMapping.get(dsName));
        }
        debugMessage.append("\nindexed input slots  (mapped name : ds name)");
        ArrayList indexedInputSlots = inputSlots.getIndexedDataSlotMappings();
        for (int ix = 0; ix < indexedInputSlots.size(); ++ix) {
            DataSlotMapping mapping = (DataSlotMapping)indexedInputSlots.get(ix);
            String dsName = mapping.getDataSlotName();
            String mapName = mapping.getMappedName();
            debugMessage.append("\n\t" + mapName + " : " + dsName);
        }
        debugMessage.append("\n mapped input slot values (mapped name : ds value)");
        HashMap mappedInputSlotsValues = inputSlots.getValuesByMappedName();
        for (String mapName : mappedInputSlotsValues.keySet()) {
            debugMessage.append("\n\t" + mapName + " : " + mappedInputSlotsValues.get(mapName));
        }
        debugMessage.append("\n----------------------------------------\n");
        BLControl.logger.debug((Object)debugMessage.toString());
    }
}

