/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class SqlQueryMap
implements Serializable {
    public static final long serialVersionUID = -2237155770699330707L;
    public static final int INSERT = 1;
    public static final int SELECT = 2;
    public static final int UPDATE = 3;
    public static final int DELETE = 4;
    private final String sqlId;
    private final int sqlType;
    private boolean defval = false;
    private String parameterClass = null;
    private String pkColumnName = null;
    private String pkMappedDSName = null;
    private LinkedHashMap params;
    private ArrayList mappedValues;

    public SqlQueryMap(String sqlId, int sqlType, boolean defval) {
        if (sqlId == null || sqlId.trim().isEmpty()) {
            throw new RuntimeException("Invalid sqlid specified");
        }
        if (sqlType < 1 || sqlType > 4) {
            throw new RuntimeException("Invalid sqlType <" + sqlType + "> specified for sqlid <" + sqlId + ">");
        }
        this.sqlId = sqlId;
        this.sqlType = sqlType;
        this.defval = defval;
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    boolean isDefault() {
        return this.defval;
    }

    public Map getParams() {
        if (this.params != null) {
            return new LinkedHashMap(this.params);
        }
        return null;
    }

    void setParams(LinkedHashMap params) {
        if (params != null) {
            this.params = params;
        }
    }

    public boolean isInsert() {
        return this.sqlType == 1;
    }

    public boolean isSelect() {
        return this.sqlType == 2;
    }

    public boolean isUpdate() {
        return this.sqlType == 3;
    }

    public boolean isDelete() {
        return this.sqlType == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addParam(String name, String value, String type) {
        if (name == null || name.trim().isEmpty()) {
            throw new RuntimeException("Invalid Parameter name specified for the query <" + this.sqlId + "> and value <" + value + ">");
        }
        if (value == null) {
            throw new RuntimeException("Invalid Parameter value specified for the query <" + this.sqlId + "> and param name <" + name + ">");
        }
        if (this.params == null) {
            SqlQueryMap sqlQueryMap = this;
            synchronized (sqlQueryMap) {
                if (this.params == null) {
                    this.params = new LinkedHashMap();
                }
            }
        }
        Object newval = this.convertStringValue(value, type);
        this.params.put(name, newval);
    }

    void addMappedValueName(String dsName) {
        if (this.mappedValues == null) {
            this.mappedValues = new ArrayList();
        }
        this.mappedValues.add(dsName);
    }

    public String[] getMappedValueList() {
        if (this.mappedValues == null || this.mappedValues.isEmpty()) {
            return null;
        }
        return this.mappedValues.toArray(new String[0]);
    }

    void setParameterClass(String parameterClass) {
        this.parameterClass = parameterClass;
    }

    public String getParameterClass() {
        return this.parameterClass;
    }

    void setPKInfo(String pkColumnName, String pkMappedDSName) {
        this.pkColumnName = pkColumnName;
        this.pkMappedDSName = pkMappedDSName;
    }

    public String getPKColumnName() {
        return this.pkColumnName;
    }

    public String getPKMappedDataSlotName() {
        return this.pkMappedDSName;
    }

    public boolean isPKAutoGenerated() {
        return this.pkColumnName != null && this.pkMappedDSName != null;
    }

    private Object convertStringValue(String value, String type) {
        if (type == null || "java.lang.String".equals(type)) {
            return value;
        }
        try {
            Class<?> javaClass = Class.forName(type);
            Constructor<?> constructor = javaClass.getConstructor(String.class);
            return constructor.newInstance(value);
        }
        catch (Throwable th) {
            throw new RuntimeException("Invalid type <" + type + "> specified for the value <" + value + "> of the sqlid <" + this.getSqlId() + ">", th);
        }
    }
}

