/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFLink;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.util.BLControl;
import java.io.IOException;
import java.util.Vector;

public class ProcessInfo {
    public static void printProcess(WFProcess pr) {
        try {
            ProcessInfo.writeLog("============================================");
            ProcessInfo.writeLog("============PRINTING PROCESS INFO===========");
            ProcessInfo.writeLog("============================================");
            ProcessInfo.printProcessInfo(pr);
            ProcessInfo.printDataSlots(pr);
            ProcessInfo.printAllWS(pr);
            ProcessInfo.printAllLinks(pr);
            ProcessInfo.writeLog("======================================================");
            ProcessInfo.writeLog("============PRINTING PROCESS INFO COMPLETED===========");
            ProcessInfo.writeLog("======================================================");
        }
        catch (Throwable th) {
            BLControl.logger.error((Object)"Error occured while printing process details");
        }
    }

    private static void printProcessInfo(WFProcess pr) throws Exception {
        ProcessInfo.writeLog("XMLFILE : <" + pr.getXMLFileName() + '>');
        ProcessInfo.writeLog("APPNAME : <" + pr.appName + '>');
        ProcessInfo.writeLog("VERSIONID : <" + pr.getVersion() + '>');
        ProcessInfo.writeLog("MANAGER : <" + pr.getManager() + '>');
        ProcessInfo.writeLog("GROUP : <" + pr.getGroup() + '>');
        ProcessInfo.writeLog("CATEGORY : <" + pr.getCategory() + '>');
        ProcessInfo.writeLog("SUBCATEGORY : <" + pr.getSubCategory() + '>');
        ProcessInfo.writeLog("INFO : <" + pr.getInfo() + '>');
        ProcessInfo.writeLog("PARENTID : <" + pr.getParentID() + '>');
        ProcessInfo.writeLog("ESTIMATED DURATION : <" + pr.getEstimatedDuration() + ">\n");
    }

    private static void printAllLinks(WFProcess pr) throws Exception {
        WFLink link = null;
        ProcessInfo.writeLog("PRINTING LINKS ..........");
        for (int i = 0; i < pr.hasConnections.size(); ++i) {
            link = (WFLink)pr.hasConnections.get(i);
            ProcessInfo.printLink(link);
        }
        ProcessInfo.writeLog("PRINTING LINKS COMPLETED ...........\n\n");
    }

    private static void printLink(WFLink link) throws Exception {
        ProcessInfo.writeLog("-----LINK-------");
        ProcessInfo.writeLog(link.toString());
        ProcessInfo.writeLog("IS TIMEOUT FLOW : " + link.isTimeoutFlow());
        ProcessInfo.writeLog("-----LINK-------");
    }

    private static void printAllWS(WFProcess pr) throws Exception {
        WFWorkstep ws = null;
        ProcessInfo.writeLog("PRINTING WORKSTEPS ..........");
        for (int i = 0; i < pr.hasWorksteps.size(); ++i) {
            ws = (WFWorkstep)pr.hasWorksteps.get(i);
            ProcessInfo.printWS(ws);
        }
        ProcessInfo.writeLog("PRINTING WORKSTEPS COMPLETED ...........\n\n");
    }

    private static void printWS(WFWorkstep ws) throws Exception {
        ProcessInfo.writeLog("------WORKSTEP START-------");
        ProcessInfo.writeLog("WSNAME : <" + ws.getName() + '>');
        ProcessInfo.writeLog("DURATION : <" + ws.duration + '>');
        ProcessInfo.writeLog("PRIORITY : <" + ws.priority + '>');
        ProcessInfo.writeLog("ACTIVATEAFTER : <" + ws.activateAfter + '>');
        ProcessInfo.writeLog("ACTIVATEAT : <" + ws.activateAt + '>');
        ProcessInfo.writeLog("PRECONDITIONTYPE : <" + ws.preconditionType + '>');
        ProcessInfo.writeLog("HASPERFORMER : <" + ws.hasPerformer + '>');
        if (ws.wsjscript != null) {
            ProcessInfo.writeLog("PRECONDITION : <" + ws.precondition + '>');
            ProcessInfo.writeLog("PRESCRIPT : <" + ws.wsjscript.getPreFunction() + '>');
            ProcessInfo.writeLog("POSTSCRIPT : <" + ws.wsjscript.getPostFunction() + '>');
            ProcessInfo.writeLog("COMPENSATORYSCRIPT : <" + ws.wsjscript.getCompFunction() + '>');
            ProcessInfo.writeLog("PERFSCRIPT : <" + ws.wsjscript.getPerformerFunction() + '>');
            ProcessInfo.writeLog("OVERDUESCRIPT : <" + ws.wsjscript.dueCompileObj + '>');
        }
        ProcessInfo.writeLog("PRECONDITIONCODE : <" + ws.preconditionCode + '>');
        ProcessInfo.writeLog("TYPETAG :  <" + ws.typeTag + '>');
        ProcessInfo.writeLog("INSTRUCTION : <" + ws.instruction + '>');
        ProcessInfo.writeLog("INPUT DATASLOTS : <" + ws.inputSlots.keySet() + '>');
        ProcessInfo.writeLog("OUTPUT DATASLOTS : <" + ws.outputSlots.keySet() + '>');
        ProcessInfo.writeLog("INPUTSLOTSQUERY : <" + ws.inputSlotsQuery + '>');
        ProcessInfo.writeLog("OUTPUTSLOTSQUERY : <" + ws.outputSlotsQuery + '>');
        ProcessInfo.writeLog("LINKS TO WORKSTEP>");
        ProcessInfo.writeLog("INCOMING LINKS : <" + ws.hasIncoming + '>');
        ProcessInfo.writeLog("OUTGOING LINKS : <" + ws.hasOutgoing + '>');
        ProcessInfo.writeLog("MILESTONENAME : <" + ws.milestoneName + '>');
        ProcessInfo.writeLog("PERFORMINGAPP : <" + ws.performingApp + '>');
        ProcessInfo.writeLog("ROLLBACKPOINT : <" + ws.isRollbackPoint() + '>');
        if (ws.isRollbackPoint()) {
            ProcessInfo.writeLog("PRINTING dsCopyNames ......");
            ProcessInfo.printVector(ws.getDSCopyNames());
        }
        ProcessInfo.writeLog("REACTIVATE WORKSTEP NAME : <" + ws.getReactivateWorkStepName() + '>');
        ProcessInfo.writeLog("ISPRECONDREFERGLOBALDS : <" + ws.isPreCondReferGlobalDS() + '>');
        if (ws.timerActions != null) {
            ProcessInfo.writeLog("TIMERACTION LIST : <" + ws.timerActions.toString() + '>');
        }
        if (ws instanceof WFAtomicWS) {
            ProcessInfo.writeLog("THIS IS AN ATOMIC WS");
            ProcessInfo.printAtomicWS((WFAtomicWS)ws);
        }
        ProcessInfo.writeLog("------WORKSTEP COMPLETED-------\n");
    }

    private static void printAtomicWS(WFAtomicWS ws) throws Exception {
        ProcessInfo.writeLog("ROLE : <" + ws.getRole() + '>');
        ProcessInfo.writeLog("PERFORMED BY ALL : <" + ws.getPerformedByAll() + '>');
        ProcessInfo.writeLog("EMAILSUPPORT : <" + ws.EmailSupport + '>');
        ProcessInfo.writeLog("EXCLUDEDPERFORMERXML : <" + ws.getExcludedPerformer() + '>');
        ProcessInfo.writeLog("EXCLUDEDPERFORMER OF WS : <" + ws.getExcludedPerformerOfWS() + '>');
        ProcessInfo.writeLog("EXCLUDED MAPPED DS PERFORMER : <" + ws.getMappedExcludedPerformer() + '>');
        ProcessInfo.writeLog("JNDI EXCLUDED PERFORMER : <" + ws.getJNDIExcludedPerformer() + '>');
        ProcessInfo.writeLog("TRACK WORKITEM PERFORMER : <" + ws.isTrackWorkItemPerformer() + '>');
        ProcessInfo.writeLog("PERFORMING APP TYPE : <" + ws.performingAppType + '>');
        ProcessInfo.writeLog("PERFORMING APP PRIVATE : <" + ws.performingAppPrivate + '>');
        ProcessInfo.writeLog("VOTING ENABLED : <" + ws.isVoteEnabled() + '>');
    }

    private static void printVector(Vector vector) throws Exception {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ProcessInfo.writeLog('<' + String.valueOf(vector.get(i)) + '>');
            }
        }
    }

    private static void printDataSlots(WFProcess pr) throws Exception {
        ProcessInfo.writeLog("PRINTING DATASLOTS ..........");
        for (int i = 0; i < pr.hasDataslots.size(); ++i) {
            ProcessInfo.printDataSlot((WFDataslot)pr.hasDataslots.get(i));
        }
        ProcessInfo.writeLog("PRINTING DATASLOTS COMPLETED ...........\n\n");
    }

    private static void printDataSlot(WFDataslot ds) throws Exception {
        ProcessInfo.writeLog("------DATASLOT START-------");
        ProcessInfo.writeLog("DATASLOT NAME : <" + ds.getName() + '>');
        ProcessInfo.writeLog("TYPE : <" + ds.getType() + '>');
        ProcessInfo.writeLog("VALUE : <" + ds.getValue() + '>');
        ProcessInfo.writeLog("DEFAULTVALUE : <" + ds.getDefaultValue() + '>');
        ProcessInfo.writeLog("SIZE : <" + ds.getSize() + '>');
        ProcessInfo.writeLog("MULTILINE : <" + ds.isMultiLine() + '>');
        ProcessInfo.writeLog("APPENDWITH : <" + ds.getAppendWith() + '>');
        ProcessInfo.writeLog("CHOICES : <" + ds.getChoices() + '>');
        ProcessInfo.writeLog("ISPUBLIC : <" + ds.isPublic + '>');
        ProcessInfo.writeLog("MIME : <" + ds.mime + '>');
        ProcessInfo.writeLog("BIZMANAGE ACCESS : <" + ds.BizManageAccess + '>');
        ProcessInfo.writeLog("BIZSITE ACCESS : <" + ds.BizSiteAccess + '>');
        ProcessInfo.printObjectConst(ds);
        ProcessInfo.writeLog("OBJCONSTRGLOBALDSNAME : <" + ds.objConstrGlobalDSName + '>');
        ProcessInfo.writeLog("OBJCONSTRGLOBALDSINDEX : <" + ds.objConstrGlobalDSindex + '>');
        ProcessInfo.writeLog("JAVA CLASS NAME : <" + ds.javaClassName + '>');
        ProcessInfo.writeLog("OBJSQLMAP : <" + ds.objSqlMap + '>');
        ProcessInfo.writeLog("REQUIRED : <" + ds.required + '>');
        ProcessInfo.writeLog("LABEL : <" + ds.label + '>');
        ProcessInfo.writeLog("GLOBAL : <" + ds.global + '>');
        ProcessInfo.writeLog("SCALE : <" + ds.scale + '>');
        ProcessInfo.writeLog("PRECISION : <" + ds.precision + '>');
        ProcessInfo.writeLog("XML COLLECTION ID : <" + ds.xmlCollectionID + '>');
        ProcessInfo.writeLog("STORAGE FORMAT : <" + ds.storageFormat + '>');
        ProcessInfo.writeLog("------DATASLOT END-------\n");
    }

    private static void printObjectConst(WFDataslot ds) throws Exception {
        ProcessInfo.writeLog("ARGUMENT PARAMETERS");
        if (ds.objConstrArgType != null) {
            for (int i = 0; i < ds.objConstrArgType.length && i < ds.objConstrArgValue.length; ++i) {
                ProcessInfo.writeLog("CLASS  : <" + ds.objConstrArgType[i] + ">  VALUE : <" + ds.objConstrArgValue[i] + '>');
            }
        } else {
            ProcessInfo.writeLog("<NO ARGUMENTS>");
        }
    }

    private static void writeLog(String str) throws IOException {
        BLControl.logger.debug((Object)str);
    }
}

