/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.common.extbo.core.BOConfig;
import com.savvion.common.extbo.core.BOServiceFactory;
import com.savvion.common.extbo.core.IBOService;
import com.savvion.common.extbo.enums.ProviderType;
import com.savvion.common.extbo.util.BOServiceUtil;
import com.savvion.sbm.bizlogic.server.ExtBOConfig;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BLBusinessObjectService {
    private static BLBusinessObjectService instance = null;

    private BLBusinessObjectService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BLBusinessObjectService self() {
        if (null != instance) return instance;
        Class<BLBusinessObjectService> clazz = BLBusinessObjectService.class;
        synchronized (BLBusinessObjectService.class) {
            if (null != instance) return instance;
            instance = new BLBusinessObjectService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Map<String, Object> createOrUpdate(WFDataslot extBODS, Object boObj) {
        if (extBODS.getBOPersistenceConfig().getTransactionLevel().isParent()) {
            BLUtil.self();
            return BLUtil.getServiceLocal().createOrUpdateExtBOParentTrans(extBODS, boObj);
        }
        if (extBODS.getBOPersistenceConfig().getTransactionLevel().isNew()) {
            BLUtil.self();
            return BLUtil.getServiceLocal().createOrUpdateExtBONewTrans(extBODS, boObj);
        }
        BLUtil.self();
        return BLUtil.getServiceLocal().createOrUpdateExtBONoTrans(extBODS, boObj);
    }

    public Object getByPKMap(WFProcessContext pCtx, WFDataslot extBODS, Map<String, Object> pkAttrValueMap) {
        if (BOServiceUtil.self().containsNullOrEmptyValue(pkAttrValueMap)) {
            BLControl.logger.warnKey("BizLogic_ERR_8100", "BLBusinessObjectService.getByPKMap", null, new Object[]{pkAttrValueMap, extBODS.getName(), pCtx.getProcessInstanceID()});
            return null;
        }
        if (extBODS.getBOPersistenceConfig().getTransactionLevel().isParent()) {
            BLUtil.self();
            return BLUtil.getServiceLocal().getExtBOByPKMapParentTrans(extBODS, pkAttrValueMap);
        }
        if (extBODS.getBOPersistenceConfig().getTransactionLevel().isNew()) {
            BLUtil.self();
            return BLUtil.getServiceLocal().getExtBOByPKMapNewTrans(extBODS, pkAttrValueMap);
        }
        BLUtil.self();
        return BLUtil.getServiceLocal().getExtBOByPKMapNoTrans(extBODS, pkAttrValueMap);
    }

    public Object get(WFDataslot extBODS, Object pkObj) {
        if (extBODS.getBOPersistenceConfig().getTransactionLevel().isParent()) {
            BLUtil.self();
            return BLUtil.getServiceLocal().getExtBOParentTrans(extBODS, pkObj);
        }
        if (extBODS.getBOPersistenceConfig().getTransactionLevel().isNew()) {
            BLUtil.self();
            return BLUtil.getServiceLocal().getExtBONewTrans(extBODS, pkObj);
        }
        BLUtil.self();
        return BLUtil.getServiceLocal().getExtBONoTrans(extBODS, pkObj);
    }

    public Map<String, Object> doCreateOrUpdate(WFDataslot extBODS, Object boObj) {
        ExtBOConfig boCfg = extBODS.getBOPersistenceConfig();
        try {
            if (ProviderType.isDXSI((String)boCfg.getProviderType().name())) {
                try {
                    return this.createExtBO(boCfg, boObj);
                }
                catch (Throwable th) {
                    BOServiceFactory.self().getBOService(boCfg.getProviderType()).update((BOConfig)boCfg, boObj);
                    return null;
                }
            }
            Object response = BOServiceFactory.self().getBOService(boCfg.getProviderType()).update((BOConfig)boCfg, boObj);
            Map pkMap = BOServiceUtil.self().getPKValues(response, boCfg.getPKAttributes());
            return pkMap;
        }
        catch (BizLogicException ble) {
            throw ble;
        }
        catch (Throwable thr) {
            throw new BizLogicException("BizLogic_ERR_8089", "BLBusinessObjectService.doCreateOrUpdate", new Object[]{boCfg.getBoClassName(), boCfg.getServiceName()}, thr);
        }
    }

    public Object doGetExtBOByPKMap(WFDataslot extBODS, Map<String, Object> pkAttrValueMap) {
        ExtBOConfig boConfig = extBODS.getBOPersistenceConfig();
        IBOService service = BOServiceFactory.self().getBOService(boConfig.getProviderType());
        return service.getByPKMap((BOConfig)boConfig, pkAttrValueMap);
    }

    public Object doGetExtBO(WFDataslot extBODS, Object pkObj) {
        ExtBOConfig boConfig = extBODS.getBOPersistenceConfig();
        IBOService service = BOServiceFactory.self().getBOService(boConfig.getProviderType());
        return service.get((BOConfig)boConfig, pkObj);
    }

    private Map<String, Object> createExtBO(ExtBOConfig boCfg, Object boObj) {
        Object response = BOServiceFactory.self().getBOService(boCfg.getProviderType()).create((BOConfig)boCfg, boObj);
        return BOServiceUtil.self().getPKValues(response, boCfg.getPKAttributes());
    }

    public static void clean() {
        BOServiceFactory.cleanAll();
    }

    public Map<String, Object> getPKDataSlotValues(WFProcessContext pCtx, String extBODS) {
        HashMap<String, Object> pkDSValues = new HashMap<String, Object>();
        WFDataslot wfDataslot = pCtx.getDataslot(extBODS);
        ExtBOConfig boCtx = wfDataslot.getBOPersistenceConfig();
        Map<String, String> pkDSMap = boCtx.getPkAttributeDSMap();
        HashMap dsValues = WFProcessInstance.self().getSlotValue(pCtx, boCtx.getPkDataslots().toArray(new String[0]), true);
        for (Map.Entry<String, String> pkDS : pkDSMap.entrySet()) {
            Object dsValue = dsValues.get(pkDS.getValue());
            pkDSValues.put(pkDS.getKey(), dsValue);
        }
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_8083", "BLUtil.getPKDataSlotValues", new Object[]{wfDataslot.getName(), ((Object)pkDSValues).toString()});
        }
        return pkDSValues;
    }

    public void populateExtBODataslots(List<String> extBODSList, WFProcessContext pCtx, HashMap dsNameValues) {
        for (String extBODSName : extBODSList) {
            Map<String, Object> pkAttrValueMap = this.getPKDataSlotValues(pCtx, extBODSName);
            WFDataslot extBODS = pCtx.getDataslot(extBODSName);
            Object extBO = this.getByPKMap(pCtx, extBODS, pkAttrValueMap);
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8093", "BLUtil.populateExtBODataslots", new Object[]{pCtx.getProcessInstanceID(), extBODS.getName(), pkAttrValueMap.toString()});
            }
            dsNameValues.put(extBODSName, extBO);
        }
    }
}

