/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging.ejb;

import com.savvion.sbm.bizlogic.messaging.subscriber.MessageManager;
import com.savvion.sbm.bizlogic.server.WFMessageSubscriberInstance;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicAppException;
import com.savvion.sbm.bizlogic.util.MDBAdapter;
import com.savvion.sbm.util.LoggerUtil;
import javax.jms.Message;

public class BLSubscriberWorkStepMDB
extends MDBAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(Message message) {
        long startTime;
        block10: {
            if (BLControl.isServerNotReady()) {
                if (!BLControl.isJMSMessagePersisted()) return;
                if (!WFMessageSubscriberInstance.self().processMessage(message)) {
                    return;
                }
            }
            if (BLControl.util.DEBUG_ENGINE || BLControl.util.DEBUG_MESSAGING) {
                BLControl.logger.debugKey("BizLogic_ERR_1200", "BLSubscriberWorkStepMDB.onMessage() ", new Object[]{message});
            }
            startTime = 0L;
            if (BLControl.util.BENCHMARK) {
                startTime = System.currentTimeMillis();
                LoggerUtil.logSOP((Object)("BLSubscriberWorkStepMDB.onMessage() : startTime : " + startTime));
            }
            String type = message.getStringProperty("TYPE");
            if ("BLSUBSCRIBERWSMDB".equals(type)) break block10;
            if (!BLControl.util.BENCHMARK) return;
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            BLControl.logger.debugKey("BizLogic_ERR_715", new Object[]{"BLSubscriberWorkStepMDB.onMessage()", totalTime});
            return;
        }
        try {
            long piid = message.getLongProperty("PROCESSINSTANCEID");
            long wsid = message.getLongProperty("WORKSTEPID");
            if (this.workstepReady(piid, wsid)) {
                MessageManager.executeTargetInstance(piid, wsid, true);
            }
            if (!BLControl.util.BENCHMARK) return;
        }
        catch (Exception e) {
            try {
                BLControl.logger.error((Object)"BLSubscriberWorkStepMDB.onMessage()", (Throwable)e);
                if (!BLControl.util.BENCHMARK) return;
            }
            catch (Throwable throwable) {
                if (!BLControl.util.BENCHMARK) throw throwable;
                long endTime = System.currentTimeMillis();
                long totalTime = endTime - startTime;
                BLControl.logger.debugKey("BizLogic_ERR_715", new Object[]{"BLSubscriberWorkStepMDB.onMessage()", totalTime});
                throw throwable;
            }
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            BLControl.logger.debugKey("BizLogic_ERR_715", new Object[]{"BLSubscriberWorkStepMDB.onMessage()", totalTime});
            return;
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        BLControl.logger.debugKey("BizLogic_ERR_715", new Object[]{"BLSubscriberWorkStepMDB.onMessage()", totalTime});
        return;
    }

    private boolean workstepReady(long piid, long wsid) throws BizLogicAppException {
        WorkStepInstanceEBLocal wsieb = null;
        int wsState = 0;
        int wsType = 0;
        int dura = 0;
        while ((long)dura < BLUtil.self().getMsgRetryMaxTime()) {
            block10: {
                try {
                    wsieb = BLUtil.self().getWorkStepInstanceEBThrowFinder(piid, wsid);
                    if (wsieb == null) break block10;
                    wsType = wsieb.getType();
                    wsState = wsieb.getState();
                    BLConstants.single();
                    if (wsType == 110) {
                        BLConstants.single();
                        if (wsState == 18) {
                            return true;
                        }
                    }
                    BLConstants.single();
                    if (wsType != 102) {
                        BLConstants.single();
                        if (wsType != 108) break block10;
                    }
                    BLConstants.single();
                    if (wsState == 60) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(BLUtil.self().getMsgRetryInterval());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            dura = (int)((long)dura + BLUtil.self().getMsgRetryInterval());
        }
        LoggerUtil.logSOP((Object)"Resending the message now...");
        WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
        WFMessageSubscriberInstance.self().sendMessage(pCtx, wsid);
        return false;
    }
}

