/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.client.messagehandler;

import com.savvion.sbm.bizlogic.client.messagehandler.ICustomMessageHandler;
import com.savvion.sbm.bizlogic.client.messagehandler.util.HandlerUtil;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.SBMDAOService;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;

public class CreateWorkflowInstance
implements ICustomMessageHandler {
    private HashMap<String, Object> messageObject;

    @Override
    public void execute(Message jmsMsg) {
        if (jmsMsg == null) {
            throw new BizLogicException("BizLogic_ERR_3605");
        }
        String msgName = null;
        String ptName = null;
        try {
            WFProcess pt;
            if (jmsMsg instanceof ObjectMessage) {
                ObjectMessage jmsObjMsg = (ObjectMessage)jmsMsg;
                this.messageObject = (HashMap)jmsObjMsg.getObject();
            } else if (jmsMsg instanceof MapMessage) {
                MapMessage jmsMapMsg = (MapMessage)jmsMsg;
                this.convertMapMessageToMap(jmsMapMsg);
                if (BLControl.util.DEBUG_MESSAGING) {
                    BLControl.logger.debugKey("BizLogic_ERR_3277", "CreateWorkflowInstance.execute()", new Object[]{HandlerUtil.getJMSMessageProperties((Message)jmsMapMsg), HandlerUtil.getJMSMapMessageBody(jmsMapMsg)});
                }
            }
            if (BLControl.util.DEBUG_MESSAGING) {
                BLControl.logger.debugKey("BizLogic_ERR_3278", "CreateWorkflowInstance.execute()", new Object[]{jmsMsg, this.messageObject});
            }
            if ((pt = this.getProcess(msgName = this.getMessageName(jmsMsg), ptName = (String)this.messageObject.get("appName"))) == null) {
                throw new BizLogicException("BizLogic_ERR_3769", "CreateWorkflowInstance.execute", new Object[]{msgName, ptName});
            }
            ptName = pt.getName();
            HashMap<String, Object> attrs = this.getAttributes(ptName);
            HashMap<String, Object> dsValues = this.getDSValues(pt);
            Session session = BLControl.getServerSession();
            WFProcessInstance.self().createInstance(session, attrs, dsValues, true);
        }
        catch (BizLogicException be) {
            throw be;
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_3770", "CreateWorkflowInstance.execute", new Object[]{jmsMsg, msgName, ptName}, th);
        }
    }

    private String getMessageName(Message message) throws JMSException {
        String name = message.getStringProperty("messageName");
        if (name == null || name.trim().length() == 0 || !name.equalsIgnoreCase("CreateWorkflowInstance")) {
            throw new BizLogicException("BizLogic_ERR_3771", "CreateWorkflowInstance.getMessageName", new Object[]{name, "CreateWorkflowInstance"});
        }
        return name;
    }

    private WFProcess getProcess(String msgName, String ptName) {
        WFProcess pt = null;
        pt = ProcessControl.isProcessTemplateExist(ptName) ? ProcessControl.getProcessTemplate(ptName) : ProcessControl.getActiveProcessTemplate(ptName);
        return pt;
    }

    private void convertMapMessageToMap(MapMessage mapMsg) throws JMSException {
        Object obj;
        this.messageObject = new HashMap();
        this.messageObject.put("appName", mapMsg.getString("appName"));
        this.messageObject.put("priority", mapMsg.getString("priority"));
        this.messageObject.put("alias", mapMsg.getString("alias"));
        this.messageObject.put("creator", mapMsg.getString("creator"));
        byte[] dsValueBytes = mapMsg.getBytes("dataslots");
        if (dsValueBytes != null && dsValueBytes.length != 0 && (obj = SBMDAOService.convertToObject((byte[])dsValueBytes)) != null) {
            if (!(obj instanceof HashMap)) {
                throw new BizLogicException("BizLogic_ERR_3772", "CreateWorkflowInstance.convertMapMessageToMap", new Object[]{obj, obj.getClass().getName()});
            }
            this.messageObject.put("dataslots", obj);
        }
    }

    private HashMap<String, Object> getAttributes(String ptName) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        String priority = null;
        try {
            priority = (String)this.messageObject.get("priority");
            if (priority != null && priority.trim().length() != 0) {
                BLConstants.single();
                attrs.put("PRIORITY", priority.toLowerCase());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String prefix = null;
        try {
            prefix = (String)this.messageObject.get("alias");
            if (prefix != null && prefix.trim().length() != 0) {
                BLConstants.single();
                attrs.put("PROCESSINSTANCENAME", prefix);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String creator = null;
        try {
            creator = (String)this.messageObject.get("creator");
            if (creator != null && creator.trim().length() != 0) {
                BLConstants.single();
                attrs.put("CREATOR", creator);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return WFProcessInstance.self().validateAttributesForCreateInstance(ptName, attrs);
    }

    private HashMap<String, Object> getDSValues(WFProcess pt) throws JMSException {
        WFWorkstep startWS = pt.getInitialWorkstep();
        String[] outputSlotNames = startWS.getOutputSlotsKeys();
        if (outputSlotNames == null || outputSlotNames.length == 0) {
            return null;
        }
        HashMap<String, Object> dsValueFromMessage = this.getDSValuesFromMessage();
        if (dsValueFromMessage == null) {
            return null;
        }
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        for (int ix = 0; ix < outputSlotNames.length; ++ix) {
            String outputDS = outputSlotNames[ix];
            if (!dsValueFromMessage.containsKey(outputDS)) continue;
            dsValues.put(outputDS, dsValueFromMessage.get(outputDS));
        }
        HashMap dsWithObjectValues = WFProcess.convertStringToObjectValue(pt, dsValues);
        return dsWithObjectValues;
    }

    private HashMap<String, Object> getDSValuesFromMessage() throws JMSException {
        Object dsMapObject = this.messageObject.get("dataslots");
        if (dsMapObject == null) {
            return null;
        }
        if (!(dsMapObject instanceof Map)) {
            throw new BizLogicException("BizLogic_ERR_3772", "CreateWorkflowInstance.getMessageName", new Object[]{dsMapObject, dsMapObject.getClass().getName()});
        }
        return new HashMap<String, Object>((Map)dsMapObject);
    }
}

