/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.client.messagehandler;

import com.savvion.sbm.alerts.AlertServiceFactory;
import com.savvion.sbm.alerts.intf.AlertService;
import com.savvion.sbm.alerts.svo.RuntimeAlert;
import com.savvion.sbm.bizlogic.client.messagehandler.ICustomMessageHandler;
import com.savvion.sbm.bizlogic.client.messagehandler.util.HandlerUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;

public class AlertHandler
implements ICustomMessageHandler {
    private HashMap<String, Object> alertData;
    private static final String BL_DATASOURCE = "jdbc/BizLogicDB";
    private static AlertService alertService;
    private static Map<String, Class<?>> alertMsgPropNameTypes;

    @Override
    public void execute(Message jmsMsg) {
        if (jmsMsg == null) {
            throw new BizLogicException("BizLogic_ERR_3605");
        }
        String msgName = null;
        String alertName = null;
        try {
            msgName = HandlerUtil.validsteMessageName(jmsMsg, "PUBLISH_ALERT");
            if (jmsMsg instanceof ObjectMessage) {
                ObjectMessage jmsObjMsg = (ObjectMessage)jmsMsg;
                Serializable dataObj = jmsObjMsg.getObject();
                if (!(dataObj instanceof HashMap)) {
                    throw new BizLogicException("BizLogic_ERR_4676", "AlertHandler.execute", new Object[]{jmsMsg, msgName});
                }
                this.alertData = (HashMap)dataObj;
            } else if (jmsMsg instanceof MapMessage) {
                this.alertData = HandlerUtil.constructMapFromMsg((MapMessage)jmsMsg, alertMsgPropNameTypes);
            } else {
                throw new BizLogicException("BizLogic_ERR_4677", "AlertHandler.execute", new Object[]{jmsMsg, msgName});
            }
            alertName = (String)this.alertData.get("ALERT_NAME");
            this.publishAlert();
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_4675", "AlertHandler.execute", new Object[]{jmsMsg, msgName, alertName}, th);
        }
    }

    private void publishAlert() {
        String ctx = "AlertHandler.publishAlert()";
        String alertName = HandlerUtil.getValidStringValue(this.alertData, "ALERT_NAME", ctx);
        String appName = HandlerUtil.getValidStringValue(this.alertData, "APPLICATION_NAME", ctx);
        String msg = HandlerUtil.getValidStringValue(this.alertData, "ALERT_MESSAGE", ctx);
        String severity = HandlerUtil.getValidStringValue(this.alertData, "ALERT_SEVERITY", ctx);
        Object recipientsObj = this.alertData.get("ALERT_RECIPIENT");
        List recipients = null;
        if (recipientsObj instanceof List) {
            recipients = (List)recipientsObj;
        } else if (recipientsObj instanceof byte[]) {
            recipients = HandlerUtil.convertToType(List.class, (byte[])recipientsObj);
        } else {
            throw new BizLogicException("BizLogic_ERR_4678", "AlertHandler.publishAlerts()", new Object[0]);
        }
        if (recipients == null || recipients.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4682", "AlertHandler.publishAlerts()", new Object[]{recipients});
        }
        RuntimeAlert rAlert = HandlerUtil.createRuntimeAlert(alertName, appName, msg, severity);
        alertService.publishExternalAlert(rAlert, recipients);
    }

    private static synchronized void init() {
        alertService = AlertServiceFactory.getInstance((String)"AlertHandler", (String)BL_DATASOURCE);
    }

    static {
        alertMsgPropNameTypes = new HashMap();
        AlertHandler.init();
        alertMsgPropNameTypes.put("ALERT_NAME", String.class);
        alertMsgPropNameTypes.put("APPLICATION_NAME", String.class);
        alertMsgPropNameTypes.put("ALERT_MESSAGE", String.class);
        alertMsgPropNameTypes.put("ALERT_SEVERITY", String.class);
        alertMsgPropNameTypes.put("ALERT_RECIPIENT", byte[].class);
    }
}

