/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.client;

import com.savvion.sbm.bizlogic.client.ProcessCacheService;
import com.savvion.sbm.bizlogic.enums.PTState;
import com.savvion.sbm.distcache.cacheconfig.ConfigGeneratorConstant;
import com.savvion.sbm.distcache.config.CacheConfigService;
import com.savvion.sbm.distcache.core.AppCacheService;
import com.savvion.sbm.distcache.model.ProcessMetaData;
import com.savvion.sbm.distcache.util.AppCacheConstant;
import com.savvion.sbm.distcache.util.AppCacheException;
import com.savvion.sbm.distcache.util.AppCacheUtil;
import com.savvion.sbm.processgraph.model.WorkflowProcess;
import com.savvion.sbm.util.logger.SBMLogger;
import com.tdiinc.BizLogic.Server.PAKClientWorkitem;
import java.util.HashMap;
import java.util.Map;

public class ProcessCacheClient
extends ProcessCacheService {
    private static ProcessCacheClient self = null;

    private ProcessCacheClient(AppCacheService appCacheService, SBMLogger sbmLogger) {
        super(appCacheService, sbmLogger);
    }

    private ProcessCacheClient(SBMLogger sbmLogger) {
        super(sbmLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProcessCacheClient self() {
        if (self != null) return self;
        Class<ProcessCacheClient> clazz = ProcessCacheClient.class;
        synchronized (ProcessCacheClient.class) {
            if (self != null) return self;
            boolean isProcessCacheEnabled = CacheConfigService.self().isCategoryEnabled(ConfigGeneratorConstant.CacheClusterType.EJBWEB, AppCacheConstant.CacheCategory.PROCESSCACHE.getName());
            String methodName = "ProcessCacheClient.createInstance(SBMLogger)";
            if (!isProcessCacheEnabled) throw (AppCacheException)AppCacheUtil.self().getExService().createException("BM_DCAC020", "ProcessCacheClient.self()", new Object[]{"ProcessCacheClient", methodName});
            methodName = "ProcessCacheClient.createInstance(AppCacheService, SBMLogger)";
            throw (AppCacheException)AppCacheUtil.self().getExService().createException("BM_DCAC020", "ProcessCacheClient.self()", new Object[]{"ProcessCacheClient", methodName});
        }
    }

    public static synchronized void createInstance(SBMLogger sbmLogger) {
        if (self == null) {
            self = new ProcessCacheClient(sbmLogger);
        }
    }

    public static synchronized void createInstance(AppCacheService appCacheService, SBMLogger sbmLogger) {
        if (self == null) {
            self = new ProcessCacheClient(appCacheService, sbmLogger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getProcessTemplateName(long ptId) {
        this.validateTemplateId(ptId);
        ProcessMetaData ptMetaData = null;
        if (!this.isProcessCacheCategoryEnabled()) {
            ptMetaData = this.loadProcessMetaData(ptId);
            return ptMetaData.getProcessTemplateName();
        }
        String ptName = super.getProcessTemplateName(ptId);
        if (this.isValidStr(ptName)) return ptName;
        Class<ProcessCacheClient> clazz = ProcessCacheClient.class;
        synchronized (ProcessCacheClient.class) {
            ptName = super.getProcessTemplateName(ptId);
            if (this.isValidStr(ptName)) return ptName;
            ptMetaData = this.loadProcessMetaData(ptId);
            this.addToProcessCache(ptMetaData);
            return ptMetaData.getProcessTemplateName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getProcessTemplateId(String ptName) {
        this.validateTemplateName(ptName);
        ProcessMetaData ptMetaData = null;
        if (!this.isProcessCacheCategoryEnabled()) {
            ptMetaData = this.loadProcessMetaData(ptName);
            return ptMetaData.getProcessTemplateId();
        }
        long ptId = super.getProcessTemplateId(ptName);
        if (this.isValidTemplateId(ptId)) return ptId;
        Class<ProcessCacheClient> clazz = ProcessCacheClient.class;
        synchronized (ProcessCacheClient.class) {
            ptId = super.getProcessTemplateId(ptName);
            if (this.isValidTemplateId(ptId)) return ptId;
            ptMetaData = this.loadProcessMetaData(ptName);
            this.addToProcessCache(ptMetaData);
            return ptMetaData.getProcessTemplateId();
        }
    }

    public PTState getProcessStatus(long ptId) {
        this.validateTemplateId(ptId);
        ProcessMetaData ptMetaData = null;
        if (!this.isProcessCacheCategoryEnabled()) {
            ptMetaData = this.loadProcessMetaData(ptId);
            return ptMetaData.getProcessStatus();
        }
        String ptName = this.getProcessTemplateName(ptId);
        return this.getProcessStatus(ptName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PTState getProcessStatus(String ptName) {
        this.validateTemplateName(ptName);
        ProcessMetaData ptMetaData = null;
        if (!this.isProcessCacheCategoryEnabled()) {
            ptMetaData = this.loadProcessMetaData(ptName);
            return ptMetaData.getProcessStatus();
        }
        this.validateTemplateName(ptName);
        PTState ptState = super.getProcessStatus(ptName);
        if (ptState != null) return ptState;
        Class<ProcessCacheClient> clazz = ProcessCacheClient.class;
        synchronized (ProcessCacheClient.class) {
            ptState = super.getProcessStatus(ptName);
            if (ptState != null) return ptState;
            ptMetaData = this.loadProcessMetaData(ptName);
            this.addToProcessCache(ptMetaData);
            return ptMetaData.getProcessStatus();
        }
    }

    public Map<String, Long> getWorkStepNameId(long ptId) {
        this.validateTemplateId(ptId);
        if (!this.isProcessCacheCategoryEnabled()) {
            return new HashMap<String, Long>();
        }
        String ptName = this.getProcessTemplateName(ptId);
        return this.getWorkStepNameId(ptName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, Long> getWorkStepNameId(String ptName) {
        this.validateTemplateName(ptName);
        if (!this.isProcessCacheCategoryEnabled()) {
            return new HashMap<String, Long>();
        }
        Map wsNameId = super.getWorkStepNameId(ptName);
        if (wsNameId != null) {
            if (!wsNameId.isEmpty()) return wsNameId;
        }
        Class<ProcessCacheClient> clazz = ProcessCacheClient.class;
        synchronized (ProcessCacheClient.class) {
            wsNameId = super.getWorkStepNameId(ptName);
            if (wsNameId != null) {
                if (!wsNameId.isEmpty()) return wsNameId;
            }
            ProcessMetaData ptMetaData = this.loadProcessMetaData(ptName);
            this.addToProcessCache(ptMetaData);
            return ptMetaData.getWorkStepNameId();
        }
    }

    public WorkflowProcess getWorkflowProcess(long ptId) {
        this.validateTemplateId(ptId);
        if (!this.isProcessCacheCategoryEnabled()) {
            return this.loadWorkflowProcess(ptId);
        }
        String ptName = this.getProcessTemplateName(ptId);
        return this.getWorkflowProcess(ptName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public WorkflowProcess getWorkflowProcess(String ptName) {
        this.validateTemplateName(ptName);
        if (!this.isProcessCacheCategoryEnabled()) {
            return this.loadWorkflowProcess(ptName);
        }
        WorkflowProcess processGraph = super.getWorkflowProcess(ptName);
        if (processGraph != null) return processGraph;
        Class<ProcessCacheClient> clazz = ProcessCacheClient.class;
        synchronized (ProcessCacheClient.class) {
            ProcessMetaData ptMetaData = null;
            processGraph = super.getWorkflowProcess(ptName);
            if (processGraph != null) return processGraph;
            if (!this.isProcessMetaDataExist(ptName)) {
                ptMetaData = this.loadProcessMetaData(ptName);
                this.addToProcessCache(ptMetaData);
            } else {
                ptMetaData = this.getProcessMetaData(ptName);
            }
            processGraph = this.loadWorkflowProcess(ptName);
            ptMetaData.setWorkflowProcess((Object)processGraph);
            return (WorkflowProcess)ptMetaData.getWorkflowProcess();
        }
    }

    public boolean isProcessActivated(String ptName) {
        this.validateTemplateName(ptName);
        return PTState.ACTIVATED == this.getProcessStatus(ptName);
    }

    public boolean isProcessActivated(long ptId) {
        this.validateTemplateId(ptId);
        String ptName = this.getProcessTemplateName(ptId);
        return PTState.ACTIVATED == this.getProcessStatus(ptName);
    }

    public boolean isProcessSuspended(String ptName) {
        this.validateTemplateName(ptName);
        return PTState.SUSPENDED == this.getProcessStatus(ptName);
    }

    public boolean isProcessSuspended(long ptId) {
        this.validateTemplateId(ptId);
        String ptName = this.getProcessTemplateName(ptId);
        return PTState.SUSPENDED == this.getProcessStatus(ptName);
    }

    public PAKClientWorkitem getPAKClientWIForStartWS(long ptId) {
        this.validateTemplateId(ptId);
        if (!this.isProcessCacheCategoryEnabled()) {
            return null;
        }
        String ptName = this.getProcessTemplateName(ptId);
        return this.getPAKClientWIForStartWS(ptName);
    }

    public void setPAKClientWIForStartWS(long ptId, PAKClientWorkitem pakClientWorkitem) {
        this.validateTemplateId(ptId);
        if (!this.isProcessCacheCategoryEnabled()) {
            return;
        }
        String ptName = this.getProcessTemplateName(ptId);
        this.setPAKClientWIForStartWS(ptName, pakClientWorkitem);
    }

    public static synchronized void cleanup() {
        self = null;
    }
}

