/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSProcess;
import com.savvion.sbm.bizlogic.storeevent.BSUtil;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.SBMDAOService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Set;

public class BSWorkitem
extends BSProcess {
    private static final String SQL_INSERT_WI = "INSERT INTO WORKITEM ( WORKITEM_ID, PROCESS_TEMPLATE_ID, PROCESS_INSTANCE_ID, WORKSTEP_NAME, PERFORMER, LOOPCOUNTER, STATUS, PRIORITY, ESTIMATED_DURATION, START_TIME, DUE_DATE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_UPDATE_WI = "UPDATE WORKITEM SET PREV_PERFORMER=PERFORMER, PERFORMER=?, STATUS=?, PRIORITY=?, START_TIME=?, DUE_DATE=? WHERE  WORKITEM_ID=?";
    private static final String SQL_UPDATE_WID = "UPDATE WORKITEM SET DUE_DATE = ? WHERE WORKITEM_ID = ?";
    private static final String SQL_UPDATE_WISTATUS = "UPDATE WORKITEM SET STATUS=? WHERE WORKITEM_ID=?";
    private static final String SQL_UPDATE_WIP = "UPDATE WORKITEM SET PRIORITY=? WHERE  WORKITEM_ID=?";
    private static final String SQL_UPDATE_WIPERF = "UPDATE WORKITEM SET PREV_PERFORMER=PERFORMER, PERFORMER=? WHERE WORKITEM_ID=?";
    private static final String SQL_UPDATE_WIENDTIME = "UPDATE WORKITEM SET STATUS=?, END_TIME=?, DURATION=? WHERE  WORKITEM_ID=?";
    private static final String SQL_SELECT_WIREAD = "SELECT IS_READ, READ_DATE FROM WORKITEM WHERE WORKITEM_ID=?";
    private static final String SQL_UPDATE_WITIMECOST = "UPDATE WORKITEM SET PREV_PERFORMER=PERFORMER, STATUS=?, END_TIME=?, DURATION=?, WAIT_TIME=?, WORK_TIME=?, COST=?, PERFORMER=? WHERE WORKITEM_ID=?";
    private static final String SQL_UPDATE_WIREAD = "UPDATE WORKITEM SET READ_DATE=?, IS_READ=? WHERE WORKITEM_ID=?";

    protected static void onCreate(CommonEvent event) throws SQLException {
        Connection conn = null;
        PreparedStatement stmtInsertWI = null;
        try {
            conn = BSControl.util.getBSConnection();
            long ptid = BizLogicEventMap.getProcessTemplateID(event);
            long wiid = BizLogicEventMap.getWorkitemID(event);
            long iid = BizLogicEventMap.getProcessInstanceID(event);
            String workstepname = BizLogicEventMap.getWorkstepName(event);
            String performer = BizLogicEventMap.getPerformer(event);
            int loopcounter = BizLogicEventMap.getLoopcounter(event);
            String status = BizLogicEventMap.getStatusString(event);
            String priority = BizLogicEventMap.getPriority(event);
            String strEstimatedDuration = BizLogicEventMap.getEstimatedDuration(event);
            long estimatedDuration = BSUtil.stringToLong(strEstimatedDuration);
            String str = BizLogicEventMap.getStartTime(event);
            Timestamp st = BSUtil.stringToTimestamp(str);
            str = BizLogicEventMap.getDueDate(event);
            Timestamp et = BSUtil.stringToTimestamp(str);
            stmtInsertWI = conn.prepareStatement(SQL_INSERT_WI);
            stmtInsertWI.setLong(1, wiid);
            stmtInsertWI.setLong(2, ptid);
            stmtInsertWI.setLong(3, iid);
            stmtInsertWI.setString(4, workstepname);
            stmtInsertWI.setString(5, performer);
            stmtInsertWI.setInt(6, loopcounter);
            BSUtil.setValue(stmtInsertWI, 7, status);
            BSUtil.setValue(stmtInsertWI, 8, priority);
            stmtInsertWI.setLong(9, estimatedDuration);
            BSUtil.setValue(stmtInsertWI, 91, 10, st);
            BSUtil.setValue(stmtInsertWI, 91, 11, et);
            stmtInsertWI.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_INSERT_WI, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtInsertWI, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtInsertWI, (Connection)conn);
    }

    protected static void onUpdate(CommonEvent event) throws SQLException {
        block29: {
            Connection conn = null;
            try {
                conn = BSControl.util.getBSConnection();
                long wiid = BizLogicEventMap.getWorkitemID(event);
                String performer = BizLogicEventMap.getPerformer(event);
                String status = BizLogicEventMap.getStatusString(event);
                String priority = BizLogicEventMap.getPriority(event);
                String str = BizLogicEventMap.getStartTime(event);
                boolean ignoreIdueDate = false;
                if (str.trim().compareTo("0") == 0) {
                    ignoreIdueDate = true;
                }
                Timestamp st = BSUtil.stringToTimestamp(str);
                if ("I_PRIORITY".equals(status)) {
                    PreparedStatement pstmtUpdateWIPriority = null;
                    try {
                        pstmtUpdateWIPriority = conn.prepareStatement(SQL_UPDATE_WIP);
                        BSUtil.setValue(pstmtUpdateWIPriority, 1, priority);
                        pstmtUpdateWIPriority.setLong(2, wiid);
                        pstmtUpdateWIPriority.executeUpdate();
                        break block29;
                    }
                    catch (SQLException se) {
                        BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_WIP, se.getMessage()});
                        throw se;
                    }
                    finally {
                        SBMDAOService.clean(null, (Statement)pstmtUpdateWIPriority, null);
                    }
                }
                if ("I_PERFORMER".equals(status)) {
                    PreparedStatement pstmtUpdateWIPerformer = null;
                    try {
                        pstmtUpdateWIPerformer = conn.prepareStatement(SQL_UPDATE_WIPERF);
                        BSUtil.setValue(pstmtUpdateWIPerformer, 1, performer);
                        pstmtUpdateWIPerformer.setLong(2, wiid);
                        pstmtUpdateWIPerformer.executeUpdate();
                        break block29;
                    }
                    catch (SQLException se) {
                        BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_WIPERF, se.getMessage()});
                        throw se;
                    }
                    finally {
                        SBMDAOService.clean(null, (Statement)pstmtUpdateWIPerformer, null);
                    }
                }
                if ("I_DUEDATE".equals(status)) {
                    if (ignoreIdueDate) break block29;
                    str = BizLogicEventMap.getDueDate(event);
                    Timestamp dueDate = BSUtil.stringToTimestamp(str);
                    PreparedStatement pstmtUpdateWIDueDate = null;
                    try {
                        pstmtUpdateWIDueDate = conn.prepareStatement(SQL_UPDATE_WID);
                        pstmtUpdateWIDueDate.setTimestamp(1, dueDate);
                        pstmtUpdateWIDueDate.setLong(2, wiid);
                        pstmtUpdateWIDueDate.executeUpdate();
                        break block29;
                    }
                    catch (SQLException se) {
                        BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_WID, se.getMessage()});
                        throw se;
                    }
                    finally {
                        SBMDAOService.clean(null, (Statement)pstmtUpdateWIDueDate, null);
                    }
                }
                str = BizLogicEventMap.getDueDate(event);
                Timestamp dueDate = BSUtil.stringToTimestamp(str);
                PreparedStatement pstmtUpdateWI = null;
                try {
                    pstmtUpdateWI = conn.prepareStatement(SQL_UPDATE_WI);
                    pstmtUpdateWI.setString(1, performer);
                    BSUtil.setValue(pstmtUpdateWI, 2, status);
                    BSUtil.setValue(pstmtUpdateWI, 3, priority);
                    BSUtil.setValue(pstmtUpdateWI, 91, 4, st);
                    BSUtil.setValue(pstmtUpdateWI, 91, 5, dueDate);
                    pstmtUpdateWI.setLong(6, wiid);
                    pstmtUpdateWI.executeUpdate();
                }
                catch (SQLException se) {
                    BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_WI, se.getMessage()});
                    throw se;
                }
                finally {
                    SBMDAOService.clean(null, (Statement)pstmtUpdateWI, null);
                }
            }
            catch (SQLException se) {
                throw se;
            }
            finally {
                SBMDAOService.clean(null, null, (Connection)conn);
            }
        }
    }

    private static double getWIResourcesCost(CommonEvent event) throws SQLException {
        long ptId = BizLogicEventMap.getProcessTemplateID(event);
        double resourceCost = 0.0;
        HashMap<String, Double> resMap = BSWorkitem.getProcessResourceInfo(ptId);
        if (resMap == null) {
            return 0.0;
        }
        Set<String> resSet = resMap.keySet();
        for (String resName : resSet) {
            Double noUnits = (Double)event.getContext().get("RES_" + resName);
            if (noUnits == null) continue;
            Double unitCost = (double)resMap.get(resName);
            resourceCost += unitCost * noUnits;
        }
        return resourceCost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void onComplete(CommonEvent event) throws SQLException {
        Connection conn = null;
        ResultSet rsSelectWIRead = null;
        PreparedStatement stmtUpdateWITimeCost = null;
        try {
            double resourceCost;
            long workTime;
            long waitTime;
            String performer;
            long duration;
            String status;
            long wiId;
            block13: {
                long readTime;
                long endTime;
                long startTime;
                block12: {
                    PreparedStatement stmtSelectWIRead;
                    block11: {
                        wiId = BizLogicEventMap.getWorkitemID(event);
                        status = BizLogicEventMap.getStatusString(event);
                        String strDuration = BizLogicEventMap.getDuration(event);
                        duration = BSUtil.stringToLong(strDuration);
                        startTime = BSUtil.stringToLong(BizLogicEventMap.getStartTime(event));
                        endTime = BSUtil.stringToLong(BizLogicEventMap.getEndTime(event));
                        performer = BizLogicEventMap.getPerformer(event);
                        waitTime = 0L;
                        readTime = 0L;
                        workTime = 0L;
                        resourceCost = 0.0;
                        conn = BSControl.util.getBSConnection();
                        if (!BSControl.RESOURCE_USAGE) break block12;
                        stmtSelectWIRead = null;
                        try {
                            stmtSelectWIRead = conn.prepareStatement(SQL_SELECT_WIREAD);
                            stmtSelectWIRead.setLong(1, wiId);
                            rsSelectWIRead = stmtSelectWIRead.executeQuery();
                            String isRead = "F";
                            if (!rsSelectWIRead.next()) break block11;
                            isRead = (String)rsSelectWIRead.getObject("IS_READ");
                            if ("F".equals(isRead)) {
                                readTime = startTime;
                                break block11;
                            }
                            Timestamp readTS = rsSelectWIRead.getTimestamp("READ_DATE");
                            readTime = readTS.getTime();
                        }
                        catch (Throwable throwable) {
                            SBMDAOService.clean(rsSelectWIRead, (Statement)stmtSelectWIRead, null);
                            throw throwable;
                        }
                    }
                    SBMDAOService.clean((ResultSet)rsSelectWIRead, (Statement)stmtSelectWIRead, null);
                    waitTime = readTime - startTime;
                    Object processTime = event.getContext().get("RES_ActualProcessingTime");
                    if (processTime != null) {
                        workTime = ((Double)processTime).longValue();
                        if (workTime > endTime - readTime) {
                            workTime = endTime - readTime;
                        }
                    } else {
                        workTime = endTime - readTime;
                    }
                    resourceCost = BSWorkitem.getWIResourcesCost(event);
                    break block13;
                }
                BSControl.logger.debug((Object)"BSWorkitem.onComplete(): As resource usage is disabled, few of resource columns will not be updated.");
                readTime = BizLogicEventMap.getReadTime(event);
                if (readTime > 0L) {
                    waitTime = readTime - startTime;
                    workTime = endTime - readTime;
                }
            }
            String str = BizLogicEventMap.getEndTime(event);
            Timestamp et = BSUtil.stringToTimestamp(str);
            stmtUpdateWITimeCost = conn.prepareStatement(SQL_UPDATE_WITIMECOST);
            stmtUpdateWITimeCost.setString(1, status);
            BSUtil.setValue(stmtUpdateWITimeCost, 91, 2, et);
            stmtUpdateWITimeCost.setLong(3, duration);
            stmtUpdateWITimeCost.setLong(4, waitTime);
            stmtUpdateWITimeCost.setLong(5, workTime);
            stmtUpdateWITimeCost.setDouble(6, resourceCost);
            stmtUpdateWITimeCost.setString(7, performer);
            stmtUpdateWITimeCost.setLong(8, wiId);
            stmtUpdateWITimeCost.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_WITIMECOST, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdateWITimeCost, conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdateWITimeCost, (Connection)conn);
    }

    protected static void onRead(CommonEvent event) throws SQLException {
        long wiid = BizLogicEventMap.getWorkitemID(event);
        Connection conn = null;
        PreparedStatement stmtUpdateWIRead = null;
        try {
            conn = BSControl.util.getBSConnection();
            Timestamp rd = new Timestamp(BizLogicEventMap.getReadTime(event));
            stmtUpdateWIRead = conn.prepareStatement(SQL_UPDATE_WIREAD);
            BSUtil.setValue(stmtUpdateWIRead, 91, 1, rd);
            stmtUpdateWIRead.setObject(2, "T");
            stmtUpdateWIRead.setLong(3, wiid);
            stmtUpdateWIRead.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_WIREAD, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdateWIRead, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdateWIRead, (Connection)conn);
    }

    protected static void onStatusChange(CommonEvent event) throws SQLException {
        long wiid = BizLogicEventMap.getWorkitemID(event);
        String status = BizLogicEventMap.getStatusString(event);
        Connection conn = null;
        PreparedStatement stmtUpdateWIS = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtUpdateWIS = conn.prepareStatement(SQL_UPDATE_WISTATUS);
            BSUtil.setValue(stmtUpdateWIS, 1, status);
            stmtUpdateWIS.setLong(2, wiid);
            stmtUpdateWIS.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_WISTATUS, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdateWIS, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdateWIS, (Connection)conn);
    }

    protected static void onTerminateSkipRemove(CommonEvent event) throws SQLException {
        long wiid = BizLogicEventMap.getWorkitemID(event);
        String status = BizLogicEventMap.getStatusString(event);
        String str = BizLogicEventMap.getEndTime(event);
        Timestamp et = BSUtil.stringToTimestamp(str);
        String strDuration = BizLogicEventMap.getDuration(event);
        long duration = BSUtil.stringToLong(strDuration);
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = BSControl.util.getBSConnection();
            pstmt = conn.prepareStatement(SQL_UPDATE_WIENDTIME);
            BSUtil.setValue(pstmt, 1, status);
            BSUtil.setValue(pstmt, 91, 2, et);
            pstmt.setLong(3, duration);
            pstmt.setLong(4, wiid);
            pstmt.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_WIENDTIME, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmt, (Connection)conn);
    }

    public static void printSQLStatements() {
        BSControl.logger.debug((Object)"BSWorkitem.printSQLStatements:");
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_INSERT_WI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WITIMECOST});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_SELECT_WIREAD});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WIREAD});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WIENDTIME});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WIP});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WID});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WISTATUS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WIPERF});
    }
}

