/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.storeevent.BSCache;
import com.savvion.sbm.bizlogic.storeevent.BSDataslot;
import com.savvion.sbm.bizlogic.storeevent.BSProcess;
import com.savvion.sbm.bizlogic.storeevent.BSProcessInstance;
import com.savvion.sbm.bizlogic.storeevent.BSProcessTemplate;
import com.savvion.sbm.bizlogic.storeevent.BSUtil;
import com.savvion.sbm.bizlogic.storeevent.BSWorkitem;
import com.savvion.sbm.bizlogic.storeevent.BSWorkstepInstance;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.bizlogic.storeevent.BizStoreException;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.eventreader.EventReader;
import com.savvion.sbm.replication.ReplicationManager;
import com.savvion.sbm.replication.service.IServiceHandler;
import com.savvion.sbm.replication.service.ServiceRegister;
import com.savvion.sbm.util.BMJMSService;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.MessageFactory;
import com.savvion.sbm.util.ResourceUtil;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMDAOService;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceDAO;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.TransactionService;
import com.savvion.sbm.util.logger.LoggerManager;
import com.savvion.sbm.util.logger.SBMLogger;
import java.io.IOException;
import java.rmi.dgc.VMID;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.transaction.UserTransaction;

public class BSControl {
    public static final String DBTYPE_ORACLE = "oracle";
    public static final String DBTYPE_MSSQLSERVER = "mssqlserver";
    public static final String DBTYPE_SYBASE = "sybase";
    public static final String DBTYPE_IBMDB2 = "ibmdb2";
    public static final String DBTYPE_OPENEDGE = "openedge";
    public static final String DBTYPE_POSTGRESQL = "postgresql";
    public static boolean PRINT_STACK = true;
    public static boolean DEBUG_ENGINE = false;
    public static boolean PRINT_EVENT = false;
    public static boolean DEBUG_SQL = false;
    public static boolean SEND_EMAIL = false;
    public static boolean RESOURCE_USAGE = false;
    private static final String SQL_UPD_LAST_EVENTID = "UPDATE BIZSTOREEVENTCOUNTER SET LAST_EVENT_ID = ?, LAST_UPDATE_DATE = ?";
    private static final String SQL_MAX_EVENTID = "SELECT max(EVENT_ID) from BIZEVENT";
    private static PreparedStatement stmt_maxEventID;
    private static PreparedStatement stmt_updLastEventIDForSyncBS;
    private static int batchsize;
    private static long sleeptimeWhenNoEvents;
    private static long onExceptionSleeptime;
    private static long sleeptimeWhenEvents;
    private static int transsize;
    private static boolean shuttingdown;
    private static boolean running;
    private static boolean initialized;
    public static SBMLogger logger;
    public static final String BS_CONF_FILE = "bizstore.conf";
    public static final String MESSAGE_FILE = "BSMessages";
    public static final String BS_LOG_CONF = "sbmlog.conf";
    private static final String EVENT_HANDLER = "com.savvion.sbm.bizlogic.storeevent.BSEventHandler";
    private static final String EVENT_TABLE = "BIZEVENT";
    private static final String COUNTER_TABLE = "BIZSTOREEVENTCOUNTER";
    private static final String BLBIZSTOREMDB = "BLBIZSTOREMDB";
    public static BSUtil util;
    public static CommonEvent eventObj;
    public static MessageFactory msgFactory;
    public static final int SERVER_NOT_RUNNING = 0;
    public static final int SERVER_RUNNING = 1;
    public static final String STARTED_MSG = "BizStore is started at node: ";
    public static final String STOPPED_MSG = "BizStore is stopped at node: ";
    public static final String ALREADY_STARTED_MSG = "BizStore is already started at node: ";
    public static final String ALREADY_STOPPED_MSG = "BizStore is already stopped at node: ";
    private static boolean isSyncBizStore;
    private static long counterUpdateTime;
    private static long SYNC_UPDATECOUNTER_INTERVAL;
    private static long MINUPDATEINTERVAL;
    private static long MAXUPDATEINTERVAL;
    private static EventReader reader;
    private static int clusterBatchSize;
    private static int clusterTransSize;
    private static int maxMissingEventRetries;
    private static final int MAX_MISSING_EVT_RETRIES = 50;
    private static long missingEventDelayAllowed;
    private static boolean missingEventInsertEnabled;
    private static int maxNoEvtRetries;
    private static boolean useURForReadingEvents;
    private static boolean eventProcessingByQueue;
    private static long sleepWhenBizStoreNotStarted;
    private static boolean currentlyProcessingEvents;
    private static int jmsInitMaxRetryCount;
    private static int jmsInitRetryInterval;
    public static final String SERVICE_NAME = "BizStore Service";
    private static final String PUBLISH_MESSAGE_MSG = "Publishing BizStore Message for processing next batch of events with unique Id: <{0}> and persisting the same in SVC_BIZSTORE table for validation. BizStore was started by <{1}>";
    private static final String PUBLISH_MESSAGE_ERROR_MSG = "Exception during saving and sending BizStore message using savvionMsgId <{0}>";

    public static boolean isSyncBizStore() {
        return isSyncBizStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        if (BSControl.isServerRunning()) {
            SBMUtil.logDuplicateMessage((SBMLogger)logger, (String)"BizStore_MSG_1011", (String)SERVICE_NAME);
            return;
        }
        if (!ReplicationManager.self().isPrimaryDatabase()) {
            BLControl.logger.warnKey("BizLogic_ERR_1014", new Object[]{SERVICE_NAME});
            return;
        }
        Class<BSControl> clazz = BSControl.class;
        synchronized (BSControl.class) {
            if (BSControl.isServerRunning()) {
                SBMUtil.logDuplicateMessage((SBMLogger)logger, (String)"BizStore_MSG_1011", (String)SERVICE_NAME);
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                SBMControl.init();
                SBMConstants.self().getClass();
                SBMControl.register((String)"BizStore");
                BSControl.init(false);
                shuttingdown = false;
            }
            catch (Throwable th) {
                throw new BizStoreException("BizStore_MSG_1509", "BSControl.start()", th);
            }
            try {
                if (initialized) {
                    if (BSControl.eventProcessingByQueueEnabled()) {
                        reader.initialize();
                    } else {
                        reader.start();
                    }
                }
            }
            catch (Throwable th) {
                logger.errorKey("BizStore_MSG_1514", null, th);
            }
            if (!BSControl.eventProcessingByQueueEnabled()) {
                BSControl.cleanup();
            }
            return;
        }
    }

    public static synchronized void shutdown() {
        if (!BSControl.isServerRunning()) {
            if (!ServiceLocator.self().isCluster()) {
                LoggerUtil.logSEP((Object)(ALREADY_STOPPED_MSG + SBMUtil.getHost() + "!"));
            }
            if (logger != null) {
                logger.info((Object)"BSControl.shutdown():Duplicate stop request is rejected.");
            }
            return;
        }
        LoggerUtil.logSOP((Object)"BizStore shutting down...");
        logger.info((Object)"####################################");
        logger.infoKey("BizStore_MSG_518", null);
        logger.info((Object)"####################################");
        shuttingdown = true;
        if (!BSControl.eventProcessingByQueueEnabled()) {
            reader.stop();
        }
        if (BSControl.eventProcessingByQueueEnabled() && !BSControl.isCurrentlyProcessingEvents()) {
            BSControl.cleanup();
        }
    }

    public static void cleanup() {
        running = false;
        shuttingdown = false;
        if (isSyncBizStore) {
            BSControl.updateSyncBSEventCounter();
        }
        initialized = false;
        isSyncBizStore = false;
        BSUtil.close();
        util = null;
        BSProcess.ptCache.close();
        BSProcess.ptCache = null;
        eventObj = null;
        maxMissingEventRetries = 5;
        maxNoEvtRetries = 10;
        reader.cleanup();
        reader = null;
        LoggerUtil.logSOP((Object)"BizStore stopped.");
        logger.info((Object)"####################################");
        logger.infoKey("BizStore_MSG_515", new Object[]{new Date()});
        logger.info((Object)"####################################");
        logger = null;
        msgFactory = null;
        SBMConstants.self().getClass();
        SBMControl.unregister((String)"BizStore");
    }

    private static boolean setBatchSize(int bsize) {
        Double val = null;
        if (ServiceLocator.self().isCluster()) {
            val = util.validateNumberValue(30.0, 750.0, bsize, clusterBatchSize, "bizstore.event.batch.size");
            clusterBatchSize = val.intValue();
        } else {
            val = util.validateNumberValue(30.0, 750.0, bsize, batchsize, "bizstore.event.batch.size");
            batchsize = val.intValue();
        }
        return true;
    }

    private static void setSleepTimeWhenNoEvents(String stime) {
        long tempValue = SBMUtil.getLongValue((String)stime, (long)sleeptimeWhenNoEvents);
        try {
            Double val = util.validateNumberValue(5000.0, 60000.0, tempValue, sleeptimeWhenNoEvents, "bizstore.sleep.noevents");
            sleeptimeWhenNoEvents = val.longValue();
        }
        catch (NumberFormatException doNothing) {
            logger.warnKey("BizStore_MSG_1007", new Object[]{stime, "bizstore.sleep.noevents", sleeptimeWhenNoEvents});
        }
    }

    private static boolean setTransactionSize(boolean isRefresh, int tsize) {
        if (ServiceLocator.self().isCluster() && isRefresh) {
            logger.warnKey("BizStore_MSG_1009");
            return true;
        }
        return BSControl.setTransactionSize(tsize);
    }

    private static boolean setTransactionSize(int tsize) {
        Double val = null;
        if (ServiceLocator.self().isCluster()) {
            val = util.validateNumberValue(30.0, 750.0, tsize, clusterTransSize, "bizstore.events.transaction.size");
            clusterTransSize = val.intValue();
        } else {
            val = util.validateNumberValue(1.0, 50.0, tsize, transsize, "bizstore.events.transaction.size");
            transsize = val.intValue();
        }
        return true;
    }

    private static void setSleepTimeWhenEvents(String stimeEvents) {
        long tempValue = SBMUtil.getLongValue((String)stimeEvents, (long)sleeptimeWhenEvents);
        try {
            Double val = util.validateNumberValue(0.0, 5000.0, tempValue, sleeptimeWhenEvents, "bizstore.sleep.moreevents");
            sleeptimeWhenEvents = val.longValue();
        }
        catch (NumberFormatException doNothing) {
            logger.warnKey("BizStore_MSG_1007", new Object[]{stimeEvents, "bizstore.sleep.moreevents", sleeptimeWhenEvents});
        }
    }

    private static void setMissingEvtRetryMaxCount(int count) {
        if (count >= 0) {
            if (count > 50) {
                logger.warnKey("BizStore_MSG_1006", new Object[]{count, 50});
            }
            maxMissingEventRetries = count;
        }
    }

    private static void setMissingEventDelayAllowed(long delayTime) {
        if (delayTime > 0L) {
            missingEventDelayAllowed = delayTime * 1000L;
        } else {
            missingEventDelayAllowed = 600000L;
            logger.warnKey("BizStore_MSG_1010", new Object[]{delayTime, missingEventDelayAllowed});
        }
    }

    public static long getMissingEventDelayAllowed() {
        return missingEventDelayAllowed;
    }

    public static boolean isMissingEventInsertEnabled() {
        return missingEventInsertEnabled;
    }

    public static int getMissingEvtRetryMaxCount() {
        return maxMissingEventRetries;
    }

    private static void setNoEvtRetryMaxCount(int count) {
        if (count >= 0) {
            maxNoEvtRetries = count;
        }
    }

    public static int getNoEvtRetryMaxCount() {
        return maxNoEvtRetries;
    }

    public static boolean isServerRunning() {
        return running;
    }

    public static boolean isServerShuttingDown() {
        return shuttingdown;
    }

    public static void refresh() {
        try {
            if (!BSControl.isServerRunning()) {
                throw new BizStoreException("BizStore_MSG_1530", "BSControl.refresh", null);
            }
            BSControl.readProperties(true);
            logger.reload();
            BSControl.setLogLevel();
            BSControl.refreshReader();
            LoggerUtil.logSOP((Object)"BizStore refresh done.");
            logger.infoKey("BizStore_MSG_524", new Object[]{new Date()});
        }
        catch (BizStoreException bse) {
            throw bse;
        }
        catch (Throwable th) {
            throw new BizStoreException("BizStore_MSG_1510", "BSControl.refresh", new Object[]{new Date()}, th);
        }
    }

    private static synchronized void initLogger() {
        try {
            if (null == logger || null == msgFactory) {
                LoggerManager loggerManager = LoggerManager.self();
                SBMConstants.self().getClass();
                logger = loggerManager.createLogger("BizStore", BS_LOG_CONF, MESSAGE_FILE, BSControl.class.getClassLoader());
                msgFactory = logger.getMessageFactory();
            }
        }
        catch (Throwable th) {
            throw new RuntimeException("BSControl.initLogger()", th);
        }
    }

    private static synchronized void setLogLevel() {
        if (DEBUG_ENGINE || DEBUG_SQL) {
            logger.setLevel(1);
        }
    }

    private static void readProperties(boolean isRefresh) {
        Properties p = new Properties();
        String propStr = null;
        try {
            String bizStoreFile = BS_CONF_FILE;
            p = ResourceUtil.getPropertyObject((String)(SBMControl.util.ABSOLUTE_CONF_PATH + bizStoreFile));
            if (!isRefresh) {
                propStr = p.getProperty("bizstore.event.batch.size");
                try {
                    BSControl.setBatchSize(SBMUtil.getIntValue((String)propStr));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            propStr = p.getProperty("bizstore.sleep.noevents");
            BSControl.setSleepTimeWhenNoEvents(propStr);
            propStr = p.getProperty("bizstore.sleep.moreevents");
            BSControl.setSleepTimeWhenEvents(propStr);
            propStr = p.getProperty("bizstore.events.transaction.size");
            BSControl.setTransactionSize(isRefresh, SBMUtil.getIntValue((String)propStr, (int)transsize));
            propStr = p.getProperty("bizstore.debug.engine");
            DEBUG_ENGINE = SBMUtil.getBooleanValue((String)propStr, (boolean)DEBUG_ENGINE);
            propStr = p.getProperty("bizstore.printEvent");
            PRINT_EVENT = SBMUtil.getBooleanValue((String)propStr, (boolean)PRINT_EVENT);
            propStr = p.getProperty("bizstore.printStack", "true");
            PRINT_STACK = SBMUtil.getBooleanValue((String)propStr, (boolean)PRINT_STACK);
            propStr = p.getProperty("bizstore.debug.sql");
            DEBUG_SQL = SBMUtil.getBooleanValue((String)propStr, (boolean)DEBUG_SQL);
            propStr = p.getProperty("bizstore.email.notification");
            SEND_EMAIL = SBMUtil.getBooleanValue((String)propStr, (boolean)SEND_EMAIL);
            propStr = p.getProperty("bizstore.resource.usage", "false");
            RESOURCE_USAGE = SBMUtil.getBooleanValue((String)propStr, (boolean)RESOURCE_USAGE);
            propStr = p.getProperty("bizstore.missingevents.retry.maxcount");
            BSControl.setMissingEvtRetryMaxCount(SBMUtil.getIntValue((String)propStr, (int)maxMissingEventRetries));
            propStr = p.getProperty("bizstore.missingevents.delay.allowed");
            BSControl.setMissingEventDelayAllowed(SBMUtil.getLongValue((String)propStr, (long)missingEventDelayAllowed));
            propStr = p.getProperty("bizstore.missingevents.insert");
            missingEventInsertEnabled = SBMUtil.getBooleanValue((String)propStr, (boolean)missingEventInsertEnabled);
            propStr = p.getProperty("bizstore.noevents.retry.maxcount");
            BSControl.setNoEvtRetryMaxCount(SBMUtil.getIntValue((String)propStr, (int)maxNoEvtRetries));
            propStr = p.getProperty("bizstore.sleep.onexception");
            onExceptionSleeptime = SBMUtil.getLongValue((String)propStr, (long)onExceptionSleeptime);
            if (ServiceLocator.self().isDB2() && ServiceLocator.self().isWebsphere()) {
                propStr = p.getProperty("bizstore.events.read.withur");
                useURForReadingEvents = SBMUtil.getBooleanValue((String)propStr, (boolean)useURForReadingEvents);
            }
            propStr = p.getProperty("bizstore.eventprocessing.queue.enable");
            eventProcessingByQueue = SBMUtil.getBooleanValue((String)propStr, (boolean)eventProcessingByQueue);
            propStr = p.getProperty("bizstore.sleep.bizstore.notstarted");
            sleepWhenBizStoreNotStarted = SBMUtil.getLongValue((String)propStr, (long)sleepWhenBizStoreNotStarted);
            propStr = p.getProperty("bizstore.server.jms.init.max.retry.count");
            jmsInitMaxRetryCount = SBMUtil.getIntValue((String)propStr, (int)jmsInitMaxRetryCount);
            propStr = p.getProperty("bizstore.server.jms.init.retry.interval");
            jmsInitRetryInterval = SBMUtil.getIntValue((String)propStr, (int)jmsInitRetryInterval);
            if (!isRefresh) {
                logger.info((Object)("bizstore.event.batch.size = " + batchsize));
            }
            logger.info((Object)("bizstore.sleep.noevents = " + sleeptimeWhenNoEvents));
            logger.info((Object)("bizstore.sleep.moreevents = " + sleeptimeWhenEvents));
            logger.info((Object)("bizstore.sleep.onexception = " + onExceptionSleeptime));
            logger.info((Object)("bizstore.events.transaction.size = " + transsize));
            logger.info((Object)("bizstore.debug.engine = " + DEBUG_ENGINE));
            logger.info((Object)("bizstore.printEvent = " + PRINT_EVENT));
            logger.info((Object)("bizstore.printStack = " + PRINT_STACK));
            logger.info((Object)("bizstore.debug.sql = " + DEBUG_SQL));
            logger.info((Object)("bizstore.email.notification = " + SEND_EMAIL));
            logger.info((Object)("bizstore.resource.usage = " + RESOURCE_USAGE));
            logger.info((Object)("bizstore.missingevents.retry.maxcount = " + maxMissingEventRetries));
            logger.info((Object)("bizstore.noevents.retry.maxcount = " + maxNoEvtRetries));
            logger.info((Object)("bizstore.missingevents.delay.allowed = " + missingEventDelayAllowed));
            logger.info((Object)("bizstore.missingevents.insert = " + missingEventInsertEnabled));
            if (ServiceLocator.self().isDB2() && ServiceLocator.self().isWebsphere()) {
                logger.info((Object)("bizstore.events.read.withur = " + useURForReadingEvents));
            }
            logger.info((Object)("bizstore.eventprocessing.queue.enable = " + eventProcessingByQueue));
            logger.info((Object)("bizstore.sleep.bizstore.notstarted = " + sleepWhenBizStoreNotStarted));
            logger.info((Object)("bizstore.server.jms.init.max.retry.count = " + jmsInitMaxRetryCount));
            logger.info((Object)("bizstore.server.jms.init.retry.interval = " + jmsInitRetryInterval));
            if (isSyncBizStore) {
                BSControl.readSyncProperties(p, isRefresh);
            } else {
                BSControl.readAsyncProperties(isRefresh);
            }
        }
        catch (Throwable th) {
            throw new BizStoreException("BizStore_MSG_1516", "BSControl.readProperties()", th);
        }
    }

    private static void readAsyncProperties(boolean isRefresh) throws IOException {
        if (isRefresh) {
            return;
        }
        Properties dbProp = null;
        String propStr = null;
        StringBuilder stringBuilder = new StringBuilder().append(SBMControl.util.ABSOLUTE_CONF_PATH);
        SBMConstants.self().getClass();
        dbProp = ResourceUtil.getPropertyObject((String)stringBuilder.append("sbmdb.properties").toString());
        propStr = dbProp.getProperty("sbm.bizstore.datasource.name");
        BSControl.util.DS_JNDI_NAME = SBMUtil.getStringValue((String)propStr, (String)BSControl.util.DS_JNDI_NAME);
        logger.info((Object)("sbm.bizstore.datasource.name = " + BSControl.util.DS_JNDI_NAME));
    }

    private static void readSyncProperties(Properties p, boolean isRefresh) throws Exception {
        String propStr = null;
        propStr = p.getProperty("bizstore.sync.updatecounter.interval");
        long tempValue = SBMUtil.getLongValue((String)propStr, (long)SYNC_UPDATECOUNTER_INTERVAL);
        Double val = util.validateNumberValue(MINUPDATEINTERVAL, MAXUPDATEINTERVAL, tempValue, SYNC_UPDATECOUNTER_INTERVAL, "bizstore.sync.updatecounter.interval");
        SYNC_UPDATECOUNTER_INTERVAL = val.longValue();
        logger.info((Object)("bizstore.sync.updatecounter.interval (in minutes) = " + SYNC_UPDATECOUNTER_INTERVAL));
        if (!isRefresh) {
            Properties dbProp = null;
            StringBuilder stringBuilder = new StringBuilder().append(SBMControl.util.ABSOLUTE_CONF_PATH);
            SBMConstants.self().getClass();
            dbProp = ResourceUtil.getPropertyObject((String)stringBuilder.append("sbmdb.properties").toString());
            propStr = dbProp.getProperty("sbm.bizlogic.datasource.name");
            if (SBMUtil.isValidProperty((String)propStr)) {
                BSControl.util.SYNC_DS_JNDI_NAME = propStr;
            }
            logger.info((Object)("sbm.bizlogic.datasource.name = " + BSControl.util.SYNC_DS_JNDI_NAME));
        }
    }

    private static void initReader() {
        try {
            HashMap<String, Object> evtReaderProp = new HashMap<String, Object>();
            if (ServiceLocator.self().isCluster()) {
                evtReaderProp.put("BATCHSIZE", clusterBatchSize);
                evtReaderProp.put("TRANSACTIONSIZE", clusterTransSize);
                logger.infoKey("BizStore_MSG_522", new Object[]{clusterBatchSize, clusterTransSize});
            } else {
                evtReaderProp.put("BATCHSIZE", batchsize);
                evtReaderProp.put("TRANSACTIONSIZE", transsize);
            }
            evtReaderProp.put("SLEEPTIME", sleeptimeWhenNoEvents);
            evtReaderProp.put("SERVICE", "BIZSTORE");
            evtReaderProp.put("NO_EVENT_RETRIES", maxNoEvtRetries);
            if (SEND_EMAIL) {
                evtReaderProp.put("ADMIN_EMAIL_ID", SBMControl.util.getAdminEmailId());
            }
            evtReaderProp.put("SLEEPTIME_WHEN_EVENTS", sleeptimeWhenEvents);
            evtReaderProp.put("SLEEPTIME_ONEXCEPTION", onExceptionSleeptime);
            Class cls = SBMUtil.load((String)EVENT_HANDLER, (ClassLoader)BSControl.class.getClassLoader());
            Object clsObj = cls.newInstance();
            Vector senderList = new Vector();
            senderList.add(clsObj);
            reader = new EventReader(BSUtil.self().DS_JNDI_NAME, EVENT_TABLE, COUNTER_TABLE, senderList, (Object)logger, evtReaderProp);
            if (ServiceLocator.self().isDB2() && ServiceLocator.self().isWebsphere()) {
                reader.setUseURForReadingEvents(useURForReadingEvents);
            }
        }
        catch (Throwable th) {
            throw new BizStoreException("BizStore_MSG_1528", "BSControl.initReader()", th);
        }
    }

    private static void refreshReader() {
        HashMap<String, Object> evtReaderProp = new HashMap<String, Object>();
        evtReaderProp.put("SLEEPTIME", sleeptimeWhenNoEvents);
        evtReaderProp.put("SLEEPTIME_WHEN_EVENTS", sleeptimeWhenEvents);
        if (SEND_EMAIL) {
            evtReaderProp.put("ADMIN_EMAIL_ID", new String(SBMControl.util.getAdminEmailId()));
        }
        reader.refresh(evtReaderProp);
        if (ServiceLocator.self().isDB2() && ServiceLocator.self().isWebsphere()) {
            reader.setUseURForReadingEvents(useURForReadingEvents);
        }
    }

    public static void init(boolean isSyncBS) {
        isSyncBizStore = isSyncBS;
        BizLogicEventMap.initialize();
        BSControl.initLogger();
        util = BSUtil.self();
        BSControl.readProperties(false);
        BSControl.setLogLevel();
        eventObj = new CommonEvent();
        BSProcess.ptCache = BSCache.self();
        try {
            BSProcess.loadCache();
        }
        catch (Throwable th) {
            throw new BizStoreException("BizStore_MSG_1521", "BSControl.init()", th);
        }
        BSControl.initReader();
        if (DEBUG_SQL) {
            BSControl.printAllSQLStatements();
        }
        initialized = true;
        running = true;
        Date currentTime = new Date();
        counterUpdateTime = currentTime.getTime();
        logger.info((Object)"###########################################################");
        if (isSyncBizStore) {
            LoggerUtil.logSOP((Object)"BizStore started in synchronous mode.");
            logger.infoKey("BizStore_MSG_521", new Object[]{currentTime});
        } else if (ServiceLocator.self().isCluster()) {
            LoggerUtil.logSOP((Object)"BizStore started in cluster mode.");
            logger.infoKey("BizStore_MSG_523", new Object[]{currentTime});
        } else {
            LoggerUtil.logSOP((Object)"BizStore started.");
            logger.infoKey("BizStore_MSG_516", new Object[]{currentTime});
        }
        logger.info((Object)"###########################################################");
    }

    public static final synchronized void processBLEvent(String type, String value, long date, Map<String, Object> eventContext) {
        eventObj.setEventAttribs(type, value, date, eventContext);
        BSProcess.storeBizLogicData(eventObj);
        if (date > counterUpdateTime) {
            BSControl.updateSyncBSEventCounter();
            counterUpdateTime += SYNC_UPDATECOUNTER_INTERVAL * 60L * 1000L;
        }
    }

    public static final void updateSyncBSEventCounter() {
        ResultSet rs = null;
        java.sql.Connection conn = null;
        try {
            long maxEventID = 0L;
            conn = util.getBSConnection();
            stmt_maxEventID = conn.prepareStatement(SQL_MAX_EVENTID);
            rs = stmt_maxEventID.executeQuery();
            while (rs.next()) {
                maxEventID = rs.getLong(1);
            }
            stmt_updLastEventIDForSyncBS = conn.prepareStatement(SQL_UPD_LAST_EVENTID);
            stmt_updLastEventIDForSyncBS.setLong(1, maxEventID);
            BSUtil.setValue(stmt_updLastEventIDForSyncBS, 91, 2, new Timestamp(new Date().getTime()));
            stmt_updLastEventIDForSyncBS.executeUpdate();
        }
        catch (SQLException se) {
            try {
                throw new BizStoreException("BizStore_MSG_1529", new Object[]{se.getMessage()}, (Throwable)se);
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(rs, (Statement)stmt_maxEventID, (java.sql.Connection)conn);
                SBMDAOService.clean(null, (Statement)stmt_updLastEventIDForSyncBS, null);
                throw throwable;
            }
        }
        SBMDAOService.clean((ResultSet)rs, (Statement)stmt_maxEventID, (java.sql.Connection)conn);
        SBMDAOService.clean(null, (Statement)stmt_updLastEventIDForSyncBS, null);
    }

    public static void printAllSQLStatements() {
        BSControl.printSQLStatements();
        BSProcess.printSQLStatements();
        BSDataslot.printSQLStatements();
        BSProcessInstance.printSQLStatements();
        BSProcessTemplate.printSQLStatements();
        BSWorkitem.printSQLStatements();
        BSWorkstepInstance.printSQLStatements();
    }

    public static void printSQLStatements() {
        logger.debug((Object)"BSControl.printSQLStatements:");
        logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPD_LAST_EVENTID});
        logger.debugKey("BizStore_MSG_002", new Object[]{SQL_MAX_EVENTID});
    }

    public static final int getState() {
        if (BSControl.isServerRunning()) {
            return 1;
        }
        return 0;
    }

    public static String getStatusMsg() {
        if (BSControl.getState() == 1) {
            return STARTED_MSG + SBMUtil.getHost();
        }
        return STOPPED_MSG + SBMUtil.getHost();
    }

    public static void doStart() {
        BSControl.doStart(null);
    }

    public static void doStart(String senderName) {
        BSControl.initLogger();
        util = BSUtil.self();
        BSControl.readProperties(false);
        BSControl.validateJMS();
        SBMConstants.self().getClass();
        BSControl.sendMessage("START", senderName);
        SBMControl.init();
        if (BSControl.eventProcessingByQueueEnabled()) {
            BSControl.publishBizStoreMessage(senderName);
        }
    }

    private static void validateJMS() {
        int maxRetryCount = jmsInitMaxRetryCount;
        int retryInterval = jmsInitRetryInterval;
        int retryCount = 1;
        while (true) {
            logger.debug((Object)("BSControl.validateJMS(), retryCount: " + retryCount + ", retryInterval: " + retryInterval));
            try {
                BMJMSService bMJMSService = SBMUtil.self().getBMJMSService();
                SBMConstants.self().getClass();
                Connection connection = bMJMSService.getConnection("sbmtopic");
                StringBuilder stringBuilder = new StringBuilder().append("BSControl.validateJMS(), Able to get topic connection: ");
                SBMConstants.self().getClass();
                logger.debug((Object)stringBuilder.append("sbmtopic").toString());
                SBMUtil.self().getBMJMSService().closeConnection(connection);
                break;
            }
            catch (JMSException jMSException) {
            }
            catch (BMJMSService.BMJMSException bMJMSException) {
                // empty catch block
            }
            if (retryCount >= maxRetryCount) {
                throw new RuntimeException("Maximum retry count of value " + maxRetryCount + " has reached for checking JMS Server availability while starting Bizstore.");
            }
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++retryCount;
        }
    }

    public static void doStop() {
        if (ServiceLocator.self().isCluster()) {
            SBMConstants.self().getClass();
            BSControl.sendMessage("STOP");
        } else {
            BSControl.shutdown();
        }
    }

    public static void doRefresh() {
        if (ServiceLocator.self().isCluster()) {
            SBMConstants.self().getClass();
            BSControl.sendMessage("REFRESH");
        } else {
            BSControl.refresh();
        }
    }

    private static void sendMessage(String operation) {
        BSControl.sendMessage(operation, null);
    }

    private static void sendMessage(String operation, String sender) {
        try {
            HashMap<String, String> selectors = new HashMap<String, String>();
            SBMConstants.self().getClass();
            selectors.put("OPERATION", operation);
            SBMConstants.self().getClass();
            selectors.put("TYPE", BLBIZSTOREMDB);
            if (sender != null && !sender.trim().isEmpty()) {
                selectors.put("SENDER_NODE_NAME", sender);
            }
            SBMConstants.self().getClass();
            String destination = "sbmtopic";
            SBMUtil.self().getBMJMSService().sendMessage(destination, (Object)"", 1, selectors);
        }
        catch (Exception ex) {
            if (logger != null) {
                logger.error((Object)"Exception in BSControl.sendMessage():", (Throwable)ex);
            }
            LoggerUtil.logSEP((Object)"Exception in BSControl.sendMessage()");
            LoggerUtil.logSEP((Object)ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    public static void performOperation(String operation) {
        SBMConstants.self().getClass();
        if ("START".equals(operation)) {
            BSControl.start();
        } else {
            SBMConstants.self().getClass();
            if ("STOP".equals(operation)) {
                BSControl.shutdown();
            } else {
                SBMConstants.self().getClass();
                if ("REFRESH".equals(operation)) {
                    BSControl.refresh();
                }
            }
        }
    }

    public static void sleep() {
        long timeInterval = sleeptimeWhenNoEvents;
        try {
            SBMControl.consts.getClass();
            long time = timeInterval % 30000L;
            if (!shuttingdown && time > 0L) {
                Thread.sleep(time);
            }
            while (!shuttingdown && time < timeInterval) {
                SBMControl.consts.getClass();
                Thread.sleep(30000L);
                SBMControl.consts.getClass();
                time += 30000L;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static boolean isValidSavvionMsgId(String savvionMsgIdFromJMS) {
        boolean isValid = false;
        java.sql.Connection conn = null;
        try {
            conn = util.getBSConnection();
            String savvionMsgIdFromDB = ServiceDAO.getSavvionMessageId((java.sql.Connection)conn);
            boolean bl = isValid = SBMUtil.isValidProperty((String)savvionMsgIdFromJMS) && SBMUtil.isValidProperty((String)savvionMsgIdFromDB) && savvionMsgIdFromDB.equals(savvionMsgIdFromJMS);
            if (!isValid) {
                logger.warnKey("BizStore_MSG_1012", "BizStoreMDB.onMessage", new Object[]{savvionMsgIdFromJMS, savvionMsgIdFromDB});
            }
        }
        catch (Throwable th) {
            throw new BizStoreException("BizStore_MSG_1615", "BSControl.validateSavvionMsgId", th);
        }
        finally {
            SBMDAOService.clean(null, null, (java.sql.Connection)conn);
        }
        return isValid;
    }

    public static void publishBizStoreMessage(String sender) {
        java.sql.Connection conn = null;
        String savvionMsgId = null;
        try {
            conn = util.getBSConnection();
            savvionMsgId = new VMID().toString();
            if (DEBUG_ENGINE) {
                if (BSControl.isServerRunning()) {
                    logger.debugKey("BizStore_MSG_533", "BSControl.publishBizStoreMessage", new Object[]{savvionMsgId, sender});
                } else {
                    String message = MessageFormat.format(PUBLISH_MESSAGE_MSG, savvionMsgId, sender);
                    System.out.println(message);
                }
            }
            HashMap<String, String> selectors = new HashMap<String, String>();
            SBMConstants.self().getClass();
            selectors.put("SAVVION_MSG_ID", savvionMsgId);
            SBMConstants.self().getClass();
            String destination = "bizstorequeue";
            ServiceDAO.updateSavvionMessageId((java.sql.Connection)conn, (String)savvionMsgId);
            SBMUtil.self().getBMJMSService().sendMessage(destination, (Object)"", 1, selectors);
        }
        catch (Throwable th) {
            if (BSControl.isServerRunning()) {
                throw new BizStoreException("BizStore_MSG_1614", new Object[]{savvionMsgId}, th);
            }
            throw new RuntimeException(MessageFormat.format(PUBLISH_MESSAGE_ERROR_MSG, savvionMsgId), th);
        }
        finally {
            SBMDAOService.clean(null, null, (java.sql.Connection)conn);
        }
    }

    private static boolean processNextBatch() {
        boolean continueProcessing = true;
        if (DEBUG_ENGINE) {
            logger.debugKey("BizStore_MSG_534", "BSControl.processNextBatch", new Object[0]);
        }
        if (BSControl.isServerRunning()) {
            try {
                BSControl.setCurrentlyProcessingEvents(true);
                reader.processNextBatch();
            }
            finally {
                BSControl.setCurrentlyProcessingEvents(false);
            }
        }
        if (BSControl.isServerShuttingDown()) {
            BSControl.cleanup();
            continueProcessing = false;
        }
        return continueProcessing;
    }

    public static boolean isEventProcessingByQueue() {
        return eventProcessingByQueue;
    }

    private static boolean eventProcessingByQueueEnabled() {
        return eventProcessingByQueue && ServiceLocator.self().isCluster();
    }

    public static long getSleepWhenBizStoreNotStarted() {
        return sleepWhenBizStoreNotStarted;
    }

    public static boolean isCurrentlyProcessingEvents() {
        return currentlyProcessingEvents;
    }

    public static void setCurrentlyProcessingEvents(boolean currentlyProcessing) {
        currentlyProcessingEvents = currentlyProcessing;
    }

    public static void processBizStoreMessage(String savvionMsgId) {
        if (BSControl.isServerShuttingDown()) {
            return;
        }
        if (DEBUG_ENGINE && logger != null) {
            logger.debugKey("BizStore_MSG_535", "BizStoreMDB.onMessage", new Object[]{savvionMsgId});
        }
        if (!BSControl.isEventProcessingByQueue()) {
            throw new RuntimeException("The bizstore.conf property 'bizstore.eventprocessing.queue.enable' must be in sync on all nodes of the cluster.");
        }
        if (!BSControl.isValidSavvionMsgId(savvionMsgId)) {
            return;
        }
        boolean continueProcessing = BSControl.processNextBatch();
        if (continueProcessing) {
            UserTransaction transaction = null;
            try {
                transaction = ServiceLocator.self().getUserTransaction();
                transaction.begin();
                BSControl.publishBizStoreMessage("SBM");
                transaction.commit();
            }
            catch (Throwable th) {
                TransactionService.rollback((UserTransaction)transaction);
                throw new BizStoreException("BizStore_MSG_1615", "BSControl.processBizStoreMessage", new Object[]{savvionMsgId}, th);
            }
        }
    }

    static {
        batchsize = 200;
        sleeptimeWhenNoEvents = 5000L;
        onExceptionSleeptime = 30000L;
        sleeptimeWhenEvents = 0L;
        transsize = 50;
        shuttingdown = false;
        running = false;
        initialized = false;
        isSyncBizStore = false;
        SYNC_UPDATECOUNTER_INTERVAL = 60L;
        MINUPDATEINTERVAL = 15L;
        MAXUPDATEINTERVAL = 120L;
        clusterBatchSize = 300;
        clusterTransSize = 300;
        maxMissingEventRetries = 3;
        missingEventDelayAllowed = 600000L;
        missingEventInsertEnabled = false;
        maxNoEvtRetries = 10;
        useURForReadingEvents = false;
        eventProcessingByQueue = false;
        sleepWhenBizStoreNotStarted = 60000L;
        jmsInitMaxRetryCount = 10;
        jmsInitRetryInterval = 15000;
        ServiceRegister.self().registerService((IServiceHandler)new BizStoreHandler());
    }

    private static class BizStoreHandler
    implements IServiceHandler {
        private BizStoreHandler() {
        }

        public String getServiceName() {
            return "BizStore";
        }

        public void startService() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BSControl.start();
                }
            }).start();
        }

        public void stopService() {
            BSControl.shutdown();
        }

        public boolean isServiceRunning() {
            return BSControl.isServerRunning();
        }
    }
}

