/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.gateway.jms;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.gateway.jms.JMSService;
import com.savvion.sbm.bizlogic.smp.gateway.jms.util.JMSUtil;
import com.savvion.sbm.bizlogic.smp.util.InvalidEventDataException;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.util.SBMUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public class BulkMessageProcessor {
    public static void process(Message message) {
        if (null == message) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW217", "BulkMessageProcessor.process(Message)"));
        }
        long methodStartTime = System.currentTimeMillis();
        Map messageDetails = JMSUtil.getEventCtx(message);
        List<ObjectMessage> messages = null;
        try {
            List<Map<String, Map<String, Object>>> eventList = BulkMessageProcessor.getEventList(message, messageDetails);
            messages = BulkMessageProcessor.convertToObjectMessages(eventList, messageDetails);
            if (JMSUtil.getLogger().isDebugEnabled()) {
                BulkMessageProcessor.logMessageDetails(message, messages, methodStartTime, messageDetails);
            }
            if (messages.size() > SMPConfig.self().getMaxBulkMessageSize()) {
                JMSUtil.getLogger().warnKey("BM_MPGW211", "BulkMessageProcessor.process()", new Object[]{messageDetails, messages.size(), SMPConfig.self().getMaxBulkMessageSize()});
            }
        }
        catch (Throwable e) {
            MPUtil.handleException(e, message);
            return;
        }
        long processingStartTime = System.currentTimeMillis();
        JMSService jmsService = MPService.self().getJMSService();
        for (ObjectMessage objectMessage : messages) {
            jmsService.processMessage((Message)objectMessage);
        }
        if (JMSUtil.getLogger().isDebugEnabled()) {
            BulkMessageProcessor.logProcessTimings(messages, methodStartTime, processingStartTime, System.currentTimeMillis(), messageDetails);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Map<String, Map<String, Object>>> getEventList(Message message, Map<String, Object> messageDetails) throws JMSException {
        List<Map<String, Map<String, Object>>> payload = null;
        Object payloadObject = null;
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            payloadObject = objectMessage.getObject();
        } else {
            if (!(message instanceof MapMessage)) throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW105", "BulkMessageProcessor.getEventList()", new Object[]{message.getClass().getName(), messageDetails}));
            MapMessage mapMessage = (MapMessage)message;
            payloadObject = mapMessage.getObject("EVENT_LIST");
            if (null != payloadObject) {
                if (!(payloadObject instanceof byte[])) throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW139", "BulkMessageProcessor.getEventList()", new Object[]{"EVENT_LIST", payloadObject.getClass().getName(), messageDetails}));
                payloadObject = MPUtil.convertByteArrToList(mapMessage.getBytes("EVENT_LIST"), "EVENT_LIST", messageDetails);
            }
        }
        payload = BulkMessageProcessor.validateMessagePayload(payloadObject, messageDetails);
        return BulkMessageProcessor.sort(payload, messageDetails);
    }

    private static List<Map<String, Map<String, Object>>> validateMessagePayload(Object payloadObject, Map<String, Object> messageDetails) {
        if (null == payloadObject) {
            throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW223", "BulkMessageProcessor.validateMessagePayload()", new Object[]{messageDetails}));
        }
        List payload = null;
        try {
            payload = (List)payloadObject;
            if (payload.isEmpty()) {
                throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW226", "BulkMessageProcessor.validateMessagePayload()", new Object[]{messageDetails}));
            }
            for (Map event : payload) {
                if (null == event || event.isEmpty()) {
                    throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW227", "BulkMessageProcessor.validateMessagePayload()", new Object[]{messageDetails}));
                }
                Set entries = event.entrySet();
                for (Map.Entry entry : entries) {
                    String key = (String)entry.getKey();
                    Map map = (Map)entry.getValue();
                    if (null != map && !map.isEmpty()) continue;
                    throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW228", "BulkMessageProcessor.validateMessagePayload()", new Object[]{messageDetails, key}));
                }
            }
        }
        catch (InvalidEventDataException e) {
            throw e;
        }
        catch (Throwable e) {
            throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW224", "BulkMessageProcessor.validateMessagePayload()", new Object[]{payloadObject.getClass().getName(), messageDetails}, e));
        }
        return payload;
    }

    private static List<Map<String, Map<String, Object>>> sort(List<Map<String, Map<String, Object>>> payload, Map<String, Object> jmsProps) {
        try {
            Collections.sort(payload, new Comparator<Map<String, Map<String, Object>>>(){

                @Override
                public int compare(Map<String, Map<String, Object>> event1, Map<String, Map<String, Object>> event2) {
                    long createTimeE1 = (Long)event1.get("EVENT_DATA").get("CREATE_TIME");
                    long createTimeE2 = (Long)event2.get("EVENT_DATA").get("CREATE_TIME");
                    return (int)(createTimeE1 - createTimeE2);
                }
            });
        }
        catch (Throwable e) {
            JMSUtil.getLogger().errorKey("BM_MPGW221", "BulkMessageProcessor.sort()", e, new Object[]{payload, jmsProps});
        }
        return payload;
    }

    private static List<ObjectMessage> convertToObjectMessages(List<Map<String, Map<String, Object>>> messagePayload, Map<String, Object> messageDetails) {
        if (null == messageDetails || messageDetails.isEmpty()) {
            throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW222", "BulkMessageProcessor.convertToObjectMessages()"));
        }
        Map<String, Object> eventProps = null;
        Map<String, Object> eventPayload = null;
        ArrayList<ObjectMessage> messages = new ArrayList<ObjectMessage>();
        ObjectMessage message = null;
        for (Map<String, Map<String, Object>> event : messagePayload) {
            try {
                eventProps = event.get("EVENT_PROPERTIES");
                eventPayload = event.get("EVENT_DATA");
                message = BulkMessageProcessor.createObjectMessage(eventProps, eventPayload, messageDetails);
                messages.add(message);
            }
            catch (Throwable e) {
                MPUtil.handleException(e, message);
            }
        }
        return messages;
    }

    private static ObjectMessage createObjectMessage(Map<String, Object> eventProps, Map<String, Object> eventPayload, Map<String, Object> messageDetails) {
        Session session = null;
        ObjectMessage message = null;
        try {
            BulkMessageProcessor.validateMessageParams(eventProps, eventPayload, messageDetails);
            session = JMSUtil.self().getSession();
            message = (ObjectMessage)SBMUtil.self().getBMJMSService().createMessage(session, 4, eventPayload, (HashMap)eventProps);
            if (null != messageDetails && !messageDetails.isEmpty()) {
                message.setJMSMessageID((String)messageDetails.get("JMSMessageID"));
                message.setStringProperty("BULK_MESSAGE_ID", message.getJMSMessageID());
                message.setJMSTimestamp(((Long)messageDetails.get("JMSTimestamp")).longValue());
            }
        }
        catch (JMSException e) {
            try {
                throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW208", "BulkMessageProcessor.createObjectMessage()", new Object[]{eventProps, eventPayload, messageDetails}));
            }
            catch (Throwable throwable) {
                JMSUtil.close(session);
                throw throwable;
            }
        }
        JMSUtil.close(session);
        return message;
    }

    private static void validateMessageParams(Map<String, Object> eventProps, Map<String, Object> eventPayload, Map<String, Object> jmsProps) {
        if (null == eventProps) {
            throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW218", "BulkMessageProcessor.validateMessageParams()", new Object[]{jmsProps}));
        }
        if (null == eventPayload) {
            throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW219", "BulkMessageProcessor.validateMessageParams()", new Object[]{jmsProps}));
        }
    }

    private static void logProcessTimings(List<ObjectMessage> messages, long methodStartTime, long processingStartTime, long processingEndTime, Map<String, Object> jmsProps) {
        try {
            long timeToProcessMessages = processingEndTime - processingStartTime;
            if (SMPConfig.self().isInlineProcessAtGateway()) {
                JMSUtil.getLogger().debugKey("BM_MPGW213", "BulkMessageProcessor.process()", new Object[]{jmsProps, messages.size(), timeToProcessMessages});
            } else {
                JMSUtil.getLogger().debugKey("BM_MPGW212", "BulkMessageProcessor.process()", new Object[]{jmsProps, messages.size(), timeToProcessMessages});
            }
            JMSUtil.getLogger().debugKey("BM_MPGW214", "BulkMessageProcessor.process()", new Object[]{jmsProps, System.currentTimeMillis() - methodStartTime});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void logMessageDetails(Message message, List<ObjectMessage> messages, long methodStartTime, Map<String, Object> jmsProps) {
        try {
            long messageSize = SBMUtil.convertToBytes((Object)message).length;
            long timeToCreateObjMessages = System.currentTimeMillis() - methodStartTime;
            JMSUtil.getLogger().debugKey("BM_MPGW209", "BulkMessageProcessor.process()", new Object[]{messageSize, messages.size(), jmsProps});
            JMSUtil.getLogger().debugKey("BM_MPGW210", "BulkMessageProcessor.process()", new Object[]{jmsProps, timeToCreateObjMessages});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

