/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.svo.MessageSubscription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageSubscriptionList
implements Serializable {
    static final long serialVersionUID = -4124275418259278461L;
    private final String ptName;
    private final String wsName;
    private boolean waitForAll;
    private String handler;
    private final List subscribedMsgList = new ArrayList();

    public MessageSubscriptionList(String ptName, String wsName) {
        this.ptName = ptName;
        this.wsName = wsName;
    }

    public void setWaitForAllMessages(boolean flag) {
        this.waitForAll = flag;
    }

    public void setMessageHandler(String messageHandler) {
        this.handler = messageHandler;
    }

    public void addSubscribedMessage(MessageSubscription msgSubscr) {
        this.subscribedMsgList.add(msgSubscr);
    }

    public String getProcessTemplateName() {
        return this.ptName;
    }

    public String getWorkstepName() {
        return this.wsName;
    }

    public boolean isWaitForAllMessages() {
        return this.waitForAll;
    }

    public String getHandler() {
        return this.handler;
    }

    public List getSubscribedMessages() {
        return this.subscribedMsgList;
    }

    public List getMessageNames() {
        ArrayList<String> messageNames = new ArrayList<String>();
        for (int ix = 0; ix < this.subscribedMsgList.size(); ++ix) {
            MessageSubscription msgSubscr = (MessageSubscription)this.subscribedMsgList.get(ix);
            String messageName = msgSubscr.getMessageName();
            messageNames.add(messageName);
        }
        return messageNames;
    }

    public Map<String, Integer> getMessageOrderingBySubscription() {
        HashMap<String, Integer> messageOrdering = new HashMap<String, Integer>();
        for (int ix = 0; ix < this.subscribedMsgList.size(); ++ix) {
            MessageSubscription msgSubscr = (MessageSubscription)this.subscribedMsgList.get(ix);
            String messageName = msgSubscr.getMessageName();
            messageOrdering.put(messageName, ix + 1);
        }
        return messageOrdering;
    }

    public MessageSubscription getSubscribedMessage(String messageName) {
        for (int ix = 0; ix < this.subscribedMsgList.size(); ++ix) {
            MessageSubscription msgSubscr = (MessageSubscription)this.subscribedMsgList.get(ix);
            if (!msgSubscr.getMessageName().equals(messageName)) continue;
            return msgSubscr;
        }
        return null;
    }

    public boolean isSubscribedToAnyMessage() {
        return !this.subscribedMsgList.isEmpty();
    }

    public int getMessageCount(String messageName) {
        for (int ix = 0; ix < this.subscribedMsgList.size(); ++ix) {
            MessageSubscription msgSubscr = (MessageSubscription)this.subscribedMsgList.get(ix);
            if (!msgSubscr.getMessageName().equals(messageName)) continue;
            return msgSubscr.getMessageCount();
        }
        return 0;
    }

    public boolean isSubscribedToMessage(String messageName) {
        if (messageName == null || messageName.trim().length() == 0) {
            return !this.isSubscribedToAnyMessage();
        }
        for (int ix = 0; ix < this.subscribedMsgList.size(); ++ix) {
            MessageSubscription msgSubscr = (MessageSubscription)this.subscribedMsgList.get(ix);
            if (!msgSubscr.getMessageName().equals(messageName)) continue;
            return true;
        }
        return false;
    }

    public HashMap getAllMessageMapping() {
        HashMap allMsgMappings = new HashMap();
        for (Object obj : this.subscribedMsgList) {
            MessageSubscription msgSubscr = (MessageSubscription)obj;
            HashMap msgMap = msgSubscr.getSlotMapping();
            allMsgMappings.putAll(msgMap);
        }
        return allMsgMappings;
    }
}

