/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.ejb.DataSlotSB;
import com.savvion.sbm.bizlogic.server.svo.BLCollection;
import com.savvion.sbm.bizlogic.server.svo.DataSlot;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.ejb.EJBObject;

public class DataSlotList
extends BLCollection {
    DataSlotList(Session session, Vector list) {
        this.session = session;
        if (list != null && !list.isEmpty()) {
            this.list = list;
        }
    }

    @Override
    public Iterator sort() {
        TreeMap tm = new TreeMap();
        for (int ix = 0; ix < this.list.size(); ++ix) {
            String name = ((DataSlot)this.list.get(ix)).getName();
            if (tm.containsKey(name)) {
                throw new RuntimeException("Found duplicate key value: " + name);
            }
            tm.put(name, this.list.get(ix));
        }
        Iterator sortedData = tm.values().iterator();
        return sortedData;
    }

    @Override
    public void save() throws RemoteException, BizLogicClientException {
        HashMap modifiedValues = this.getModifiedValues();
        if (!modifiedValues.isEmpty()) {
            ((DataSlotSB)this.getRemoteRef()).setValue(this.session, modifiedValues);
        }
    }

    @Override
    protected final EJBObject getRemoteRef() throws BizLogicClientException, RemoteException {
        if (!this.isEmptyList()) {
            return ((DataSlot)this.list.firstElement()).getRemoteRef();
        }
        throw new RuntimeException("No SVO Object available in the List. So SessionBean lookup failed");
    }

    private HashMap getModifiedValues() {
        HashMap<Long, HashMap<String, Object>> pidsValues = new HashMap<Long, HashMap<String, Object>>();
        DataSlot ds = null;
        if (!this.isEmptyList()) {
            for (int ix = 0; ix < this.list.size(); ++ix) {
                ds = (DataSlot)this.list.elementAt(ix);
                if (!ds.isValueModified) continue;
                Long piid = ds.getProcessInstanceID();
                HashMap<String, Object> dsValues = (HashMap<String, Object>)pidsValues.get(piid);
                if (dsValues == null) {
                    dsValues = new HashMap<String, Object>();
                }
                dsValues.put(ds.getName(), ds.getValue());
                pidsValues.put(piid, dsValues);
            }
        }
        return pidsValues;
    }

    public Map<String, Object> getValues() {
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        if (this.list == null) {
            return dsValues;
        }
        for (Object obj : this.list) {
            DataSlot ds = (DataSlot)obj;
            dsValues.put(ds.getName(), ds.getValue());
        }
        return dsValues;
    }

    public Map<String, Object> getValues(List<String> dsNames) {
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        if (this.list == null || dsNames == null || dsNames.isEmpty()) {
            return dsValues;
        }
        for (Object obj : this.list) {
            DataSlot ds = (DataSlot)obj;
            if (!dsNames.contains(ds.getName())) continue;
            dsValues.put(ds.getName(), ds.getValue());
        }
        return dsValues;
    }

    public Object getValue(String dsName) {
        Object dsValue = null;
        if (this.list == null || dsName == null) {
            return dsValue;
        }
        for (Object obj : this.list) {
            DataSlot ds = (DataSlot)obj;
            if (!dsName.equals(ds.getName())) continue;
            dsValue = ds.getValue();
            break;
        }
        return dsValue;
    }
}

