/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.MDBAdapter;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.TransactionService;
import com.savvion.sbm.util.logger.SBMLogger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.transaction.UserTransaction;

public class BLCacheSyncMDB
extends MDBAdapter {
    private UserTransaction utx = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(Message msg) {
        BLConstants consts = BLConstants.single();
        try {
            String server = msg.getStringProperty("SERVER_ID");
            if (server == null) return;
            if (server.equals(BLControl.getServerID())) {
                return;
            }
            String type = msg.getStringProperty("TYPE");
            if (type.equalsIgnoreCase("PROCESSTEMPLATENAME")) {
                this.syncProcessTemplate(msg, consts);
                return;
            }
            if (!type.equalsIgnoreCase("SUSPENDED_WORKSTEP")) return;
        }
        catch (JMSException jex) {
            BLControl.logger.errorKey("BizLogic_ERR_2620", new Object[]{msg.toString()}, (Throwable)jex);
        }
    }

    private void syncProcessTemplate(Message msg, BLConstants consts) {
        try {
            String operation = msg.getStringProperty("OPERATION");
            long ptid = msg.getLongProperty("PROCESSTEMPLATEID");
            long lastModifiedTime = msg.getLongProperty("LAST_MODIFIED_TIME");
            String serverId = msg.getStringProperty("SERVER_ID");
            try {
                if (operation.equalsIgnoreCase("ADD")) {
                    if (BLControl.util.DEBUG_CLUSTERING) {
                        BLControl.logger.debugKey("BizLogic_ERR_9153", new Object[]{ptid, serverId});
                    }
                    this.updateProcessTemplate(ptid, lastModifiedTime);
                } else if (operation.equalsIgnoreCase("REMOVE")) {
                    if (BLControl.util.DEBUG_CLUSTERING) {
                        BLControl.logger.debugKey("BizLogic_ERR_9154", new Object[]{ptid, serverId});
                    }
                    ProcessControl.removeAlertsFromCache(ptid);
                    WFProcess pt = ProcessControl.removeProcessTemplateFromCache(ptid);
                    if (pt == null) {
                        BLControl.logger.debugKey("BizLogic_ERR_9155", new Object[]{ptid, serverId});
                    }
                } else if (operation.equalsIgnoreCase("UPDATE")) {
                    if (BLControl.util.DEBUG_CLUSTERING) {
                        BLControl.logger.debugKey("BizLogic_ERR_9156", new Object[]{ptid, serverId});
                    }
                    ProcessControl.removeAlertsFromCache(ptid);
                    this.updateProcessTemplate(ptid, lastModifiedTime);
                } else {
                    BLConstants.ClusterConstants cfr_ignored_0 = consts.cluster;
                    if (operation.equalsIgnoreCase("CLEAR_PT_CACHE")) {
                        if (BLControl.util.DEBUG_CLUSTERING) {
                            BLControl.logger.debugKey("BizLogic_ERR_9157", new Object[]{serverId});
                        }
                        ProcessControl.doClearCache();
                    }
                }
            }
            catch (Exception ex) {
                try {
                    TransactionService.rollback((UserTransaction)this.utx, (SBMLogger)BLControl.logger);
                }
                catch (Exception ex1) {
                    BLControl.logger.errorKey("BizLogic_ERR_2621", new Object[]{"BLCacheSyncMDB", "ProcessTemplateSync"}, (Throwable)ex1);
                }
                BLControl.logger.errorKey("BizLogic_ERR_2618", new Object[]{operation, ptid}, (Throwable)ex);
            }
        }
        catch (JMSException jex) {
            BLControl.logger.errorKey("BizLogic_ERR_2620", new Object[]{msg.toString()}, (Throwable)jex);
        }
        catch (Throwable th) {
            if (null != BLControl.logger) {
                BLControl.logger.fatal((Object)"The BizLogic Cache Sync JMS Message could not be processed!", th);
            }
            LoggerUtil.logSOP((Object)"<FATAL> <BizLogic> The BizLogic Cache Sync JMS Message could not be processed!");
            th.printStackTrace();
        }
    }

    private void updateProcessTemplate(long ptid, long lastModifiedTime) {
        WFProcess ptObject = null;
        try {
            int dura = 0;
            while ((long)dura < BLUtil.self().getMsgRetryMaxTime()) {
                this.utx = this.mdc.getUserTransaction();
                this.utx.begin();
                ptObject = ProcessControl.addProcessTemplateToCache(ptid);
                this.utx.commit();
                if (ptObject == null || ptObject.getLastModifiedTime() < lastModifiedTime) {
                    Thread.sleep(BLUtil.self().getMsgRetryInterval());
                    dura = (int)((long)dura + BLUtil.self().getMsgRetryInterval());
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (ptObject == null) {
            BLControl.logger.debugKey("BizLogic_ERR_9158", new Object[]{ptid});
        }
    }
}

