/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Hashtable;

public class ProcessTemplateDAO
extends BLDAOService {
    private static final String[] CREATE_LIST;
    private static final String[] LOAD_ALL_PT;
    private static final String[] LOAD_LIST;
    static String insertProcessTemplate;
    static String loadProcessTemplates;
    static String loadAllProcessTemplates;
    static String loadProcessTemplateWithID;
    static String loadProcessTemplateWithName;
    static String removeProcessTemplate;
    static String updateProcessTemplate;
    static String checkTemplateQuery;
    static String getPTCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(WFProcess pt) {
        block7: {
            Connection conn = null;
            PreparedStatement pstmtInsertProcessTemplate = null;
            ByteArrayInputStream contextInsert = null;
            ResultSet rs = null;
            try {
                conn = ProcessTemplateDAO.getConnection();
                pstmtInsertProcessTemplate = conn.prepareStatement(insertProcessTemplate);
                pstmtInsertProcessTemplate.setLong(1, pt.getID());
                pstmtInsertProcessTemplate.setString(2, pt.getName());
                pstmtInsertProcessTemplate.setString(3, pt.getAppName());
                contextInsert = new ByteArrayInputStream(ProcessTemplateDAO.convertToBytes((Object)pt));
                pstmtInsertProcessTemplate.setBinaryStream(4, (InputStream)contextInsert, contextInsert.available());
                pstmtInsertProcessTemplate.setString(5, pt.getFolderId());
                pstmtInsertProcessTemplate.setLong(6, pt.getStatus());
                pstmtInsertProcessTemplate.setInt(7, pt.getProcessType().getId());
                if (pt.getMonitorDSName() != null) {
                    pstmtInsertProcessTemplate.setString(8, pt.getMonitorDSName());
                } else {
                    pstmtInsertProcessTemplate.setNull(8, 12);
                }
                pstmtInsertProcessTemplate.setTimestamp(9, new Timestamp(pt.getStartTime()));
                pstmtInsertProcessTemplate.setTimestamp(10, new Timestamp(pt.getLastModifiedTime()));
                pstmtInsertProcessTemplate.setString(11, pt.getCategory());
                pstmtInsertProcessTemplate.executeUpdate();
                FileUtil.close((InputStream)contextInsert);
                contextInsert = null;
            }
            catch (SQLException sqlerr) {
                ProcessTemplateDAO.handle((Throwable)sqlerr, (String)("PTDAO.create(PKey: " + pt.getID() + ")"));
                break block7;
            }
            finally {
                FileUtil.close(contextInsert);
                contextInsert = null;
                ProcessTemplateDAO.clean(rs, (Statement)pstmtInsertProcessTemplate, (Connection)conn);
            }
            ProcessTemplateDAO.clean(rs, (Statement)pstmtInsertProcessTemplate, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(WFProcess pt) {
        block7: {
            Connection conn = null;
            ByteArrayInputStream contextUpdate = null;
            PreparedStatement pstmtUpdateProcessTemplate = null;
            try {
                conn = ProcessTemplateDAO.getConnection();
                pstmtUpdateProcessTemplate = conn.prepareStatement(updateProcessTemplate);
                contextUpdate = new ByteArrayInputStream(ProcessTemplateDAO.convertToBytes((Object)pt));
                pstmtUpdateProcessTemplate.setBinaryStream(1, (InputStream)contextUpdate, contextUpdate.available());
                pstmtUpdateProcessTemplate.setString(2, pt.getAppName());
                pstmtUpdateProcessTemplate.setLong(3, pt.getStatus());
                pstmtUpdateProcessTemplate.setInt(4, pt.getProcessType().getId());
                if (pt.getMonitorDSName() != null) {
                    pstmtUpdateProcessTemplate.setString(5, pt.getMonitorDSName());
                } else {
                    pstmtUpdateProcessTemplate.setNull(5, 12);
                }
                pstmtUpdateProcessTemplate.setTimestamp(6, new Timestamp(pt.getLastModifiedTime()));
                pstmtUpdateProcessTemplate.setString(7, pt.getCategory());
                pstmtUpdateProcessTemplate.setLong(8, pt.getID());
                pstmtUpdateProcessTemplate.executeUpdate();
                FileUtil.close((InputStream)contextUpdate);
                contextUpdate = null;
            }
            catch (SQLException sqlerr) {
                ProcessTemplateDAO.handle((SQLException)sqlerr);
                break block7;
            }
            finally {
                FileUtil.close(contextUpdate);
                contextUpdate = null;
                ProcessTemplateDAO.clean(null, (Statement)pstmtUpdateProcessTemplate, (Connection)conn);
            }
            ProcessTemplateDAO.clean(null, (Statement)pstmtUpdateProcessTemplate, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(long templateID) {
        Connection conn = null;
        PreparedStatement pstmtRemoveProcessTemplate = null;
        try {
            conn = ProcessTemplateDAO.getConnection();
            pstmtRemoveProcessTemplate = conn.prepareStatement(removeProcessTemplate);
            pstmtRemoveProcessTemplate.setLong(1, templateID);
            pstmtRemoveProcessTemplate.executeUpdate();
        }
        catch (SQLException sqlerr) {
            ProcessTemplateDAO.handle((SQLException)sqlerr);
        }
        finally {
            ProcessTemplateDAO.clean(null, (Statement)pstmtRemoveProcessTemplate, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WFProcess load(long templateID) {
        InputStream is;
        WFProcess process;
        ResultSet rset;
        PreparedStatement pstmtLoadProcessTemplateWithID;
        Connection conn;
        block7: {
            block8: {
                conn = null;
                pstmtLoadProcessTemplateWithID = null;
                rset = null;
                process = null;
                is = null;
                conn = ProcessTemplateDAO.getConnection();
                pstmtLoadProcessTemplateWithID = conn.prepareStatement(loadProcessTemplateWithID);
                pstmtLoadProcessTemplateWithID.setLong(1, templateID);
                rset = pstmtLoadProcessTemplateWithID.executeQuery();
                if (!rset.next()) break block7;
                is = rset.getBinaryStream(1);
                process = (WFProcess)ProcessTemplateDAO.convertToObject((InputStream)is);
                if (process == null) {
                    throw new BizLogicException("BizLogic_ERR_1526", "ProcessTemplateDAO.load(long)", new Object[]{"ID=" + templateID});
                }
                boolean compileOK = process.compileJavaScript();
                if (!compileOK) break block8;
                WFProcess wFProcess = process;
                FileUtil.close((InputStream)is);
                is = null;
                ProcessTemplateDAO.clean((ResultSet)rset, (Statement)pstmtLoadProcessTemplateWithID, (Connection)conn);
                return wFProcess;
            }
            WFProcess wFProcess = null;
            FileUtil.close((InputStream)is);
            is = null;
            ProcessTemplateDAO.clean((ResultSet)rset, (Statement)pstmtLoadProcessTemplateWithID, (Connection)conn);
            return wFProcess;
        }
        try {
            try {
                throw new BizLogicException("BizLogic_ERR_8125", "ProcessTemplateDAO.load(long)", new Object[]{"ID", templateID});
            }
            catch (Throwable th) {
                ProcessTemplateDAO.handle((Throwable)th);
                FileUtil.close(is);
                is = null;
                ProcessTemplateDAO.clean(rset, (Statement)pstmtLoadProcessTemplateWithID, (Connection)conn);
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(is);
            is = null;
            ProcessTemplateDAO.clean(rset, (Statement)pstmtLoadProcessTemplateWithID, (Connection)conn);
            throw throwable;
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WFProcess load(String ptName) {
        InputStream is;
        WFProcess process;
        ResultSet rset;
        PreparedStatement pstmtLoadProcessTemplateWithName;
        Connection conn;
        block7: {
            block8: {
                conn = null;
                pstmtLoadProcessTemplateWithName = null;
                rset = null;
                process = null;
                is = null;
                conn = ProcessTemplateDAO.getConnection();
                pstmtLoadProcessTemplateWithName = conn.prepareStatement(loadProcessTemplateWithName);
                pstmtLoadProcessTemplateWithName.setString(1, ptName);
                rset = pstmtLoadProcessTemplateWithName.executeQuery();
                if (!rset.next()) break block7;
                is = rset.getBinaryStream(1);
                process = (WFProcess)ProcessTemplateDAO.convertToObject((InputStream)is);
                if (process == null) {
                    throw new BizLogicException("BizLogic_ERR_1526", "ProcessTemplateDAO.load(String)", new Object[]{"Name=" + ptName});
                }
                boolean compileOK = process.compileJavaScript();
                if (!compileOK) break block8;
                WFProcess wFProcess = process;
                FileUtil.close((InputStream)is);
                is = null;
                ProcessTemplateDAO.clean((ResultSet)rset, (Statement)pstmtLoadProcessTemplateWithName, (Connection)conn);
                return wFProcess;
            }
            WFProcess wFProcess = null;
            FileUtil.close((InputStream)is);
            is = null;
            ProcessTemplateDAO.clean((ResultSet)rset, (Statement)pstmtLoadProcessTemplateWithName, (Connection)conn);
            return wFProcess;
        }
        try {
            try {
                throw new BizLogicException("BizLogic_ERR_8125", "ProcessTemplateDAO.load(String)", new Object[]{"Name", ptName});
            }
            catch (Throwable th) {
                ProcessTemplateDAO.handle((Throwable)th);
                FileUtil.close(is);
                is = null;
                ProcessTemplateDAO.clean(rset, (Statement)pstmtLoadProcessTemplateWithName, (Connection)conn);
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(is);
            is = null;
            ProcessTemplateDAO.clean(rset, (Statement)pstmtLoadProcessTemplateWithName, (Connection)conn);
            throw throwable;
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getProcessTemplateList() {
        Connection conn = null;
        PreparedStatement pstmtLoadProcessTemplates = null;
        ResultSet rset = null;
        Hashtable<Long, WFProcess> ptList = new Hashtable<Long, WFProcess>();
        WFProcess pt = null;
        InputStream is = null;
        try {
            conn = ProcessTemplateDAO.getConnection();
            pstmtLoadProcessTemplates = conn.prepareStatement(loadAllProcessTemplates);
            rset = pstmtLoadProcessTemplates.executeQuery();
            while (rset.next()) {
                long ptId = rset.getLong(1);
                String ptName = rset.getString(2);
                is = rset.getBinaryStream(3);
                pt = (WFProcess)ProcessTemplateDAO.convertToObject((InputStream)is);
                if (pt == null) {
                    throw new BizLogicException("BizLogic_ERR_1526", "ProcessTemplateDAO.getProcessTemplateList", new Object[]{"ID=" + ptId + ", Name=" + ptName});
                }
                boolean compileOK = pt.compileJavaScript();
                if (!compileOK) continue;
                ptList.put(pt.getID(), pt);
            }
        }
        catch (SQLException sqlerr) {
            ptList.clear();
            ProcessTemplateDAO.handle((SQLException)sqlerr);
        }
        finally {
            FileUtil.close(is);
            is = null;
            ProcessTemplateDAO.clean((ResultSet)rset, (Statement)pstmtLoadProcessTemplates, (Connection)conn);
        }
        return ptList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean checkRecordExists(String templateName) {
        boolean recordExists;
        ResultSet rs;
        PreparedStatement pstmtCheckTemplate;
        Connection conn;
        block4: {
            conn = null;
            pstmtCheckTemplate = null;
            rs = null;
            recordExists = false;
            try {
                conn = ProcessTemplateDAO.getConnection();
                pstmtCheckTemplate = conn.prepareStatement(checkTemplateQuery);
                pstmtCheckTemplate.setString(1, templateName);
                rs = pstmtCheckTemplate.executeQuery();
                if (!rs.next()) break block4;
                recordExists = true;
            }
            catch (SQLException sQLException) {
                ProcessTemplateDAO.clean(rs, (Statement)pstmtCheckTemplate, (Connection)conn);
                catch (Throwable throwable) {
                    ProcessTemplateDAO.clean(rs, (Statement)pstmtCheckTemplate, (Connection)conn);
                    throw throwable;
                }
            }
        }
        ProcessTemplateDAO.clean((ResultSet)rs, (Statement)pstmtCheckTemplate, (Connection)conn);
        return recordExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getPTCount(int processType) {
        long ptCount;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block5: {
            conn = null;
            pstmt = null;
            rs = null;
            ptCount = 0L;
            try {
                conn = ProcessTemplateDAO.getConnection();
                pstmt = conn.prepareStatement(getPTCount);
                pstmt.setInt(1, processType);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                ptCount = rs.getLong(1);
            }
            catch (Throwable th) {
                try {
                    ProcessTemplateDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    ProcessTemplateDAO.clean(rs, (Statement)pstmt, (Connection)conn);
                }
            }
        }
        ProcessTemplateDAO.clean((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return ptCount;
    }

    public static synchronized void initSQLStatements() {
        ProcessTemplateDAO.initSQLStatementInsertProcessTemplate();
        ProcessTemplateDAO.initSQLStatementLoadProcessTemplates();
        ProcessTemplateDAO.initSQLStatementLoadAllProcessTemplates();
        ProcessTemplateDAO.initSQLStatementCheckTemplateQuery();
        ProcessTemplateDAO.initSQLStatementLoadProcessTemplateWithID();
        ProcessTemplateDAO.initSQLStatementLoadProcessTemplateWithName();
        ProcessTemplateDAO.initSQLStatementRemoveProcessTemplate();
        ProcessTemplateDAO.initSQLStatementUpdateProcessTemplate();
        ProcessTemplateDAO.initSQLStatementGetPTCount();
        ProcessTemplateDAO.printSQLStatements();
    }

    private static void initSQLStatementInsertProcessTemplate() {
        int ix;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO ").append("BIZLOGIC_PROCESSTEMPLATE").append(" (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            stringBuilder.append(CREATE_LIST[ix]);
            if (ix == CREATE_LIST.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(") ").append(" VALUES ").append(" (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            stringBuilder.append("?");
            if (ix == CREATE_LIST.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(") ");
        insertProcessTemplate = stringBuilder.toString();
    }

    private static void initSQLStatementLoadProcessTemplates() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" SELECT ");
        for (int ix = 0; ix < LOAD_LIST.length; ++ix) {
            stringBuilder.append(LOAD_LIST[ix]);
            if (ix == LOAD_LIST.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" FROM ").append("BIZLOGIC_PROCESSTEMPLATE");
        loadProcessTemplates = stringBuilder.toString();
    }

    private static void initSQLStatementLoadAllProcessTemplates() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" SELECT ");
        for (int ix = 0; ix < LOAD_ALL_PT.length; ++ix) {
            stringBuilder.append(LOAD_ALL_PT[ix]);
            if (ix == LOAD_ALL_PT.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" FROM ").append("BIZLOGIC_PROCESSTEMPLATE");
        loadAllProcessTemplates = stringBuilder.toString();
    }

    private static void initSQLStatementCheckTemplateQuery() {
        checkTemplateQuery = " SELECT PROCESS_TEMPLATE_NAME FROM BIZLOGIC_PROCESSTEMPLATE WHERE PROCESS_TEMPLATE_NAME = ? ";
    }

    private static void initSQLStatementLoadProcessTemplateWithID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" SELECT ");
        for (int ix = 0; ix < LOAD_LIST.length; ++ix) {
            stringBuilder.append(LOAD_LIST[ix]);
            if (ix == LOAD_LIST.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" FROM ").append("BIZLOGIC_PROCESSTEMPLATE").append(" WHERE ").append("PROCESS_TEMPLATE_ID").append(" = ? ");
        loadProcessTemplateWithID = stringBuilder.toString();
    }

    private static void initSQLStatementLoadProcessTemplateWithName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" SELECT ");
        for (int ix = 0; ix < LOAD_LIST.length; ++ix) {
            stringBuilder.append(LOAD_LIST[ix]);
            if (ix == LOAD_LIST.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" FROM ").append("BIZLOGIC_PROCESSTEMPLATE").append(" WHERE ").append("PROCESS_TEMPLATE_NAME").append(" = ? ");
        loadProcessTemplateWithName = stringBuilder.toString();
    }

    private static void initSQLStatementRemoveProcessTemplate() {
        removeProcessTemplate = " DELETE  FROM BIZLOGIC_PROCESSTEMPLATE WHERE PROCESS_TEMPLATE_ID = ? ";
    }

    private static void initSQLStatementUpdateProcessTemplate() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" UPDATE ").append("BIZLOGIC_PROCESSTEMPLATE").append(" SET ").append("PROCESS_OBJECT").append(" = ? ").append(", ").append("DISPLAY_NAME").append(" = ? ").append(", ").append("STATUS").append(" = ? ").append(", ").append("PROCESS_TYPE").append(" = ? ").append(", ").append("MONITORDS_NAME").append(" = ? ").append(", ").append("MODIFIED_DATE").append(" = ? ").append(", ").append("CATEGORY").append(" = ? ").append(" WHERE ").append("PROCESS_TEMPLATE_ID").append(" = ? ");
        updateProcessTemplate = stringBuilder.toString();
    }

    private static void initSQLStatementGetPTCount() {
        getPTCount = " SELECT  COUNT(*)  FROM BIZLOGIC_PROCESSTEMPLATE WHERE PROCESS_TYPE = ? ";
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"ProcessTemplateDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", insertProcessTemplate, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadAllProcessTemplates, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadProcessTemplates, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadProcessTemplateWithID, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadProcessTemplateWithName, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeProcessTemplate, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", updateProcessTemplate, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getPTCount, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[11];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[0] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[1] = "PROCESS_TEMPLATE_NAME";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[2] = "DISPLAY_NAME";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray[3] = "PROCESS_OBJECT";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray[4] = "FOLDER_ID";
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        stringArray[5] = "STATUS";
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        stringArray[6] = "PROCESS_TYPE";
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        stringArray[7] = "MONITORDS_NAME";
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        stringArray[8] = "CREATE_DATE";
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        stringArray[9] = "MODIFIED_DATE";
        DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
        stringArray[10] = "CATEGORY";
        CREATE_LIST = stringArray;
        String[] stringArray2 = new String[3];
        DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
        stringArray2[0] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_12 = BLControl.dbconsts.col;
        stringArray2[1] = "PROCESS_TEMPLATE_NAME";
        DBConstants.ColConstants cfr_ignored_13 = BLControl.dbconsts.col;
        stringArray2[2] = "PROCESS_OBJECT";
        LOAD_ALL_PT = stringArray2;
        String[] stringArray3 = new String[1];
        DBConstants.ColConstants cfr_ignored_14 = BLControl.dbconsts.col;
        stringArray3[0] = "PROCESS_OBJECT";
        LOAD_LIST = stringArray3;
    }
}

