/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.SubProcessInstanceData;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFNestedWS;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.SubProcessDAO;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceSB;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceSBHome;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDocService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WFNestedInstance
extends WFWorkstepInstance {
    private static WFNestedInstance self;

    private WFNestedInstance() {
    }

    private void init() {
    }

    public static WFNestedInstance self() {
        if (self == null) {
            self = new WFNestedInstance();
        }
        return self;
    }

    @Override
    public void execute(WFProcessContext pCtx, long wsid) {
        WFNestedWS ws = (WFNestedWS)pCtx.getWorkstep(wsid);
        if (!this.isSubProcessActivated(pCtx, wsid)) {
            WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
            if (!ws.isSynchronous() && wsieb.getLoopCounter() > 1) {
                SubProcessDAO.removeByWorkstepInstance(pCtx.getProcessInstanceID(), wsid);
            }
            if (ws.hasDocumentDS()) {
                WFNestedInstance.createDSFolder(pCtx, ws);
            }
            ArrayList instances = SubProcessInstanceData.getSubProcessInstances(pCtx, wsid);
            for (int ix = 0; ix < instances.size(); ++ix) {
                SubProcessInstanceData instance = (SubProcessInstanceData)instances.get(ix);
                if (instance.isRemoteSubProcess()) {
                    this.createRemoteSubProcess(pCtx, wsid, instance);
                    continue;
                }
                this.createLocalSubProcess(pCtx, wsid, instance);
            }
            if (wsieb.getState() != 21) {
                this.setSubProcessActivated(pCtx, wsid, true);
            }
        }
        if (!ws.isSynchronous()) {
            this.setSubProcessActivated(pCtx, wsid, false);
            this.complete(pCtx, wsid);
        }
    }

    @Override
    public void complete(WFProcessContext pCtx, long wsid) {
        int count;
        this.validateCompletion(pCtx, wsid);
        WFNestedWS ws = (WFNestedWS)pCtx.getWorkstep(wsid);
        if (pCtx.isDebug() && ws.isSynchronous() && (count = SubProcessDAO.getCount(pCtx.getProcessInstanceID(), wsid)) > 0) {
            BLControl.logger.error((Object)("The workstep <" + ws.getName() + " of process instance <" + pCtx.getProcessInstanceID() + "> is not completed as it has <" + count + "> active sub-processes"));
            return;
        }
        super.complete(pCtx, wsid);
        WorkStepInstanceEBLocal wsi = pCtx.getWorkstepInstanceEB(wsid);
        if (wsi.getState() != 21) {
            return;
        }
        this.setSubProcessActivated(pCtx, wsid, false);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_3120", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()});
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 21), (int)21);
        super.afterComplete(pCtx, wsid);
        if (!this.isSuspendedByCompensatory(pCtx, wsid)) {
            this.activateNextWorksteps(pCtx, wsid);
        }
    }

    public void completeCallerWorkstep(Session ses, long piid, long wsid, long subpiid, HashMap dsValues) {
        int count;
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        super.completeCallerWorkstep(pCtx, wsid, dsValues);
        SubProcessDAO.removeBySubProcessInstance(subpiid);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_3122", new Object[]{subpiid, pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()});
        }
        if ((count = SubProcessDAO.getCount(piid, wsid)) == 0) {
            pCtx.completeWorkstep(wsid);
        }
    }

    private void createLocalSubProcess(WFProcessContext pCtx, long wsid, SubProcessInstanceData instance) {
        WFNestedWS ws = (WFNestedWS)pCtx.getWorkstep(wsid);
        ProcessInstanceEBLocal ppi = pCtx.getProcessInstanceEB();
        ppi.getName();
        String wsName = ws.getName();
        String spiName = instance.getSubProcessAlias();
        String actualSubProcessName = instance.getSubProcessName();
        WFProcessContext subProcessContext = this.doCreateSubProcess(pCtx.getSession(), actualSubProcessName, spiName, SBMUtil.self().getStringPriority(ppi.getPriority()), ppi.getCreator(), instance.getInputSlotValues(), ws.isSynchronous(), instance.getCallerInfo());
        long subpiid = subProcessContext.getProcessInstanceID();
        SubProcessDAO.insert(pCtx.getProcessInstanceID(), pCtx.getProcessInstanceName(), wsid, pCtx.getWorkStepInstanceName(wsid), subpiid, subProcessContext.getProcessTemplateID(), instance.isRemoteSubProcess(), instance.getAppServerID());
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_3121", new Object[]{ppi.getId(), ppi.getProcessTemplateID(), wsName, ws.isSynchronous() ? "Synchronous" : "Asynchronous", subpiid, actualSubProcessName});
        }
        WFProcessContext spCtx = new WFProcessContext(pCtx.getSession(), subpiid);
        spCtx.activateProcessInstance();
    }

    private WFProcess getProcess(String processName) {
        WFProcess pt = null;
        if (ProcessControl.isProcessTemplateExist(processName)) {
            pt = ProcessControl.getProcessTemplate(processName);
        } else {
            pt = ProcessControl.getActiveProcessTemplate(processName);
            if (pt == null) {
                throw new BizLogicException("BizLogic_ERR_519", "WFNestedInstance.getProcess", new Object[]{processName});
            }
        }
        return pt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createRemoteSubProcess(WFProcessContext pCtx, long wsid, SubProcessInstanceData instance) {
        WFNestedWS ws = (WFNestedWS)pCtx.getWorkstep(wsid);
        String ppiName = pCtx.getProcessInstanceName();
        String wsName = pCtx.getWorkstep(wsid).getName();
        String piName = instance.getSubProcessAlias();
        String performer = instance.getPerformer();
        String actualSubP = instance.getSubProcessName();
        ProcessInstanceEBLocal ppi = pCtx.getProcessInstanceEB();
        HashMap callerInfo = instance.getCallerInfo();
        BLServer rBL = BLUtil.lookupRemoteBLServer((String)performer, (String)piName, (String)actualSubP);
        Session session = null;
        try {
            session = rBL.connect(SBMUtil.self().getGuestUser(), SBMUtil.self().getGuestPasswd());
            long subpiid2332 = rBL.createSubProcessInstance(session, actualSubP, piName, SBMUtil.self().getStringPriority(ppi.getPriority()), ppi.getCreator(), instance.getInputSlotValues(), ws.isSynchronous(), callerInfo);
            SubProcessDAO.insert(pCtx.getProcessInstanceID(), pCtx.getProcessInstanceName(), wsid, pCtx.getWorkStepInstanceName(wsid), subpiid2332, 0L, instance.isRemoteSubProcess(), instance.getAppServerID());
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_3121", new Object[]{ppi.getId(), ppi.getProcessTemplateID(), wsName, ws.isSynchronous() ? "Synchronous" : "Asynchronous", subpiid2332, actualSubP});
            }
            ProcessInstanceSBHome piSBHome = (ProcessInstanceSBHome)SBMControl.homeFactory.lookupHome(instance.getAppServerID(), ProcessInstanceSBHome.class);
            ProcessInstanceSB piSB = piSBHome.create();
            piSB.activate(session, subpiid2332);
        }
        catch (Exception e) {
            try {
                throw new BizLogicException("BizLogic_ERR_2602", "WFNestedInstance.createRemoteSubProcess", new Object[]{actualSubP, performer}, (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    rBL.disConnect(session);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            rBL.disConnect(session);
            return;
        }
        catch (Throwable subpiid2332) {
            return;
        }
    }

    public WFProcessContext doCreateSubProcess(Session ses, String ptName, String piPrefix, String priority, String creator, HashMap dsValues, boolean callback, HashMap callerInfo) {
        WFProcess pt = this.getProcess(ptName);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("PROCESSTEMPLATEID", pt.getID());
        attrs.put("PROCESSINSTANCENAME", piPrefix);
        attrs.put("PRIORITY", SBMControl.util.getIntegerPriority(priority));
        attrs.put("CREATOR", creator);
        if (callerInfo != null) {
            Long rootPtId;
            Long rootPiId = (Long)callerInfo.get("CALLERROOTINSTANCEID");
            if (rootPiId != null) {
                attrs.put("RPID", rootPiId);
            }
            if ((rootPtId = (Long)callerInfo.get("CALLERROOTTEMPLATEID")) != null) {
                attrs.put("RPTID", rootPtId);
            }
            if (callerInfo.containsKey("DEBUG_PROCESS_INSTANCE")) {
                Object debugObj = callerInfo.get("DEBUG_PROCESS_INSTANCE");
                attrs.put("DEBUG_PROCESS_INSTANCE", debugObj);
            }
        }
        attrs.put("SYNCHRONOUS_SUBPROCESS", callback);
        WFProcessContext pCtx = WFProcessContext.createProcessInstance(ses, attrs, dsValues, false);
        pCtx.setProcessInstanceCaller(callerInfo, callback);
        return pCtx;
    }

    public boolean isSubProcessActivated(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsi = pCtx.getWorkstepInstanceEB(wsid);
        return wsi.isSubProcessActivated() == 1;
    }

    public void setSubProcessActivated(WFProcessContext pCtx, long wsid, boolean flag) {
        WorkStepInstanceEBLocal wsi = pCtx.getWorkstepInstanceEB(wsid);
        if (flag) {
            wsi.setIsSubProcessActivated(1);
        } else {
            wsi.setIsSubProcessActivated(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void suspend(WFProcessContext pCtx, long wsID, boolean reactivateOnError, Throwable causedBy, String reason) {
        if (this.isSuspended(pCtx, wsID)) {
            BLControl.logger.warnKey("BizLogic_ERR_1669", new Object[]{pCtx.getWorkstep(wsID).getName(), pCtx.getProcessInstanceName()});
            return;
        }
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsID);
        int state = wsieb.getSuspendState();
        if (state == 5) {
            List subPIList = SubProcessDAO.findByWorkstepInstance(pCtx.getProcessInstanceID(), wsID);
            for (int ix = 0; ix < subPIList.size(); ++ix) {
                HashMap subPIInfo = (HashMap)subPIList.get(ix);
                long subpiid = (Long)subPIInfo.get("SUBPROCESS_INSTANCE_ID");
                boolean isRemote = (Boolean)subPIInfo.get("IS_REMOTE");
                String appServer = (String)subPIInfo.get("APPSERVER_ID");
                if (isRemote) {
                    BLServer remoteBL = null;
                    Session session = null;
                    BLServerHome blServerHome2333333332 = (BLServerHome)SBMControl.homeFactory.lookupHome(appServer, BLServerHome.class);
                    remoteBL = blServerHome2333333332.create();
                    session = remoteBL.connect(SBMControl.util.getGuestUser(), SBMControl.util.getGuestPasswd());
                    ProcessInstanceSBHome piSBHome = (ProcessInstanceSBHome)SBMControl.homeFactory.lookupHome(appServer, ProcessInstanceSBHome.class);
                    ProcessInstanceSB piSB = piSBHome.create();
                    piSB.suspend(session, subpiid);
                    try {
                        if (remoteBL == null) continue;
                        remoteBL.disConnect(session);
                    }
                    catch (Throwable blServerHome2333333332) {}
                    continue;
                    catch (Exception e) {
                        try {
                            BLControl.logger.errorKey("BizLogic_ERR_879", new Object[]{subpiid, pCtx.getProcessInstanceName(), wsieb.getName()}, (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            try {
                                if (remoteBL != null) {
                                    remoteBL.disConnect(session);
                                }
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            if (remoteBL == null) continue;
                            remoteBL.disConnect(session);
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                }
                WFProcessContext spCtx = new WFProcessContext(null, subpiid);
                WFProcessInstance.self().suspend(spCtx);
            }
        }
        super.suspend(pCtx, wsID, reactivateOnError, causedBy, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void resume(WFProcessContext pCtx, long wsID) {
        if (this.isActivated(pCtx, wsID)) {
            BLControl.logger.warnKey("BizLogic_ERR_1670", new Object[]{pCtx.getWorkstep(wsID).getName(), pCtx.getProcessInstanceName()});
            return;
        }
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsID);
        int state = wsieb.getSuspendState();
        if (state == 5) {
            List subPIList = SubProcessDAO.findByWorkstepInstance(pCtx.getProcessInstanceID(), wsID);
            for (int ix = 0; ix < subPIList.size(); ++ix) {
                HashMap subPIInfo = (HashMap)subPIList.get(ix);
                long subpiid = (Long)subPIInfo.get("SUBPROCESS_INSTANCE_ID");
                boolean isRemote = (Boolean)subPIInfo.get("IS_REMOTE");
                String appServer = (String)subPIInfo.get("APPSERVER_ID");
                if (isRemote) {
                    BLServer remoteBL = null;
                    Session session = null;
                    BLServerHome blServerHome2333333332 = (BLServerHome)SBMControl.homeFactory.lookupHome(appServer, BLServerHome.class);
                    remoteBL = blServerHome2333333332.create();
                    session = remoteBL.connect(SBMControl.util.getGuestUser(), SBMControl.util.getGuestPasswd());
                    ProcessInstanceSBHome piSBHome = (ProcessInstanceSBHome)SBMControl.homeFactory.lookupHome(appServer, ProcessInstanceSBHome.class);
                    ProcessInstanceSB piSB = piSBHome.create();
                    piSB.resume(session, subpiid);
                    try {
                        if (remoteBL == null) continue;
                        remoteBL.disConnect(session);
                    }
                    catch (Throwable blServerHome2333333332) {}
                    continue;
                    catch (Exception e) {
                        try {
                            BLControl.logger.errorKey("BizLogic_ERR_880", new Object[]{subpiid, pCtx.getProcessInstanceName(), wsieb.getName()}, (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            try {
                                if (remoteBL != null) {
                                    remoteBL.disConnect(session);
                                }
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            if (remoteBL == null) continue;
                            remoteBL.disConnect(session);
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                }
                WFProcessContext spCtx = new WFProcessContext(null, subpiid);
                WFNestedWS nestedWS = (WFNestedWS)pCtx.getWorkstep(wsID);
                if (nestedWS.isSynchronous()) {
                    spCtx.setResumeFromParent(true);
                }
                WFProcessInstance.self().resume(spCtx);
            }
        }
        super.resume(pCtx, wsID);
    }

    private static void createDSFolder(WFProcessContext pCtx, WFNestedWS ws) {
        String[] dSNames = ws.getSlotKeys();
        ArrayList<String> docDSNames = new ArrayList<String>();
        for (String dataslotName : dSNames) {
            WFDataslot ds = pCtx.getDataslot(dataslotName);
            if (!ds.isDocument()) continue;
            docDSNames.add(dataslotName);
        }
        if (!docDSNames.isEmpty()) {
            HashMap docDSList = pCtx.getSlotValue(docDSNames.toArray(new String[docDSNames.size()]));
            for (String dsName : docDSList.keySet()) {
                DocumentDS docDS = (DocumentDS)docDSList.get(dsName);
                if (!docDS.isNull()) continue;
                docDS = BLDocService.createDSFolder((DocumentDS)docDS);
                docDSList.put(dsName, docDS);
            }
            pCtx.updateSlotValue(docDSList);
        }
    }
}

