/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.email.EmailComposer;
import com.savvion.sbm.bizlogic.messaging.dao.BLMessagesDAO;
import com.savvion.sbm.bizlogic.server.DataslotOperation;
import com.savvion.sbm.bizlogic.server.WFAtomicInstance;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.TimerActionDAO;
import com.savvion.sbm.bizlogic.server.svo.DataSlot;
import com.savvion.sbm.bizlogic.server.svo.DataSlotList;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.MessageSubscriptionList;
import com.savvion.sbm.bizlogic.server.svo.SVOFactory;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BCLService;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDocClient;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.dms.DSContext;
import com.savvion.sbm.dms.svo.DocumentFolder;
import com.savvion.sbm.objectgraph.service.OGSFactory;
import com.savvion.sbm.objectgraph.service.ObjectGraphService;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.dcl.FCLService;
import com.tdiinc.common.Emailer.OutGoingMailException;
import com.tdiinc.common.Emailer.SendEmail;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSTools {
    private final WFProcessContext pctx;
    private long wsID = -1L;
    String wsName = "";

    protected JSTools(long piid, long wsid, String wsName) {
        this.pctx = new WFProcessContext(BLControl.getServerSession(), piid);
        this.pctx.getWorkstep(wsid);
        this.pctx.getProcess().getWorkstep(wsName);
        this.wsID = wsid;
        this.wsName = wsName;
    }

    JSTools(WFProcessContext ctx, long wsid) {
        this.wsID = wsid;
        this.pctx = ctx;
    }

    JSTools(WFProcessContext ctx, String name) {
        this.wsName = name;
        this.pctx = ctx;
    }

    public void sendEmail(String address, String subject, String content) {
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.infoKey("BizLogic_ERR_1004", new Object[]{this.pctx.getProcessInstanceName(), this.getWorkstepName(), address});
        }
        EmailComposer.self().sendEmailForJavaScript(address, subject, content);
    }

    public String getStringDataSlot(String dsName) {
        Object dsObj = this.pctx.getSlotValue(dsName);
        String strVal = "";
        if (dsObj != null) {
            strVal = dsObj.toString();
        }
        return strVal;
    }

    public String getURLDataSlot(String dsName) {
        Object dsObj = this.pctx.getSlotValue(dsName);
        String strVal = "";
        if (dsObj != null) {
            strVal = dsObj.toString();
        }
        return strVal;
    }

    public Object getObjectDataSlot(String dsName) {
        Object dsObj = this.pctx.getSlotValue(dsName);
        return dsObj;
    }

    public boolean getBooleanDataSlot(String dsName) {
        String className;
        Object dsObj = this.pctx.getSlotValue(dsName);
        boolean bval = false;
        if (dsObj != null && (className = dsObj.getClass().getName()).compareTo("java.lang.Boolean") == 0) {
            bval = (Boolean)dsObj;
        }
        return bval;
    }

    public long getLongDataSlot(String dsName) {
        String className;
        Object dsObj = this.pctx.getSlotValue(dsName);
        long lval = 0L;
        if (dsObj != null && (className = dsObj.getClass().getName()).compareTo("java.lang.Long") == 0) {
            lval = (Long)dsObj;
        }
        return lval;
    }

    public double getDoubleDataSlot(String dsName) {
        String className;
        Object dsObj = this.pctx.getSlotValue(dsName);
        double dval = 0.0;
        if (dsObj != null && (className = dsObj.getClass().getName()).compareTo("java.lang.Double") == 0) {
            dval = (Double)dsObj;
        }
        return dval;
    }

    public void putDataSlot(String dsName, Object dsValue) {
        this.pctx.updateSlotValue(dsName, dsValue);
    }

    public void writeLog(String msg) {
        if (BLControl.util.DEBUG_JSCRIPT) {
            BLControl.logger.debug((Object)("SCRIPT::Debug::Context(" + this.pctx.getProcessInstanceName() + ":" + this.getWorkstepName() + "):" + msg));
        }
    }

    public String getWorkstepName() {
        if ((this.wsName == null || this.wsName.trim().isEmpty()) && this.wsID > 0L) {
            this.wsName = this.pctx.getWorkStepInstanceName(this.wsID);
        }
        return this.wsName;
    }

    public String getProcessInstanceName() {
        return this.pctx.getProcessInstanceName();
    }

    public String getProcessTemplateName() {
        return this.pctx.getProcessTemplateName();
    }

    public DateTime getDateTimeDataSlot(String dsName) {
        return (DateTime)this.pctx.getSlotValue(dsName);
    }

    public Decimal getDecimalDataSlot(String dsName) {
        return (Decimal)this.pctx.getSlotValue(dsName);
    }

    public XML getXMLDataSlot(String dsName) {
        XML xmlObj = null;
        try {
            WFDataslot ds = this.pctx.getDataslot(dsName);
            if (ds == null || !ds.isXML()) {
                throw new BizLogicException("BizLogic_ERR_4516", "JSTools.getXMLDataSlot(dsName)", new Object[]{dsName, this.pctx.getProcessInstanceName(), this.wsName});
            }
            xmlObj = (XML)this.pctx.getSlotValue(dsName);
            String xml = this.pctx.getXMLContent(dsName);
            xmlObj.setContent(xml);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return xmlObj;
    }

    public String getXPathValue(String dsName, String xpath) {
        try {
            XML xmlObj = this.getXMLDataSlot(dsName);
            String content = xmlObj.getContent();
            if (content == null || content.trim().length() == 0) {
                throw new BizLogicException("BizLogic_ERR_3531", "JSTools.getXPathValue", new Object[]{this.pctx.getProcessInstanceName(), this.wsName, dsName});
            }
            return xmlObj.getXPathValue((Session)null, xpath);
        }
        catch (BizLogicException blx) {
            throw blx;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Map getXPathValue(String dsName, String[] xpaths) {
        try {
            XML xmlObj = this.getXMLDataSlot(dsName);
            String content = xmlObj.getContent();
            if (content == null || content.trim().length() == 0) {
                throw new BizLogicException("BizLogic_ERR_3531", "JSTools.getXPathValue[]", new Object[]{this.pctx.getProcessInstanceName(), this.wsName, dsName});
            }
            return xmlObj.getXPathValue((Session)null, xpaths);
        }
        catch (BizLogicException blx) {
            throw blx;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getXPathValue(String xmlDSName, String xpathStr, Map<String, String> nsMap) {
        String value = null;
        try {
            XML xmlObj = this.getXMLDataSlot(xmlDSName);
            String content = xmlObj.getContent();
            if (content == null || content.trim().length() == 0) {
                throw new BizLogicException("BizLogic_ERR_3531", "JSTools.getXPathValue(dsName, xpath, nsmap)", new Object[]{this.pctx.getProcessInstanceName(), this.wsName, xmlDSName});
            }
            value = xmlObj.getXPathValue(null, xpathStr, nsMap);
        }
        catch (BizLogicException blx) {
            throw blx;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        return value;
    }

    public String getXPathValues(String xmlDSName, String xpathStr, String nsmapStr) {
        Map<String, String> nsMap = this.parseNameSpaceString(nsmapStr);
        return this.getXPathValue(xmlDSName, xpathStr, nsMap);
    }

    public String getXMLContent(String dsName) {
        return this.pctx.getXMLContent(dsName);
    }

    public void setXPathValue(String dsName, String xpath, String value) {
        try {
            XML xmlObj = this.getXMLDataSlot(dsName);
            String content = xmlObj.getContent();
            if (content == null || content.trim().length() == 0) {
                throw new BizLogicException("BizLogic_ERR_3531", "JSTools.setXPathValue", new Object[]{this.pctx.getProcessInstanceName(), this.wsName, dsName});
            }
            xmlObj.setXPathValue(null, xpath, value);
            HashMap<String, XML> dsValues = new HashMap<String, XML>();
            dsValues.put(dsName, xmlObj);
            this.setDataSlotValues(dsValues);
        }
        catch (BizLogicException blx) {
            throw blx;
        }
        catch (Throwable th) {
            BLControl.logger.errorKey("BizLogic_ERR_3899", new Object[]{dsName, xpath, value}, th);
            throw new RuntimeException(th);
        }
    }

    public void setXPathValue(String dsName, Map xpathMap) {
        try {
            XML xmlObj = this.getXMLDataSlot(dsName);
            String content = xmlObj.getContent();
            if (content == null || content.trim().length() == 0) {
                throw new BizLogicException("BizLogic_ERR_3531", "JSTools.setXPathValue[]", new Object[]{this.pctx.getProcessInstanceName(), this.wsName, dsName});
            }
            xmlObj.setXPathValue(null, xpathMap);
            HashMap<String, XML> dsValues = new HashMap<String, XML>();
            dsValues.put(dsName, xmlObj);
            this.setDataSlotValues(dsValues);
        }
        catch (BizLogicException blx) {
            throw blx;
        }
        catch (Throwable th) {
            BLControl.logger.errorKey("BizLogic_ERR_3900", new Object[]{dsName, xpathMap}, th);
            throw new RuntimeException(th);
        }
    }

    public void setXPathValue(String xmlDSName, String xpathStr, String value, Map<String, String> nsMap) {
        try {
            XML xmlObj = this.getXMLDataSlot(xmlDSName);
            String content = xmlObj.getContent();
            if (content == null || content.trim().length() == 0) {
                throw new BizLogicException("BizLogic_ERR_3531", "JSTools.setXPathValue[]", new Object[]{this.pctx.getProcessInstanceName(), this.wsName, xmlDSName});
            }
            xmlObj.setXPathValue(null, xpathStr, value, nsMap);
            HashMap<String, XML> dsValues = new HashMap<String, XML>();
            dsValues.put(xmlDSName, xmlObj);
            this.setDataSlotValues(dsValues);
        }
        catch (BizLogicException blx) {
            throw blx;
        }
        catch (Throwable th) {
            BLControl.logger.errorKey("BizLogic_ERR_3901", new Object[]{xmlDSName, xpathStr, value, nsMap}, th);
            throw new RuntimeException(th);
        }
    }

    public void setXPathValues(String xmlDSName, String xpathStr, String nsmapStr, String values) {
        Map<String, String> nsMap = this.parseNameSpaceString(nsmapStr);
        this.setXPathValue(xmlDSName, xpathStr, values, nsMap);
    }

    public SendEmail getSendEmailObject(String charset) {
        SendEmail sendEmail = null;
        try {
            sendEmail = new SendEmail(SBMUtil.self().getOutgoingMailServer(), String.valueOf(SBMUtil.self().getOutgoingMailPort()), SBMUtil.self().getOutgoingMailUser(), SBMUtil.self().getOutgoingMailPassword(), charset);
        }
        catch (OutGoingMailException ogme) {
            throw ogme;
        }
        catch (Throwable th) {
            throw new RuntimeException("JSTools.getSendEmailObject(): Error creating SendEmail Object.", th);
        }
        return sendEmail;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        FCLService fcls = BCLService.getService((String)this.pctx.getProcessTemplateName());
        return fcls.loadClass(className);
    }

    public Class loadClass(String className, String path) throws ClassNotFoundException {
        FCLService fcls = BCLService.getService((String)this.pctx.getProcessTemplateName());
        if (path != null) {
            fcls.addPaths(new String[]{path});
        }
        return fcls.loadClass(className);
    }

    public long getProcessInstanceID() {
        return this.pctx.getProcessInstanceID();
    }

    public String getName() {
        return this.getWorkstepName();
    }

    public HashMap getDataSlotValue() {
        this.validateWorkStepID("JSTools.getDataSlotValues", new Object[]{"jst.getDataSlotValues()"});
        return WFWorkstepInstance.single().getSlotValues(this.pctx, this.wsID);
    }

    public HashMap getDataSlotValue(String[] dsNames) {
        if (dsNames == null || dsNames.length == 0) {
            return null;
        }
        return this.pctx.getSlotValue(dsNames);
    }

    public HashMap getDataSlotValue(Session blSession, long piid, String[] dsNames) {
        if (dsNames == null || dsNames.length == 0) {
            return null;
        }
        WFProcessContext newProcessCtx = new WFProcessContext(blSession, piid);
        return newProcessCtx.getSlotValue(dsNames);
    }

    public HashMap<String, Object> getDataSlotRealValue(List<String> dsNames) {
        if (dsNames == null || dsNames.isEmpty()) {
            return null;
        }
        String[] dsNameArr = dsNames.toArray(new String[0]);
        HashMap dsValues = this.getDataSlotValue(dsNameArr);
        HashMap updateMap = new HashMap();
        try {
            for (Map.Entry mapEntry : dsValues.entrySet()) {
                Object dsValue = mapEntry.getValue();
                if (dsValue == null) continue;
                if (dsValue instanceof DateTime) {
                    dsValue = ((DateTime)dsValue).getValue();
                } else if (dsValue instanceof Decimal) {
                    dsValue = ((Decimal)dsValue).getValue();
                } else if (dsValue instanceof XML) {
                    dsValue = ((XML)dsValue).getContent(this.pctx.getServerSession());
                }
                updateMap.put(mapEntry.getKey(), dsValue);
            }
            if (!updateMap.isEmpty()) {
                dsValues.putAll(updateMap);
            }
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_8106", "JSTools.getDataSlotRealValue()", new Object[]{dsNames, this.pctx.getProcessTemplateID(), this.pctx.getProcessInstanceID()}, th);
        }
        return dsValues;
    }

    public Object getDataSlotValue(String dsName) {
        if (dsName == null || dsName.length() == 0) {
            return null;
        }
        return this.pctx.getSlotValue(dsName);
    }

    public Object getDataSlotValue(Session blSession, long piid, String dsName) {
        if (dsName == null || dsName.length() == 0) {
            return null;
        }
        WFProcessContext newProcessCtx = new WFProcessContext(blSession, piid);
        return newProcessCtx.getSlotValue(dsName);
    }

    public Map<String, Map<String, Object>> getDataSlotMetadata(List<String> dsNames) {
        if (dsNames == null || dsNames.isEmpty()) {
            return null;
        }
        String[] dsNameArr = dsNames.toArray(new String[0]);
        return this.pctx.getProcess().getDataSlotMetaData(dsNameArr);
    }

    public HashMap getSlotValue(String[] dsNames) {
        if (dsNames == null || dsNames.length == 0) {
            return null;
        }
        HashMap dsValues = this.pctx.getSlotValue(dsNames);
        for (int ix = 0; ix < dsNames.length; ++ix) {
            Object value = dsValues.get(dsNames[ix]);
            if (value == null || !"<NULL>".equals(value)) continue;
            dsValues.put(dsNames[ix], null);
        }
        return dsValues;
    }

    public void setDataSlotValues(HashMap dsValues) {
        if (dsValues == null || dsValues.isEmpty()) {
            return;
        }
        this.pctx.updateSlotValue(dsValues);
    }

    public void setDataSlotValue(Session blSession, long piid, HashMap dsValues) {
        if (dsValues == null || dsValues.isEmpty()) {
            return;
        }
        WFProcessContext newProcessCtx = new WFProcessContext(blSession, piid);
        newProcessCtx.updateSlotValue(dsValues);
    }

    public HashMap getInputNames() {
        this.validateWorkStepID("JSTools.getInputNames", new Object[]{"jst.getInputNames()"});
        return this.pctx.getWorkstep(this.wsID).getInputSlotsMapping();
    }

    public HashMap getOutputNames() {
        this.validateWorkStepID("JSTools.getOutputNames", new Object[]{"jst.getOutputNames()"});
        return this.pctx.getWorkstep(this.wsID).getOutputSlotsMapping();
    }

    public HashMap getInputValues() {
        this.validateWorkStepID("JSTools.getInputValues", new Object[]{"jst.getInputValues()"});
        HashMap map = this.pctx.getWorkstepInputSlotValueList(this.wsID);
        return map;
    }

    public HashMap getOutputValues() {
        this.validateWorkStepID("JSTools.getOutputValues", new Object[]{"jst.getOutputValues()"});
        HashMap map = this.pctx.getWorkstepOutputSlotValueList(this.wsID);
        return map;
    }

    public Calendar getDueDate() {
        this.validateWorkStepID("JSTools.getDueDate", new Object[]{"jst.getDueDate()"});
        long dueDt = this.pctx.getWorkstepInstanceEB(this.wsID).getDuedate();
        return this.getCalendarDate(dueDt);
    }

    public Calendar calculateActivityDueDate() {
        this.validateWorkStepID("JSTools.getDueDate", new Object[]{"jst.getDueDate()"});
        long dueDt = this.pctx.calculateDueDate(this.wsID);
        return this.getCalendarDate(dueDt);
    }

    private Calendar getCalendarDate(long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        return cal;
    }

    public void setDueDate(long dueDate) {
        this.validateWorkStepID("JSTools.setDueDate", new Object[]{"jst.setDueDate(long dueDate)"});
        WFWorkstepInstance wsInstance = WFWorkstepInstance.getWorkstepInstance(this.pctx.getWorkstep(this.wsID).getType());
        wsInstance.setDuedate(this.pctx, this.wsID, dueDate, true);
    }

    public void setDueDate(DateTime dt) {
        if (dt == null) {
            return;
        }
        this.validateWorkStepID("JSTools.setDueDate", new Object[]{"jst.setDueDate(DateTime dt)"});
        WFWorkstepInstance wsInstance = WFWorkstepInstance.getWorkstepInstance(this.pctx.getWorkstep(this.wsID).getType());
        wsInstance.setDuedate(this.pctx, this.wsID, dt.getTime(), true);
    }

    public void setDueDate(Calendar cal) {
        if (cal == null) {
            return;
        }
        this.validateWorkStepID("JSTools.setDueDate", new Object[]{"jst.setDueDate(Calendar cal)"});
        WFWorkstepInstance wsInstance = WFWorkstepInstance.getWorkstepInstance(this.pctx.getWorkstep(this.wsID).getType());
        wsInstance.setDuedate(this.pctx, this.wsID, cal.getTime().getTime(), true);
    }

    public String getInstruction() {
        this.validateWorkStepID("JSTools.getInstruction", new Object[]{"jst.getInstruction()"});
        return this.pctx.getWorkstepRealInstruction(this.wsID);
    }

    public void setInstruction(String instruction) {
        if (instruction == null) {
            return;
        }
        this.validateWorkStepID("JSTools.setInstruction", new Object[]{"jst.setInstruction(String instruction)"});
        WFWorkstepInstance.single().setInstruction(this.pctx, this.wsID, instruction);
    }

    public String getPerformer() {
        this.validateWorkStepID("JSTools.getPerformer", new Object[]{"jst.getPerformer()"});
        return WFWorkstepInstance.single().getRealPerformer(this.pctx, this.wsID);
    }

    public void setPerformer(String performer) {
        if (performer == null) {
            return;
        }
        this.validateWorkStepID("JSTools.setPerformer", new Object[]{"jst.setPerformer(String performer)"});
        WFWorkstepInstance.single().setPerformer(this.pctx, this.wsID, performer);
    }

    public Object getPerformingApp() {
        this.validateWorkStepID("JSTools.getPerformingApp", new Object[]{"jst.getPerformingApp()"});
        return this.pctx.getWorkstepRealPerformingApp(this.wsID);
    }

    public Calendar getStartTime() {
        this.validateWorkStepID("JSTools.getStartTime", new Object[]{"jst.getStartTime()"});
        long timeStarted = this.pctx.getWorkstepInstanceEB(this.wsID).getTimeStarted();
        Date startTime = new Date(timeStarted);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        return cal;
    }

    public String getPriority() {
        this.validateWorkStepID("JSTools.getPriority", new Object[]{"jst.getPriority()"});
        return SBMControl.util.getStringPriority(WFWorkstepInstance.single().getPriority(this.pctx, this.wsID));
    }

    public void setPriority(String priority) {
        if (priority == null) {
            return;
        }
        this.validateWorkStepID("JSTools.setPriority", new Object[]{"jst.setPriority(String priority)"});
        WFWorkstepInstance.single().setPriority(this.pctx, this.wsID, priority);
    }

    public int getSubscribedMessageCount(String msgName) {
        if (msgName == null || msgName.trim().length() == 0) {
            return 0;
        }
        Map msgCountsInDB = this.getSubscribedMessageCount();
        Integer msgCount = (Integer)msgCountsInDB.get(msgName);
        if (msgCount == null) {
            return 0;
        }
        return msgCount;
    }

    public Map getSubscribedMessageCount() {
        this.validateWorkStepID("JSTools.getSubscribedMessageCount", new Object[]{"jst.getSubscribedMessageCount()"});
        return BLMessagesDAO.getMessageCount(this.pctx.getProcessInstanceID(), this.wsID);
    }

    public List getSubscribedMessageNames() {
        this.validateWorkStepID("JSTools.getSubscribedMessageNames", new Object[]{"jst.getSubscribedMessageNames()"});
        WFWorkstep ws = this.pctx.getWorkstep(this.wsID);
        MessageSubscriptionList msgSubscriptionList = ws.getMessageSubscriptionList();
        return msgSubscriptionList.getMessageNames();
    }

    public int getOverDueCount() {
        this.validateWorkStepID("JSTools.getOverDueCount", new Object[]{"jst.getOverDueCount()"});
        long piid = this.getProcessInstanceID();
        int overdueTimes = TimerActionDAO.getOverDueCount(piid, this.wsID);
        return ++overdueTimes;
    }

    public boolean isOverDueEnabled() {
        this.validateWorkStepID("JSTools.isOverDueEnabled", new Object[]{"jst.isOverDueEnabled()"});
        WFWorkstep ws = this.pctx.getWorkstep(this.wsID);
        return ws.isCheckDue();
    }

    private final void validateWorkStepID(String context, Object[] eargs) {
        if (this.wsID <= 0L) {
            if (eargs == null) {
                eargs = new Object[]{context};
            }
            throw new BizLogicException("BizLogic_ERR_1702", context, eargs);
        }
    }

    public DataSlot getDataSlot(String dsName) {
        return SVOFactory.getDataSlot(this.pctx.getSession(), this.pctx.getProcessInstanceID(), dsName);
    }

    public DataSlotList getDataSlotList(String[] dsNames) {
        return SVOFactory.getDataSlotList(this.pctx.getSession(), this.pctx.getProcessInstanceID(), dsNames);
    }

    public String getSBMHome() {
        return SBMUtil.self().getSBMHome();
    }

    public Session getSession() {
        return this.pctx.getSession();
    }

    public void incrementLongDS(String dsName, long value) {
        this.pctx.incrementLongSlotValue(dsName, value);
    }

    public void incrementLongDS(Session blSession, long piid, String longDSName, long incrementBy) {
        WFProcessContext newProcessCtx = new WFProcessContext(blSession, piid);
        newProcessCtx.incrementLongSlotValue(longDSName, incrementBy);
    }

    public void appendStringDS(String dsName, String value) {
        this.pctx.appendStringSlotValue(dsName, value);
    }

    private Map<String, String> parseNameSpaceString(String nsmapStr) {
        HashMap<String, String> ns = new HashMap<String, String>();
        String[] nsarr = nsmapStr.split("[<>]");
        for (int ix = 0; ix < nsarr.length; ++ix) {
            if (nsarr[ix].trim().isEmpty()) continue;
            String[] ans = nsarr[ix].split("[=]");
            if (ans.length != 2) {
                throw new RuntimeException("JSTools.parserNameSpaceString:Invalid NameSpace specified: " + nsmapStr);
            }
            ns.put(ans[0], ans[1]);
        }
        return ns;
    }

    public List<String> getCompletedWorkItemPerformer() {
        return this.getCompletedWorkItemPerformer(this.getWorkstepName());
    }

    public List<String> getCompletedWorkItemPerformer(String wsName) {
        if (wsName == null || wsName.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_4801", "JSTools.getCompletedWorkItemPerformer(wsName)");
        }
        long wsid = this.pctx.getProcess().getWorkstepID(wsName);
        return WFAtomicInstance.self().getCompletedWorkItemPerformer(this.pctx, wsid);
    }

    public DocumentDS setDocumentPath(String dsName, String customPath, boolean returnNullIfNotAllowed) {
        WFDataslot ds = this.pctx.getDataslot(dsName);
        if (ds == null || !ds.isDocument()) {
            throw new BizLogicException("BizLogic_ERR_4666", "JSTools.setDocumentPath()", new Object[]{dsName, this.pctx.getProcessInstanceName(), this.wsName});
        }
        DocumentDS docds = (DocumentDS)this.pctx.getSlotValue(dsName);
        return this.setDocumentPath(docds, customPath, returnNullIfNotAllowed);
    }

    public void setDocumentPath(DocumentDS docDS, String customPath) {
        this.setDocumentPath(docDS, customPath, false);
    }

    private DocumentDS setDocumentPath(DocumentDS docds, String customPath, boolean returnNullifNotAllowed) {
        String dsName = null;
        if (!SBMUtil.self().isCustomPathForDocDS()) {
            throw new BizLogicException("BizLogic_ERR_4665", "JSTools.setDocumentPath()");
        }
        if (customPath == null || customPath.trim().length() == 0) {
            throw new BizLogicException("The custom path expression cannot be null or empty.");
        }
        if (!this.canSetDocumentPath(docds)) {
            if (returnNullifNotAllowed) {
                return null;
            }
            dsName = docds.getDataslotName();
            throw new BizLogicException("BizLogic_ERR_4667", "JSTools.setDocumentPath()", new Object[]{dsName, this.pctx.getProcessInstanceName()});
        }
        dsName = docds.getDataslotName();
        try {
            DSContext dsCtx = new DSContext(null);
            String folderHierarchyPath = this.evaluateFolderPath(customPath);
            boolean isFolderExist = BLDocClient.getService().isFolderExistByPath(dsCtx, folderHierarchyPath);
            DocumentFolder dsFolder = null;
            dsFolder = isFolderExist ? BLDocClient.getService().getFolderByPath(dsCtx, folderHierarchyPath) : BLDocClient.getService().createFolderHierarchy(dsCtx, folderHierarchyPath);
            docds.setDSFolder(dsFolder);
            this.pctx.updateSlotValue(dsName, docds);
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.infoKey("BizLogic_ERR_4671", new Object[]{folderHierarchyPath, dsName, this.pctx.getProcessInstanceName()});
            }
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_4670", "JSTools.setDocumentPath()", new Object[]{dsName, customPath, this.pctx.getProcessInstanceName()}, th);
        }
        return docds;
    }

    public boolean canSetDocumentPath(String dsName) {
        if (!SBMUtil.self().isCustomPathForDocDS()) {
            return false;
        }
        WFDataslot ds = this.pctx.getDataslot(dsName);
        if (ds == null || !ds.isDocument()) {
            throw new BizLogicException("BizLogic_ERR_4666", "JSTools.setDocumentPath()", new Object[]{dsName, this.pctx.getProcessInstanceName(), this.wsName});
        }
        DocumentDS docds = (DocumentDS)this.pctx.getSlotValue(dsName);
        return docds.isNull();
    }

    public boolean canSetDocumentPath(DocumentDS docDS) {
        if (docDS == null) {
            throw new BizLogicException("The DocumentDS object passed cannot be null.");
        }
        if (!SBMUtil.self().isCustomPathForDocDS()) {
            return false;
        }
        return docDS.isNull();
    }

    public ObjectGraphService getExprEval() {
        return OGSFactory.getDefault();
    }

    private String evaluateFolderPath(String pathExprn) {
        String regex = "[$][{]([\\w\\W]*?)[}]";
        StringBuffer sb = new StringBuffer();
        Matcher matcher = Pattern.compile(regex).matcher(pathExprn);
        while (matcher.find()) {
            String folderName = matcher.group();
            String dsName = folderName.substring(2, folderName.length() - 1);
            Object value = this.pctx.getSlotValue(dsName);
            if (value == null) {
                throw new BizLogicException("BizLogic_ERR_4669", "JSTools.evaluateFolderPath()", new Object[]{dsName, pathExprn, null, this.pctx.getProcessInstanceName()});
            }
            if (!(value instanceof String) && !(value instanceof Number)) {
                throw new BizLogicException("BizLogic_ERR_4668", "JSTools.evaluateFolderPath()", new Object[]{dsName, pathExprn, "String,Number", this.pctx.getProcessInstanceName()});
            }
            String dsValue = value.toString();
            if (dsValue == null || dsValue.trim().length() == 0) {
                throw new BizLogicException("BizLogic_ERR_4669", "JSTools.evaluateFolderPath()", new Object[]{dsName, pathExprn, dsValue, this.pctx.getProcessInstanceName()});
            }
            matcher.appendReplacement(sb, dsValue);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public void copyDataslot(String srcDSName, String tgtDSName) {
        DataslotOperation.copy(this.pctx, srcDSName, tgtDSName);
    }
}

