/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.util.BizLogicException;
import java.io.Serializable;
import java.util.List;

public class DataSlotTableIndex
implements Serializable {
    static final long serialVersionUID = -5336534552123697745L;
    private final List<String> dsNames;
    private String blIndexName = null;
    private String bsIndexName = null;
    private boolean isBizLogicIndex = false;
    private String indexHashValue = null;

    public DataSlotTableIndex(List<String> dsNames, boolean isBizLogicIndex) {
        if (dsNames == null || dsNames.isEmpty()) {
            throw new RuntimeException();
        }
        this.dsNames = dsNames;
        this.isBizLogicIndex = isBizLogicIndex;
        this.indexHashValue = this.prepareIndexHashValue();
    }

    public String prepareIndexName(long ptid, String prefix) {
        return prefix + ptid + "_" + this.indexHashValue;
    }

    public void generateIndexNames(long ptid) {
        this.blIndexName = this.prepareIndexName(ptid, "bl");
        this.bsIndexName = this.prepareIndexName(ptid, "bs");
        this.validateIndexNames();
    }

    private String prepareIndexHashValue() {
        String concatedDSName = "";
        String separator = "";
        for (String dsName : this.dsNames) {
            concatedDSName = concatedDSName + separator + dsName;
            separator = "|";
        }
        int hashcode = concatedDSName.hashCode();
        String hashcodeStr = hashcode < 0 ? "n" + hashcode * -1 : "p" + hashcode;
        return hashcodeStr;
    }

    public String getIndexHashValue() {
        return this.indexHashValue;
    }

    public String getBizLogicIndexName() {
        return this.blIndexName;
    }

    public String getBizStoreIndexName() {
        return this.bsIndexName;
    }

    public List<String> getDataslotNames() {
        return this.dsNames;
    }

    public boolean hasBizLogicIndex() {
        return this.isBizLogicIndex;
    }

    private void validateIndexNames() {
        if (this.blIndexName != null && this.blIndexName.trim().length() > 18) {
            throw new BizLogicException("BizLogic_ERR_4825", "DataSlotTableIndex.validateIndexNames", new Object[]{this.blIndexName});
        }
        if (this.bsIndexName != null && this.bsIndexName.trim().length() > 18) {
            throw new BizLogicException("BizLogic_ERR_4826", "DataSlotTableIndex.validateIndexNames", new Object[]{this.bsIndexName});
        }
    }
}

