/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.scheduler;

import com.savvion.sbm.bizlogic.scheduler.DelegatingWork;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.logger.LoggerManager;
import com.savvion.sbm.util.logger.SBMLogger;
import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.quartz.spi.ThreadExecutor;

public class WorkManagerThreadExecutor
implements ThreadExecutor {
    private static final SBMLogger logger;
    private String workManagerName;
    private WorkManager workManager;

    public void execute(Thread thread) {
        DelegatingWork work = new DelegatingWork(thread);
        try {
            this.workManager.schedule((Work)work);
        }
        catch (WorkException e) {
            logger.error((Object)"Error attempting to schedule QuartzSchedulerThread", (Throwable)e);
        }
    }

    public void initialize() {
        try {
            this.workManager = (WorkManager)new InitialContext().lookup(this.workManagerName);
        }
        catch (NamingException e) {
            throw new IllegalStateException("Could not locate WorkManager: " + e.getMessage(), e);
        }
    }

    public void setWorkManagerName(String workManagerName) {
        this.workManagerName = workManagerName;
    }

    static {
        LoggerManager loggerManager = LoggerManager.self();
        SBMConstants.self().getClass();
        logger = loggerManager.createLogger("BizLogic", "sbmlog.conf", "BLMessages", WorkManagerThreadExecutor.class.getClassLoader());
    }
}

