/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging.subscriber;

import com.savvion.sbm.bizlogic.messaging.BLMessageException;
import com.savvion.sbm.bizlogic.messaging.MessageHandler;
import com.savvion.sbm.bizlogic.messaging.subscriber.BizMessage;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.ProcessContext;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.messaging.svo.MessageDescriptor;
import com.savvion.sbm.messaging.svo.MessageProperty;
import com.savvion.sbm.util.DOMParser;
import com.savvion.sbm.util.jax.XMLUtil;
import com.savvion.sbm.util.jax.XPathUtil;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class CreateInstanceHandler
implements MessageHandler {
    private static String CREATE_INSTANCE_MESSAGE_NAME = "CreateInstance";
    private static String TEMPLATE_NAME = "appName";
    private static String PRIORITY = "priority";
    private static String ALIAS = "alias";
    private static String DATASLOTS = "dataslots";
    private static String ERROR_INVALID_PT = "The message <%s> carries the application name as <%s>. This application does not exist";
    private static String ERROR_INVALID_SUBSCRIPTION = "The message <%s> carries the application name as <%s>. The start workstep of this application does not subscribe to the <" + CREATE_INSTANCE_MESSAGE_NAME + "> message";
    private static String ERROR_INVALID_MSGNAME = "The message name is invalid. It should be " + CREATE_INSTANCE_MESSAGE_NAME;
    private BizMessage message = null;
    private boolean discard = false;
    private String reason = null;

    @Override
    public void init() {
    }

    @Override
    public void setContext(ProcessContext context) {
    }

    @Override
    public HashMap execute(List bizMessage) {
        String ptName;
        this.message = (BizMessage)bizMessage.get(0);
        String msgName = this.getMessageName();
        WFProcess pt = this.getProcess(msgName, ptName = this.message.getProperty(TEMPLATE_NAME));
        if (pt == null) {
            this.discard = true;
            this.reason = this.getReason(ERROR_INVALID_PT, msgName, ptName);
            return null;
        }
        ptName = pt.getName();
        if (!pt.isInstantiateOnMessage(msgName)) {
            this.discard = true;
            this.reason = this.getReason(ERROR_INVALID_SUBSCRIPTION, msgName, ptName);
            return null;
        }
        HashMap attrs = this.getAttributes(ptName);
        HashMap dsValues = null;
        try {
            dsValues = this.getDSValues(pt);
        }
        catch (Throwable th) {
            this.discard = true;
            this.reason = th.getMessage();
            return null;
        }
        Session session = BLControl.getServerSession();
        WFProcessInstance.self().createInstance(session, attrs, dsValues, true);
        return null;
    }

    private String getMessageName() {
        String name = this.message.getMessageName();
        if (name == null || name.trim().length() == 0) {
            this.discard = true;
            this.reason = this.getReason(ERROR_INVALID_MSGNAME, new Object[0]);
        }
        return name;
    }

    private WFProcess getProcess(String msgName, String ptName) {
        WFProcess pt = null;
        pt = ProcessControl.isProcessTemplateExist(ptName) ? ProcessControl.getProcessTemplate(ptName) : ProcessControl.getActiveProcessTemplate(ptName);
        return pt;
    }

    private HashMap getAttributes(String ptName) {
        HashMap attrs = new HashMap();
        String priority = null;
        try {
            priority = this.message.getProperty(PRIORITY);
            if (priority != null && priority.trim().length() != 0) {
                BLConstants.single();
                attrs.put("PRIORITY", priority);
            }
        }
        catch (BLMessageException bLMessageException) {
            // empty catch block
        }
        String prefix = null;
        try {
            prefix = this.message.getProperty(ALIAS);
            if (prefix != null && prefix.trim().length() != 0) {
                BLConstants.single();
                attrs.put("PROCESSINSTANCENAME", prefix);
            }
        }
        catch (BLMessageException bLMessageException) {
            // empty catch block
        }
        attrs = WFProcessInstance.self().validateAttributesForCreateInstance(ptName, attrs);
        return attrs;
    }

    public HashMap getDSValues(WFProcess pt) throws Exception {
        WFWorkstep startWS = pt.getInitialWorkstep();
        String[] outputSlotNames = startWS.getOutputSlotsKeys();
        if (outputSlotNames == null || outputSlotNames.length == 0) {
            return null;
        }
        HashMap dsValueFromMessage = this.getDSValuesFromMessage();
        if (dsValueFromMessage == null) {
            return null;
        }
        HashMap dsValues = new HashMap();
        for (int ix = 0; ix < outputSlotNames.length; ++ix) {
            String outputDS = outputSlotNames[ix];
            if (!dsValueFromMessage.containsKey(outputDS)) continue;
            dsValues.put(outputDS, dsValueFromMessage.get(outputDS));
        }
        HashMap dsWithObjectValues = WFProcess.convertStringToObjectValue(pt, dsValues);
        return dsWithObjectValues;
    }

    private HashMap getDSValuesFromMessage() throws Exception {
        MessageDescriptor msgDescr = this.message.getMessageDescriptor();
        MessageProperty msgProp = msgDescr.getProperty(DATASLOTS);
        if (msgProp == null) {
            return null;
        }
        String payload = this.message.getPayload();
        Document doc = XMLUtil.getDocument((String)payload, (boolean)false);
        List dataslots = XPathUtil.evaluateToList((Document)doc, (String)msgProp.getXPath(), (Map)msgDescr.getNamespaces());
        HashMap<String, String> dsValueFromMessage = new HashMap<String, String>();
        for (int ix = 0; ix < dataslots.size(); ++ix) {
            String oneDSxml = (String)dataslots.get(ix);
            Document oneDSdoc = XMLUtil.getDocument((String)oneDSxml, (boolean)false);
            Element dsElement = oneDSdoc.getDocumentElement();
            String dsName = dsElement.getAttribute("name");
            String dsValue = DOMParser.getText((Node)dsElement);
            dsValueFromMessage.put(dsName, dsValue);
        }
        return dsValueFromMessage;
    }

    @Override
    public void destroy() {
    }

    @Override
    public HashMap getMessagesToDiscard() {
        if (this.discard) {
            HashMap<BizMessage, String> discardMessages = new HashMap<BizMessage, String>();
            discardMessages.put(this.message, this.reason);
            return discardMessages;
        }
        return null;
    }

    private String getReason(String reasonFormat, Object ... arguments) {
        StringBuilder sb = new StringBuilder(100);
        Formatter formatter = new Formatter(sb);
        formatter.format(reasonFormat, arguments);
        return sb.toString();
    }
}

