/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging.ejb;

import com.savvion.sbm.bizlogic.messaging.MessageControl;
import com.savvion.sbm.bizlogic.messaging.subscriber.BizJMSMessage;
import com.savvion.sbm.bizlogic.messaging.subscriber.MessageManager;
import com.savvion.sbm.bizlogic.server.WFMessageSubscriberInstance;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.MDBAdapter;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;

public class BLMessageReceiverMDB
extends MDBAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(Message message) {
        if (BLControl.isServerNotReady() && !WFMessageSubscriberInstance.self().processMessage(message, "jms/SBMMessageQueue")) {
            return;
        }
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_1200", "BLMessageReceiverMDB.onMessage()", new Object[0]);
        }
        if (message == null) {
            BLControl.logger.warnKey("BizLogic_ERR_3767", "BLMessageReceiverMDB.onMessage()", null);
            return;
        }
        long startTime = 0L;
        try {
            if (BLControl.util.BENCHMARK) {
                startTime = System.currentTimeMillis();
            }
            if (message instanceof ObjectMessage || message instanceof MapMessage) {
                if (BLControl.util.DEBUG_MESSAGING) {
                    MessageControl.self().logger.debugKey("BizLogic_ERR_2230", "BLMessageReceiverMDB.onMessage()", new Object[]{message});
                }
                MessageManager.processCustomMessage(message);
            } else {
                this.process(message);
            }
            if (!BLControl.util.BENCHMARK) return;
        }
        catch (Throwable th) {
            try {
                BLControl.logger.error((Object)"BLMessageReceiverMDB.onMessage()", th);
                if (!BLControl.util.BENCHMARK) return;
            }
            catch (Throwable throwable) {
                if (!BLControl.util.BENCHMARK) throw throwable;
                long endTime = System.currentTimeMillis();
                long totalTime = endTime - startTime;
                BLControl.logger.debugKey("BizLogic_ERR_715", new Object[]{"BLMessageReceiverMDB.onMessage()", totalTime});
                throw throwable;
            }
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            BLControl.logger.debugKey("BizLogic_ERR_715", new Object[]{"BLMessageReceiverMDB.onMessage()", totalTime});
            return;
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        BLControl.logger.debugKey("BizLogic_ERR_715", new Object[]{"BLMessageReceiverMDB.onMessage()", totalTime});
        return;
    }

    private void process(Message message) {
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2230", "BLMessageReceiverMDB.process()", new Object[]{message});
        }
        BizJMSMessage bizMsg = new BizJMSMessage(message);
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2226", "BLMessageReceiverMDB.process()", new Object[]{bizMsg.getMessageName()});
        }
        MessageManager.process(bizMsg);
    }
}

