/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.email;

import com.savvion.sbm.bizlogic.email.EmailTemplate;
import com.savvion.sbm.bizlogic.email.EmailUtil;
import com.savvion.sbm.bizlogic.email.RETextReplacer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class REManager {
    private static final String EMAIL_MSG_021 = "EMAIL_MSG_021";
    private static final String ESCAPE_XML = "escapeXml";
    static final String WHITESPACES = "\\s*?";
    static final String DATA_SEPERATOR = "=";
    static final String BLANK_SPACES = "[ \t]*?";
    static final String RE_SYSDSNAME = "(PCTX[.]\\w+?[[.]?\\w+?]*?)";
    static final String RE_SYSDSVALUE = "([\\w[\\W]]*?)";
    static final String RE_DSNAME = "(\\w+?[[.]?\\w+?]*?)";
    static final String RE_DSVALUE = "([\\w[\\W]]*?)";
    static final String RE_REPLACE = "[$][{][ ]*?([\\w[:.]]+?)[ ]*?[}]";
    private static REManager self;
    private final String regExpSysDS = this.getSystemDSPattern();
    private final String regExpDS = this.getDSPattern();
    private final String regExpEmailVar = this.getEmailVariablePattern();

    private REManager() {
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().debug("--------------Regular Expressions-------------");
            EmailUtil.self().debug("   Email Variables        : " + this.regExpEmailVar);
            EmailUtil.self().debug("   System Dataslots       : " + this.regExpSysDS);
            EmailUtil.self().debug("   User Defined Dataslots : " + this.regExpDS);
            EmailUtil.self().debug("----------------------------------------------");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized REManager self() {
        if (null != self) return self;
        Class<REManager> clazz = REManager.class;
        synchronized (REManager.class) {
            if (null != self) return self;
            self = new REManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    private String getSystemDSPattern() {
        StringBuilder sysDSBuffer = new StringBuilder();
        sysDSBuffer.append("\\");
        sysDSBuffer.append(EmailUtil.self().getEmailVarNamePrefix());
        sysDSBuffer.append(BLANK_SPACES);
        sysDSBuffer.append(RE_SYSDSNAME);
        sysDSBuffer.append(BLANK_SPACES);
        sysDSBuffer.append("\\");
        sysDSBuffer.append(EmailUtil.self().getEmailVarNameSuffix());
        sysDSBuffer.append(BLANK_SPACES);
        sysDSBuffer.append(DATA_SEPERATOR);
        sysDSBuffer.append(BLANK_SPACES);
        sysDSBuffer.append("\\");
        sysDSBuffer.append(EmailUtil.self().getEmailVarOutputPrefix());
        sysDSBuffer.append("([\\w[\\W]]*?)");
        sysDSBuffer.append("\\");
        sysDSBuffer.append(EmailUtil.self().getEmailVarOutputSuffix());
        return sysDSBuffer.toString();
    }

    private String getDSPattern() {
        StringBuilder dsBuffer = new StringBuilder();
        dsBuffer.append("\\");
        dsBuffer.append(EmailUtil.self().getEmailVarNamePrefix());
        dsBuffer.append(BLANK_SPACES);
        dsBuffer.append(RE_DSNAME);
        dsBuffer.append(BLANK_SPACES);
        dsBuffer.append("\\");
        dsBuffer.append(EmailUtil.self().getEmailVarNameSuffix());
        dsBuffer.append(BLANK_SPACES);
        dsBuffer.append(DATA_SEPERATOR);
        dsBuffer.append(BLANK_SPACES);
        dsBuffer.append("\\");
        dsBuffer.append(EmailUtil.self().getEmailVarOutputPrefix());
        dsBuffer.append("([\\w[\\W]]*?)");
        dsBuffer.append("\\");
        dsBuffer.append(EmailUtil.self().getEmailVarOutputSuffix());
        return dsBuffer.toString();
    }

    private String getEmailVariablePattern() {
        StringBuilder emailVar = new StringBuilder();
        emailVar.append("[ \t]*?[$](EMAIL[.](SUBJECT|CC|BCC))[ \t]*?=[ \t]*?(.+?)");
        emailVar.append("(");
        emailVar.append(EmailUtil.self().getLineSeperator());
        emailVar.append("|$)");
        return emailVar.toString();
    }

    public Map parse(String contents) {
        if (EmailUtil.isEmpty(contents)) {
            throw new IllegalArgumentException("Contents are empty");
        }
        HashMap data = new HashMap();
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().debug("Parsing System DataSlots from email");
        }
        Matcher matcherSysDS = Pattern.compile(this.regExpSysDS).matcher(contents);
        data.putAll(this.prepare(matcherSysDS));
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().debug("Parsing User defined DataSlots from email");
        }
        Matcher matcherDS = Pattern.compile(this.regExpDS).matcher(contents);
        data.putAll(this.prepare(matcherDS));
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().debug("Parsing finished.");
        }
        return data;
    }

    private Map prepare(Matcher matcher) {
        HashMap<String, String> parsedData = new HashMap<String, String>();
        while (matcher.find()) {
            String keyword = matcher.group(1);
            String value = matcher.group(2);
            if (null == keyword || keyword.length() == 0 || matcher.start(1) >= matcher.end(1)) {
                if (!EmailUtil.self().isDebug()) continue;
                EmailUtil.self().debug("EMAIL_MSG_112", new Object[]{keyword});
                continue;
            }
            if (matcher.start(2) > matcher.end(2)) {
                if (!EmailUtil.self().isDebug()) continue;
                EmailUtil.self().debug("EMAIL_MSG_113", new Object[]{keyword, value});
                continue;
            }
            if (EmailUtil.self().isDebug()) {
                EmailUtil.self().debug("EMAIL_MSG_114", new Object[]{keyword, value});
            }
            parsedData.put(keyword, REManager.format(value));
        }
        return parsedData;
    }

    public static String format(String val) {
        List remChars = EmailUtil.self().getRemoveChars();
        if (null != remChars) {
            Object[] data = remChars.toArray();
            for (int idx = 0; idx < data.length; ++idx) {
                String eatables = String.valueOf(data[idx]);
                val = EmailUtil.replace(val, eatables, "");
            }
        }
        return val;
    }

    public Map prepareTemplate(EmailTemplate template, Map ds, Map dsChoices, int wiState, String performerId) {
        String templateText = template.getContent();
        if (EmailUtil.isEmpty(templateText)) {
            EmailUtil.self().throwEmailException("EMAIL_MSG_238", new Object[0]);
        }
        HashMap<String, EmailTemplate> pInfo = new HashMap<String, EmailTemplate>();
        if (ds == null || ds.isEmpty()) {
            EmailUtil.self().warn("EMAIL_MSG_121", new Object[]{String.valueOf(wiState)});
            pInfo.put("EMAIL_TEMPLATE", template);
            return pInfo;
        }
        String text = templateText;
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().debug("Preparing e-mail template text.");
        }
        text = this.fillFormalReferences(text, ds);
        text = this.fillChoices(text, dsChoices);
        text = this.parseEmailVariables(text, pInfo);
        EmailTemplate preparedTemplate = new EmailTemplate(text, template.getContentType(), false);
        preparedTemplate.setHtmlImages(template.getHtmlImages());
        pInfo.put("EMAIL_TEMPLATE", preparedTemplate);
        return pInfo;
    }

    private String fillChoices(String templateText, Map dsChoices) {
        if (dsChoices.isEmpty()) {
            return templateText;
        }
        Matcher matcher = Pattern.compile(this.regExpDS).matcher(templateText);
        RETextReplacer replcer = new RETextReplacer(matcher, templateText);
        while (matcher.find()) {
            String matchedString = matcher.group(0);
            String dsName = matcher.group(1);
            String choices = (String)dsChoices.get(dsName);
            if (EmailUtil.isEmpty(choices)) continue;
            if (EmailUtil.self().isDebug()) {
                EmailUtil.self().debug("EMAIL_MSG_020", new Object[]{dsName, choices});
            }
            replcer.appendReplacement(matchedString + choices);
        }
        replcer.appendTrail();
        return replcer.getReplacedText();
    }

    public String fillFormalReferences(String templateText, Map ds) {
        Matcher refMatcher = Pattern.compile(RE_REPLACE).matcher(templateText);
        RETextReplacer replacer = new RETextReplacer(refMatcher, templateText);
        while (refMatcher.find()) {
            String dsValue;
            String matchedDs = refMatcher.group(1);
            boolean isEscapeXml = matchedDs.startsWith(ESCAPE_XML);
            String dataslotName = matchedDs;
            if (isEscapeXml) {
                dataslotName = StringUtils.trim((String)matchedDs.substring(matchedDs.indexOf(":") + 1));
            }
            if ((dsValue = (String)ds.get(dataslotName)) != null) {
                if (isEscapeXml) {
                    dsValue = StringEscapeUtils.escapeXml((String)dsValue);
                }
            } else {
                dsValue = "";
            }
            if (EmailUtil.self().isDebug()) {
                EmailUtil.self().debug(EMAIL_MSG_021, new Object[]{dataslotName, dsValue});
            }
            replacer.appendReplacement(dsValue);
        }
        replacer.appendTrail();
        return replacer.getReplacedText();
    }

    private String parseEmailVariables(String contents, Map emailVariables) {
        Matcher mchr = Pattern.compile(this.regExpEmailVar, 8).matcher(contents);
        StringBuffer buffer = new StringBuffer();
        while (mchr.find()) {
            if (null == mchr.group(1) || null == mchr.group(3)) continue;
            emailVariables.put(mchr.group(1).trim(), mchr.group(3).trim());
            if (EmailUtil.self().isDebug()) {
                EmailUtil.self().debug("EMAIL_MSG_022", new Object[]{mchr.group(1), mchr.group(3)});
            }
            mchr.appendReplacement(buffer, "");
        }
        mchr.appendTail(buffer);
        return buffer.toString();
    }

    public static synchronized void clean() {
        self = null;
    }
}

