/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.email;

import com.savvion.sbm.bizlogic.email.EmailUtil;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.URLHexCoder;
import com.tdiinc.common.Emailer.SendEmailRef;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public abstract class EmailAdapterSender {
    protected SendEmailRef sendEmail = null;
    protected boolean isEmailNotification = false;
    protected boolean isAssignTaskEmail = false;
    protected boolean isSuccessful = false;
    private String bizsiteURL = "";
    private String processInstanceName = "";
    private String processInstanceID = "";
    private String workstepName = "";
    private String workitemName = "";
    private String workitemID = "";
    private String performerName = "";
    private String performerEmailAddress = "";
    private String mailServer = "";
    private String fromAddress = "";
    private String workstepInstruction = "";
    private String systemMessage = "";
    private String documentRepositoryURL = "";
    protected Hashtable processContextDataList = new Hashtable();
    protected Hashtable inputDataslotList = new Hashtable();
    protected Hashtable outputDataslotList = new Hashtable();

    public EmailAdapterSender(String mailServer) throws Exception {
        if (BLUtil.sendEmailClass == null) {
            throw new RuntimeException("EmailAdapterSender class can not work without sending email class");
        }
        Constructor oConstructor = BLUtil.sendEmailClass.getConstructor(String.class);
        Object sendEmailClassObject = oConstructor.newInstance(new String(mailServer));
        this.sendEmail = (SendEmailRef)sendEmailClassObject;
    }

    public abstract void prepareEmailSubject();

    public abstract void prepareEmailContent();

    public final void prepareData() {
        Map.Entry entry2 = null;
        String key = null;
        for (Map.Entry entry2 : this.processContextDataList.entrySet()) {
            key = (String)entry2.getKey();
            BLConstants.single();
            if (key.equals("SYSTEMMESSAGE")) {
                this.systemMessage = (String)entry2.getValue();
                continue;
            }
            BLConstants.single();
            if (key.equals("PROCESSINSTANCENAME")) {
                this.processInstanceName = (String)entry2.getValue();
                continue;
            }
            BLConstants.single();
            if (key.equals("PROCESSINSTANCEID")) {
                this.processInstanceID = (String)entry2.getValue();
                continue;
            }
            BLConstants.single();
            if (key.equals("WORKSTEPNAME")) {
                this.workstepName = (String)entry2.getValue();
                continue;
            }
            BLConstants.single();
            if (key.equals("WORKITEMNAME")) {
                this.workitemName = (String)entry2.getValue();
                continue;
            }
            BLConstants.single();
            if (key.equals("WORKITEMID")) {
                this.workitemID = (String)entry2.getValue();
                continue;
            }
            BLConstants.single();
            if (key.equals("PERFORMERNAME")) {
                this.performerName = (String)entry2.getValue();
                continue;
            }
            BLConstants.single();
            if (key.equals("PERFORMEREMAILADDRESS")) {
                this.performerEmailAddress = (String)entry2.getValue();
                this.getMailSender().setMailTo(this.performerEmailAddress);
                continue;
            }
            BLConstants.single();
            if (key.equals("MAILSERVER")) {
                this.mailServer = (String)entry2.getValue();
                this.getMailSender().setSMTPHost(this.mailServer);
                continue;
            }
            BLConstants.single();
            if (key.equals("BIZSITEURL")) {
                this.bizsiteURL = (String)entry2.getValue();
                continue;
            }
            BLConstants.single();
            if (key.equals("FROMADDRESS")) {
                this.fromAddress = (String)entry2.getValue();
                this.getMailSender().setMailFrom(this.fromAddress);
                continue;
            }
            BLConstants.single();
            if (key.equals("WORKSTEPINSTRUCTION")) {
                this.workstepInstruction = (String)entry2.getValue();
                continue;
            }
            BLConstants.single();
            if (key.equals("DOCUMENTREPOSITORYURL")) {
                this.documentRepositoryURL = (String)entry2.getValue();
                continue;
            }
            BLConstants.single();
            if (key.equals("ISEMAILNOTIFICATION")) {
                this.isEmailNotification = Boolean.valueOf((String)entry2.getValue());
                continue;
            }
            BLConstants.single();
            if (!key.equals("ISASSIGNTASKEMAIL")) continue;
            this.isAssignTaskEmail = Boolean.valueOf((String)entry2.getValue());
        }
    }

    public final String getSystemMessage() {
        return this.systemMessage;
    }

    public final String getBizSiteURL() {
        return this.bizsiteURL;
    }

    public final boolean isEmailNotification() {
        return this.isEmailNotification;
    }

    public final boolean isAssginTaskEmail() {
        return this.isAssignTaskEmail;
    }

    public final String getWorkitemName() {
        return this.workitemName;
    }

    public final String getWorkitemID() {
        return this.workitemID;
    }

    public final String getWorkstepName() {
        return this.workstepName;
    }

    public final String getProcessInstanceName() {
        return this.processInstanceName;
    }

    public final String getProcessInstanceID() {
        return this.processInstanceID;
    }

    public final String getPerformerName() {
        return this.performerName;
    }

    public final String getPerformerEmailAddress() {
        return this.performerEmailAddress;
    }

    public final String getWorkstepInstruction() {
        return this.workstepInstruction;
    }

    public final String getDocumentRepositoryURL() {
        return this.documentRepositoryURL;
    }

    public Hashtable getInputDataslotList() {
        return this.inputDataslotList;
    }

    public Hashtable getOutputDataslotList() {
        return this.outputDataslotList;
    }

    public final String getDataslotType(String dsName) {
        String type = this.getDataslotInfoFromHashtable(this.inputDataslotList, dsName, "type");
        if (type == null && (type = this.getDataslotInfoFromHashtable(this.outputDataslotList, dsName, "type")) == null) {
            return null;
        }
        return type;
    }

    public final String getDataslotValue(String dsName) {
        String value = this.getDataslotInfoFromHashtable(this.inputDataslotList, dsName, "value");
        if (value == null && (value = this.getDataslotInfoFromHashtable(this.outputDataslotList, dsName, "value")) == null) {
            return null;
        }
        return value;
    }

    public void setProcessContextDataList(Hashtable processContextDataList) {
        this.processContextDataList = processContextDataList;
    }

    public void setInputDataslotList(Hashtable inputDataslotList) {
        this.inputDataslotList = inputDataslotList;
    }

    public void setOutputDataslotList(Hashtable outputDataslotList) {
        this.outputDataslotList = outputDataslotList;
    }

    public Hashtable attachDataslotDocuments() {
        Enumeration e;
        Hashtable h = new Hashtable();
        String dsName = "";
        Vector v = null;
        Object o = null;
        if (!this.inputDataslotList.isEmpty()) {
            e = this.inputDataslotList.keys();
            while (e.hasMoreElements()) {
                o = e.nextElement();
                dsName = o;
                v = (Vector)this.inputDataslotList.get(o);
                if (!"DOCUMENT".equals(v.elementAt(0).toString()) || h.get(dsName) != null) continue;
                h.put(dsName, v.elementAt(1));
                if (v.size() <= 2) continue;
                this.attachDocument((Vector)v.elementAt(2));
            }
        }
        if (!this.outputDataslotList.isEmpty()) {
            e = this.outputDataslotList.keys();
            while (e.hasMoreElements()) {
                o = e.nextElement();
                dsName = o;
                v = (Vector)this.outputDataslotList.get(o);
                if (!"DOCUMENT".equals(v.elementAt(0).toString()) || h.get(dsName) != null) continue;
                h.put(dsName, v.elementAt(1));
                if (v.size() <= 2) continue;
                this.attachDocument((Vector)v.elementAt(2));
            }
        }
        return h;
    }

    private void attachDocument(Vector vURLs) {
        for (int x = 0; x < vURLs.size(); ++x) {
            try {
                URL docURL = (URL)vURLs.elementAt(x);
                String docName = docURL.getFile();
                docName = docName.substring(docName.lastIndexOf(47) + 1);
                this.getMailSender().addFile(docURL, URLHexCoder.decode((String)docName));
                continue;
            }
            catch (Throwable th) {
                LoggerUtil.logStackTrace((String)"Exception in <EmailAdapterSender:attachDocument()>", (Throwable)th, null);
            }
        }
    }

    private String getDataslotInfoFromHashtable(Hashtable h, String dsName, String what) {
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!dsName.equals(o)) continue;
            Vector v = (Vector)h.get(o);
            if ("type".equals(what)) {
                return (String)v.elementAt(0);
            }
            if (!"value".equals(what)) continue;
            return (String)v.elementAt(1);
        }
        return null;
    }

    public SendEmailRef getMailSender() {
        return this.sendEmail;
    }

    public void setMailTo(String emailAddr) {
        this.getMailSender().setMailTo(emailAddr);
    }

    public void send() throws Exception {
        this.getMailSender().send();
    }

    public static String getSubjectPattern() {
        return EmailUtil.self().getSubjectPattern();
    }

    public void init() {
    }

    public void clean() {
    }
}

