/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent.mconsole;

import com.savvion.sbm.bizlogic.storeevent.mconsole.ConsoleTableHandler;
import com.savvion.sbm.bizlogic.storeevent.mconsole.MConsole;
import com.savvion.sbm.bizlogic.storeevent.mconsole.PopulatorDaemon;
import com.savvion.sbm.util.dcl.FCLService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.lang.reflect.Method;
import java.util.Vector;

public class SbmApp {
    private final String name;
    private final String id;
    private final PopulatorDaemon daemon;
    private Vector tables;
    private Class popClass;
    private Object popObject;
    private Method iMethod;
    private Method uMethod;
    private Method readAllTablesMethod;
    private final int initCounter;

    public SbmApp(String name, String id, PopulatorDaemon daemon, int counter) {
        this.name = name;
        this.id = id;
        this.daemon = daemon;
        this.initCounter = counter;
        this.tables = new Vector();
        String fullClassName = name + daemon.getPopClassName();
        String iMethodName = daemon.getIMethodName();
        String uMethodName = daemon.getUMethodName();
        String readAllTablesMethodName = daemon.getReadAllTablesMethodName();
        Class[] paramTypes = daemon.getParamTypes();
        try {
            FCLService fcl = new FCLService(null);
            this.popClass = fcl.loadClass(fullClassName);
            this.popObject = this.popClass.newInstance();
            this.iMethod = this.popClass.getMethod(iMethodName, paramTypes);
            this.uMethod = this.popClass.getMethod(uMethodName, paramTypes);
            this.readAllTablesMethod = this.popClass.getMethod(readAllTablesMethodName, Boolean.TYPE);
            this.readAllTablesMethod.invoke(this.popObject, MConsole.isReadingAllTablesEnabled);
            ConsoleTableHandler handler = new ConsoleTableHandler(this);
            this.tables = handler.getTableList();
            this.createTables();
            this.setLogger(fullClassName);
            MConsole.logger.debugKey("MConsole_MSG_005", new Object[]{fullClassName});
        }
        catch (ClassNotFoundException cnfe) {
            MConsole.logger.warnKey("MConsole_MSG_1514", "SbmApp.SbmApp()", new Object[]{fullClassName});
        }
        catch (NoSuchMethodException nsme) {
            MConsole.logger.errorKey("MConsole_MSG_1515", "SbmApp.SbmApp()", (Throwable)nsme, new Object[]{fullClassName});
        }
        catch (SecurityException se) {
            MConsole.logger.errorKey("MConsole_MSG_1516", "SbmApp.SbmApp()", (Throwable)se, new Object[]{fullClassName});
        }
        catch (InstantiationException ie) {
            MConsole.logger.errorKey("MConsole_MSG_1517", "SbmApp.SbmApp()", (Throwable)ie, new Object[]{fullClassName});
        }
        catch (IllegalAccessException iae) {
            MConsole.logger.errorKey("MConsole_MSG_1518", "SbmApp.SbmApp()", (Throwable)iae, new Object[]{fullClassName});
        }
        catch (Throwable th) {
            MConsole.logger.errorKey("MConsole_MSG_1519", "SbmApp.SbmApp()", th, new Object[]{fullClassName});
        }
    }

    public final void setLogger(String fullClassName) {
        try {
            Class[] paramTypes = new Class[]{SBMLogger.class};
            Method setLog = this.popClass.getMethod("setLogger", paramTypes);
            Object[] parameters = new Object[]{MConsole.logger};
            setLog.invoke(this.popObject, parameters);
        }
        catch (Throwable th) {
            MConsole.logger.errorKey("MConsole_MSG_1528", "SbmApp.setLogger()", th, new Object[]{fullClassName});
        }
    }

    public final void createTables() throws Exception {
        this.daemon.createTablesInDB(this.tables);
    }

    public void removeTables() throws Exception {
        this.daemon.dropTablesInDB(this.tables);
    }

    public void deleteStatusRows() {
        this.daemon.deleteStatusRowsInDB(this.id);
    }

    public void populateTables(int counter) throws Exception {
        this.daemon.populateTablesInDB(this.tables, counter);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.daemon.getEbmsapps() + "/" + this.name;
    }

    public Class getPopClass() {
        return this.popClass;
    }

    public Object getPopObject() {
        return this.popObject;
    }

    public Method getInsert() {
        return this.iMethod;
    }

    public Method getUpdate() {
        return this.uMethod;
    }

    public String getDB() {
        return this.daemon.getDBVendor();
    }

    public int getCounter() {
        return this.initCounter;
    }
}

