/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.server.ejb.ServiceLocal;
import com.savvion.sbm.bizlogic.server.ejb.ServiceLocalHome;
import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSDataslot;
import com.savvion.sbm.bizlogic.storeevent.BizStoreException;
import com.savvion.sbm.bizlogic.storeevent.BizStoreSchemaViewService;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMDAOService;
import com.savvion.sbm.util.SBMHomeFactory;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.config.SBMConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;

public class BSUtil
extends SBMDAOService {
    private static BSUtil self;
    private Statement stmt_any;
    public String DS_JNDI_NAME = "BizStoreDB";
    public String SYNC_DS_JNDI_NAME = "BizLogicDB";
    public int MAX_CHOICES_SIZE = 1750;
    static final String PATTERN_PT_NAME = "<PT_NAME>";
    static final String PATTERN_DS_TABLE_NAME = "<DS_TABLE_NAME>";
    static final String PATTERN_VIEW_NAME = "<PT_VIEW_NAME>";
    static final String PATTERN_COLUMN_NAME = "<COLUMN_NAME>";
    static final String PATTERN_ALIAS_NAME = "<ALIAS_NAME>";
    static final String PT_NAME = "PT_NAME";
    static final String PT_ID = "PT_ID";
    static final String INSTANCE_DS = "INSTANCE_DS";
    static final String MONITOR_DS = "MONITOR_DS";
    static final String COLUMN_NAME = "COLUMN_NAME";
    static final String ALIAS_NAME = "ALIAS_NAME";
    static final String VIEW_NAME = "VIEW_NAME";
    static final String ATOMIC = "ATOMIC";
    static final String EXTERNAL = "EXTERNAL";
    static final String NESTED = "NESTED";
    static final String WEBSERVICE = "WEBSERVICE";
    static final String SUBSCRIBER = "SUBSCRIBER";
    static final String PUBLISHER = "PUBLISHER";
    static final String WS_VIEW_COLUMN_PREFIX = "WS_";
    public static final double PRECISION = 1.0E-8;

    private BSUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BSUtil self() {
        if (self != null) return self;
        Class<BSUtil> clazz = BSUtil.class;
        synchronized (BSUtil.class) {
            if (self != null) return self;
            self = new BSUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public final Connection getBSConnection() throws SQLException {
        if (BSControl.isSyncBizStore()) {
            return BSUtil.getConnection((String)this.SYNC_DS_JNDI_NAME);
        }
        return BSUtil.getConnection((String)this.DS_JNDI_NAME);
    }

    public final void closeBSConnection(Connection conn) {
        BSUtil.clean(null, null, (Connection)conn);
    }

    public final void executeDDLStmt(String sql) throws Exception {
        this.executeDDLStmt(sql, false);
    }

    public final void executeDDLStmt(String sql, boolean alwaysNewTX) {
        Connection conn;
        block6: {
            conn = null;
            try {
                if (BSControl.DEBUG_SQL) {
                    BSControl.logger.debugKey("BizStore_MSG_001", new Object[]{sql});
                }
                if (SBMControl.dbmap.isDDLAutocommit() || alwaysNewTX) {
                    ServiceLocalHome serviceHome = (ServiceLocalHome)SBMHomeFactory.self().lookupLocalHome(ServiceLocalHome.class);
                    ServiceLocal serviceLocal = serviceHome.create();
                    serviceLocal.executeDDL(sql);
                    break block6;
                }
                conn = this.getBSConnection();
                this.stmt_any = conn.createStatement();
                this.stmt_any.execute(sql);
            }
            catch (Throwable th) {
                try {
                    throw new BizStoreException("BizStore_MSG_1535", "BSUtil.executeDDLStmt()", new Object[]{sql, alwaysNewTX}, th);
                }
                catch (Throwable throwable) {
                    SBMDAOService.clean(null, (Statement)this.stmt_any, conn);
                    throw throwable;
                }
            }
        }
        SBMDAOService.clean(null, (Statement)this.stmt_any, (Connection)conn);
    }

    public static void updateBSNewDataSlotsForPTR(ArrayList names, ArrayList types, ArrayList values, CommonEvent event, boolean isGlobal) throws Exception {
        BSDataslot.updateDSTable(names, types, values, event, isGlobal);
    }

    public static final void setValue(PreparedStatement stmt, int type, int pos, Object o) throws SQLException {
        int sqltype = type;
        if (o == null) {
            stmt.setNull(pos, sqltype);
        } else {
            if (type == -3) {
                byte[] ba = BSUtil.convertToBytes((Object)o);
                stmt.setBinaryStream(pos, (InputStream)new ByteArrayInputStream(ba), ba.length);
                return;
            }
            if (o instanceof String) {
                switch (type) {
                    case -5: {
                        long lg = Long.valueOf((String)o);
                        stmt.setLong(pos, lg);
                        break;
                    }
                    case 7: {
                        double db = Double.valueOf((String)o);
                        stmt.setDouble(pos, db);
                        break;
                    }
                    case -7: {
                        boolean bo = Boolean.valueOf((String)o);
                        BSUtil.setBoolean(stmt, pos, bo);
                        break;
                    }
                    case 1: 
                    case 12: {
                        String st = (String)o;
                        stmt.setString(pos, st);
                        break;
                    }
                    case 91: 
                    case 93: {
                        Timestamp ts = BSUtil.stringToTimestamp((String)o);
                        stmt.setTimestamp(pos, ts);
                        break;
                    }
                    case 3: {
                        BigDecimal bd = new BigDecimal((String)o);
                        stmt.setBigDecimal(pos, bd);
                        break;
                    }
                }
            } else {
                switch (type) {
                    case -5: {
                        stmt.setLong(pos, (Long)o);
                        break;
                    }
                    case 7: {
                        stmt.setDouble(pos, (Double)o);
                        break;
                    }
                    case -7: {
                        BSUtil.setBoolean(stmt, pos, (Boolean)o);
                        break;
                    }
                    case 91: 
                    case 93: {
                        stmt.setTimestamp(pos, (Timestamp)o);
                        break;
                    }
                    case 3: {
                        stmt.setBigDecimal(pos, (BigDecimal)o);
                        break;
                    }
                    default: {
                        stmt.setObject(pos, o);
                    }
                }
            }
        }
    }

    public static void setBoolean(PreparedStatement stmt, int pos, boolean bool) throws SQLException {
        if (ServiceLocator.self().isPostgresql()) {
            if (bool) {
                stmt.setInt(pos, 1);
            } else {
                stmt.setInt(pos, 0);
            }
        } else {
            stmt.setBoolean(pos, bool);
        }
    }

    public static final void setValue(PreparedStatement stmt, int pos, String val) throws SQLException {
        if (val == null || "<NULL>".equals(val)) {
            stmt.setNull(pos, 12);
        } else {
            stmt.setString(pos, val);
        }
    }

    public static final void setLongAsciiValue(PreparedStatement stmt, int pos, String val) throws SQLException {
        ByteArrayInputStream byteStream = null;
        try {
            if (val == null) {
                stmt.setNull(pos, 12);
            } else if (SBMControl.dbmap.getDatabaseName().equalsIgnoreCase("oracle")) {
                stmt.setCharacterStream(pos, (Reader)new StringReader(val), val != null ? val.length() : 0);
            } else if (val != null) {
                byte[] ba = val.getBytes();
                byteStream = new ByteArrayInputStream(ba);
                stmt.setAsciiStream(pos, (InputStream)byteStream, ba.length);
            }
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            BSUtil.clean(byteStream, null, null, null);
        }
    }

    public static final void setLongBinaryValue(PreparedStatement stmt, int pos, byte[] val) throws SQLException {
        ByteArrayInputStream byteStream = null;
        try {
            if (val == null) {
                stmt.setNull(pos, 12);
            } else {
                byteStream = new ByteArrayInputStream(val);
                stmt.setBinaryStream(pos, (InputStream)byteStream, val.length);
            }
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            BSUtil.clean((InputStream)byteStream, null, null, null);
        }
    }

    public static final Timestamp stringToTimestamp(String str) {
        Timestamp ts = null;
        if (str != null && !str.isEmpty()) {
            long t = Long.valueOf(str);
            ts = new Timestamp(t);
        }
        return ts;
    }

    public static final long stringToLong(String str) {
        long ln = -1L;
        if (str != null) {
            ln = Long.valueOf(str);
        }
        return ln;
    }

    public static final boolean isDuplicatedObjectException(SQLException sqle) {
        if (BSControl.DEBUG_ENGINE) {
            BSControl.logger.debug((Object)("SQLException, vendor error code = " + sqle.getErrorCode()));
        }
        String dbmsname = SBMControl.dbmap.getDatabaseName();
        int errCode = sqle.getErrorCode();
        boolean res = false;
        if (dbmsname.equalsIgnoreCase("mssqlserver")) {
            res = errCode == 2627 || errCode == 2714;
        } else if (dbmsname.equalsIgnoreCase("oracle")) {
            res = errCode == 1 || errCode == 955;
        } else if (dbmsname.equalsIgnoreCase("ibmdb2")) {
            res = errCode == -803 || errCode == -601;
        } else if (dbmsname.equalsIgnoreCase("sybase")) {
            res = errCode == 2601 || errCode == 2714;
        } else if ("openedge".equalsIgnoreCase(dbmsname)) {
            res = errCode == 7518 || errCode == 7535;
        } else if ("postgresql".equalsIgnoreCase(dbmsname)) {
            res = errCode == 23505 || errCode == 42710;
        }
        return res;
    }

    public Double validateNumberValue(double minval, double maxval, double confvalue, double defaultval, String paramName) {
        Double val = null;
        if (confvalue >= minval && confvalue <= maxval) {
            val = new Double(confvalue);
        } else {
            val = new Double(defaultval);
            BSControl.logger.infoKey("BizStore_MSG_520", new Object[]{paramName, new Double(confvalue), val});
        }
        return val;
    }

    static boolean isPTViewExists(String templateName, long ptid) {
        return BSUtil.isViewExists(BizStoreSchemaViewService.getProcessViewName(templateName));
    }

    static boolean isWorkstepViewExists(String templateName, long ptid) {
        return BSUtil.isViewExists(BizStoreSchemaViewService.getWSViewName(templateName));
    }

    static boolean isViewExists(String viewName) {
        boolean isViewExist = false;
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            isViewExist = BSUtil.checkViewExists((Connection)conn, (String)viewName);
        }
        catch (Throwable th) {
            throw new RuntimeException("Error while checking if view:< " + viewName + "> exists in database.", th);
        }
        finally {
            BSUtil.clean(null, null, (Connection)conn);
        }
        return isViewExist;
    }

    static void logDynamicViewCreateError(String createViewSql, String templateName, long ptid, String viewType) {
        StringBuilder sb = new StringBuilder(SBMConfig.self().getSBMHome());
        sb.append("/temp");
        String tempDirName = sb.toString();
        sb.append("/").append(templateName);
        sb.append(".sql.").append(System.currentTimeMillis());
        String tempFileName = sb.toString();
        try {
            File tempDir = new File(tempDirName);
            if (tempDir.exists()) {
                StringBuilder content = new StringBuilder();
                String msg = BSControl.msgFactory.lookup("BizStore_MSG_1607", new Object[]{templateName, ptid, viewType, 25, tempFileName});
                content.append(msg);
                content.append(System.getProperty("line.separator"));
                content.append(System.getProperty("line.separator"));
                content.append("View creation SQL:");
                content.append(System.getProperty("line.separator"));
                content.append("==================");
                content.append(System.getProperty("line.separator"));
                content.append(createViewSql);
                FileUtil.saveContent((String)content.toString(), (File)new File(tempFileName));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BSControl.logger.errorKey("BizStore_MSG_1607", new Object[]{templateName, ptid, viewType, 25, tempFileName});
    }

    public static final synchronized void close() {
        self = null;
    }
}

