/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.storeevent.BSCWorkItem;
import com.savvion.sbm.bizlogic.storeevent.BSCache;
import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSDataslot;
import com.savvion.sbm.bizlogic.storeevent.BSProcessInstance;
import com.savvion.sbm.bizlogic.storeevent.BSProcessNotes;
import com.savvion.sbm.bizlogic.storeevent.BSProcessStatus;
import com.savvion.sbm.bizlogic.storeevent.BSProcessTemplate;
import com.savvion.sbm.bizlogic.storeevent.BSUtil;
import com.savvion.sbm.bizlogic.storeevent.BSWIResourceUsage;
import com.savvion.sbm.bizlogic.storeevent.BSWorkitem;
import com.savvion.sbm.bizlogic.storeevent.BSWorkstepInstance;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.bizlogic.storeevent.BizStoreException;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.SBMDAOService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Set;

public class BSProcess {
    protected static final String SQL_UPDATE_PIP = "UPDATE PROCESSINSTANCE SET PRIORITY=? WHERE PROCESS_INSTANCE_ID = ? ";
    private static final String SQL_SELECT_PT = "SELECT PROCESS_TEMPLATE_ID, PROCESS_TEMPLATE_NAME FROM PROCESSTEMPLATE";
    private static final String SQL_SELECT_PTNAME = "SELECT PROCESS_TEMPLATE_NAME FROM PROCESSTEMPLATE where PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_SELECT_DSM = "SELECT DATASLOT_NAME, DATASLOT_TYPE, GLOBAL_FLAG from PROCESSDATAINFO where PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_SELECT_PRI = "SELECT NAME, UNIT_COST FROM PROCESSRESOURCEINFO WHERE PROCESS_TEMPLATE_ID=?";
    private static final String SQL_SELECT_ALLPRI = "SELECT PROCESS_TEMPLATE_ID, NAME, UNIT_COST FROM PROCESSRESOURCEINFO ORDER BY PROCESS_TEMPLATE_ID";
    protected static BSCache ptCache;
    private static HashMap<Long, HashMap<String, Double>> ptResourceMap;
    private static long lastErrorEventID;

    public static void loadCache() throws SQLException {
        ptCache.clear();
        BSProcess.loadPTInfo();
        if (BSControl.RESOURCE_USAGE) {
            ptResourceMap.clear();
            BSProcess.loadAllProcessResourceInfo();
            if (BSControl.DEBUG_ENGINE) {
                BSControl.logger.debugKey("BizStore_MSG_006", new Object[]{ptResourceMap});
            }
        }
    }

    public static void updateCache(Object ptid) throws SQLException {
        if (BSControl.DEBUG_ENGINE) {
            BSControl.logger.debugKey("BizStore_MSG_005", new Object[]{ptid});
        }
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement pstmtSelectPTName = null;
        try {
            conn = BSControl.util.getBSConnection();
            pstmtSelectPTName = conn.prepareStatement(SQL_SELECT_PTNAME);
            long id = (Long)ptid;
            pstmtSelectPTName.setLong(1, id);
            rs = pstmtSelectPTName.executeQuery();
            if (rs.next()) {
                String templateName = rs.getString(1);
                ptCache.addPTName(id, templateName);
                BSProcess.loadMetadata(id);
            }
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{pstmtSelectPTName, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(rs, pstmtSelectPTName, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean((ResultSet)rs, (Statement)pstmtSelectPTName, (Connection)conn);
    }

    private static void loadPTInfo() throws SQLException {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement pstmtSelectPT = null;
        try {
            conn = BSControl.util.getBSConnection();
            pstmtSelectPT = conn.prepareStatement(SQL_SELECT_PT);
            rs = pstmtSelectPT.executeQuery();
            while (rs.next()) {
                long ptid = rs.getLong(1);
                String templateName = rs.getString(2);
                ptCache.addPTName(ptid, templateName);
                BSProcess.loadMetadata(ptid);
            }
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_SELECT_PT, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(rs, pstmtSelectPT, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean((ResultSet)rs, (Statement)pstmtSelectPT, (Connection)conn);
    }

    private static void loadMetadata(long ptid) throws SQLException {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement pstmtSelectDSMetadata = null;
        try {
            boolean hasIDS = false;
            boolean hasGDS = false;
            conn = BSControl.util.getBSConnection();
            pstmtSelectDSMetadata = conn.prepareStatement(SQL_SELECT_DSM);
            pstmtSelectDSMetadata.setLong(1, ptid);
            rs = pstmtSelectDSMetadata.executeQuery();
            while (rs.next()) {
                String dataslotName = rs.getString(1);
                int dsType = rs.getInt(2);
                String isGlobal = rs.getString(3);
                if ("t".equalsIgnoreCase(isGlobal)) {
                    hasGDS = true;
                } else if ("f".equalsIgnoreCase(isGlobal)) {
                    hasIDS = true;
                }
                ptCache.addDSType(ptid, dataslotName, dsType);
            }
            ptCache.addGlobalDSInfo(ptid, hasGDS);
            ptCache.addInstanceDSInfo(ptid, hasIDS);
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_SELECT_DSM, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(rs, pstmtSelectDSMetadata, conn);
                throw throwable;
            }
        }
        SBMDAOService.clean((ResultSet)rs, (Statement)pstmtSelectDSMetadata, (Connection)conn);
    }

    public static boolean ptHasResources(long ptId) throws SQLException {
        if (!ptResourceMap.containsKey(ptId)) {
            BSProcess.loadProcessResourceInfo(ptId);
        }
        return !ptResourceMap.get(ptId).isEmpty();
    }

    public static final HashMap<String, Double> getProcessResourceInfo(long ptId) throws SQLException {
        if (!BSProcess.ptHasResources(ptId)) {
            return null;
        }
        return ptResourceMap.get(ptId);
    }

    private static final void unloadProcessResourceInfo(CommonEvent event) {
        long ptId = BizLogicEventMap.getProcessTemplateID(event);
        ptResourceMap.remove(ptId);
    }

    private static final void loadAllProcessResourceInfo() throws SQLException {
        HashMap<Object, Object> resourceCost = null;
        Connection conn = null;
        ResultSet rsSelectAllPRI = null;
        PreparedStatement pstmtSelectAllPRI = null;
        try {
            conn = BSControl.util.getBSConnection();
            pstmtSelectAllPRI = conn.prepareStatement(SQL_SELECT_ALLPRI);
            rsSelectAllPRI = pstmtSelectAllPRI.executeQuery();
            while (rsSelectAllPRI.next()) {
                Long ptId = rsSelectAllPRI.getLong("PROCESS_TEMPLATE_ID");
                String resourceName = rsSelectAllPRI.getString("NAME");
                Double unitCost = rsSelectAllPRI.getDouble("UNIT_COST");
                resourceCost = BSProcess.ptHasResources(ptId) ? ptResourceMap.get(ptId) : new HashMap();
                resourceCost.put(resourceName, unitCost);
                if (ptResourceMap.containsKey(ptId)) continue;
                ptResourceMap.put(ptId, resourceCost);
            }
            Set<Long> ptIdSet = ptCache.getAllPtId();
            for (Long ptIdCache : ptIdSet) {
                if (ptResourceMap.containsKey(ptIdCache)) continue;
                ptResourceMap.put(ptIdCache, new HashMap());
            }
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_SELECT_ALLPRI, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(rsSelectAllPRI, pstmtSelectAllPRI, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean((ResultSet)rsSelectAllPRI, (Statement)pstmtSelectAllPRI, (Connection)conn);
    }

    private static final void loadProcessResourceInfo(long ptId) throws SQLException {
        if (BSControl.DEBUG_ENGINE) {
            BSControl.logger.debugKey("BizStore_MSG_007", new Object[]{ptId});
        }
        HashMap<String, Double> resourceCost = new HashMap<String, Double>();
        Connection conn = null;
        ResultSet rsSelectPRI = null;
        PreparedStatement pstmtSelectPRI = null;
        try {
            conn = BSControl.util.getBSConnection();
            pstmtSelectPRI = conn.prepareStatement(SQL_SELECT_PRI);
            pstmtSelectPRI.setLong(1, ptId);
            rsSelectPRI = pstmtSelectPRI.executeQuery();
            while (rsSelectPRI.next()) {
                String resourceName = rsSelectPRI.getString("NAME");
                Double unitCost = rsSelectPRI.getDouble("UNIT_COST");
                resourceCost.put(resourceName, unitCost);
            }
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_SELECT_PRI, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(rsSelectPRI, pstmtSelectPRI, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean((ResultSet)rsSelectPRI, (Statement)pstmtSelectPRI, (Connection)conn);
        ptResourceMap.put(ptId, resourceCost);
    }

    private static final void loadProcessResourceInfo(CommonEvent event) throws SQLException {
        long ptId = BizLogicEventMap.getProcessTemplateID(event);
        BSProcess.loadProcessResourceInfo(ptId);
    }

    public static final void storeBizLogicData(CommonEvent event) throws BizStoreException {
        String eventValue = event.getValue();
        long eventID = event.getEventID();
        try {
            if (BSControl.PRINT_EVENT) {
                BSControl.logger.debug((Object)(event.toLogFormat() + "\n"));
            }
            int evtype = BizLogicEventMap.getType(event);
            switch (evtype) {
                case 1: {
                    BSProcessTemplate.onCreate(event);
                    break;
                }
                case 2: {
                    if (BSControl.RESOURCE_USAGE) {
                        BSProcess.loadProcessResourceInfo(event);
                    }
                    BSProcessTemplate.onInstall(event);
                    break;
                }
                case 3: {
                    if (BSControl.RESOURCE_USAGE) {
                        BSProcess.unloadProcessResourceInfo(event);
                        BSWIResourceUsage.removeProcessResources(event);
                        BSProcessStatus.removeProcessStatus(event);
                    }
                    BSProcessTemplate.onRemove(event);
                    break;
                }
                case 4: {
                    BSProcessTemplate.onSuspend(event);
                    break;
                }
                case 5: {
                    BSProcessTemplate.onResume(event);
                    break;
                }
                case 6: {
                    if (BSControl.RESOURCE_USAGE) {
                        BSProcess.loadProcessResourceInfo(event);
                    }
                    BSProcessTemplate.onReplace(event);
                    break;
                }
                case 10: {
                    if (BSControl.RESOURCE_USAGE) {
                        BSProcessStatus.onCreate(event);
                    }
                    BSProcessInstance.onCreate(event);
                    break;
                }
                case 12: 
                case 13: {
                    if (BSControl.RESOURCE_USAGE) {
                        BSProcessStatus.onStatusChange(event);
                    }
                    BSProcessInstance.onStatusChange(event);
                    break;
                }
                case 14: 
                case 15: {
                    if (BSControl.RESOURCE_USAGE) {
                        BSProcessStatus.onStatusChange(event);
                    }
                    BSProcessInstance.onComplete(event);
                    break;
                }
                case 11: {
                    if (BSControl.RESOURCE_USAGE) {
                        BSProcessStatus.onStatusChange(event);
                    }
                    BSProcessInstance.onActivate(event, evtype);
                    break;
                }
                case 16: {
                    BSProcessInstance.onUpdate(event, evtype);
                    break;
                }
                case 61: {
                    BSProcessInstance.onAttributeSet(event);
                    break;
                }
                case 62: {
                    BSProcessInstance.onDataslotSet(event);
                    break;
                }
                case 21: {
                    BSWorkstepInstance.onActivation(event);
                    break;
                }
                case 92: {
                    BSWorkstepInstance.onEventActivationWait(event);
                    break;
                }
                case 90: 
                case 91: {
                    BSWorkstepInstance.onActivationAndPreConditionWait(event);
                    break;
                }
                case 25: 
                case 28: {
                    BSWorkstepInstance.onUpdate(event);
                    break;
                }
                case 22: 
                case 23: {
                    BSWorkstepInstance.onSuspendAndResume(event);
                    break;
                }
                case 24: 
                case 26: {
                    BSWorkstepInstance.onCompleteTerminateSkip(event);
                    break;
                }
                case 27: {
                    BSWorkstepInstance.onSkip(event);
                    break;
                }
                case 30: {
                    BSWorkitem.onCreate(event);
                    break;
                }
                case 33: {
                    BSWorkitem.onUpdate(event);
                    break;
                }
                case 37: {
                    BSWorkitem.onUpdate(event);
                    BSCWorkItem.onRemove(event);
                    break;
                }
                case 31: {
                    BSWorkitem.onUpdate(event);
                    BSCWorkItem.onCreatorUpdate(event);
                    break;
                }
                case 101: {
                    BSWorkitem.onRead(event);
                    break;
                }
                case 34: 
                case 36: {
                    BSWorkitem.onStatusChange(event);
                    break;
                }
                case 35: 
                case 38: 
                case 100: {
                    BSWorkitem.onTerminateSkipRemove(event);
                    break;
                }
                case 32: {
                    if (BSControl.RESOURCE_USAGE) {
                        BSWIResourceUsage.onStatusChange(event);
                    }
                    BSWorkitem.onComplete(event);
                    BSCWorkItem.onCreatorUpdate(event);
                    break;
                }
                case 126: {
                    BSCWorkItem.onCStepCreate(event);
                    break;
                }
                case 134: {
                    BSCWorkItem.onCreate(event);
                    break;
                }
                case 129: 
                case 130: 
                case 133: 
                case 135: {
                    BSCWorkItem.onUpdate(event);
                    break;
                }
                case 127: 
                case 128: 
                case 131: 
                case 132: {
                    BSCWorkItem.onStatusChange(event);
                    break;
                }
                case 161: {
                    BSProcessNotes.onCreate(event);
                    break;
                }
                case 162: {
                    BSProcessNotes.onUpdate(event);
                    break;
                }
                case 163: {
                    BSProcessNotes.onRemove(event);
                    break;
                }
                case 42: {
                    BSDataslot.onUpdate(event);
                    break;
                }
                case 81: {
                    BSControl.logger.debugKey("BizStore_MSG_004", new Object[]{eventValue, event.toLogFormat() + "\n"});
                    break;
                }
                default: {
                    BSControl.logger.errorKey("BizStore_MSG_1527", new Object[]{eventValue, event.toLogFormat() + "\n"});
                    break;
                }
            }
        }
        catch (SQLException sqlEx) {
            if (BSUtil.isDuplicatedObjectException(sqlEx)) {
                BSControl.logger.warnKey("BizStore_MSG_1001", new Object[]{eventID, eventValue, sqlEx.getMessage()});
                return;
            }
            BSProcess.handleErrorEvent(event, lastErrorEventID, sqlEx);
        }
        catch (BizStoreException bizStoreEx) {
            throw bizStoreEx;
        }
        catch (Throwable th) {
            BSProcess.handleErrorEvent(event, lastErrorEventID, th);
        }
    }

    public static void printSQLStatements() {
        BSControl.logger.debug((Object)"BSProcess.printSQLStatements:");
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_PIP});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_SELECT_PT});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_SELECT_DSM});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_SELECT_PRI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_SELECT_ALLPRI});
    }

    private static void handleErrorEvent(CommonEvent event, long lastErrorEventID, Throwable th) {
        String eventValue = event.getValue();
        long eventID = event.getEventID();
        if (lastErrorEventID != eventID) {
            lastErrorEventID = eventID;
            throw new BizStoreException("BizStore_MSG_1529", new Object[]{event.toLogFormat()}, th, eventID);
        }
        throw new BizStoreException("BizStore_MSG_1611", new Object[]{eventID, eventValue, th.getMessage()}, null, eventID);
    }

    static {
        ptResourceMap = new HashMap();
        lastErrorEventID = -1L;
    }
}

