/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.scheduler.job;

import com.savvion.sbm.bizlogic.scheduler.SchedulerUtil;
import com.savvion.sbm.bizlogic.smp.scheduler.job.EventHistoryJob;
import com.savvion.sbm.bizlogic.smp.scheduler.job.EventJob;
import com.savvion.sbm.bizlogic.smp.scheduler.job.PurgeEventJob;
import com.savvion.sbm.bizlogic.smp.scheduler.job.WaitWorkStepJob;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.QuartzSchedulerService;
import com.savvion.sbm.util.logger.SBMLogger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Trigger;

public class MPJobService {
    private static QuartzSchedulerService qrtzSchedService = null;

    public static synchronized void startScheduler(SBMLogger logger) {
        try {
            qrtzSchedService = new QuartzSchedulerService(SchedulerUtil.self().getSchedulerProps(), logger);
        }
        catch (Throwable th) {
            throw new RuntimeException("Error occurred starting the Scheduler.", th);
        }
    }

    public static void createJobs() {
        MPJobService.createJobs(null);
    }

    public static void createJobs(SBMLogger logger) {
        try {
            if (qrtzSchedService.checkJobExist("EventJob", "MonitoringJobGroup")) {
                throw new RuntimeException("Can not create job with name <EventJob> in group <MonitoringJobGroup> as it already exists.");
            }
            if (qrtzSchedService.checkJobExist("WaitWSJob", "MonitoringJobGroup")) {
                throw new RuntimeException("Can not create job with name <WaitWSJob> in group <MonitoringJobGroup> as it already exists.");
            }
            if (qrtzSchedService.checkJobExist("HistoryJob", "MonitoringJobGroup")) {
                throw new RuntimeException("Can not create job with name <HistoryJob> in group <MonitoringJobGroup> as it already exists.");
            }
            MPJobService.createJob("EventJob", "MonitoringJobGroup", "EventTrigger", "MonitoringTriggerGroup", SMPConfig.self().getEventTriggerExpression(), EventJob.class, logger, QuartzSchedulerService.MisFirePolicy.FIRE_ONCE_NOW);
            MPJobService.createJob("WaitWSJob", "MonitoringJobGroup", "WaitWSTrigger", "MonitoringTriggerGroup", SMPConfig.self().getWaitWSTriggerExpression(), WaitWorkStepJob.class, logger, QuartzSchedulerService.MisFirePolicy.FIRE_ONCE_NOW);
            MPJobService.createJob("HistoryJob", "MonitoringJobGroup", "HistoryTrigger", "MonitoringTriggerGroup", SMPConfig.self().getHistoryTriggerExpression(), EventHistoryJob.class, logger, QuartzSchedulerService.MisFirePolicy.DO_NOTHING);
            MPJobService.createJob("PurgeEventJob", "MonitoringJobGroup", "PurgeEventTrigger", "MonitoringTriggerGroup", SMPConfig.self().getPurgeEventTriggerExpression(), PurgeEventJob.class, logger, QuartzSchedulerService.MisFirePolicy.DO_NOTHING);
        }
        catch (Throwable th) {
            throw new RuntimeException("Error occurred scheduling the jobs <EventJob, WaitWSJob, HistoryJob, PurgeEventJob>  of group <PurgeEventTrigger>for Monitoring Process", th);
        }
    }

    private static void createJob(String jobName, String jobGroupName, String triggerName, String trgGroupName, String cronExprn, Class<? extends Job> jobClass, SBMLogger logger, QuartzSchedulerService.MisFirePolicy misFirePolicy) {
        try {
            JobDetail job = qrtzSchedService.createJob(jobName, jobGroupName, jobClass);
            Trigger trigger = qrtzSchedService.createTrigger(triggerName, trgGroupName, job, cronExprn, misFirePolicy);
            qrtzSchedService.scheduleJob(job, trigger);
            if (logger == null) {
                LoggerUtil.logSOP((Object)("Scheduled a job with jobKey <" + jobGroupName + "." + jobName + ">, triggerKey <" + trgGroupName + "." + triggerName + ">."));
            } else {
                logger.info((Object)("Scheduled a job with jobKey <" + jobGroupName + "." + jobName + ">, triggerKey <" + trgGroupName + "." + triggerName + ">."));
            }
        }
        catch (Throwable th) {
            throw new RuntimeException("Error occurred scheduling the job with jobKey <" + jobGroupName + "." + jobName + ">, triggerKey <" + trgGroupName + "." + triggerName + ">.", th);
        }
    }

    public static void deleteJobs() {
        MPJobService.deleteJobs(null);
    }

    public static void deleteJobs(SBMLogger logger) {
        MPJobService.deleteJob("EventJob", "MonitoringJobGroup", logger);
        MPJobService.deleteJob("WaitWSJob", "MonitoringJobGroup", logger);
        MPJobService.deleteJob("HistoryJob", "MonitoringJobGroup", logger);
        MPJobService.deleteJob("PurgeEventJob", "MonitoringJobGroup", logger);
    }

    private static void deleteJob(String jobName, String jobGroupName, SBMLogger logger) {
        try {
            qrtzSchedService.deleteJob(jobName, jobGroupName);
            if (logger != null) {
                logger.info((Object)("Deleted a job with jobKey <" + jobGroupName + "." + jobName + ">."));
            }
        }
        catch (Throwable th) {
            throw new RuntimeException("Error occurred deleting the job  with name <" + jobName + ">, group <" + jobGroupName + "> used for Monitoring Process", th);
        }
    }

    public static void shutdownScheduler() {
        try {
            if (!qrtzSchedService.isShutdown()) {
                qrtzSchedService.shutdownScheduler();
            }
        }
        catch (Throwable th) {
            throw new RuntimeException("Error occurred stopping the Scheduler.", th);
        }
    }

    public static void scheduleMonitoringJobs() {
        MPJobService.scheduleMonitoringJobs(null);
    }

    public static void scheduleMonitoringJobs(SBMLogger logger) {
        try {
            MPJobService.startScheduler(logger);
            MPJobService.deleteJobs(logger);
            MPJobService.createJobs(logger);
        }
        finally {
            MPJobService.shutdownScheduler();
        }
    }

    public static void main(String[] args) {
        try {
            MPJobService.scheduleMonitoringJobs();
        }
        catch (Throwable th) {
            LoggerUtil.logStackTrace((String)"Exception in <MPJobService:main()>", (Throwable)th, null);
        }
    }
}

