/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.client.queryservice.ProcessNotesFilter;
import com.savvion.sbm.bizlogic.client.queryservice.QSCWorkItem;
import com.savvion.sbm.bizlogic.client.queryservice.QSProcessNotes;
import com.savvion.sbm.bizlogic.client.queryservice.QSProcessNotesFilter;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemSB;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemSBHome;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstancePK;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceSB;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceSBHome;
import com.savvion.sbm.bizlogic.server.svo.BLProcess;
import com.savvion.sbm.bizlogic.server.svo.BLProcessInterface;
import com.savvion.sbm.bizlogic.server.svo.CWorkItem;
import com.savvion.sbm.bizlogic.server.svo.CWorkItemList;
import com.savvion.sbm.bizlogic.server.svo.DataSlot;
import com.savvion.sbm.bizlogic.server.svo.DataSlotList;
import com.savvion.sbm.bizlogic.server.svo.ProcessNotes;
import com.savvion.sbm.bizlogic.server.svo.ProcessNotesList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstance;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.ResultData;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ejb.EJBObject;

public class WorkItem
extends BLProcess
implements BLProcessInterface {
    private WorkStepInstance parent;

    WorkItem(Session session, HashMap attributes) {
        BLConstants.single();
        super(session, (Long)attributes.get("WORKITEMID"), attributes);
        this.parent = null;
        this.modifiedAttrs = new HashMap();
    }

    public void assign(String performer) throws RemoteException {
        if (performer == null || performer.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_1103", new Object[]{performer, this.getName()});
        }
        if (this.isAssigned() && !performer.equals(this.getPerformer())) {
            throw new BizLogicClientException("BizLogic_ERR_4703", new Object[]{this.getName(), this.getProcessInstanceName(), this.getPerformer(), performer});
        }
        ((WorkItemSB)this.getRemoteRef()).assign(this.session, this.getID(), performer);
        this.refresh();
    }

    public void assignNext(String performer) throws RemoteException {
        ((WorkItemSB)this.getRemoteRef()).assignNext(this.session, this.getID(), performer);
        BLConstants.single();
        String previousPerformer = (String)this.attributes.get("PERFORMER");
        BLConstants.single();
        this.attributes.put("PERFORMER", performer);
        BLConstants.single();
        this.attributes.put("PREVIOUSASSIGNEE", previousPerformer);
        BLConstants.single();
        BLConstants.single();
        this.attributes.put("STATUS", 28);
    }

    public static boolean assignNextIfAvailable(Session session, long wiid, String performer) throws RemoteException {
        try {
            WorkItemSB wisb = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
            return wisb.assignNextIfAvailable(session, wiid, performer);
        }
        catch (Throwable th) {
            return false;
        }
    }

    public void reAssign(String performer) throws RemoteException {
        if (this.getPerformer().equals(performer.trim())) {
            return;
        }
        ((WorkItemSB)this.getRemoteRef()).reAssign(this.session, this.getID(), performer);
        this.resetReadTime();
        this.refresh();
    }

    public Vector getAvailablePerformers() throws RemoteException {
        return ((WorkItemSB)this.getRemoteRef()).getAvailablePerformers(this.session, this.getID());
    }

    public boolean isAvailable() {
        int n = this.getState();
        BLConstants.single();
        return n == 27;
    }

    public boolean isAssigned() {
        int n = this.getState();
        BLConstants.single();
        return n == 28;
    }

    public boolean isSkipped() {
        int n = this.getState();
        BLConstants.single();
        return n == 48;
    }

    public boolean isAvailablePerformer(String performer) throws RemoteException {
        return ((WorkItemSB)this.getRemoteRef()).isAvailablePerformer(this.session, this.getID(), performer);
    }

    public boolean isAssignedPerformer(String performer) throws RemoteException {
        return ((WorkItemSB)this.getRemoteRef()).isAssignedPerformer(this.session, this.getID(), performer);
    }

    public String getPerformer() {
        BLConstants.single();
        return (String)this.attributes.get("PERFORMER");
    }

    public String getPreviousPerformer() {
        BLConstants.single();
        return (String)this.attributes.get("PREVIOUSASSIGNEE");
    }

    @Override
    public String getName() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (String)hashMap.get("WORKITEMNAME");
    }

    @Override
    public long getID() {
        return this.id;
    }

    public String getInstruction() throws RemoteException {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        String instruction = (String)hashMap.get("INSTRUCTION");
        if (instruction == null) {
            HashMap hashMap2 = this.getAttributes();
            BLConstants.single();
            if (!hashMap2.containsKey("INSTRUCTION")) {
                instruction = this.getParent().getInstruction();
                BLConstants.single();
                this.attributes.put("INSTRUCTION", instruction);
                return instruction;
            }
        }
        return instruction;
    }

    public String getWorkStepMilestoneDescription() throws RemoteException {
        BLConstants.single();
        return (String)this.attributes.get("MILESTONE_DESC");
    }

    public String getWorkStepMilestoneName() throws RemoteException {
        BLConstants.single();
        return (String)this.attributes.get("MILESTONE_NAME");
    }

    public long getDueDate() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (Long)hashMap.get("DUEDATE");
    }

    public boolean sendAssignedTask() throws Exception {
        return ((WorkItemSB)this.getRemoteRef()).sendAssignedTask(this.session, this.getID());
    }

    public void setDueDate(long duedate) {
        BLConstants.single();
        this.setAttribute("DUEDATE", duedate);
    }

    @Override
    protected EJBObject findRemoteRef() throws RemoteException {
        try {
            return (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        }
        catch (Exception e) {
            throw new BizLogicClientException("BizLogic_ERR_1527", new Object[]{this.getName()}, (Throwable)e);
        }
    }

    @Override
    public void refresh() throws RemoteException {
        this.attributes = ((WorkItemSB)this.getRemoteRef()).getAttributes(this.session, this.getID());
        this.modifiedAttrs.clear();
        this.parent = null;
    }

    @Override
    public void save() throws RemoteException {
        if (this.removed) {
            throw new BizLogicClientException("BizLogic_ERR_910", new Object[]{"WorkItem"});
        }
        boolean receivedException = false;
        try {
            if (!this.modifiedAttrs.isEmpty()) {
                ((WorkItemSB)this.getRemoteRef()).save(this.session, this.getID(), this.modifiedAttrs);
                this.modifiedAttrs.clear();
            }
        }
        catch (BizLogicException | RemoteException e) {
            receivedException = true;
            throw e;
        }
        finally {
            WorkItem.doFinally(receivedException, this);
        }
    }

    @Override
    public void suspend() throws RemoteException {
        if (this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_1673", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        ((WorkItemSB)this.getRemoteRef()).suspend(this.session, this.getID(), null);
        BLConstants.single();
        super.setState(32);
    }

    public void suspend(String reason) throws RemoteException {
        if (this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_1673", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        ((WorkItemSB)this.getRemoteRef()).suspend(this.session, this.getID(), reason);
        BLConstants.single();
        super.setState(32);
    }

    @Override
    public void resume() throws RemoteException {
        if (!this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_1674", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        ((WorkItemSB)this.getRemoteRef()).resume(this.session, this.getID());
        this.refresh();
    }

    @Override
    public void remove() throws RemoteException {
        ((WorkItemSB)this.getRemoteRef()).remove(this.session, this.getID());
        this.removed = true;
    }

    @Override
    public long getProcessTemplateID() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Long ptID = (Long)hashMap.get("PROCESSTEMPLATEID");
        return ptID;
    }

    @Override
    public String getProcessTemplateName() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (String)hashMap.get("PROCESSTEMPLATENAME");
    }

    @Override
    public String getAppName() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (String)hashMap.get("APP_NAME");
    }

    public String getProcessTemplateDisplayName() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (String)hashMap.get("APP_NAME");
    }

    @Override
    public long getProcessInstanceID() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Long piID = (Long)hashMap.get("PROCESSINSTANCEID");
        return piID;
    }

    @Override
    public String getProcessInstanceName() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (String)hashMap.get("PROCESSINSTANCENAME");
    }

    public WorkStepInstance getParent() throws RemoteException {
        if (this.parent == null) {
            this.parent = ((WorkStepInstanceSB)WorkItem.getRemoteRef(WorkStepInstanceSBHome.class)).getWorkStepInstance(this.session, this.getProcessInstanceID(), this.getWorkStepID());
        }
        return this.parent;
    }

    public WorkStepInstancePK getParentID() {
        return new WorkStepInstancePK(this.getProcessInstanceID(), this.getWorkStepID());
    }

    @Override
    public HashMap getProcessContext() {
        return this.getAttributes();
    }

    public long getWorkStepID() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (Long)hashMap.get("WORKSTEPID");
    }

    public String getWorkStepName() throws RemoteException {
        BLConstants.single();
        return (String)this.attributes.get("WORKSTEPNAME");
    }

    @Override
    public void complete(HashMap dsValues) throws RemoteException {
        if (this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_902", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        if (dsValues != null && !dsValues.isEmpty()) {
            BLConstants.single();
            dsValues.put("@WORKSTEPID", this.getWorkStepID());
        }
        ((WorkItemSB)this.getRemoteRef()).complete((Session)this.getSession(), this.getID(), dsValues);
    }

    @Override
    public void complete() throws RemoteException {
        if (this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_902", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        ((WorkItemSB)this.getRemoteRef()).complete((Session)this.getSession(), this.getID(), null);
        BLConstants.single();
        super.setState(31);
    }

    public void complete(String wiPerformer, Map<String, Object> dsValues) throws RemoteException {
        if (wiPerformer == null || wiPerformer.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_4526", new Object[]{wiPerformer});
        }
        if (this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_902", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        ((WorkItemSB)this.getRemoteRef()).complete((Session)this.getSession(), this.getID(), wiPerformer, dsValues);
        BLConstants.single();
        super.setState(31);
    }

    public void complete(HashMap dsValues, Hashtable resources) throws RemoteException {
        if (resources == null || resources.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_933", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        if (this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_902", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        if (dsValues != null && !dsValues.isEmpty()) {
            BLConstants.single();
            dsValues.put("@WORKSTEPID", this.getWorkStepID());
        }
        ((WorkItemSB)this.getRemoteRef()).complete((Session)this.getSession(), this.getID(), dsValues, resources);
        BLConstants.single();
        super.setState(31);
    }

    public void skip() throws RemoteException {
        ((WorkItemSB)this.getRemoteRef()).skip((Session)this.getSession(), this.getID());
        BLConstants.single();
        super.setState(48);
    }

    public DataSlotList getInputDataSlotList(boolean withMetaData) throws RemoteException {
        BLConstants.single();
        if (this.attributes.containsKey("INPUTDATASLOTS")) {
            BLConstants.single();
            return (DataSlotList)this.attributes.get("INPUTDATASLOTS");
        }
        DataSlotList inputDSList = ((WorkItemSB)this.getRemoteRef()).getInputDataSlotList((Session)this.getSession(), this.getID(), withMetaData);
        BLConstants.single();
        this.attributes.put("INPUTDATASLOTS", inputDSList);
        return inputDSList;
    }

    public DataSlotList getOutputDataSlotList(boolean withMetaData) throws RemoteException {
        BLConstants.single();
        if (this.attributes.containsKey("OUTPUTDATASLOTS")) {
            BLConstants.single();
            return (DataSlotList)this.attributes.get("OUTPUTDATASLOTS");
        }
        DataSlotList outputDSList = ((WorkItemSB)this.getRemoteRef()).getOutputDataSlotList((Session)this.getSession(), this.getID(), withMetaData);
        BLConstants.single();
        this.attributes.put("OUTPUTDATASLOTS", outputDSList);
        return outputDSList;
    }

    public HashMap getDataSlotList(boolean withMetaData) throws RemoteException {
        BLConstants.single();
        if (this.attributes.containsKey("INPUTDATASLOTS")) {
            BLConstants.single();
            if (this.attributes.containsKey("OUTPUTDATASLOTS")) {
                HashMap dsList = new HashMap();
                BLConstants.single();
                BLConstants.single();
                dsList.put("INPUTDATASLOTS", this.attributes.get("INPUTDATASLOTS"));
                BLConstants.single();
                BLConstants.single();
                dsList.put("OUTPUTDATASLOTS", this.attributes.get("OUTPUTDATASLOTS"));
                return dsList;
            }
        }
        HashMap dsMap = ((WorkItemSB)this.getRemoteRef()).getDataSlotList((Session)this.getSession(), this.getID(), withMetaData);
        BLConstants.single();
        BLConstants.single();
        this.attributes.put("INPUTDATASLOTS", dsMap.get("INPUTDATASLOTS"));
        BLConstants.single();
        BLConstants.single();
        this.attributes.put("OUTPUTDATASLOTS", dsMap.get("OUTPUTDATASLOTS"));
        return dsMap;
    }

    public DataSlot getDataSlot(String dsName) throws RemoteException {
        return ((WorkItemSB)this.getRemoteRef()).getDataSlot((Session)this.getSession(), this.getID(), dsName);
    }

    public boolean getEmailSupport() throws RemoteException {
        WorkItemSB workItemSB = (WorkItemSB)this.getRemoteRef();
        Session session = (Session)this.getSession();
        long l = this.getProcessTemplateID();
        long l2 = this.getProcessInstanceID();
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return workItemSB.getEmailSupport(session, l, l2, (Long)hashMap.get("PARENTID"), this.getWorkStepID());
    }

    public Map getEmailTemplateInstance() throws Exception {
        return ((WorkItemSB)this.getRemoteRef()).getEmailTemplateInstance(this.session, this.getID());
    }

    public long getDuration() throws RemoteException {
        BLConstants.single();
        Long duration = (Long)this.attributes.get("DURATION");
        if (duration == null) {
            BLConstants.single();
            if (!this.attributes.containsKey("DURATION")) {
                duration = ((WorkStepInstanceSB)WorkItem.getRemoteRef(WorkStepInstanceSBHome.class)).getDuration((Session)this.getSession(), this.getProcessInstanceID(), this.getWorkStepID());
                BLConstants.single();
                this.attributes.put("DURATION", duration);
            } else {
                return BLUtil.self().getDefaultWSDuration();
            }
        }
        return duration;
    }

    public Object getPerformingApp() throws RemoteException {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Object performingApp = hashMap.get("PERFORMINGAPP");
        if (performingApp != null && performingApp.toString().startsWith("@")) {
            performingApp = ((WorkStepInstanceSB)WorkItem.getRemoteRef(WorkStepInstanceSBHome.class)).getPerformingApp((Session)this.getSession(), this.getProcessInstanceID(), this.getWorkStepID());
            BLConstants.single();
            this.attributes.put("PERFORMINGAPP", performingApp);
        }
        return performingApp;
    }

    public String getProcessInstanceCreator() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (String)hashMap.get("CREATOR");
    }

    public HashMap getInputDataSlotNames() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (HashMap)hashMap.get("INPUTDATASLOTNAMES");
    }

    public HashMap getOutputDataSlotNames() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (HashMap)hashMap.get("OUTPUTDATASLOTNAMES");
    }

    public boolean isInputDataSlot(String dsName) {
        return this.isDataSlot(dsName, this.getInputDataSlotNames().keySet());
    }

    public boolean isOutputDataSlot(String dsName) {
        return this.isDataSlot(dsName, this.getOutputDataSlotNames().keySet());
    }

    @Override
    public boolean isActivated() {
        int state = super.getState();
        BLConstants consts = BLConstants.single();
        if (state != 25) {
            if (state != 32) {
                return true;
            }
        }
        return false;
    }

    public void makeAvailable() throws RemoteException {
        this.makeAvailable(null);
    }

    public void makeAvailable(Vector performers) throws RemoteException {
        if (this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_4632", new Object[]{this.getProcessInstanceName(), "workitem", this.getID()});
        }
        WorkItemSB wiSB = (WorkItemSB)this.getRemoteRef();
        wiSB.makeAvailable(this.session, this.getProcessInstanceID(), this.getID(), performers);
        this.resetReadTime();
    }

    public static void makeAvailable(Session session, List<Long> wiids) throws RemoteException {
        WorkItem.makeAvailable(session, wiids, null);
    }

    public static void makeAvailable(Session session, List<Long> wiids, List<String> performers) throws RemoteException {
        if (wiids == null || wiids.isEmpty()) {
            return;
        }
        WorkItemSB wiSB = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        ResultData<List<Long>> result = wiSB.makeAvailable(session, wiids, performers, true);
        if (!result.isSuccessful()) {
            throw result.getConsolidatedError();
        }
    }

    public static WorkItem get(Session session, long workitemId) throws RemoteException {
        WorkItemSB wiSB = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        return wiSB.getWorkItem(session, workitemId);
    }

    public static WorkItem get(Session session, long workitemId, boolean withDataslots) throws RemoteException {
        WorkItemSB wiSB = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        return wiSB.getWorkItem(session, workitemId, withDataslots);
    }

    public static boolean isExist(Session session, long workitemId) throws RemoteException {
        return ((WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class)).isExist(session, workitemId);
    }

    public static void reAssign(Session session, List<Long> wiids, String performer) throws RemoteException {
        if (performer == null || performer.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_504", new Object[]{performer});
        }
        if (wiids == null || wiids.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_4613", (Object)"WorkItem.reAssign()");
        }
        WorkItemSB wiSB = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        wiSB.reAssign(session, wiids, performer, false);
    }

    public static void reAssign(Session session, Hashtable wiids) throws RemoteException {
        WorkItemSB wiSB = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        wiSB.reAssign(session, wiids, false);
    }

    public static void reAssign(Session session, Hashtable wiids, boolean isMultiTrans) throws RemoteException {
        WorkItemSB wiSB = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        ResultData<List<Long>> result = wiSB.reAssign(session, wiids, isMultiTrans);
        if (!result.isSuccessful()) {
            throw result.getExceptionWithConsolidatedGracefulMessages();
        }
    }

    public static void reAssign(Session session, String fromPerformer, String toPerformer) throws RemoteException {
        if (fromPerformer.trim().equals(toPerformer.trim())) {
            throw new BizLogicClientException("Bizlogic_ERR_3809", (Object)"WorkItem.reAssign");
        }
        WorkItemSB wiSB = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        wiSB.reAssign(session, fromPerformer, toPerformer, false);
    }

    public String getResponse() {
        BLConstants.single();
        return (String)this.attributes.get("RESPONSE");
    }

    public void setResponse(String response) {
        BLConstants.single();
        this.setAttribute("RESPONSE", response);
    }

    public void markRead() throws RemoteException {
        if (!this.isAssigned()) {
            throw new BizLogicClientException("BizLogic_ERR_4512", (Object)this.getStateDescription());
        }
        BLConstants.single();
        long readTime = (Long)this.attributes.get("READTIME");
        if (readTime > 0L) {
            return;
        }
        readTime = System.currentTimeMillis();
        ((WorkItemSB)this.getRemoteRef()).markRead(this.session, this.getID(), readTime);
        BLConstants.single();
        this.attributes.put("READTIME", readTime);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCollaborationEnabled() {
        BLConstants.single();
        if (!this.attributes.containsKey("COLLABORATION_ENABLED")) return false;
        BLConstants.single();
        if (this.attributes.get("COLLABORATION_ENABLED") == null) return false;
        BLConstants.single();
        if ((Boolean)this.attributes.get("COLLABORATION_ENABLED") == false) return false;
        return true;
    }

    public List getTemplateCollaborators() {
        BLConstants.single();
        return (List)this.attributes.get("COLLABORATORS");
    }

    public CWorkItemList createCWorkItems(List<String> collaborators, String cStepNameAlias, Map cWorkItemData) throws RemoteException {
        WorkItemSB wiSB = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        long cStepID = wiSB.createCWorkItems(this.session, this.getID(), collaborators, cStepNameAlias, cWorkItemData);
        QSCWorkItem qsCWorkItem = CWorkItem.getQSCWorkItem((Session)this.getSession());
        return qsCWorkItem.getListByCStep(cStepID, null, new int[0]);
    }

    public CWorkItem getCWorkItem(long cWorkItemId) throws RemoteException {
        WorkItemSB wiSB = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        return wiSB.getCWorkItem((Session)this.getSession(), cWorkItemId);
    }

    public boolean isExistCWorkItem(long cWorkItemId) throws RemoteException {
        WorkItemSB wiSB = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        return wiSB.isExistCWorkItem((Session)this.getSession(), this.getID(), cWorkItemId);
    }

    public CWorkItemList getCWorkItems() {
        QSCWorkItem qsCWorkItem = CWorkItem.getQSCWorkItem((Session)this.getSession());
        return qsCWorkItem.getListByParentWI(this.getID(), null, new int[0]);
    }

    public CWorkItemList getCWorkItems(String cStepName) {
        QSCWorkItem qsCWorkItem = CWorkItem.getQSCWorkItem((Session)this.getSession());
        return qsCWorkItem.getListByCStep(cStepName, null, new int[0]);
    }

    public List getCStepNames() {
        QSCWorkItem qsCWorkItem = CWorkItem.getQSCWorkItem((Session)this.getSession());
        return qsCWorkItem.getCStepNames(this.getID());
    }

    public ProcessNotes createNotesForWorkItems(String notes, String threadName) throws RemoteException {
        return ProcessNotes.createForWorkItem(this.session, this.getProcessInstanceID(), this.getID(), notes, threadName);
    }

    public ProcessNotes createNotesForCollaborators(String notes, String threadName) throws RemoteException {
        long l = this.getProcessInstanceID();
        String string = this.getWorkStepName();
        long l2 = this.getID();
        BLConstants.single();
        return ProcessNotes.create(this.session, l, string, l2, -1L, notes, threadName, 5);
    }

    public ProcessNotesList getCollaborationNotes() {
        QSProcessNotes qsProcessNotes = this.getQSProcessNotes();
        QSProcessNotesFilter filter = new QSProcessNotesFilter("CollabNotesForWI");
        filter.setConditionForCWorkItem();
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("piid", this.getProcessInstanceID());
        params.put("wiid", this.getID());
        filter.setParameterValues(params);
        return qsProcessNotes.getList((ProcessNotesFilter)filter);
    }

    public ProcessNotesList getAllNotes(boolean includeCollaborationNotes) throws RemoteException {
        QSProcessNotes qsProcessNotes = this.getQSProcessNotes();
        QSProcessNotesFilter filter = new QSProcessNotesFilter("NotesForWorkItem");
        filter.setConditionForWorkStep(includeCollaborationNotes);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("piid", this.getProcessInstanceID());
        params.put("wsname", this.getWorkStepName());
        filter.setParameterValues(params);
        return qsProcessNotes.getList((ProcessNotesFilter)filter);
    }

    private void resetReadTime() {
        BLConstants.single();
        BLConstants.single();
        this.attributes.put("READTIME", 0L);
    }

    public boolean isRead() {
        BLConstants.single();
        Long readTime = (Long)this.attributes.get("READTIME");
        return readTime != null && readTime > 0L;
    }

    public static void complete(Session session, long wiid, String wiPerformer, Map<String, Object> dsValues, Hashtable<String, Object> resources) throws RemoteException {
        if (wiPerformer == null || wiPerformer.trim().length() == 0) {
            wiPerformer = session.getUser();
        }
        ((WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class)).complete(session, wiid, wiPerformer, dsValues, resources);
    }

    public static void complete(Session session, List<Long> wiids) throws RemoteException {
        if (wiids == null || wiids.isEmpty()) {
            return;
        }
        Vector<Long> idList = new Vector<Long>(wiids);
        ((WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class)).complete(session, idList);
    }

    public static void complete(Session session, List<Long> wiids, Map<String, Object> dsValues, boolean isMultiTrans) throws RemoteException {
        if (wiids == null || wiids.isEmpty()) {
            return;
        }
        ResultData<List<Long>> result = ((WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class)).complete(session, wiids, dsValues, isMultiTrans);
        if (!result.isSuccessful()) {
            throw result.getExceptionWithConsolidatedGracefulMessages();
        }
    }

    public static void skip(Session session, long wiid) throws RemoteException {
        ((WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class)).skip(session, wiid);
    }

    public static void assign(Session session, List<Long> wiids, String performer, boolean isMultiTrans) throws RemoteException {
        if (wiids == null || wiids.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_4613", (Object)"WorkItem.assign()");
        }
        WorkItemSB wisb = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        ResultData<List<Long>> result = wisb.assign(session, wiids, performer, isMultiTrans);
        if (!result.isSuccessful()) {
            throw result.getExceptionWithConsolidatedGracefulMessages();
        }
    }

    public static void assign(Session session, Map<Long, String> wiids, boolean isMultiTrans) throws RemoteException {
        if (wiids == null || wiids.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_4636", (Object)"WorkItem.assign()");
        }
        WorkItemSB wisb = (WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class);
        ResultData<List<Long>> result = wisb.assign(session, wiids, isMultiTrans);
        if (!result.isSuccessful()) {
            throw result.getExceptionWithConsolidatedGracefulMessages();
        }
    }

    public static void assign(Session session, long wiid, String performer) throws RemoteException {
        ArrayList<Long> wiids = new ArrayList<Long>();
        wiids.add(wiid);
        WorkItem.assign(session, wiids, performer, false);
    }

    public static void remove(Session session, List<Long> wiids) throws RemoteException {
        if (wiids == null || wiids.isEmpty()) {
            return;
        }
        Vector<Long> idList = new Vector<Long>(wiids);
        ((WorkItemSB)WorkItem.getRemoteRef(WorkItemSBHome.class)).remove(session, idList);
    }
}

