/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.svo.ProcessNotes;
import com.savvion.sbm.bizlogic.util.Session;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ProcessNotesList
implements Serializable {
    Session session;
    List<ProcessNotes> processNotesList = new ArrayList<ProcessNotes>();
    boolean threadNamesPopulated = false;
    List<String> threadNames = new ArrayList<String>();

    ProcessNotesList(Session session, List<ProcessNotes> processNotesList) {
        this.session = session;
        if (processNotesList != null) {
            this.processNotesList = processNotesList;
        }
    }

    public List<ProcessNotes> getList() {
        return this.processNotesList;
    }

    public List<ProcessNotes> getNotesByReference(long notesID) {
        ArrayList<ProcessNotes> notesByRef = new ArrayList<ProcessNotes>();
        for (int ix = 0; ix < this.processNotesList.size(); ++ix) {
            ProcessNotes notes = this.processNotesList.get(ix);
            if (notes.getReferenceID() != notesID) continue;
            notesByRef.add(notes);
        }
        return notesByRef;
    }

    public List<ProcessNotes> getNotesByThreadName(String threadName) {
        ArrayList<ProcessNotes> notesByThreadName = new ArrayList<ProcessNotes>();
        for (int ix = 0; ix < this.processNotesList.size(); ++ix) {
            ProcessNotes notes = this.processNotesList.get(ix);
            String threadNameInStore = notes.getThreadName();
            if (threadName == null || threadName.trim().length() == 0) {
                if (threadNameInStore != null && threadNameInStore.trim().length() != 0) continue;
                notesByThreadName.add(notes);
                continue;
            }
            if (!threadName.equalsIgnoreCase(threadNameInStore)) continue;
            notesByThreadName.add(notes);
        }
        return notesByThreadName;
    }

    public List<String> getThreadNames() {
        if (this.threadNamesPopulated) {
            return this.threadNames;
        }
        HashSet<String> threadSet = new HashSet<String>();
        for (int ix = 0; ix < this.processNotesList.size(); ++ix) {
            ProcessNotes notes = this.processNotesList.get(ix);
            String threadName = notes.getThreadName();
            if (threadName == null || threadName.trim().length() <= 0) continue;
            threadSet.add(threadName);
        }
        this.threadNames.addAll(threadSet);
        this.threadNamesPopulated = true;
        return this.threadNames;
    }
}

