/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.util.BLConstants;
import java.io.Serializable;
import java.util.HashMap;

public class ProcessCount
implements Serializable {
    Long ptid = null;
    HashMap processInstance = null;
    HashMap workItem = null;
    String ptName = null;
    String ptAppName = null;
    int ptStatus = 0;
    private int suspendedworkitemcount = -1;
    private int availableworkitemcount = -1;
    private int assignedworkitemcount = -1;
    private int workitemcount = -1;
    private int processinstancecount = -1;
    private int createdprocessinstancecount = -1;
    private int activatedprocessinstancecount = -1;
    private int suspendedprocessinstancecount = -1;

    ProcessCount(Long ptid, HashMap pi, HashMap wi, String ptName, String ptAppName, int ptStatus) {
        this.ptid = ptid;
        this.processInstance = pi;
        this.workItem = wi;
        this.ptName = ptName;
        this.ptAppName = ptAppName;
        this.ptStatus = ptStatus;
    }

    public int getActivatedProcessInstanceCount() {
        if (this.activatedprocessinstancecount == -1) {
            BLConstants.single();
            this.activatedprocessinstancecount = this.getCountByProcessInstanceStatus(7);
        }
        return this.activatedprocessinstancecount;
    }

    public int getSuspendedProcessInstanceCount() {
        if (this.suspendedprocessinstancecount == -1) {
            BLConstants.single();
            this.suspendedprocessinstancecount = this.getCountByProcessInstanceStatus(8);
        }
        return this.suspendedprocessinstancecount;
    }

    public int getCreatedProcessInstanceCount() {
        if (this.createdprocessinstancecount == -1) {
            BLConstants.single();
            this.createdprocessinstancecount = this.getCountByProcessInstanceStatus(6);
        }
        return this.createdprocessinstancecount;
    }

    public int getProcessInstanceCount() {
        if (this.processinstancecount == -1) {
            this.processinstancecount = this.getActivatedProcessInstanceCount() + this.getCreatedProcessInstanceCount() + this.getSuspendedProcessInstanceCount();
        }
        return this.processinstancecount;
    }

    public int getAssignedWorkItemCount() {
        if (this.assignedworkitemcount == -1) {
            BLConstants.single();
            this.assignedworkitemcount = this.getCountByWorkItemStatus(28);
        }
        return this.assignedworkitemcount;
    }

    public int getAvailableWorkItemCount() {
        if (this.availableworkitemcount == -1) {
            BLConstants.single();
            this.availableworkitemcount = this.getCountByWorkItemStatus(27);
        }
        return this.availableworkitemcount;
    }

    public int getSuspendedWorkItemCount() {
        if (this.suspendedworkitemcount == -1) {
            BLConstants.single();
            this.suspendedworkitemcount = this.getCountByWorkItemStatus(32);
        }
        return this.suspendedworkitemcount;
    }

    public int getWorkItemCount() {
        if (this.workitemcount == -1) {
            this.workitemcount = this.getAssignedWorkItemCount() + this.getAvailableWorkItemCount() + this.getSuspendedWorkItemCount();
        }
        return this.workitemcount;
    }

    public long getProcessTemplateID() {
        return this.ptid;
    }

    public String getProcessTemplateName() {
        return this.ptName;
    }

    public String getAppName() {
        if (this.ptAppName == null) {
            this.ptAppName = this.ptName;
        }
        return this.ptAppName;
    }

    public String getProcessDisplayName() {
        if (this.ptAppName == null) {
            this.ptAppName = this.ptName;
        }
        return this.ptAppName;
    }

    private int getCountByProcessInstanceStatus(int status) {
        Object count = this.processInstance.get(status);
        if (count == null) {
            return 0;
        }
        return (Integer)count;
    }

    private int getCountByWorkItemStatus(int status) {
        Object count = this.workItem.get(status);
        if (count == null) {
            return 0;
        }
        return (Integer)count;
    }

    public boolean isProcessActive() {
        BLConstants.single();
        return this.ptStatus == 2;
    }

    public boolean isProcessSuspended() {
        BLConstants.single();
        return this.ptStatus == 4;
    }
}

