/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.client.queryservice.ProcessNotesFilter;
import com.savvion.sbm.bizlogic.client.queryservice.QSCWorkItem;
import com.savvion.sbm.bizlogic.client.queryservice.QSProcessNotes;
import com.savvion.sbm.bizlogic.client.queryservice.QSProcessNotesFilter;
import com.savvion.sbm.bizlogic.client.queryservice.QueryService;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemSB;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemSBHome;
import com.savvion.sbm.bizlogic.server.svo.BLProcess;
import com.savvion.sbm.bizlogic.server.svo.BLProcessInterface;
import com.savvion.sbm.bizlogic.server.svo.CWorkItemList;
import com.savvion.sbm.bizlogic.server.svo.DataSlot;
import com.savvion.sbm.bizlogic.server.svo.DataSlotList;
import com.savvion.sbm.bizlogic.server.svo.ProcessNotes;
import com.savvion.sbm.bizlogic.server.svo.ProcessNotesList;
import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ejb.EJBObject;

public class CWorkItem
extends BLProcess
implements BLProcessInterface {
    static final long serialVersionUID = -1027274669843567912L;
    private WorkItem parent;

    CWorkItem(Session session, Map<String, Object> attributes) {
        BLConstants.single();
        super(session, (Long)attributes.get("CWORKITEM_ID"), (HashMap)attributes);
        this.parent = null;
        this.modifiedAttrs = new HashMap();
    }

    @Override
    public String getName() {
        BLConstants.single();
        return (String)this.attributes.get("CWORKITEM_NAME");
    }

    @Override
    public long getID() {
        return this.id;
    }

    public boolean isAssigned() {
        int n = this.getState();
        BLConstants.single();
        return n == 65;
    }

    public boolean isCompleted() {
        int n = this.getState();
        BLConstants.single();
        return n == 67;
    }

    public boolean isTerminated() {
        int n = this.getState();
        BLConstants.single();
        return n == 68;
    }

    public boolean isDeclined() {
        int n = this.getState();
        BLConstants.single();
        return n == 74;
    }

    public boolean isAvailable() {
        int n = this.getState();
        BLConstants.single();
        return n == 69;
    }

    public boolean isAssignee(String user) {
        return user != null && user.equalsIgnoreCase(this.getCollaborator());
    }

    public long getLastModifiedTime() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Long time = (Long)hashMap.get("LAST_MODIFIED_TIME");
        return time;
    }

    public String getCollaborator() {
        BLConstants.single();
        return (String)this.attributes.get("COLLABORATOR");
    }

    public String getInstruction() {
        BLConstants.single();
        return (String)this.attributes.get("INSTRUCTION");
    }

    public String getResponse() {
        BLConstants.single();
        return (String)this.attributes.get("RESPONSE");
    }

    public void setResponse(String response) throws BizLogicClientException {
        this.checkStateForModify("response");
        BLConstants.single();
        this.setAttribute("RESPONSE", response);
    }

    public ProcessNotes createNotes(String notes) throws RemoteException, BizLogicClientException {
        return this.createNotes(notes, null);
    }

    public ProcessNotes createNotes(String notes, String threadName) throws RemoteException, BizLogicClientException {
        return ProcessNotes.createForCWorkItem(this.session, this.getProcessInstanceID(), this.getID(), notes, threadName);
    }

    public ProcessNotesList getAllNotes() {
        QSProcessNotes qsProcessNotes = this.getQSProcessNotes();
        QSProcessNotesFilter filter = new QSProcessNotesFilter("CollabNotesForWI");
        filter.setConditionForCWorkItem();
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("piid", this.getProcessInstanceID());
        params.put("wiid", this.getParentWorkItemID());
        filter.setParameterValues(params);
        return qsProcessNotes.getList((ProcessNotesFilter)filter);
    }

    @Override
    public void setPriority(String priority) throws BizLogicClientException {
        this.checkStateForModify("priority");
        super.setPriority(priority);
    }

    public String getEscalationString() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        int esclType = (Integer)hashMap.get("ESCALATION_TYPE");
        return BLConstants.single().escalationTypes[esclType];
    }

    public void setEscalation(int escalation) throws BizLogicClientException {
        this.checkStateForModify("escalation");
        BLConstants.single();
        if (escalation != 0) {
            BLConstants.single();
            if (escalation != 1) {
                BLConstants.single();
                if (escalation != 2) {
                    BLConstants.single();
                    if (escalation != 3) {
                        throw new BizLogicClientException("BizLogic_ERR_3633", new Object[]{this.getName(), this.getCStepName(), this.getParentWorkItemID(), this.getProcessInstanceName()});
                    }
                }
            }
        }
        BLConstants.single();
        this.setAttribute("ESCALATION_TYPE", escalation);
    }

    public long getDueDate() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (Long)hashMap.get("DUEDATE");
    }

    public void setDueDate(long duedate) throws BizLogicClientException {
        this.checkStateForModify("duedate");
        long startTime = this.getStartTime();
        if (duedate <= startTime) {
            throw new BizLogicClientException("BizLogic_ERR_2567", new Object[]{this.getProcessInstanceName(), "collaborative workitem : " + this.getName()});
        }
        BLConstants.single();
        this.setAttribute("DUEDATE", duedate);
    }

    public long getDuration() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (Long)hashMap.get("DURATION");
    }

    public void setDuration(long duration) throws BizLogicClientException {
        this.checkStateForModify("duration");
        if (duration <= 0L) {
            throw new BizLogicClientException("BizLogic_ERR_4618", new Object[]{duration, this.getName(), this.getCStepName(), this.getParentWorkItemID(), this.getProcessInstanceName()});
        }
        BLConstants.single();
        this.setAttribute("DURATION", duration);
    }

    public boolean hasDataSlots() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Integer dsAccessObj = (Integer)hashMap.get("DATASLOT_ACCESS");
        int n = dsAccessObj;
        BLConstants.single();
        return n != -1;
    }

    public boolean hasReadOnlyDataSlots() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Integer dsAccessObj = (Integer)hashMap.get("DATASLOT_ACCESS");
        int n = dsAccessObj;
        BLConstants.single();
        return n == 0;
    }

    public boolean hasReadWriteDataSlots() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Integer dsAccessObj = (Integer)hashMap.get("DATASLOT_ACCESS");
        int n = dsAccessObj;
        BLConstants.single();
        return n == 1;
    }

    public List<String> getInputDataSlotNames() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Map dataslots = (Map)hashMap.get("DATASLOTNAMELIST");
        if (dataslots == null || dataslots.isEmpty()) {
            return null;
        }
        ArrayList<String> dsNames = new ArrayList<String>();
        for (String dsName : dataslots.keySet()) {
            int dsAccess = (Integer)dataslots.get(dsName);
            BLConstants.single();
            if (dsAccess != 0) continue;
            dsNames.add(dsName);
        }
        return dsNames;
    }

    public List<String> getOutputDataSlotNames() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Map dataslots = (Map)hashMap.get("DATASLOTNAMELIST");
        if (dataslots == null || dataslots.isEmpty()) {
            return null;
        }
        ArrayList<String> dsNames = new ArrayList<String>();
        for (String dsName : dataslots.keySet()) {
            int dsAccess = (Integer)dataslots.get(dsName);
            BLConstants.single();
            if (dsAccess != 1) continue;
            dsNames.add(dsName);
        }
        return dsNames;
    }

    public List<String> getDataSlotNames() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Map dataslots = (Map)hashMap.get("DATASLOTNAMELIST");
        if (dataslots == null || dataslots.isEmpty()) {
            return null;
        }
        ArrayList<String> dsNames = new ArrayList<String>();
        dsNames.addAll(dataslots.keySet());
        return dsNames;
    }

    public DataSlotList getInputDataSlotList() throws BizLogicClientException, RemoteException {
        List<String> dsNames = this.getInputDataSlotNames();
        if (dsNames == null || dsNames.isEmpty()) {
            return new DataSlotList((Session)this.getSession(), new Vector());
        }
        String[] dsNamesArray = dsNames.toArray(new String[]{""});
        return ((WorkItemSB)this.getRemoteRef()).getDataSlotList((Session)this.getSession(), this.getParentWorkItemID(), dsNamesArray, true);
    }

    public DataSlotList getOutputDataSlotList() throws BizLogicClientException, RemoteException {
        List<String> dsNames = this.getOutputDataSlotNames();
        if (dsNames == null || dsNames.isEmpty()) {
            return new DataSlotList((Session)this.getSession(), new Vector());
        }
        String[] dsNamesArray = dsNames.toArray(new String[]{""});
        return ((WorkItemSB)this.getRemoteRef()).getDataSlotList((Session)this.getSession(), this.getParentWorkItemID(), dsNamesArray, true);
    }

    public DataSlotList getDataSlotList() throws BizLogicClientException, RemoteException {
        List<String> dsNames = this.getDataSlotNames();
        if (dsNames == null || dsNames.isEmpty()) {
            return new DataSlotList((Session)this.getSession(), new Vector());
        }
        String[] dsNamesArray = dsNames.toArray(new String[]{""});
        return ((WorkItemSB)this.getRemoteRef()).getDataSlotList((Session)this.getSession(), this.getParentWorkItemID(), dsNamesArray, true);
    }

    public DataSlot getDataSlot(String dsName) throws BizLogicClientException, RemoteException {
        return ((WorkItemSB)this.getRemoteRef()).getDataSlot((Session)this.getSession(), this.getParentWorkItemID(), dsName);
    }

    public void reAssign(String newCollaborator) throws BizLogicClientException, RemoteException {
        if (newCollaborator == null || newCollaborator.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3631", new Object[]{"NULL/EMPTY", this.getName(), this.getCStepName(), this.getParentWorkItemID(), this.getProcessInstanceName()});
        }
        if (!this.isAssigned()) {
            throw new BizLogicClientException("BizLogic_ERR_3632", new Object[]{this.getName(), this.getCStepName(), this.getParentWorkItemID(), this.getProcessInstanceName()});
        }
        ((WorkItemSB)this.getRemoteRef()).reAssignCWorkItem(this.session, this.getProcessInstanceID(), this.getID(), newCollaborator);
        BLConstants.single();
        this.attributes.put("COLLABORATOR", newCollaborator);
    }

    public void assign(String collaborator) throws BizLogicClientException, RemoteException {
        if (!this.isAvailable()) {
            throw new BizLogicClientException("BizLogic_ERR_3622", new Object[]{this.getName(), this.getCStepName(), this.getParentWorkItemID(), this.getProcessInstanceName()});
        }
        ((WorkItemSB)this.getRemoteRef()).assignCWorkItem(this.session, this.getProcessInstanceID(), this.getID(), collaborator);
        BLConstants.single();
        super.setState(65);
        BLConstants.single();
        this.attributes.put("COLLABORATOR", collaborator);
    }

    public void decline(String reason) throws BizLogicClientException, RemoteException {
        if (!this.isAssigned()) {
            throw new BizLogicClientException("BizLogic_ERR_3648", new Object[]{"decline", this.getName(), this.getCStepName(), this.getParentWorkItemID(), this.getProcessInstanceName()});
        }
        ((WorkItemSB)this.getRemoteRef()).declineCWorkItem(this.session, this.getProcessInstanceID(), this.getID(), reason);
        BLConstants.single();
        super.setState(74);
        if (reason != null && reason.trim().length() > 0) {
            BLConstants.single();
            this.attributes.put("RESPONSE", reason);
        }
    }

    @Override
    public void suspend() throws BizLogicClientException, RemoteException {
        if (!this.isAssigned()) {
            throw new BizLogicClientException("BizLogic_ERR_3648", new Object[]{"suspend", this.getName(), this.getCStepName(), this.getParentWorkItemID(), this.getProcessInstanceName()});
        }
        ((WorkItemSB)this.getRemoteRef()).suspendCWorkItem(this.session, this.getProcessInstanceID(), this.getID());
        BLConstants.single();
        super.setState(66);
    }

    @Override
    public void resume() throws BizLogicClientException, RemoteException {
        if (!this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_3647", new Object[]{this.getName(), this.getCStepName(), this.getParentWorkItemID(), this.getProcessInstanceName()});
        }
        ((WorkItemSB)this.getRemoteRef()).resumeCWorkItem(this.session, this.getProcessInstanceID(), this.getID());
        BLConstants.single();
        super.setState(65);
    }

    @Override
    public void remove() throws BizLogicClientException {
        throw new BizLogicClientException("Remove operation is not supported");
    }

    public void terminate() throws BizLogicClientException, RemoteException {
        if (this.isTerminated() || this.isCompleted() || this.isDeclined()) {
            throw new BizLogicClientException("BizLogic_ERR_4634", new Object[]{this.getName(), this.getCStepName(), this.getParentWorkItemID(), this.getProcessInstanceName(), this.getStateDescription()});
        }
        ((WorkItemSB)this.getRemoteRef()).terminateCWorkItem(this.session, this.getProcessInstanceID(), this.getID());
        BLConstants.single();
        super.setState(68);
    }

    @Override
    public void complete() throws BizLogicClientException, RemoteException {
        this.complete(null, null);
    }

    @Override
    public void complete(HashMap dsValues) throws BizLogicClientException, RemoteException {
        this.complete(dsValues, null);
    }

    public void complete(HashMap dsValues, Hashtable resources) throws BizLogicClientException, RemoteException {
        if (!this.isAssigned() && !this.isAvailable()) {
            throw new BizLogicClientException("BizLogic_ERR_3646", new Object[]{this.getName(), this.getCStepName(), this.getParentWorkItemID(), this.getProcessInstanceName(), this.getStateDescription()});
        }
        ((WorkItemSB)this.getRemoteRef()).completeCWorkItem((Session)this.getSession(), this.getProcessInstanceID(), this.getID(), dsValues, this.modifiedAttrs, resources);
        BLConstants.single();
        super.setState(67);
    }

    @Override
    public long getProcessInstanceID() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Long piID = (Long)hashMap.get("PROCESSINSTANCEID");
        return piID;
    }

    @Override
    public String getProcessInstanceName() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (String)hashMap.get("PROCESSINSTANCENAME");
    }

    @Override
    public long getProcessTemplateID() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Long ptID = (Long)hashMap.get("PROCESSTEMPLATEID");
        return ptID;
    }

    @Override
    public String getProcessTemplateName() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (String)hashMap.get("PROCESSTEMPLATENAME");
    }

    @Override
    public String getAppName() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (String)hashMap.get("APP_NAME");
    }

    public WorkItem getParent() throws BizLogicClientException, RemoteException {
        if (this.parent == null) {
            this.parent = ((WorkItemSB)CWorkItem.getRemoteRef(WorkItemSBHome.class)).getWorkItem(this.session, this.getParentWorkItemID());
        }
        return this.parent;
    }

    public long getParentWorkItemID() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Long wiid = (Long)hashMap.get("PARENT_WORKITEM_ID");
        return wiid;
    }

    public long getCStepID() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Long cStepID = (Long)hashMap.get("CSTEP_ID");
        return cStepID;
    }

    public String getCStepName() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        String cStepName = (String)hashMap.get("CSTEP_NAME");
        return cStepName;
    }

    @Override
    public HashMap getProcessContext() {
        return this.getAttributes();
    }

    @Override
    public void refresh() throws BizLogicClientException, RemoteException {
        this.attributes = (HashMap)((WorkItemSB)this.getRemoteRef()).getCWorkItemAttributes(this.session, this.getID());
        this.modifiedAttrs.clear();
        this.parent = null;
    }

    @Override
    public void save() throws BizLogicClientException, RemoteException {
        boolean receivedException = false;
        try {
            if (!this.modifiedAttrs.isEmpty()) {
                ((WorkItemSB)this.getRemoteRef()).saveCWorkItem(this.session, this.getID(), this.modifiedAttrs);
                this.modifiedAttrs.clear();
            }
        }
        catch (BizLogicException | RemoteException e) {
            receivedException = true;
            throw e;
        }
        finally {
            CWorkItem.doFinally(receivedException, this);
        }
    }

    @Override
    protected EJBObject findRemoteRef() throws BizLogicClientException, RemoteException {
        try {
            return (WorkItemSB)CWorkItem.getRemoteRef(WorkItemSBHome.class);
        }
        catch (Exception e) {
            throw new BizLogicClientException("BizLogic_ERR_1527", new Object[]{this.getName()}, (Throwable)e);
        }
    }

    private void checkStateForModify(String field) throws BizLogicClientException {
        if (!this.isAssigned() && !this.isAvailable()) {
            throw new BizLogicClientException("BizLogic_ERR_3638", new Object[]{field, this.getName(), this.getCStepName(), this.getProcessInstanceName(), this.getStateDescription()});
        }
    }

    @Override
    public boolean isActivated() {
        block3: {
            block2: {
                int state = super.getState();
                BLConstants consts = BLConstants.single();
                if (state == 65) break block2;
                if (state == 69) break block2;
                if (state != 70) break block3;
            }
            return true;
        }
        return false;
    }

    public static CWorkItemList getCWorkItemListForCollaborator(Session session) {
        QSCWorkItem qsCWorkItem = CWorkItem.getQSCWorkItem(session);
        return qsCWorkItem.getListByCollaborator(null, new int[0]);
    }

    public static CWorkItemList getCWorkItemListByCreator(Session session) {
        QSCWorkItem qsCWorkItem = CWorkItem.getQSCWorkItem(session);
        return qsCWorkItem.getListByCreator(null, new int[0]);
    }

    static QSCWorkItem getQSCWorkItem(Session session) {
        QueryService qs = new QueryService(session);
        QSCWorkItem qsCWorkItem = qs.getCWorkItem();
        return qsCWorkItem;
    }

    public static CWorkItem get(Session session, long cWorkItemId) throws BizLogicClientException, RemoteException {
        WorkItemSB wiSB = (WorkItemSB)CWorkItem.getRemoteRef(WorkItemSBHome.class);
        return wiSB.getCWorkItem(session, cWorkItemId);
    }
}

