/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.ejb.BizStoreSB;
import com.savvion.sbm.bizlogic.server.svo.BizLogicServer;
import com.savvion.sbm.bizlogic.storeevent.mconsole.ejb.MConsoleSB;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLJMSService;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.ResourceUtil;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;

public class BizLogicCluster
extends BizLogicServer {
    private boolean printStatus;
    private boolean started;
    private boolean failed;
    private Boolean startMConsole;
    private static final String ALREADY = "already";
    private static final String FAILED = "failed";
    private static final String BL_CONF_FILE = "bizlogic.conf";
    private static final String START_MCONSOLE = "bizlogic.start.mconsole";

    public BizLogicCluster(String user, String passwd) {
        BLConstants.ClusterConstants cfr_ignored_0 = BLConstants.single().cluster;
        this(user, passwd, -1);
    }

    public BizLogicCluster(int count) {
        this.printStatus = true;
        this.started = false;
        this.failed = false;
        this.startMConsole = null;
        this.loginFrame("Enter user details...");
        this.validateUser(this.user, this.passwd);
        this.init(count);
    }

    public BizLogicCluster(String user, String passwd, int count) {
        this.printStatus = true;
        this.started = false;
        this.failed = false;
        this.startMConsole = null;
        this.validateUser(user, passwd);
        this.user = user;
        this.passwd = passwd;
        this.init(count);
    }

    public BizLogicCluster(int count, boolean showDialog) {
        this.printStatus = true;
        this.started = false;
        this.failed = false;
        this.startMConsole = null;
        if (showDialog) {
            this.loginFrame("Enter user details...");
            if (this.isCancelled()) {
                return;
            }
        } else {
            this.user = SBMUtil.self().getGuestUser();
            this.passwd = SBMUtil.self().getGuestPasswd();
        }
        this.validateUser(this.user, this.passwd);
        this.init(count);
    }

    public BizLogicCluster(com.savvion.sbm.bizlogic.util.Session sess, int count) {
        this.printStatus = true;
        this.started = false;
        this.failed = false;
        this.startMConsole = null;
        if (!this.isValidSession(sess)) {
            throw new BizLogicClientException("BizLogic_ERR_3854");
        }
        this.user = sess.getUser();
        this.session = sess;
        this.init(count);
    }

    @Override
    public Map<String, String> start() {
        BLConstants.ClusterConstants cfr_ignored_0 = BLConstants.single().cluster;
        return this.startServers("BL_START", this.nodeCount);
    }

    @Override
    public Map<String, String> shutdown() {
        BLConstants.ClusterConstants cfr_ignored_0 = BLConstants.single().cluster;
        this.notifyClusterNodes("BL_STOP");
        HashMap<String, String> blInfo = this.getNodeResponses(this.nodeCount);
        if (this.isStartMConsole()) {
            this.stopMConsole();
        }
        return blInfo;
    }

    public Map<String, String> addNode(int nodecnt) {
        BLConstants.ClusterConstants cfr_ignored_0 = BLConstants.single().cluster;
        this.notifyClusterNodes("BL_ADDNODE");
        HashMap<String, String> blInfo = this.getNodeResponses(nodecnt);
        this.nodeCount += blInfo.size();
        this.startBizStore();
        if (this.isStartMConsole()) {
            this.startMConsole();
        }
        this.startBLServices();
        return blInfo;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void setPrintStatus(boolean status) {
        this.printStatus = status;
    }

    private Map<String, String> startServers(String type, int nodecnt) {
        if (this.passwd == null) {
            throw new BizLogicClientException("BizLogic_ERR_3855");
        }
        this.notifyClusterNodes(type);
        HashMap<String, String> map = this.getNodeResponses(nodecnt);
        this.checkNodeResponses(map);
        if (this.isAllNodeFailed()) {
            throw new BizLogicClientException("BizLogic_ERR_3862");
        }
        if (!this.isAnyNodeStarted()) {
            this.restartExternalServices();
        } else {
            this.resumeConnectionsCluster();
        }
        this.startBizStore();
        if (this.isStartMConsole()) {
            this.startMConsole();
        }
        this.startBLServices();
        return map;
    }

    private void startBizStore() {
        this.printMessage("Starting BizStore service...");
        BizStoreSB bizStoreSB = this.getBizStoreRef();
        try {
            bizStoreSB.start(this.user, this.passwd);
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
    }

    private void startMConsole() {
        this.printMessage("Starting Management Console service...");
        MConsoleSB mconsoleSB = this.getMConsoleRef();
        try {
            mconsoleSB.start(this.user, this.passwd);
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
    }

    private void stopMConsole() {
        this.printMessage("Stopping Management Console service...");
        MConsoleSB mconsoleSB = this.getMConsoleRef();
        try {
            mconsoleSB.stop(this.user, this.passwd);
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
    }

    private void restartExternalServices() {
        BLConstants consts = BLConstants.single();
        HashMap<String, Object> selectors = new HashMap<String, Object>();
        BLConstants.ClusterConstants cfr_ignored_0 = consts.cluster;
        BLConstants.ClusterConstants cfr_ignored_1 = consts.cluster;
        selectors.put("CLUSTER_OPERATION", "BL_RESTART_EXTERNAL_SERVICES");
        SBMConstants.self().getClass();
        selectors.put("TYPE", "BLADMINMDB");
        BLConstants.ClusterConstants cfr_ignored_2 = consts.cluster;
        BLConstants.ClusterConstants cfr_ignored_3 = consts.cluster;
        selectors.put("REPEAT_MSG_COUNT", 1);
        this.sendJMSMessage("bladminqueue", "", 1, selectors);
    }

    private void resumeConnectionsCluster() {
        BLConstants consts = BLConstants.single();
        HashMap<String, Object> selectors = new HashMap<String, Object>();
        BLConstants.ClusterConstants cfr_ignored_0 = consts.cluster;
        BLConstants.ClusterConstants cfr_ignored_1 = consts.cluster;
        selectors.put("CLUSTER_OPERATION", "BL_RESUME_CONNECTIONS");
        SBMConstants.self().getClass();
        selectors.put("TYPE", "BLSERVICEMDB");
        this.sendJMSMessage("bladmintopic", "", 1, selectors);
    }

    private void startBLServices() {
        BLConstants consts = BLConstants.single();
        this.printMessage("Starting Session service...");
        this.startBLService("BLSESSIONMDB", "START");
        this.printMessage("Starting Resume Workstep service...");
        this.startBLService("BLRESUMEWSMDB", "START");
        this.printMessage("Starting Check Due service...");
        this.startBLService("BLCHECKDUEMDB", "START");
        this.printMessage("Starting Email service...");
        this.startBLService("BLEMAILMDB", "START");
    }

    private void startBLService(String mdbName, String operation) {
        HashMap<String, Object> selectors = new HashMap<String, Object>();
        SBMConstants.self().getClass();
        selectors.put("OPERATION", operation);
        SBMConstants.self().getClass();
        selectors.put("TYPE", mdbName);
        SBMConstants.self().getClass();
        this.sendJMSMessage("sbmtopic", "", 1, selectors);
    }

    private void sendJMSMessage(String destination, Object msg, int msgType, HashMap<String, Object> selectors) {
        try {
            BLJMSService.self().sendMessage(destination, msg, msgType, selectors);
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClusterNodes(String cmd) {
        Session sess = null;
        BLConstants consts = BLConstants.single();
        Connection conn = null;
        try {
            conn = BLJMSService.self().getConnection("bladmintopic");
            sess = BLJMSService.self().createSession(conn);
            Destination dest = BLJMSService.self().lookupChannelDestination("bladmintopic");
            HashMap<String, String> selectors = new HashMap<String, String>();
            BLConstants.ClusterConstants cfr_ignored_0 = consts.cluster;
            selectors.put("CLUSTER_OPERATION", cmd);
            SBMConstants.self().getClass();
            selectors.put("TYPE", "BLSERVICEMDB");
            BLConstants.ClusterConstants cfr_ignored_1 = consts.cluster;
            selectors.put("NODECOUNT", "" + this.nodeCount);
            Message msg = BLJMSService.self().createMessage(sess, 1, (Object)"", selectors);
            if (this.nodeCount > 0) {
                msg.setJMSReplyTo(dest);
            }
            BLJMSService.self().sendMessage(dest, msg);
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
        finally {
            try {
                if (sess != null) {
                    sess.close();
                }
            }
            catch (JMSException dest) {}
            BLJMSService.self().closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap<String, String> getNodeResponses(int count) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        BLConstants consts = BLConstants.single();
        if (!this.waitForResponse()) {
            try {
                BLConstants.ClusterConstants cfr_ignored_0 = consts.cluster;
                Thread.sleep(60000L / 2L);
                return map;
            }
            catch (InterruptedException ie) {
                this.throwEx(ie);
            }
            return map;
        }
        Session sess = null;
        MessageConsumer consumer = null;
        Connection conn = null;
        try {
            String destination2332 = "bladmintopic";
            String selector = "TYPE = 'BIZLOGICSERVER'";
            BLJMSService service = BLJMSService.self();
            conn = service.getConnection("bladmintopic");
            sess = service.createSession(conn);
            Destination dest = service.lookupChannelDestination(destination2332);
            consumer = sess.createConsumer(dest, selector, false);
            for (int i = 0; i < count; ++i) {
                Message msg = consumer.receive(timeout);
                if (msg == null) continue;
                String host = msg.getStringProperty("SERVER_HOST");
                String serverName = msg.getStringProperty("SERVER_NAME");
                String desc = msg.getStringProperty("SERVER_MSG");
                if (desc != null && host != null) {
                    map.put(host, desc);
                }
                this.printMessage("Received response: " + host + '(' + serverName + ')' + ": " + desc);
            }
        }
        catch (Throwable th) {
            try {
                this.throwEx(th);
                return map;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (consumer != null) {
                        consumer.close();
                    }
                }
                catch (JMSException jMSException) {}
                BLJMSService.self().closeConnection(conn);
            }
        }
        try {
            if (consumer != null) {
                consumer.close();
            }
        }
        catch (JMSException destination2332) {
            // empty catch block
        }
        BLJMSService.self().closeConnection(conn);
        return map;
    }

    private boolean waitForResponse() {
        BLConstants.ClusterConstants cfr_ignored_0 = BLConstants.single().cluster;
        return this.nodeCount != -1;
    }

    private void printMessage(String msg) {
        if (this.printStatus) {
            LoggerUtil.logSOP((Object)msg);
        }
    }

    private void checkNodeResponses(Map<String, String> map) {
        this.started = false;
        this.failed = false;
        int failcnt = 0;
        Object[] elements = map.values().toArray();
        for (int iy = 0; iy < elements.length; ++iy) {
            String s1 = (String)elements[iy];
            if (s1 == null) continue;
            if (s1.indexOf(ALREADY) > 0) {
                this.started = true;
                break;
            }
            if (s1.indexOf(FAILED) <= 0) continue;
            ++failcnt;
        }
        if (elements.length > 0 && failcnt == elements.length) {
            this.failed = true;
        }
    }

    private boolean isAnyNodeStarted() {
        return this.started;
    }

    private boolean isAllNodeFailed() {
        return this.failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStartMConsole() {
        if (this.startMConsole == null) {
            BizLogicCluster bizLogicCluster = this;
            synchronized (bizLogicCluster) {
                if (this.startMConsole == null) {
                    Properties prop = null;
                    try {
                        prop = ResourceUtil.getPropertyObject((String)BL_CONF_FILE);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("Caught an Exception while reading bizlogic.conf", ioe);
                    }
                    String strStartMConsole = prop.getProperty(START_MCONSOLE);
                    this.startMConsole = SBMUtil.isValidProperty((String)strStartMConsole) ? Boolean.valueOf(Boolean.parseBoolean(strStartMConsole.trim())) : Boolean.FALSE;
                }
            }
        }
        return this.startMConsole;
    }
}

