/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.enums.SubProcessType;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.EntityAdapter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;

public class ProcessInstanceEBBBean
extends EntityAdapter {
    public Long id;
    public long rootTemplateID;
    public long processTemplateID;
    public long rootInstanceID;
    public long duedate;
    public long timeStarted;
    public int state;
    public int priority;
    public int isCallbackCaller;
    public String name;
    public String creator;
    public String startPoint;
    public String nodeVisited;
    public long parentID;
    public String folderId;
    public HashMap callerInfo = null;

    public Long getId() {
        return this.id;
    }

    public long getRootTemplateID() {
        return this.rootTemplateID;
    }

    public long getProcessTemplateID() {
        return this.processTemplateID;
    }

    public long getRootInstanceID() {
        return this.rootInstanceID;
    }

    public long getDuedate() {
        return this.duedate;
    }

    public long getTimeStarted() {
        return this.timeStarted;
    }

    public int getState() {
        return this.state;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getIsCallbackCaller() {
        return this.isCallbackCaller;
    }

    public String getName() {
        return this.name;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getStartPoint() {
        if (this.startPoint == null) {
            Long piid = (Long)this.ctx.getPrimaryKey();
            ProcessInstanceDAO.getStartPoint(this, piid);
        }
        return this.startPoint;
    }

    public String getNodeVisited() {
        if (this.nodeVisited == null) {
            Long piid = (Long)this.ctx.getPrimaryKey();
            ProcessInstanceDAO.getNodeVisited(this, piid);
        }
        return this.nodeVisited;
    }

    public HashMap getCallerInfo() {
        if (this.callerInfo == null) {
            Long piid = (Long)this.ctx.getPrimaryKey();
            ProcessInstanceDAO.getCallerInfo(this, piid);
        }
        return this.callerInfo;
    }

    public long getParentID() {
        return this.parentID;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public void setDuedate(long duedate) {
        this.duedate = duedate;
        this.modifiedAttrs.put("DUEDATE", duedate);
    }

    public void setTimeStarted(long timeStarted) {
        this.timeStarted = timeStarted;
        this.modifiedAttrs.put("STARTTIME", timeStarted);
    }

    public void setState(int state) {
        this.state = state;
        this.modifiedAttrs.put("STATUS", state);
    }

    public void setIsCallbackCaller(int isCallbackCaller) {
        this.isCallbackCaller = isCallbackCaller;
        this.modifiedAttrs.put("ISCALLBACKCALLER", isCallbackCaller);
    }

    public void setCreator(String creator) {
        if (creator != null && creator.length() > BLControl.util.MAX_CREATOR_SIZE) {
            throw new BizLogicException("BizLogic_ERR_685", "PIEB::setCreator", new Object[]{creator, this.getName(), String.valueOf(BLControl.util.MAX_CREATOR_SIZE)});
        }
        this.creator = creator;
        this.modifiedAttrs.put("CREATOR", creator);
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.modifiedAttrs.put("PRIORITY", priority);
    }

    public void setStartPoint(String startPoint) {
        this.startPoint = startPoint;
        this.modifiedAttrs.put("STARTPOINT", startPoint);
    }

    public void setNodeVisited(String nodeVisited) {
        if (nodeVisited != null && nodeVisited.length() > BLControl.util.MAX_NODEVISITED_SIZE) {
            throw new BizLogicException("BizLogic_ERR_684", "PIEB::setNodeVisited", new Object[]{nodeVisited, this.getName(), String.valueOf(BLControl.util.MAX_NODEVISITED_SIZE)});
        }
        this.nodeVisited = nodeVisited;
        this.modifiedAttrs.put("NODEVISITED", nodeVisited);
    }

    public void setCallerInfo(HashMap callerInfo) {
        this.callerInfo = callerInfo;
        this.modifiedAttrs.put("CALLERINFO", callerInfo);
    }

    public void setParentID(long parentID) {
        this.parentID = parentID;
        this.modifiedAttrs.put("PARENTID", parentID);
    }

    public void setFolderId(String folderId) {
        if (folderId == null || folderId.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_3066", "PIEB.setFolderId()", new Object[]{this.id});
        }
        this.folderId = folderId;
        this.modifiedAttrs.put("FOLDER_ID", folderId);
    }

    public HashMap getAttributes() {
        HashMap<String, Object> attrsList = new HashMap<String, Object>();
        attrsList.put("PROCESSINSTANCEID", this.id);
        attrsList.put("PROCESSTEMPLATEID", this.processTemplateID);
        attrsList.put("RPTID", this.rootTemplateID);
        attrsList.put("RPID", this.rootInstanceID);
        attrsList.put("DUEDATE", this.duedate);
        attrsList.put("STARTTIME", this.timeStarted);
        attrsList.put("STATUS", this.state);
        attrsList.put("PRIORITY", this.priority);
        attrsList.put("PROCESSINSTANCENAME", this.name);
        attrsList.put("CREATOR", this.creator);
        attrsList.put("PARENTID", this.parentID);
        attrsList.put("ISCALLBACKCALLER", this.isCallbackCaller);
        attrsList.put("FOLDER_ID", this.folderId);
        return attrsList;
    }

    public void ejbHomeDelete(Long piid) throws RemoveException {
        ProcessInstanceDAO.remove(piid);
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"PIEB", "ejbHomeDelete()", this.getPrimaryKey(piid), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
    }

    public Long ejbCreate(HashMap attrsList) throws CreateException {
        Iterator keySet = attrsList.keySet().iterator();
        String key = null;
        Object value = null;
        while (keySet.hasNext()) {
            key = (String)keySet.next();
            value = attrsList.get(key);
            if (key.equalsIgnoreCase("PROCESSINSTANCEID")) {
                this.id = value;
                continue;
            }
            if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) {
                this.processTemplateID = value;
                continue;
            }
            if (key.equalsIgnoreCase("RPTID")) {
                this.rootTemplateID = value;
                continue;
            }
            if (key.equalsIgnoreCase("PARENTID")) {
                this.parentID = value;
                continue;
            }
            if (key.equalsIgnoreCase("RPID")) {
                this.rootInstanceID = value;
                continue;
            }
            if (key.equalsIgnoreCase("DUEDATE")) {
                this.duedate = value;
                continue;
            }
            if (key.equalsIgnoreCase("STATUS")) {
                this.state = value;
                continue;
            }
            if (key.equalsIgnoreCase("PROCESSINSTANCENAME")) {
                this.name = value;
                continue;
            }
            if (key.equalsIgnoreCase("CREATOR")) {
                this.creator = value;
                continue;
            }
            if (key.equalsIgnoreCase("PRIORITY")) {
                this.priority = value;
                continue;
            }
            if (key.equalsIgnoreCase("ISCALLBACKCALLER")) {
                this.isCallbackCaller = value;
                continue;
            }
            if (key.equalsIgnoreCase("FOLDER_ID")) {
                this.folderId = value;
                continue;
            }
            Object[] eargs = new Object[]{"PIEB.create()", key, value};
            throw new BizLogicException("BizLogic_ERR_1506", "ProcessInstanceEBBean.ejbCreate", eargs);
        }
        ProcessInstanceDAO.create(attrsList);
        this.setLoaded(true);
        this.modifiedAttrs = new HashMap();
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"PIEB", "ejbCreate()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
        return this.id;
    }

    public void ejbPostCreate(HashMap attrsList) {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"PIEB", "ejbPostCreate()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
    }

    public Long ejbFindByPrimaryKey(Long piid) throws ObjectNotFoundException {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"PIEB", "ejbFindByPrimaryKey()", this.getPrimaryKey(piid), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
        return ProcessInstanceDAO.findByPrimaryKey(piid);
    }

    public Long ejbFindByName(String piName) throws ObjectNotFoundException {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"PIEB", "ejbFindByName()", this};
            BLControl.logger.debugKey("BizLogic_ERR_1201", largs);
        }
        return ProcessInstanceDAO.findByName(piName);
    }

    public Collection ejbFindByProcessTemplate(long ptid) {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"PIEB", "ejbFindByProcessTemplate()", this};
            BLControl.logger.debugKey("BizLogic_ERR_1201", largs);
        }
        return ProcessInstanceDAO.findByProcessTemplate(ptid);
    }

    public void ejbActivate() {
        this.setLoaded(false);
        this.modifiedAttrs = new HashMap();
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"PIEB", "ejbActivate()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
    }

    public void ejbPassivate() {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"PIEB", "ejbPassivate()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
        this.setLoaded(false);
        this.modifiedAttrs = new HashMap();
        this.clean();
    }

    public void ejbLoad() {
        Object[] largs;
        if (BLControl.util.DEBUG_ENTITY) {
            largs = new Object[]{"PIEB", "ejbLoad()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1208", largs);
        }
        if (this.isLoadRequired()) {
            this.load();
            if (BLControl.util.DEBUG_ENTITY) {
                largs = new Object[]{"PIEB", "ejbLoad()", this.getPrimaryKey(), this};
                BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
            }
        }
    }

    private void load() {
        Long piid = (Long)this.ctx.getPrimaryKey();
        ProcessInstanceDAO.load(this, piid);
        this.setLoaded(true);
        this.modifiedAttrs = new HashMap();
    }

    public void ejbStore() {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"PIEB", "ejbStore()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1208", largs);
        }
        if (!this.modifiedAttrs.isEmpty()) {
            Long piid = (Long)this.ctx.getPrimaryKey();
            ProcessInstanceDAO.store(this, piid, this.modifiedAttrs);
            this.modifiedAttrs = new HashMap();
            if (BLControl.util.DEBUG_ENTITY) {
                Object[] largs = new Object[]{"PIEB", "ejbStore()", this.getPrimaryKey(), this};
                BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
            }
        }
    }

    public void ejbRemove() throws RemoveException {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"PIEB", "ejbRemove()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
        Long piid = (Long)this.ctx.getPrimaryKey();
        this.setLoaded(false);
        this.clean();
        ProcessInstanceDAO.remove(piid);
    }

    protected final void clean() {
        this.id = -1L;
        this.processTemplateID = -1L;
        this.rootTemplateID = -1L;
        this.rootInstanceID = -1L;
        this.duedate = -1L;
        this.timeStarted = -1L;
        this.state = 0;
        this.priority = 0;
        this.isCallbackCaller = 0;
        this.name = null;
        this.creator = null;
        this.startPoint = null;
        this.nodeVisited = null;
        this.parentID = -1L;
        this.folderId = null;
    }

    public boolean isSubProcessInstance() {
        return this.rootInstanceID != this.id;
    }

    public boolean isSyncSubProcessInstance() {
        return SubProcessType.isSynchronousSubProcess((int)this.isCallbackCaller);
    }

    public boolean isSuspended() {
        return this.state == 8;
    }

    private String getPrimaryKey(long piid) {
        StringBuilder parameters = new StringBuilder("piid=");
        parameters.append(piid);
        return parameters.toString();
    }

    private String getPrimaryKey() {
        long piid = -1L;
        if (this.id != null) {
            piid = this.id;
        }
        return this.getPrimaryKey(piid);
    }
}

