/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ProcessInstanceXMLDAO
extends BLDAOService {
    private static final String[] CREATE_LIST;
    private static final String[] LOAD_LIST;
    private static String insertProcessInstanceXML;
    private static String loadProcessInstanceXML;
    private static String removeProcessInstanceXML;
    private static String updateProcessInstanceXML;
    private static String getRemoveOnCompletion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(long piID, long parentID, String xmlDefinition, boolean removeOnCompletion) {
        block6: {
            Connection conn = null;
            PreparedStatement pstmtInsertProcessInstanceXML = null;
            ByteArrayInputStream piXMLInsert = null;
            int rm = 0;
            if (removeOnCompletion) {
                rm = 1;
            }
            try {
                conn = ProcessInstanceXMLDAO.getConnection();
                pstmtInsertProcessInstanceXML = conn.prepareStatement(insertProcessInstanceXML);
                pstmtInsertProcessInstanceXML.setLong(1, piID);
                pstmtInsertProcessInstanceXML.setLong(2, parentID);
                pstmtInsertProcessInstanceXML.setInt(3, rm);
                piXMLInsert = new ByteArrayInputStream(ProcessInstanceXMLDAO.convertToBytes((Object)xmlDefinition));
                pstmtInsertProcessInstanceXML.setBinaryStream(4, (InputStream)piXMLInsert, piXMLInsert.available());
                pstmtInsertProcessInstanceXML.executeUpdate();
                ProcessInstanceXMLDAO.clean(null, (Statement)pstmtInsertProcessInstanceXML, (Connection)conn);
            }
            catch (SQLException sqlerr) {
                ProcessInstanceXMLDAO.handle((SQLException)sqlerr);
                break block6;
            }
            finally {
                ProcessInstanceXMLDAO.clean(null, (Statement)pstmtInsertProcessInstanceXML, (Connection)conn);
                FileUtil.close(piXMLInsert);
            }
            FileUtil.close((InputStream)piXMLInsert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String load(long piID) {
        String piXML;
        block7: {
            Connection conn = null;
            PreparedStatement pstmtLoadProcessInstanceXML = null;
            ResultSet rset = null;
            piXML = null;
            InputStream is = null;
            try {
                conn = ProcessInstanceXMLDAO.getConnection();
                pstmtLoadProcessInstanceXML = conn.prepareStatement(loadProcessInstanceXML);
                pstmtLoadProcessInstanceXML.setLong(1, piID);
                rset = pstmtLoadProcessInstanceXML.executeQuery();
                if (rset.next()) {
                    is = rset.getBinaryStream(1);
                    piXML = (String)ProcessInstanceXMLDAO.convertToObject((InputStream)is);
                }
                ProcessInstanceXMLDAO.clean((ResultSet)rset, (Statement)pstmtLoadProcessInstanceXML, (Connection)conn);
            }
            catch (SQLException sqlerr) {
                ProcessInstanceXMLDAO.handle((SQLException)sqlerr);
                break block7;
            }
            finally {
                ProcessInstanceXMLDAO.clean(rset, (Statement)pstmtLoadProcessInstanceXML, (Connection)conn);
                FileUtil.close(is);
            }
            FileUtil.close((InputStream)is);
        }
        if (piXML != null && piXML.length() == 0) {
            throw new BizLogicException("BizLogic_ERR_2541", "ProcessInstanceXMLDAO.load");
        }
        return piXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRemoveOnCompletion(long piID) {
        Connection conn = null;
        PreparedStatement pstmtGetRemoveOnCompletion = null;
        ResultSet rset = null;
        boolean removeOnCompletion = false;
        try {
            int rm;
            conn = ProcessInstanceXMLDAO.getConnection();
            pstmtGetRemoveOnCompletion = conn.prepareStatement(getRemoveOnCompletion);
            pstmtGetRemoveOnCompletion.setLong(1, piID);
            rset = pstmtGetRemoveOnCompletion.executeQuery();
            if (rset.next() && (rm = rset.getInt(1)) == 1) {
                removeOnCompletion = true;
            }
            ProcessInstanceXMLDAO.clean((ResultSet)rset, (Statement)pstmtGetRemoveOnCompletion, (Connection)conn);
        }
        catch (SQLException sqlerr) {
            ProcessInstanceXMLDAO.handle((SQLException)sqlerr);
        }
        finally {
            ProcessInstanceXMLDAO.clean(rset, (Statement)pstmtGetRemoveOnCompletion, (Connection)conn);
        }
        return removeOnCompletion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(long piID) {
        Connection conn = null;
        PreparedStatement pstmtRemoveProcessInstanceXML = null;
        try {
            conn = ProcessInstanceXMLDAO.getConnection();
            pstmtRemoveProcessInstanceXML = conn.prepareStatement(removeProcessInstanceXML);
            pstmtRemoveProcessInstanceXML.setLong(1, piID);
            pstmtRemoveProcessInstanceXML.executeUpdate();
        }
        catch (SQLException sqlerr) {
            ProcessInstanceXMLDAO.handle((SQLException)sqlerr);
        }
        finally {
            ProcessInstanceXMLDAO.clean(null, (Statement)pstmtRemoveProcessInstanceXML, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(long piID, String xml) {
        block5: {
            Connection conn = null;
            PreparedStatement pstmtUpdateProcessInstanceXML = null;
            ByteArrayInputStream piXMLUpdate = null;
            try {
                conn = ProcessInstanceXMLDAO.getConnection();
                pstmtUpdateProcessInstanceXML = conn.prepareStatement(updateProcessInstanceXML);
                piXMLUpdate = new ByteArrayInputStream(ProcessInstanceXMLDAO.convertToBytes((Object)xml));
                pstmtUpdateProcessInstanceXML.setBinaryStream(1, (InputStream)piXMLUpdate, piXMLUpdate.available());
                pstmtUpdateProcessInstanceXML.setLong(2, piID);
                pstmtUpdateProcessInstanceXML.executeUpdate();
                ProcessInstanceXMLDAO.clean(null, (Statement)pstmtUpdateProcessInstanceXML, (Connection)conn);
            }
            catch (SQLException sqlerr) {
                ProcessInstanceXMLDAO.handle((SQLException)sqlerr);
                break block5;
            }
            finally {
                ProcessInstanceXMLDAO.clean(null, (Statement)pstmtUpdateProcessInstanceXML, (Connection)conn);
                FileUtil.close(piXMLUpdate);
            }
            FileUtil.close((InputStream)piXMLUpdate);
        }
    }

    public static synchronized void initSQLStatements() {
        int ix = 0;
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("insert into ");
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        buffer.append("BIZLOGIC_PIXML");
        buffer.append(" (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            buffer.append(CREATE_LIST[ix]);
            if (ix == CREATE_LIST.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(") values (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            buffer.append("?");
            if (ix == CREATE_LIST.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        insertProcessInstanceXML = buffer.toString();
        buffer = new StringBuffer(100);
        buffer.append("select ");
        for (ix = 0; ix < LOAD_LIST.length; ++ix) {
            buffer.append(LOAD_LIST[ix]);
            if (ix == LOAD_LIST.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(" from ");
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        buffer.append("BIZLOGIC_PIXML");
        buffer.append(" where ");
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        buffer.append("PROCESS_INSTANCE_ID").append(" = ?");
        loadProcessInstanceXML = buffer.toString();
        buffer = new StringBuffer(100);
        buffer.append("delete from ");
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        buffer.append("BIZLOGIC_PIXML");
        buffer.append(" where  ");
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        buffer.append("PROCESS_INSTANCE_ID").append(" = ?");
        removeProcessInstanceXML = buffer.toString();
        buffer = new StringBuffer(100);
        buffer.append("update ");
        DBConstants.TableConstants cfr_ignored_5 = BLControl.dbconsts.tab;
        buffer.append("BIZLOGIC_PIXML");
        buffer.append(" set  ");
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        buffer.append("PROCESS_XML").append(" = ? where ");
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        buffer.append("PROCESS_INSTANCE_ID").append(" = ?");
        updateProcessInstanceXML = buffer.toString();
        buffer = new StringBuffer(100);
        buffer.append("select ");
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        buffer.append("REMOVE_ON_COMPLETION");
        buffer.append(" from ");
        DBConstants.TableConstants cfr_ignored_9 = BLControl.dbconsts.tab;
        buffer.append("BIZLOGIC_PIXML");
        buffer.append(" where ");
        DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
        buffer.append("PROCESS_INSTANCE_ID").append(" = ?");
        getRemoveOnCompletion = buffer.toString();
        ProcessInstanceXMLDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"ProcessInstanceXMLDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", insertProcessInstanceXML, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadProcessInstanceXML, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeProcessInstanceXML, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", updateProcessInstanceXML, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getRemoveOnCompletion, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[4];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[1] = "PARENT_ID";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[2] = "REMOVE_ON_COMPLETION";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray[3] = "PROCESS_XML";
        CREATE_LIST = stringArray;
        String[] stringArray2 = new String[1];
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray2[0] = "PROCESS_XML";
        LOAD_LIST = stringArray2;
    }
}

