/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.DBConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class BLResourcesDAO
extends BLDAOService {
    private static final String[] INSERT_RESOURCE_LIST;
    private static String insertResources;
    private static String deleteResources;

    public static void create(long ptid, List<Map<String, Object>> resList) {
        if (resList == null || resList.isEmpty()) {
            return;
        }
        for (int i = 0; i < resList.size(); ++i) {
            BLResourcesDAO.create(ptid, resList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void create(long ptid, Map<String, Object> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmtInsertResources = null;
        try {
            conn = BLResourcesDAO.getConnection();
            pstmtInsertResources = conn.prepareStatement(insertResources);
            String key = null;
            Object value = null;
            for (int i = 0; i < INSERT_RESOURCE_LIST.length; ++i) {
                block16: {
                    block15: {
                        key = INSERT_RESOURCE_LIST[i];
                        value = attributes.get(key);
                        DBConstants.ColConstants cfr_ignored_0 = DBConstants.single().col;
                        if (key.equals("PROCESS_TEMPLATE_ID")) {
                            pstmtInsertResources.setLong(i + 1, ptid);
                            continue;
                        }
                        DBConstants.ColConstants cfr_ignored_1 = DBConstants.single().col;
                        if (key.equals("NAME")) break block15;
                        DBConstants.ColConstants cfr_ignored_2 = DBConstants.single().col;
                        if (key.equals("TYPE")) break block15;
                        DBConstants.ColConstants cfr_ignored_3 = DBConstants.single().col;
                        if (!key.equals("UNIT")) break block16;
                    }
                    if (value == null) {
                        pstmtInsertResources.setNull(i + 1, 12);
                        continue;
                    }
                    pstmtInsertResources.setString(i + 1, (String)value);
                    continue;
                }
                DBConstants.ColConstants cfr_ignored_4 = DBConstants.single().col;
                if (!key.equals("UNIT_COST")) {
                    DBConstants.ColConstants cfr_ignored_5 = DBConstants.single().col;
                    if (!key.equals("THRESHOLD")) continue;
                }
                if (value == null) {
                    pstmtInsertResources.setNull(i + 1, 8);
                    continue;
                }
                pstmtInsertResources.setDouble(i + 1, (Double)value);
            }
            pstmtInsertResources.execute();
        }
        catch (SQLException e) {
            BLResourcesDAO.handle((Throwable)e, (String)("BLResourcesDAO.insert() " + attributes));
        }
        finally {
            BLResourcesDAO.clean(null, (Statement)pstmtInsertResources, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(long ptid) {
        Connection conn = null;
        PreparedStatement pstmtDeleteResources = null;
        try {
            conn = BLResourcesDAO.getConnection();
            pstmtDeleteResources = conn.prepareStatement(deleteResources);
            pstmtDeleteResources.setLong(1, ptid);
            pstmtDeleteResources.execute();
        }
        catch (SQLException e) {
            BLResourcesDAO.handle((Throwable)e, (String)("BLResourcesDAO.delete() ptid : " + ptid));
        }
        finally {
            BLResourcesDAO.clean(null, (Statement)pstmtDeleteResources, (Connection)conn);
        }
    }

    public static synchronized void initSQLStatements() {
        DBConstants.TableConstants cfr_ignored_0 = DBConstants.single().tab;
        insertResources = BLResourcesDAO.composeInsertStatement((String)"PROCESSRESOURCEINFO", (String[])INSERT_RESOURCE_LIST);
        DBConstants.TableConstants cfr_ignored_1 = DBConstants.single().tab;
        String[] stringArray = new String[1];
        DBConstants.ColConstants cfr_ignored_2 = DBConstants.single().col;
        stringArray[0] = "PROCESS_TEMPLATE_ID";
        deleteResources = BLResourcesDAO.composeRemoveStatement((String)"PROCESSRESOURCEINFO", (String[])stringArray);
        BLResourcesDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLUtil.self().DEBUG_DAO) {
            BLControl.logger.debug((Object)"BLResourcesDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", insertResources, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", deleteResources, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[6];
        DBConstants.ColConstants cfr_ignored_0 = DBConstants.single().col;
        stringArray[0] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_1 = DBConstants.single().col;
        stringArray[1] = "NAME";
        DBConstants.ColConstants cfr_ignored_2 = DBConstants.single().col;
        stringArray[2] = "TYPE";
        DBConstants.ColConstants cfr_ignored_3 = DBConstants.single().col;
        stringArray[3] = "UNIT";
        DBConstants.ColConstants cfr_ignored_4 = DBConstants.single().col;
        stringArray[4] = "UNIT_COST";
        DBConstants.ColConstants cfr_ignored_5 = DBConstants.single().col;
        stringArray[5] = "THRESHOLD";
        INSERT_RESOURCE_LIST = stringArray;
    }
}

