/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.common.documentrepository.DocCollection;
import com.savvion.common.documentrepository.DocCollectionBean;
import com.savvion.common.documentrepository.Document;
import com.savvion.common.documentrepository.DocumentBean;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import java.sql.Timestamp;
import java.util.Date;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class XMLDocRepository {
    public static final void prepareDataSource() {
        try {
            if (DocumentBean.getDataSource() == null || DocCollectionBean.getDataSource() == null) {
                DataSource dataSource = ServiceLocator.self().getDataSource(BLControl.util.DS_JNDI_NAME);
                DocCollectionBean.setDataSource((DataSource)dataSource);
                DocumentBean.setDataSource((DataSource)dataSource);
            }
        }
        catch (NamingException nex) {
            throw new BizLogicException("BizLogic_ERR_1594", "XMLDocRepository.prepareDataSource", new Object[]{"jdbc/BizLogicDB"}, (Throwable)nex);
        }
    }

    public static final long getCollectionID(long docID) {
        try {
            XMLDocRepository.prepareDataSource();
            Document doc = DocumentBean.getDocument((long)docID);
            if (doc == null) {
                throw new BizLogicException("BizLogic_ERR_1597", "XMLDocRepository.getCollectionID", new Object[]{String.valueOf(docID)});
            }
            return doc.getCollectionId();
        }
        catch (BizLogicException blex) {
            throw blex;
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_1532", "XMLDocRepository.getCollectionID", new Object[]{"getCollectionID", "docid:", String.valueOf(docID), ex.getMessage()}, (Throwable)ex);
        }
    }

    public static final String getContent(long docID) {
        try {
            XMLDocRepository.prepareDataSource();
            Document doc = DocumentBean.getDocument((long)docID);
            if (doc == null) {
                throw new BizLogicException("BizLogic_ERR_1597", "XMLDocRepository.getContent", new Object[]{String.valueOf(docID)});
            }
            byte[] content = doc.getContent();
            if (content != null) {
                SBMConstants.self().getClass();
                return new String(content, "UTF-8");
            }
            return null;
        }
        catch (BizLogicException blex) {
            throw blex;
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_1532", "XMLDocRepository.getContent", new Object[]{"getContent", "docid:", String.valueOf(docID), ex.getMessage()}, (Throwable)ex);
        }
    }

    public static final String getName(long docID) {
        try {
            XMLDocRepository.prepareDataSource();
            Document doc = DocumentBean.getDocument((long)docID);
            if (doc == null) {
                throw new BizLogicException("BizLogic_ERR_1597", "XMLDocRepository.getName", new Object[]{String.valueOf(docID)});
            }
            return doc.getName();
        }
        catch (BizLogicException blex) {
            throw blex;
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_1532", "XMLDocRepository.getName", new Object[]{"getName", "docid:", String.valueOf(docID), ex.getMessage()}, (Throwable)ex);
        }
    }

    public static final void remove(long docID) {
        try {
            XMLDocRepository.prepareDataSource();
            DocumentBean.removeDocument((long)docID);
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_1532", "XMLDocRepository.remove", new Object[]{"remove", "docid:", String.valueOf(docID), ex.getMessage()}, (Throwable)ex);
        }
    }

    public static final void removeCollection(long collectionID) {
        try {
            XMLDocRepository.prepareDataSource();
            DocCollectionBean.removeDocCollection((long)collectionID);
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_1532", "XMLDocRepository.removeCollection", new Object[]{"removeCollection", "collectionID:", String.valueOf(collectionID), ex.getMessage()}, (Throwable)ex);
        }
    }

    public static final DocCollection getCollection(long collectionID) {
        try {
            XMLDocRepository.prepareDataSource();
            DocCollection docColl = DocCollectionBean.getDocCollection((long)collectionID);
            if (docColl == null) {
                throw new BizLogicException("BizLogic_ERR_1600", "XMLDocRepository.getCollection", new Object[]{String.valueOf(collectionID)});
            }
            return docColl;
        }
        catch (BizLogicException blex) {
            throw blex;
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_1532", "XMLDocRepository.getCollection", new Object[]{"getCollection", "collectionid:", String.valueOf(collectionID), ex.getMessage()}, (Throwable)ex);
        }
    }

    public static final long create(long collectionID, String name, String content, String ptName, String dsName) throws Exception {
        try {
            XMLDocRepository.prepareDataSource();
            name = XMLDocRepository.getDocName(name, content, ptName, dsName);
            if (content == null) {
                content = "";
            }
            content = content.trim();
            SBMConstants.self().getClass();
            Document doc = new Document(collectionID, name, 1, "1.0", null, null, content.getBytes("UTF-8"));
            return DocumentBean.create((Document)doc);
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_1532", "XMLDocRepository.create", new Object[]{"create", "docid:", name, ex.getMessage()}, (Throwable)ex);
        }
    }

    private static final void update(long docID, String content, String docName, String ptName, String dsName, boolean isContentModified) {
        try {
            XMLDocRepository.prepareDataSource();
            Document doc = DocumentBean.getDocument((long)docID);
            if (doc == null) {
                throw new BizLogicException("BizLogic_ERR_1597", "XMLDocRepository.update", new Object[]{String.valueOf(docID)});
            }
            if (isContentModified) {
                if (content == null) {
                    content = "";
                }
                content = content.trim();
                SBMConstants.self().getClass();
                doc.setContent(content.getBytes("UTF-8"));
            }
            docName = XMLDocRepository.getDocName(docName, content, ptName, dsName);
            doc.setName(docName);
            doc.setModifiedDate(new Timestamp(new Date().getTime()));
            DocumentBean.updateDocument((Document)doc);
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_1532", "XMLDocRepository.update", new Object[]{"update", "docid:", String.valueOf(docID), ex.getMessage()}, (Throwable)ex);
        }
    }

    private static final String getDocName(String docName, String content, String ptName, String dsName) {
        if (!SBMUtil.isValidProperty((String)docName) && SBMUtil.isValidProperty((String)content)) {
            docName = ptName + "_" + dsName + ".xml";
        }
        if (docName == null) {
            docName = "";
        }
        return docName;
    }

    public static final XML validate(String ptName, String dsName, long dsCollectionID, XML orgValue, XML xmlObj) {
        long docid = -1L;
        if (xmlObj == null) {
            return new XML(-1L);
        }
        String docName = xmlObj.getName();
        try {
            docid = xmlObj.getID();
            if (docid > 0L) {
                long collectionid = XMLDocRepository.getCollectionID(docid);
                if (dsCollectionID != collectionid) {
                    throw new BizLogicException("BizLogic_ERR_1593", "XMLDocRepository.validate", new Object[]{String.valueOf(docid), docName});
                }
                if (xmlObj.isModified()) {
                    if (xmlObj.isContentUpdated()) {
                        String content = xmlObj.getContent((Session)null);
                        XMLDocRepository.update(docid, content, docName, ptName, dsName, true);
                    } else {
                        XMLDocRepository.update(docid, null, docName, ptName, dsName, false);
                    }
                }
                return xmlObj;
            }
            if (orgValue != null && orgValue.getID() > 0L) {
                docid = orgValue.getID();
            }
            if (xmlObj.isContentUpdated()) {
                String content = xmlObj.getContent((Session)null);
                if (docid > 0L) {
                    XMLDocRepository.update(docid, content, docName, ptName, dsName, true);
                } else {
                    docid = XMLDocRepository.create(dsCollectionID, docName, content, ptName, dsName);
                }
            }
            return new XML(docid);
        }
        catch (BizLogicException blex) {
            throw blex;
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_1593", "XMLDocRepository.validate", new Object[]{String.valueOf(docid), docName}, (Throwable)ex);
        }
    }

    public static final long validateCollection(long docID, String name, String description) throws Exception {
        XMLDocRepository.prepareDataSource();
        Document doc = DocumentBean.getDocument((long)docID);
        if (doc == null) {
            throw new BizLogicException("BizLogic_ERR_1597", "XMLDocRepository.validateCollection", new Object[]{String.valueOf(docID)});
        }
        long collectionID = doc.getCollectionId();
        DocCollection collection = DocCollectionBean.getDocCollection((long)collectionID);
        if (collection == null) {
            throw new BizLogicException("BizLogic_ERR_1600", "XMLDocRepository.validateCollection", new Object[]{String.valueOf(collectionID)});
        }
        String colName = collection.getName();
        String colDesc = collection.getDescription();
        if (colName != null && !colName.equalsIgnoreCase(name) || colDesc != null && !colDesc.equalsIgnoreCase(description)) {
            throw new BizLogicException("BizLogic_ERR_1593", "validate DocCollection:" + description, new Object[]{String.valueOf(docID), name});
        }
        return collectionID;
    }

    public static final long createCollection(String name, String description) throws Exception {
        XMLDocRepository.prepareDataSource();
        DocCollection collection = new DocCollection(name, description, new Timestamp(new Date().getTime()));
        return DocCollectionBean.create((DocCollection)collection);
    }
}

