/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWebServiceInstance;
import com.savvion.sbm.bizlogic.server.WFWebServiceWS;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.util.WebServiceInvoker;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;

public class WSDLManager {
    private static final String INT = "int";
    private static final String FLOAT = "float";
    private static final String SHORT = "short";
    private static final String DATETIME = "datetime";

    public static final void invoke(HashMap map) {
        WFProcessContext pCtx = null;
        long ptid = 0L;
        long piid = 0L;
        long wsid = 0L;
        try {
            ptid = (Long)map.get("PROCESSTEMPLATEID");
            piid = (Long)map.get("PROCESSINSTANCEID");
            wsid = (Long)map.get("WORKSTEPID");
            if (!WFWebServiceInstance.self().isWorkstepReady(map)) {
                BLControl.logger.warnKey("BizLogic_ERR_3117");
                return;
            }
        }
        catch (BizLogicException bex) {
            throw bex;
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_930", "WSDLManager.invoke", new Object[]{piid, wsid}, (Throwable)ex);
        }
        try {
            pCtx = new WFProcessContext(BLControl.getServerSession(), ptid, piid);
            WFWebServiceWS ws = (WFWebServiceWS)pCtx.getWorkstep(wsid);
            Object[][] inParams = WSDLManager.getInParams(ws, pCtx);
            String[][] outParams = WSDLManager.getOutParams(ws);
            String[][] complexTypeInfo = ws.getComplexTypeInfo();
            if (BLControl.util.WEBSERVICE_TYPE != 1) {
                throw new Exception("Invalid WebService Type: " + BLControl.util.WEBSERVICE_TYPE);
            }
            Object retValue = WSDLManager.invokeAxis(ws, pCtx, inParams, outParams, complexTypeInfo);
            if (retValue instanceof Float) {
                double rVal = ((Float)retValue).floatValue();
                retValue = rVal;
            } else if (retValue instanceof Integer) {
                long rVal = ((Integer)retValue).intValue();
                retValue = rVal;
            } else if (retValue instanceof Short) {
                long rVal = ((Short)retValue).shortValue();
                retValue = rVal;
            } else if (retValue instanceof Calendar) {
                // empty if block
            }
            WSDLManager.updateSlotValue(ws, pCtx, retValue);
            pCtx.completeWorkstep(wsid);
        }
        catch (Exception ex) {
            if (pCtx != null) {
                WSDLManager.suspend(pCtx, wsid, ex);
                throw new BizLogicException("BizLogic_ERR_3102", "WSDLManager.invoke", new Object[]{pCtx.getProcessInstanceName(), pCtx.getWorkStepInstanceName(wsid)}, (Throwable)ex);
            }
            throw new BizLogicException("BizLogic_ERR_3102", "WSDLManager.invoke", new Object[]{"INVALID PIID", "INVALID WSID"}, (Throwable)ex);
        }
    }

    public static final Object invokeAxis(WFWebServiceWS ws, WFProcessContext pCtx, Object[][] inpValues, String[][] outParams, String[][] complexInfo) throws Exception {
        long wsid = ws.getID();
        boolean retry = true;
        int retryCount = 0;
        Object retValue = null;
        while (retry) {
            try {
                if (BLControl.util.DEBUG_ENGINE) {
                    WSDLManager.printDebug(pCtx, wsid, "Before invoking WebService");
                }
                for (int ix = 0; ix < inpValues.length; ++ix) {
                    Object obj = inpValues[ix][2];
                    if (obj instanceof Decimal) {
                        inpValues[ix][2] = ((Decimal)obj).getValue();
                        continue;
                    }
                    if (obj instanceof DateTime) {
                        inpValues[ix][2] = ((DateTime)obj).getTime();
                        continue;
                    }
                    if (!(obj instanceof XML)) continue;
                    inpValues[ix][2] = ((XML)obj).getContent(BLControl.getServerSession());
                }
                if (BLControl.util.DEBUG_ENGINE) {
                    WSDLManager.printDebug(inpValues, outParams, "Invoking WebService with values ");
                }
                retValue = WebServiceInvoker.invokeAXIS((String)ws.getEndpoint(), (String)ws.getSOAPAction(), (String)ws.getNamespaceURI(), (String)ws.getOperation(), (Object[][])inpValues, (String[][])outParams, (String[][])complexInfo);
                retry = false;
                if (!BLControl.util.DEBUG_ENGINE) continue;
                WSDLManager.printDebug(pCtx, wsid, "WEBService invoked successfully");
            }
            catch (Exception ex) {
                if (++retryCount == 1) {
                    if (BLControl.util.DEBUG_ENGINE) {
                        WSDLManager.printDebug(pCtx, wsid, "Again Parse WSDL because WebService failed");
                    }
                    ws.updateTargetData();
                    continue;
                }
                retry = false;
                throw ex;
            }
        }
        return retValue;
    }

    private static final void printDebug(WFProcessContext pCtx, long wsid, String msg) {
        StringBuilder buf = new StringBuilder(msg);
        buf.append(" for PI:").append(pCtx.getProcessInstanceName());
        buf.append("  WS:").append(pCtx.getWorkStepInstanceName(wsid));
        BLControl.logger.debug((Object)buf.toString());
    }

    private static final void printDebug(Object[][] inpParams, String[][] outParams, String msg) {
        int ix;
        StringBuilder buf = new StringBuilder(msg);
        if (inpParams != null && inpParams.length > 0) {
            for (ix = 0; ix < inpParams.length; ++ix) {
                buf.append("<Input PartName: ").append(inpParams[ix][0]);
                buf.append(">");
                buf.append("<Input PartType: ").append(inpParams[ix][1]);
                buf.append(">");
                buf.append("<Input ParamType: ").append(inpParams[ix][2].getClass().getName());
                buf.append(">");
                buf.append("<Input ParamValue: ").append(inpParams[ix][2]);
                buf.append(">");
                buf.append("\n");
            }
        }
        if (outParams != null && outParams.length > 0) {
            for (ix = 0; ix < outParams.length; ++ix) {
                buf.append("<Output PartName: ").append(outParams[ix][0]);
                buf.append(">");
                buf.append("<Output PartType: ").append(outParams[ix][1]);
                buf.append(">");
                buf.append("\n");
            }
        }
        BLControl.logger.debug((Object)buf.toString());
    }

    private static final Object[][] getInParams(WFWebServiceWS ws, WFProcessContext pCtx) {
        String[] inpdsNames = ws.getInpSlotNames();
        String[][] iparams = ws.getInpParams();
        Object[][] inArray = new Object[inpdsNames.length][3];
        if (inpdsNames.length == 0) {
            return inArray;
        }
        HashMap dsValues = pCtx.getSlotValue(inpdsNames);
        for (int ix = 0; ix < inpdsNames.length; ++ix) {
            inArray[ix][0] = iparams[ix][2];
            inArray[ix][1] = iparams[ix][3];
            Object val = dsValues.get(inpdsNames[ix]);
            if (INT.equalsIgnoreCase(iparams[ix][3])) {
                inArray[ix][2] = ((Long)val).intValue();
                continue;
            }
            if (FLOAT.equalsIgnoreCase(iparams[ix][3])) {
                inArray[ix][2] = Float.valueOf(((Double)val).floatValue());
                continue;
            }
            if (SHORT.equalsIgnoreCase(iparams[ix][3])) {
                inArray[ix][2] = ((Long)val).shortValue();
                continue;
            }
            if (DATETIME.equalsIgnoreCase(iparams[ix][3])) continue;
            inArray[ix][2] = val;
        }
        return inArray;
    }

    private static final String[][] getOutParams(WFWebServiceWS ws) {
        String[] outdsNames = ws.getOutSlotNames();
        String[][] outparams = ws.getOutParams();
        String[][] outArray = new String[outdsNames.length][2];
        if (outdsNames.length == 0) {
            return outArray;
        }
        for (int ix = 0; ix < outdsNames.length; ++ix) {
            outArray[ix][0] = outparams[ix][2];
            outArray[ix][1] = outparams[ix][3];
        }
        return outArray;
    }

    private static final void updateSlotValue(WFWebServiceWS ws, WFProcessContext pCtx, Object value) {
        String[] outdsNames = ws.getOutSlotNames();
        if (outdsNames == null || outdsNames.length == 0) {
            return;
        }
        Object retValue = value;
        WFDataslot ds = ws.getParentProcess().getDataslot(outdsNames[0]);
        String dsType = ds.getType();
        if (dsType.equals("DECIMAL")) {
            retValue = new Decimal((BigDecimal)value);
        } else if (dsType.equals("XML")) {
            retValue = new XML((String)value);
        } else if (dsType.equals("DATETIME")) {
            retValue = new DateTime((Long)value);
        }
        pCtx.updateSlotValue(outdsNames[0], retValue);
    }

    private static final void complete(WFProcessContext pCtx, long wsid) {
        pCtx.completeWorkstep(wsid);
    }

    private static final void suspend(WFProcessContext pCtx, long wsid, Throwable causedBy) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        wsieb.setSuspendState(3);
        pCtx.suspendWorkstep(wsid, true, causedBy, null);
    }
}

