/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.ProcessInfo;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkItem;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.WFimportProcess;
import com.savvion.sbm.bizlogic.server.dao.AvailableWorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceTemplateDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceXMLDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkStepInstanceDAO;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class WFDynamicProcessInstance {
    private static synchronized WFProcess createProcess(WFProcessContext pCtx, long ptid, String processDefinition) throws BizLogicException {
        try {
            BLConstants.single();
            WFProcess pt = new WFimportProcess(processDefinition, 1, ptid).getProcess();
            if (BLControl.util.DEBUG_CREATE) {
                ProcessInfo.printProcess(pt);
            }
            WFProcess ppt = pCtx.getProcess();
            WFDynamicProcessInstance.syncXMLCollectionID(ppt, pt);
            WFDynamicProcessInstance.validateProcess(pCtx, ppt, pt);
            pt.checkPreCondGlobalSlotReference();
            pt.setStatus(2);
            return pt;
        }
        catch (Exception e) {
            throw new BizLogicException("BizLogic_ERR_517", "WFDynamicProcessInstance.createProcess", new Object[]{processDefinition}, (Throwable)e);
        }
    }

    public static boolean validateProcess(WFProcessContext pCtx, WFProcess ppt, WFProcess pt) {
        long maxwsid = ppt.getMaxWorkstepID();
        ppt.getWorksteps();
        Vector ptWSList = pt.getWorksteps();
        WFWorkstep pptWS = null;
        WFWorkstep ptWS = null;
        for (int itr = 0; itr < ptWSList.size(); ++itr) {
            ptWS = (WFWorkstep)ptWSList.elementAt(itr);
            pptWS = ppt.getWorkstep(ptWS.getName(), true);
            if (pptWS != null) {
                if (ptWS.getType() != pptWS.getType()) {
                    throw new BizLogicException("Bizlogic_ERR_3684", "WFDynamicProcessInstance.validateProcess", new Object[]{ppt.getName(), pCtx.getProcessInstanceName(), pptWS.getName()});
                }
                ptWS.setID(pptWS.getID());
                continue;
            }
            ptWS.setID(++maxwsid);
        }
        Vector pptDSList = ppt.getDataslots();
        Vector ptDSList = pt.getDataslots();
        WFDataslot ptds = null;
        WFDataslot pptds = null;
        if (pptDSList.size() != ptDSList.size()) {
            throw new BizLogicException("BizLogic_ERR_1649", "WFDynamicProcessInstance.validateProcess", new Object[]{ppt.getName(), pt.getName()});
        }
        for (int itr = 0; itr < pptDSList.size(); ++itr) {
            pptds = (WFDataslot)pptDSList.elementAt(itr);
            ptds = pt.getDataslot(pptds.getName());
            WFDynamicProcessInstance.compareDS(pptds, ptds);
        }
        pt.validateProcess();
        return true;
    }

    public static long create(WFProcessContext parentCtx, String xmlDefinition, boolean removeOnCompletion) {
        String ppiname = null;
        try {
            long piID;
            ppiname = parentCtx.getProcessInstanceName();
            long parentID = parentCtx.getProcessInstanceID();
            HashMap wsstatus = WorkStepInstanceDAO.findStatusByProcessInstance(parentID);
            Vector wiList = WorkItemDAO.getWorkItemList(null, new long[]{parentID}, null, null, null, false);
            Session session = parentCtx.getSession();
            WFDynamicProcessInstance.canProcessInstanceSuspended(parentCtx, wsstatus);
            parentCtx.suspendProcessInstance();
            long ptid = parentCtx.getProcessTemplateID();
            WFProcess pt = WFDynamicProcessInstance.createProcess(parentCtx, ptid, xmlDefinition);
            WFDynamicProcessInstance.isWorkstepStatusIntact(pt, wsstatus, ppiname);
            HashMap piAttrs = parentCtx.getProcessInstanceEB().getAttributes();
            piAttrs.remove("STARTTIME");
            piAttrs.put("PROCESSINSTANCENAME", ppiname);
            piAttrs.put("PARENTID", parentID);
            Session ses = parentCtx.getSession();
            if (ses != null) {
                piAttrs.put("CREATOR", ses.getUser());
            }
            piAttrs.put("DYNAMICPROCESSOBJECT", pt);
            String[] instanceDSNames = parentCtx.getProcess().getInstanceDSNamesArray();
            HashMap instanceDSvalues = parentCtx.getSlotValue(instanceDSNames);
            WFDynamicProcessInstance.syncProcessAttributes(parentCtx.getProcess(), pt);
            WFProcessContext dpiCtx = WFProcessContext.createProcessInstance(session, piAttrs, instanceDSvalues, false);
            pt.dynamicinstanceid = piID = dpiCtx.getProcessInstanceID();
            ProcessInstanceXMLDAO.create(piID, parentID, xmlDefinition, removeOnCompletion);
            ProcessInstanceTemplateDAO.create(piID, pt);
            dpiCtx.activateProcessInstance();
            WFDynamicProcessInstance.syncProcessInstanceData(parentCtx, dpiCtx, wsstatus, wiList);
            return piID;
        }
        catch (BizLogicException ble) {
            throw ble;
        }
        catch (Exception e) {
            throw new BizLogicException("BizLogic_ERR_653", "WFDynamicProcessInstance.createProcessInstance", new Object[]{ppiname}, (Throwable)e);
        }
    }

    private static void syncProcessAttributes(WFProcess ppt, WFProcess dpt) {
        dpt.setAppName(ppt.getAppName());
        dpt.setGlobalDSTableName(ppt.getGlobalDSTableName());
        dpt.setDSTableName(ppt.getDSTableName());
    }

    private static void syncProcessInstanceData(WFProcessContext parentCtx, WFProcessContext dpiCtx, HashMap wsstatus, Vector wiList) {
        WFDynamicProcessInstance.syncProcessInstanceAttributes(parentCtx, dpiCtx);
        WFDynamicProcessInstance.syncWorkstepData(parentCtx, dpiCtx, wsstatus);
        WFDynamicProcessInstance.syncWorkitemData(parentCtx, dpiCtx, wiList);
        WFDynamicProcessInstance.syncDataslot(parentCtx, dpiCtx);
    }

    private static void syncProcessInstanceAttributes(WFProcessContext parentCtx, WFProcessContext dpiCtx) {
        ProcessInstanceEBLocal dynamicPieb = dpiCtx.getProcessInstanceEB();
        ProcessInstanceEBLocal parentPieb = parentCtx.getProcessInstanceEB();
        dynamicPieb.setIsCallbackCaller(parentPieb.getIsCallbackCaller());
        dynamicPieb.setStartPoint(parentPieb.getStartPoint());
        dynamicPieb.setNodeVisited(parentPieb.getNodeVisited());
    }

    private static void syncWorkstepData(WFProcessContext parentCtx, WFProcessContext dpiCtx, HashMap wsstatus) {
        WorkStepInstanceEBLocal pwseb = null;
        Map.Entry entry = null;
        Iterator kv = wsstatus.entrySet().iterator();
        String status = null;
        String wsname = null;
        WFProcess pt = parentCtx.getProcess();
        WFProcess dpt = dpiCtx.getProcess();
        long wsid = 0L;
        while (kv.hasNext()) {
            entry = kv.next();
            wsname = (String)entry.getKey();
            status = (String)entry.getValue();
            wsid = pt.getWorkstepID(wsname);
            if (status.equals(BLControl.consts.wfStates[18])) {
                pwseb = parentCtx.getWorkstepInstanceEB(wsid);
                HashMap<String, Object> attrs = new HashMap<String, Object>(30);
                attrs.put("PROCESSINSTANCEID", dpiCtx.getProcessInstanceID());
                attrs.put("WORKSTEPID", wsid);
                attrs.put("PROCESSTEMPLATEID", pt.getID());
                attrs.put("TYPE", pwseb.getType());
                attrs.put("PRIORITY", pwseb.getPriority());
                attrs.put("STATUS", 18);
                attrs.put("SUSPENDSTATUS", 5);
                attrs.put("LOOPCOUNTER", pwseb.getLoopCounter());
                attrs.put("WORKSTEPNAME", wsname);
                attrs.put("CREATOR", pwseb.getCreator());
                attrs.put("PERFORMER", pwseb.getPerformer());
                attrs.put("ACTUALPERFORMER", pwseb.getActualPerformer());
                attrs.put("INSTRUCTION", pwseb.getInstruction());
                attrs.put("STARTTIME", pwseb.getTimeStarted());
                attrs.put("DUEDATE", pwseb.getDuedate());
                attrs.put("DATASLOTCOPIES", pwseb.getDataSlotCopies());
                if (pwseb.isMilestone()) {
                    attrs.put("MILESTONE_NAME", pwseb.getMilestoneName());
                    attrs.put("MILESTONE_DESC", pwseb.getMilestoneDescription());
                }
                attrs.put("MONITOR_STEP", pwseb.isMonitorStep());
                try {
                    WorkStepInstanceDAO.createDynamicProcess(attrs);
                }
                catch (Exception err) {
                    throw new BizLogicException("BizLogic_ERR_654", "WFDynamicProcessInstance.syncWorkstepData", new Object[]{parentCtx.getProcessInstanceName(), wsname}, (Throwable)err);
                }
                BLUtil.fireEvent(WFWorkstepInstance.single().getEventContext(dpiCtx, wsid, 18), (int)18);
                continue;
            }
            if (!status.equals(BLControl.consts.wfStates[21])) continue;
            WFWorkstep ws = dpt.getWorkstep(wsid);
            pwseb = parentCtx.getWorkstepInstanceEB(wsid);
            HashMap<String, Object> attrs = new HashMap<String, Object>(30);
            attrs.put("PROCESSINSTANCEID", dpiCtx.getProcessInstanceID());
            attrs.put("WORKSTEPID", wsid);
            attrs.put("PROCESSTEMPLATEID", pt.getID());
            attrs.put("TYPE", pwseb.getType());
            attrs.put("PRIORITY", ws.getPriority());
            attrs.put("STATUS", 21);
            attrs.put("LOOPCOUNTER", pwseb.getLoopCounter());
            attrs.put("WORKSTEPNAME", wsname);
            attrs.put("CREATOR", pwseb.getCreator());
            attrs.put("PERFORMER", ws.getPerformer());
            attrs.put("ACTUALPERFORMER", pwseb.getActualPerformer());
            attrs.put("INSTRUCTION", ws.getInstruction());
            attrs.put("STARTTIME", pwseb.getTimeStarted());
            attrs.put("ENDTIME", pwseb.getTimeCompleted());
            attrs.put("DUEDATE", pwseb.getDuedate());
            if (ws.isMilestone()) {
                attrs.put("MILESTONE_NAME", ws.getMilestoneName());
                attrs.put("MILESTONE_DESC", ws.getMilestoneDescription());
            }
            attrs.put("MONITOR_STEP", ws.isMonitorStep());
            try {
                WorkStepInstanceDAO.createDynamicProcess(attrs);
            }
            catch (Exception err) {
                throw new BizLogicException("BizLogic_ERR_654", "WFDynamicProcessInstance.syncWorkstepData", new Object[]{parentCtx.getProcessInstanceName(), wsname}, (Throwable)err);
            }
            BLUtil.fireEvent(WFWorkstepInstance.single().getEventContext(dpiCtx, wsid, 18), (int)18);
            BLUtil.fireEvent(WFWorkstepInstance.single().getEventContext(dpiCtx, wsid, 21), (int)21);
        }
    }

    private static void syncWorkitemData(WFProcessContext parentCtx, WFProcessContext dpiCtx, Vector wiList) {
        HashMap wi = null;
        long dpiid = dpiCtx.getProcessInstanceID();
        long ptid = dpiCtx.getProcessTemplateID();
        String winameprefix = dpiCtx.getProcessInstanceName();
        long wiid = 0L;
        try {
            for (int itr = 0; itr < wiList.size(); ++itr) {
                HashMap<String, Object> attrs = new HashMap<String, Object>(30);
                wiid = BLControl.util.wiSeq.getNextNumber();
                wi = (HashMap)wiList.elementAt(itr);
                Integer status = (Integer)wi.get("STATUS");
                attrs.put("WORKITEMID", wiid);
                attrs.put("PROCESSTEMPLATEID", ptid);
                attrs.put("PROCESSINSTANCEID", dpiid);
                attrs.put("WORKSTEPID", wi.get("WORKSTEPID"));
                attrs.put("WORKSTEPNAME", wi.get("WORKSTEPNAME"));
                attrs.put("STARTTIME", wi.get("STARTTIME"));
                attrs.put("DUEDATE", wi.get("DUEDATE"));
                attrs.put("STATUS", status);
                attrs.put("PRIORITY", wi.get("PRIORITY"));
                StringBuilder sb = new StringBuilder(30);
                String pwiname = (String)wi.get("WORKITEMNAME");
                int index = pwiname.indexOf("::");
                sb.append(winameprefix);
                sb.append(pwiname.substring(index));
                attrs.put("WORKITEMNAME", sb.toString());
                attrs.put("PERFORMER", wi.get("PERFORMER"));
                attrs.put("PREVIOUSASSIGNEE", wi.get("PREVIOUSASSIGNEE"));
                WorkItemDAO.createDynamicProcess(attrs);
                Vector availperf = AvailableWorkItemDAO.getAvailablePerformers((Long)wi.get("WORKITEMID"));
                String[] perfs = new String[availperf.size()];
                for (int perfitr = 0; perfitr < availperf.size(); ++perfitr) {
                    perfs[perfitr] = (String)availperf.elementAt(perfitr);
                }
                AvailableWorkItemDAO.store(wiid, ptid, dpiid, perfs);
                BLUtil.fireEvent(WFWorkItem.self().getEventContext(dpiCtx, wiid, 25), (int)25);
                if (status == 27) {
                    BLUtil.fireEvent(WFWorkItem.self().getEventContext(dpiCtx, wiid, 27), (int)27);
                    continue;
                }
                if (status != 28) continue;
                BLUtil.fireEvent(WFWorkItem.self().getEventContext(dpiCtx, wiid, 28), (int)28);
            }
        }
        catch (BizLogicException ble) {
            throw ble;
        }
        catch (Exception err) {
            throw new BizLogicException("BizLogic_ERR_654", "WFDynamicProcessInstance.syncWorkItemData", new Object[]{parentCtx.getProcessInstanceName()}, (Throwable)err);
        }
    }

    private static void syncDataslot(WFProcessContext parentCtx, WFProcessContext dpiCtx) {
    }

    private static boolean canProcessInstanceSuspended(WFProcessContext pCtx, HashMap wsstatus) {
        Map.Entry entry = null;
        Iterator kv = wsstatus.entrySet().iterator();
        String status = null;
        String wsname = null;
        int wstype = 0;
        while (kv.hasNext()) {
            entry = kv.next();
            wsname = (String)entry.getKey();
            status = (String)entry.getValue();
            if (status.equals(BLControl.consts.wfStates[18])) {
                wstype = pCtx.getProcess().getWorkstep(wsname).getType();
                if (wstype == 102) continue;
                throw new BizLogicException("BizLogic_ERR_651", "WFDynamicProcessInstance.canProcessInstanceSuspended", new Object[]{wsname});
            }
            if (!status.equals(BLControl.consts.wfStates[16])) continue;
            throw new BizLogicException("BizLogic_ERR_657", "WFDynamicProcessInstance.canProcessInstanceSuspended", new Object[]{wsname});
        }
        return true;
    }

    private static void isWorkstepStatusIntact(WFProcess pt, HashMap wsstatus, String ppiname) {
        WFWorkstep ws = null;
        String wsname = null;
        Vector wslist = pt.hasWorksteps;
        String status = null;
        for (int itr = 0; itr < wslist.size(); ++itr) {
            ws = (WFWorkstep)wslist.elementAt(itr);
            wsname = ws.getName();
            status = (String)wsstatus.get(wsname);
            if (status == null) {
                if (ws.getStatus() == 15) continue;
                throw new BizLogicException("BizLogic_ERR_658", "WFDynamicProcessInstance.isWorkstepStatusIntact", new Object[]{ppiname, wsname});
            }
            if (status.equals(BLControl.consts.wfStates[ws.getStatus()])) continue;
            throw new BizLogicException("BizLogic_ERR_652", "WFDynamicProcessInstance.isWorkstepStatusIntact", new Object[]{ppiname, wsname});
        }
    }

    public static boolean compareDS(WFDataslot pptds, WFDataslot ptds) {
        String dsName = pptds.getName();
        if (!pptds.getName().equals(ptds.getName())) {
            throw new BizLogicException("BizLogic_ERR_655", "WFDynamicPI.compareDS", new Object[]{dsName, "Name"});
        }
        if (!pptds.getType().equals(ptds.getType())) {
            throw new BizLogicException("BizLogic_ERR_655", "WFDynamicPI.compareDS", new Object[]{dsName, "Type"});
        }
        if (pptds.isPublic() != ptds.isPublic) {
            throw new BizLogicException("BizLogic_ERR_655", "WFDynamicPI.compareDS", new Object[]{dsName, "Accessor"});
        }
        if (pptds.getBizManageAccess() != ptds.getBizManageAccess()) {
            throw new BizLogicException("BizLogic_ERR_655", "WFDynamicPI.compareDS", new Object[]{dsName, "BizManageAccess"});
        }
        if (pptds.getBizSiteAccess() != ptds.getBizSiteAccess()) {
            throw new BizLogicException("BizLogic_ERR_655", "WFDynamicPI.compareDS", new Object[]{dsName, "BizSiteAccess"});
        }
        if (!pptds.getLabel().equals(ptds.getLabel())) {
            throw new BizLogicException("BizLogic_ERR_655", "WFDynamicPI.compareDS", new Object[]{dsName, "Label"});
        }
        if (pptds.isRequired() != ptds.isRequired()) {
            throw new BizLogicException("BizLogic_ERR_655", "WFDynamicPI.compareDS", new Object[]{dsName, "Required Flag"});
        }
        if (pptds.getSize() != ptds.getSize()) {
            throw new BizLogicException("BizLogic_ERR_655", "WFDynamicPI.compareDS", new Object[]{dsName, "Size"});
        }
        return true;
    }

    private static void syncXMLCollectionID(WFProcess ppt, WFProcess dpt) {
        Vector dsl = ppt.hasDataslots;
        WFDataslot pds = null;
        WFDataslot dds = null;
        if (dsl != null) {
            for (int itr = 0; itr < dsl.size(); ++itr) {
                pds = (WFDataslot)dsl.elementAt(itr);
                if (!pds.getType().equals("XML")) continue;
                dds = dpt.getDataslot(pds.getName());
                dds.setXMLCollectionID(pds.getXMLCollectionID());
            }
        }
    }
}

