/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.DebugService;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import java.util.Vector;

public class WFConnectorInstance
extends WFWorkstepInstance {
    private static WFConnectorInstance self;

    private WFConnectorInstance() {
    }

    private void init() {
    }

    public static WFConnectorInstance self() {
        if (self == null) {
            self = new WFConnectorInstance();
        }
        return self;
    }

    @Override
    public void execute(WFProcessContext pCtx, long wsid) {
        int typeTag = pCtx.getWorkstep(wsid).getType();
        switch (typeTag) {
            case 104: {
                if (!this.isEmptyExpectArrivals(pCtx, wsid)) break;
                this.complete(pCtx, wsid);
                break;
            }
            case 105: {
                this.complete(pCtx, wsid);
                break;
            }
            case 113: {
                this.terminateActiveParents(pCtx, wsid);
                this.complete(pCtx, wsid);
                break;
            }
            default: {
                this.complete(pCtx, wsid);
            }
        }
    }

    @Override
    public void complete(WFProcessContext pCtx, long wsid) {
        pCtx.getWorkstepInstanceEB(wsid).setExpectArrivals("");
        super.complete(pCtx, wsid);
        if (pCtx.getWorkstepInstanceEB(wsid).getState() != 21) {
            return;
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 21), (int)21);
        super.afterComplete(pCtx, wsid);
        this.activateNextWorksteps(pCtx, wsid);
    }

    public void terminateActiveParents(WFProcessContext pCtx, long wsid) {
        WFWorkstep xorws = pCtx.getWorkstep(wsid);
        Vector prewslist = xorws.getPreviousWorksteps();
        String[] prewsnames = pCtx.getActivatedWorkStepNames();
        for (int itr = 0; itr < prewslist.size(); ++itr) {
            WFWorkstep prews = (WFWorkstep)prewslist.elementAt(itr);
            if (!prews.isAtomic()) continue;
            if (pCtx.isDebug() && !WFWorkstepInstance.single().isActivated(pCtx, prews.getID())) {
                DebugService.self().removeDebugWSEntry(pCtx, prews.getID(), 1);
                continue;
            }
            boolean foundInDB = false;
            for (int count = 0; count < prewsnames.length; ++count) {
                if (!prews.getName().equals(prewsnames[count])) continue;
                pCtx.terminateWorkstep(prews.getID());
                foundInDB = true;
                break;
            }
            if (foundInDB) continue;
            WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(prews.getID(), true);
            if (wsieb != null) {
                if (wsieb.getState() == 18) {
                    pCtx.terminateWorkstep(prews.getID());
                    continue;
                }
            }
            if (prews.getID() == pCtx.getXORHelper().getActivatorWsId()) continue;
            pCtx.getXORHelper().markWSForTermination(prews.getID());
            BLControl.logger.infoKey("BizLogic_ERR_3248", "WFConnectorInstance.terminateActiveParents", new Object[]{prews.getName(), pCtx.getProcessInstanceName()});
        }
        pCtx.getXORHelper().setActivatorWsId(-1L);
    }
}

