/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging;

import com.savvion.sbm.bizlogic.messaging.BLMessageException;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.util.SBMExceptionIntf;
import javax.jms.JMSException;

public class MsgErrorHandler {
    public static BLMessageException createEx(String mkey) {
        String message = BLControl.msgFactory.lookup(mkey, null);
        String severity = BLControl.msgFactory.lookupSeverity(mkey);
        BLMessageException tex = new BLMessageException(mkey, message, severity, BLControl.msgFactory.lookupAction(mkey), null);
        int iSeverity = BLControl.msgFactory.getSeverity(mkey);
        BLControl.logger.log((Object)message, iSeverity, (Throwable)tex);
        return tex;
    }

    public static BLMessageException createEx(String mkey, String ctx) {
        String message = BLControl.msgFactory.lookup(mkey, null, ctx);
        String severity = BLControl.msgFactory.lookupSeverity(mkey);
        BLMessageException tex = new BLMessageException(mkey, message, severity, BLControl.msgFactory.lookupAction(mkey), ctx);
        int iSeverity = BLControl.msgFactory.getSeverity(mkey);
        BLControl.logger.log((Object)message, iSeverity, (Throwable)tex);
        return tex;
    }

    public static BLMessageException createEx(String mkey, String ctx, Object[] args) {
        return MsgErrorHandler.createEx(mkey, ctx, args, false);
    }

    public static BLMessageException createEx(String mkey, String ctx, Object[] args, boolean notifySender) {
        String message = BLControl.msgFactory.lookup(mkey, args, ctx);
        String severity = BLControl.msgFactory.lookupSeverity(mkey);
        BLMessageException tex = new BLMessageException(mkey, message, severity, BLControl.msgFactory.lookupAction(mkey), ctx, notifySender);
        int iSeverity = BLControl.msgFactory.getSeverity(mkey);
        BLControl.logger.log((Object)message, iSeverity, (Throwable)tex);
        return tex;
    }

    public static BLMessageException createEx(String mkey, String ctx, Object[] args, Throwable ex) {
        String message = null;
        message = ex != null ? BLControl.msgFactory.lookup(mkey, args, ctx, ex) : BLControl.msgFactory.lookup(mkey, args, ctx);
        String severity = BLControl.msgFactory.lookupSeverity(mkey);
        BLMessageException tex = new BLMessageException(mkey, message, severity, BLControl.msgFactory.lookupAction(mkey), ctx);
        int iSeverity = BLControl.msgFactory.getSeverity(mkey);
        BLControl.logger.log((Object)message, iSeverity, (Throwable)tex);
        return tex;
    }

    public static BLMessageException createEx(Throwable t) throws BLMessageException {
        return MsgErrorHandler.createEx(t, null);
    }

    public static BLMessageException createEx(Throwable t, String context) {
        BLMessageException tex = MsgErrorHandler.createException(t, null);
        BLControl.logger.log((Object)context, 4, t);
        return tex;
    }

    public static BLMessageException createException(String mkey) {
        BLMessageException tex = new BLMessageException(mkey, BLControl.msgFactory.lookup(mkey, null), BLControl.msgFactory.lookupSeverity(mkey), BLControl.msgFactory.lookupAction(mkey), null);
        return tex;
    }

    public static BLMessageException createException(Throwable e) {
        return MsgErrorHandler.createException(e, null);
    }

    public static BLMessageException createException(Throwable e, String ctx) {
        String msgID = null;
        String message = null;
        String severity = null;
        String action = null;
        String context = ctx;
        if (e instanceof SBMExceptionIntf) {
            SBMExceptionIntf sbmEx = (SBMExceptionIntf)e;
            msgID = sbmEx.getMessageID();
            message = sbmEx.getMessage();
            severity = sbmEx.getSeverity();
            action = sbmEx.getAction();
            context = sbmEx.getContext();
        } else if (e instanceof JMSException) {
            msgID = "BizLogic_ERR_702";
            message = BLControl.msgFactory.lookup(msgID, null);
        } else {
            msgID = "BizLogic_ERR_703";
            message = BLControl.msgFactory.lookup(msgID, null);
        }
        return new BLMessageException(msgID, message, severity, action, context, e);
    }
}

