/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging;

import com.savvion.sbm.bizlogic.client.messagehandler.ICustomMessageHandler;
import com.savvion.sbm.bizlogic.messaging.MessageHandler;
import com.savvion.sbm.bizlogic.messaging.dao.BLMessagesDAO;
import com.savvion.sbm.bizlogic.messaging.publisher.MessagePublisher;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.messaging.core.MDService;
import com.savvion.sbm.messaging.dao.MessagingDAO;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.ResourceUtil;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.dcl.FCLService;
import com.savvion.sbm.util.logger.LoggerManager;
import com.savvion.sbm.util.logger.SBMLogger;
import java.io.IOException;
import java.util.Properties;

public class MessageControl {
    public SBMLogger logger;
    private static MessageControl self = null;
    public String MSG_HANDLER_LOCATION;

    private MessageControl() {
        this.MSG_HANDLER_LOCATION = SBMControl.util.SBM_APPS_DIR + "/common/messaging/classes";
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final MessageControl self() {
        if (self != null) return self;
        Class<MessageControl> clazz = MessageControl.class;
        synchronized (MessageControl.class) {
            if (self != null) return self;
            self = new MessageControl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public final synchronized void init() {
        this.logger = LoggerManager.self().createLogger("Messaging", "sbmlog.conf", "BLMessages", MessageControl.class.getClassLoader());
        this.readProperties();
        BLMessagesDAO.initSQLStatements();
        MessagingDAO.init((String)("jdbc/" + BLControl.util.DS_JNDI_NAME));
    }

    public final synchronized void close() {
        if (BLControl.util.DEBUG_ENGINE) {
            LoggerUtil.logSOP((Object)"MessageControl.close()");
        }
        self = null;
        MDService.close();
    }

    public synchronized void refresh() {
        this.readProperties();
    }

    public synchronized void readProperties() {
        String bizlogicFile = "bizlogic.conf";
        Properties prop = null;
        try {
            BLControl.logger.debugKey("BizLogic_ERR_2227", "MessageControl.readProperties", new Object[]{bizlogicFile});
            prop = ResourceUtil.getPropertyObject((String)(SBMControl.util.ABSOLUTE_CONF_PATH + bizlogicFile));
        }
        catch (IOException e) {
            throw new BizLogicException("BizLogic_ERR_5001", "MessageControl.readProperties", new Object[]{bizlogicFile, e.getMessage()}, (Throwable)e);
        }
        String propStr = null;
        try {
            propStr = prop.getProperty("bizlogic.messaging.handler.location");
            if (SBMUtil.isValidProperty((String)propStr)) {
                this.MSG_HANDLER_LOCATION = propStr;
            }
        }
        catch (Throwable th) {
            if (propStr == null) {
                propStr = "";
            }
            throw new BizLogicException("BizLogic_ERR_5003", "MessageControl.readProperties", new Object[]{bizlogicFile, propStr}, th);
        }
    }

    public static MessageHandler loadSubscriberHandler(String handler, String appName, boolean saveLoader) {
        if (handler == null || handler.trim().length() == 0) {
            return null;
        }
        try {
            MessageHandler handlerObj = (MessageHandler)FCLService.newClassInstance((String)handler, (String)appName, (String)MessageControl.self().MSG_HANDLER_LOCATION, (ClassLoader)MessageControl.class.getClassLoader(), (boolean)saveLoader);
            return handlerObj;
        }
        catch (Exception e) {
            throw new BizLogicException("BizLogic_ERR_708", "MessageControl.loadSubscriberHandler", new Object[]{handler}, (Throwable)e);
        }
    }

    public static MessagePublisher loadPublisherHandler(String handlerName, String appName, boolean saveLoader) {
        if (handlerName == null || handlerName.trim().length() == 0) {
            return null;
        }
        try {
            return (MessagePublisher)FCLService.newClassInstance((String)handlerName, (String)appName, (String)MessageControl.self().MSG_HANDLER_LOCATION, (ClassLoader)MessageControl.class.getClassLoader(), (boolean)saveLoader);
        }
        catch (Exception e) {
            throw new BizLogicException("BizLogic_ERR_708", "MessageControl.loadPublisherHandler", (Throwable)e);
        }
    }

    public static enum CustomHandler {
        CREATE_WORKFLOW_INSTANCE("CreateWorkflowInstance", "com.savvion.sbm.bizlogic.client.messagehandler.CreateWorkflowInstance"),
        PUBLISH_ALERT("PUBLISH_ALERT", "com.savvion.sbm.bizlogic.client.messagehandler.AlertHandler");

        private String messageName;
        private String handlerClassName;

        private CustomHandler(String msgName, String className) {
            this.messageName = msgName;
            this.handlerClassName = className;
        }

        public static CustomHandler getCustomHandler(String msgName) {
            for (CustomHandler handler : CustomHandler.values()) {
                if (handler == null || handler.messageName == null || !handler.messageName.equalsIgnoreCase(msgName)) continue;
                return handler;
            }
            throw new BizLogicException("BizLogic_ERR_3768", "enum CustomHandler", new Object[]{msgName});
        }

        public ICustomMessageHandler loadMapMessageHandler() {
            try {
                return (ICustomMessageHandler)FCLService.newClassInstance((String)this.handlerClassName, (String)MessageControl.self().MSG_HANDLER_LOCATION, (ClassLoader)MessageControl.class.getClassLoader(), (boolean)false);
            }
            catch (Throwable th) {
                throw new BizLogicException("BizLogic_ERR_708", "enum CustomHandler.loadMapMessageHandler", th);
            }
        }
    }
}

