/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.email;

import com.savvion.sbm.bizlogic.email.EmailAdapterReceiver;
import com.savvion.sbm.bizlogic.email.EmailAdapterReceiverInterface;
import com.savvion.sbm.bizlogic.email.EmailData;
import com.savvion.sbm.bizlogic.email.EmailException;
import com.savvion.sbm.bizlogic.email.EmailManager;
import com.savvion.sbm.bizlogic.email.EmailParser;
import com.savvion.sbm.bizlogic.email.EmailUtil;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.ServiceManager;
import com.savvion.sbm.replication.ReplicationManager;
import com.savvion.sbm.replication.service.IServiceHandler;
import com.savvion.sbm.replication.service.ServiceRegister;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.logger.SBMLogger;
import com.tdiinc.common.Emailer.SendEmail;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.Date;
import javax.mail.AuthenticationFailedException;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;

public class EmailReader
extends ServiceManager {
    private static final String INBOX = "INBOX";
    private Session session;
    private Store store = null;
    private Folder backupFolder = null;
    private Folder inbox = null;
    public static boolean debug = true;
    private boolean useBackupFolder = false;
    private static boolean isRunning = false;
    private static final String INVOKING_METHOD = "process";
    private static EmailReader self = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized EmailReader self() {
        if (null != self) return self;
        Class<EmailReader> clazz = EmailReader.class;
        synchronized (EmailReader.class) {
            if (null != self) return self;
            self = new EmailReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    private EmailReader() {
        this.init();
    }

    private synchronized void init() {
        EmailUtil.clean();
        this.session = EmailUtil.self().getIncomingMailSession();
        this.session.setDebug(EmailUtil.self().isSessionDebug());
        this.useBackupFolder = this.hasValidBackupFolder();
        ServiceRegister.self().registerService((IServiceHandler)new EmailReaderHandler());
    }

    private boolean hasValidBackupFolder() {
        String backupFolder;
        boolean flag = false;
        if ("imap".equalsIgnoreCase(EmailUtil.self().getIncomingMailProtocol()) && !EmailUtil.isEmpty(backupFolder = EmailUtil.self().getBackupFolder()) && !INBOX.equalsIgnoreCase(backupFolder)) {
            flag = true;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startEmailReader(SBMLogger logger) {
        if (EmailReader.isRunning()) {
            BLConstants.single();
            SBMUtil.logDuplicateMessage((SBMLogger)BLControl.logger, (String)"BizLogic_ERR_1009", (String)"Incoming Email Service(BLEMAILMDB)");
            return;
        }
        if (!ReplicationManager.self().isPrimaryDatabase()) {
            Object[] objectArray = new Object[1];
            BLConstants.single();
            objectArray[0] = "BLEMAILMDB";
            BLControl.logger.warnKey("BizLogic_ERR_1014", objectArray);
            return;
        }
        Class<EmailReader> clazz = EmailReader.class;
        synchronized (EmailReader.class) {
            if (EmailReader.isRunning()) {
                BLConstants.single();
                SBMUtil.logDuplicateMessage((SBMLogger)BLControl.logger, (String)"BizLogic_ERR_1009", (String)"Incoming Email Service(BLEMAILMDB)");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            EmailUtil.self().info("##############################################");
            EmailUtil.self().info("EMAIL_MSG_027", new Object[]{new Date()});
            EmailUtil.self().info("##############################################");
            LoggerUtil utilLogger = new LoggerUtil(logger);
            try {
                EmailUtil.self().enableEmailReader();
                this.initService("EMAIL", BLControl.util.DS_JNDI_NAME, ((Object)((Object)this)).getClass(), INVOKING_METHOD, ServiceLocator.self().isCluster(), utilLogger);
                this.setSleepTime(EmailUtil.self().getSleepInterval());
            }
            catch (Exception ex) {
                EmailUtil.self().error("Exception occured in starting Email Reader", ex);
                throw new RuntimeException(ex);
            }
            isRunning = true;
            EmailUtil.self().info("##############################################");
            EmailUtil.self().info("EMAIL_MSG_031", new Object[]{new Date()});
            EmailUtil.self().info("##############################################");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                this.runService();
            }
            catch (Throwable ex) {
                EmailUtil.self().error("Exception in executing EmailReader: runService() ", ex);
                throw new RuntimeException(ex);
            }
            finally {
                this.stopEmailReader();
            }
            return;
        }
    }

    public static boolean isRunning() {
        return isRunning;
    }

    public final void process() throws Throwable {
        this.connect();
        this.processFolder();
        this.closeFolders();
    }

    private void connect() throws MessagingException {
        this.getConnectedStore();
        this.inbox = this.getInbox();
        if (this.useBackupFolder) {
            this.backupFolder = this.getBackupFolder();
        }
    }

    private synchronized void getConnectedStore() {
        if (null == this.store) {
            if (EmailUtil.self().isDebug()) {
                EmailUtil.self().debug("EMAIL_MSG_001", new String[]{EmailUtil.self().getIncomingMailProtocol()});
            }
            try {
                this.store = this.session.getStore(EmailUtil.self().getIncomingMailProtocol());
            }
            catch (NoSuchProviderException nspe) {
                String message = EmailUtil.self().getMessage("EMAIL_MSG_206", new String[]{EmailUtil.self().getIncomingMailProtocol()});
                throw new RuntimeException(message, nspe);
            }
        }
        try {
            if (!this.store.isConnected()) {
                EmailUtil.self().info("EMAIL_MSG_002", new String[]{EmailUtil.self().getIncomingMailUser(), EmailUtil.self().getIncomingMailServer(), String.valueOf(EmailUtil.self().getIncomingMailPort()), EmailUtil.self().getIncomingMailProtocol()});
                this.store.connect(EmailUtil.self().getIncomingMailServer(), EmailUtil.self().getIncomingMailPort(), EmailUtil.self().getIncomingMailUser(), EmailUtil.self().getIncomingMailPassword());
            }
        }
        catch (AuthenticationFailedException afe) {
            String message = EmailUtil.self().getMessage("EMAIL_MSG_207", new String[]{EmailUtil.self().getIncomingMailUser(), EmailUtil.self().getIncomingMailServer()});
            throw new RuntimeException(message, afe);
        }
        catch (MessagingException me) {
            String message = EmailUtil.self().getMessage("EMAIL_MSG_208", new String[]{EmailUtil.self().getIncomingMailUser(), EmailUtil.self().getIncomingMailServer(), EmailUtil.self().getIncomingMailProtocol()});
            throw new RuntimeException(message, me);
        }
    }

    private Folder getInbox() {
        try {
            Folder folder = this.store.getFolder(INBOX);
            folder.open(2);
            return folder;
        }
        catch (MessagingException me) {
            throw new RuntimeException("Error opening INBOX in READ/WRITE mode", me);
        }
    }

    private synchronized Folder getBackupFolder() throws MessagingException {
        String backupFolderName = EmailUtil.self().getBackupFolder();
        Folder folder = this.store.getFolder(backupFolderName);
        if (!folder.exists()) {
            if (EmailUtil.self().isDebug()) {
                EmailUtil.self().info("EMAIL_MSG_004", new Object[]{backupFolderName});
            }
            this.useBackupFolder = folder.create(1);
            if (!this.useBackupFolder) {
                if (EmailUtil.self().isDebug()) {
                    EmailUtil.self().info("EMAIL_MSG_117", new Object[]{backupFolderName, EmailUtil.self().getIncomingMailServer()});
                }
                return folder;
            }
        }
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().debug("EMAIL_MSG_005", new String[]{EmailUtil.self().getBackupFolder()});
        }
        folder.open(2);
        return folder;
    }

    public void processFolder() {
        try {
            if (EmailUtil.self().isDebug()) {
                EmailUtil.self().debug("EMAIL_MSG_008", new Object[]{EmailUtil.self().getSubjectPattern()});
            }
            SubjectTerm subjectTerm = new SubjectTerm(EmailUtil.self().getSubjectPattern());
            Message[] msgs = this.inbox.search((SearchTerm)subjectTerm);
            for (int i = 0; msgs != null && i < msgs.length; ++i) {
                String messageId = EmailUtil.getMessageId(msgs[i]);
                if (EmailUtil.self().isDebug()) {
                    EmailUtil.self().logSeperator();
                    EmailUtil.self().debug("EMAIL_MSG_003", new Object[]{msgs[i].getFrom()[0], msgs[i].getSubject(), messageId});
                }
                try {
                    BLUtil.getServiceLocal().processEmailMessage(msgs[i]);
                }
                catch (Exception exc) {
                    if (this.isBizlogicException(exc)) {
                        String message = EmailUtil.self().getMessage("EMAIL_MSG_118", new Object[]{msgs[i].getFrom()[0], msgs[i].getSubject(), messageId});
                        this.handleError(message, exc);
                        continue;
                    }
                    throw exc;
                }
                if (!EmailUtil.self().isDebug()) continue;
                EmailUtil.self().debug("EMAIL_MSG_038", new Object[]{msgs[i].getFrom()[0], msgs[i].getSubject(), messageId});
                EmailUtil.self().logSeperator();
            }
        }
        catch (Throwable thrw) {
            this.handleError("Error processing e-mails", thrw);
        }
    }

    private boolean isBizlogicException(Exception exc) {
        return true;
    }

    public void processMessage(Message message) throws Exception {
        boolean delete;
        block16: {
            String messageId = EmailUtil.getMessageId(message);
            delete = true;
            String performer = null;
            EmailParser parser = null;
            if (EmailUtil.self().getEmailAdapterReceiver() != null) {
                this.processMessageByAdapter(message);
            } else {
                parser = new EmailParser();
                try {
                    EmailData emailData = parser.process(message);
                    if (EmailUtil.self().isDebug()) {
                        EmailUtil.self().debug("EMAIL_MSG_011", new Object[]{message.getFrom()[0], message.getSubject(), messageId});
                    }
                    int wiState = emailData.getEmailType();
                    BLConstants.single();
                    if (28 == wiState) {
                        try {
                            EmailManager.completeWorkItem(emailData, parser.getOutputDataslots());
                        }
                        catch (Throwable ex) {
                            if (EmailUtil.self().isDBConnectionValid() && EmailUtil.self().isBizLogicServerRunning()) {
                                EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_261", null, ex);
                                break block16;
                            }
                            EmailUtil.self().throwEmailException("EMAIL_MSG_261", null, true, false, ex);
                        }
                        break block16;
                    }
                    BLConstants.single();
                    if (27 == wiState) {
                        try {
                            EmailManager.assignWorkItem(emailData);
                        }
                        catch (Throwable ex) {
                            if (EmailUtil.self().isDBConnectionValid() && EmailUtil.self().isBizLogicServerRunning()) {
                                EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_262", null, ex);
                                break block16;
                            }
                            EmailUtil.self().throwEmailException("EMAIL_MSG_262", null, true, false, ex);
                        }
                        break block16;
                    }
                    EmailUtil.self().error("EMAIL_MSG_233", new Object[]{String.valueOf(wiState), message.getSubject(), message.getFrom()[0], messageId});
                }
                catch (EmailException ee) {
                    String string = performer = parser != null ? parser.getPerformer() : "Performer";
                    if (ee.isSendMail()) {
                        this.sendReply(ee.getMessage(), message, performer);
                    }
                    delete = ee.isDeleteMail();
                    if (ee.isDeleteMail() || ee.isSendMail()) break block16;
                    throw ee;
                }
            }
        }
        if (this.useBackupFolder) {
            this.backupMessage(message);
        }
        if (delete) {
            this.deleteMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessageByAdapter(Object msgObj) {
        Object objReceiver = null;
        EmailAdapterReceiverInterface oReceiver = null;
        try {
            Class receiverAdapter = EmailUtil.self().getEmailAdapterReceiver();
            Constructor oConstructor = receiverAdapter.getConstructor(String.class);
            objReceiver = oConstructor.newInstance(new String(SBMUtil.self().getSMTPServer()));
            oReceiver = objReceiver;
            oReceiver.init();
            oReceiver.setServerID(InetAddress.getLocalHost().getHostName());
            oReceiver.setMessageObject(msgObj);
            oReceiver.processMessage();
            oReceiver.completeTask();
        }
        catch (Exception ex) {
            if (oReceiver != null) {
                ((EmailAdapterReceiver)oReceiver).bounceEmailBack("Can not successfully complete your task, please try again later.");
            }
            BLControl.logger.error((Object)"Can not successfully complete the task, please check the exception.", (Throwable)ex);
        }
        finally {
            if (oReceiver != null) {
                oReceiver.clean();
            }
        }
    }

    private void deleteMessage(Message message) throws MessagingException {
        String messageId = EmailUtil.getMessageId(message);
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().debug("EMAIL_MSG_007", new Object[]{message.getFrom()[0], message.getSubject(), messageId});
        }
        this.inbox.setFlags(new Message[]{message}, new Flags(Flags.Flag.DELETED), true);
    }

    private void backupMessage(Message message) throws MessagingException {
        String messageId = EmailUtil.getMessageId(message);
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().debug("EMAIL_MSG_006", new Object[]{message.getFrom()[0], message.getSubject(), this.backupFolder.getName(), messageId});
        }
        this.inbox.copyMessages(new Message[]{message}, this.backupFolder);
    }

    private void sendReply(String content, Message message, String performer) throws Exception {
        String replyMsg = EmailUtil.self().prepareReplyMessage(content, performer);
        SendEmail.replyTo((Message)message, (String)replyMsg);
    }

    public final void closeFolders() {
        this.closeFolder(this.inbox);
        this.closeFolder(this.backupFolder);
    }

    private void closeFolder(Folder folder) {
        boolean expunge = true;
        try {
            if (EmailUtil.self().isDebug()) {
                EmailUtil.self().debug("EMAIL_MSG_024", new Object[]{folder.getName()});
            }
            if (folder != null && folder.isOpen()) {
                folder.close(expunge);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final synchronized void stopEmailReader() {
        if (!isRunning) {
            return;
        }
        isRunning = false;
        EmailUtil.self().info("##############################################");
        EmailUtil.self().info("Shutting Down the Email Reader...");
        this.closeFolders();
        if (null != this.store && this.store.isConnected()) {
            try {
                this.store.close();
                EmailUtil.self().info("Mail Store closed sucessfully.");
                EmailUtil.self().disableEmailReader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.session = null;
        EmailUtil.self().info("Mail Session is cleaned");
        self = null;
        EmailUtil.self().info("EMAIL_MSG_026", new Object[]{new Date()});
        EmailUtil.self().info("##############################################");
        EmailUtil.clean();
    }

    public boolean getStopFlag() {
        return isRunning;
    }

    public final void refresh() {
        EmailUtil.self().info("Refreshing Email Reader now ...");
        EmailUtil.clean();
    }

    public void setSessionDebug(boolean debug) {
        if (this.session != null) {
            this.session.setDebug(debug);
        }
    }

    private class EmailReaderHandler
    implements IServiceHandler {
        private EmailReaderHandler() {
        }

        public String getServiceName() {
            return "EmailReader";
        }

        public void startService() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    EmailReader.this.startEmailReader(BLControl.logger);
                }
            }).start();
        }

        public void stopService() {
            EmailReader.this.stopEmailReader();
        }

        public boolean isServiceRunning() {
            return EmailReader.isRunning();
        }
    }
}

